/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.initlizer;

import com.hs.lego.cbb.task.certjob.TaskInitializer;
import com.hs.lego.cbb.task.dao.ITaskTypeDAO;
import com.hs.lego.cbb.task.sdk.model.TaskType;
import com.hs.lego.cbb.task.sysjob.InitDataStorageTask;
import com.hs.lego.cbb.task.sysjob.InitDivertLogStorageTask;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.schedule.AticBackendThreadUtil;
import com.huawei.atic.service.IAlarmInitService;
import java.util.List;

public class InitTaskTypeThread {
    protected final transient Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_DUMP);
    private IAlarmInitService alarmService;
    private TaskInitializer certTaskInitializer;
    private InitDataStorageTask initDataStorageTask;
    private InitDivertLogStorageTask initDivertLogStorageTask;
    private ITaskTypeDAO taskTypeDao;
    private List<TaskType> types;

    private InitTaskTypeThread() {
    }

    public static InitTaskTypeThread getInstance() {
        return InitTaskTypeThreadHolder.instance;
    }

    public void init() {
        this.initTaskTypes();
        AticBackendThreadUtil aticBackendThreadUtil = AticBackendThreadUtil.getInstance();
        Thread dataStorageTask = new Thread((Runnable)this.initDataStorageTask, "initDataStorageTask");
        aticBackendThreadUtil.addAticBackendThread(dataStorageTask);
        Thread certTaskThread = new Thread((Runnable)this.certTaskInitializer, "certTaskInitializer");
        aticBackendThreadUtil.addAticBackendThread(certTaskThread);
        Thread divertLogStorageTask = new Thread((Runnable)this.initDivertLogStorageTask, "initDivertLogStorageTask");
        aticBackendThreadUtil.addAticBackendThread(divertLogStorageTask);
    }

    private void initTaskTypes() {
        if (null == this.types || this.types.isEmpty()) {
            return;
        }
        for (TaskType type : this.types) {
            type.setType(Integer.valueOf(1));
            if (null == this.taskTypeDao) continue;
            TaskType type1 = null;
            int exceptionTimes = 0;
            while (true) {
                try {
                    type1 = this.taskTypeDao.readTaskType(type.getTaskType());
                }
                catch (RuntimeException e) {
                    this.log.error((Object)("readTaskType with error" + e.getMessage()));
                    if (++exceptionTimes >= 10) {
                        this.alarmService.callinitAlarm("atic.report.ddos.reportTask", "T_tasktype");
                        break;
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ex) {
                        this.log.error((Object)("sleep error." + ex.getMessage()));
                    }
                    continue;
                }
                break;
            }
            if (null != type1) continue;
            this.taskTypeDao.addTaskType(type);
        }
    }

    public TaskInitializer getCertTaskInitializer() {
        return this.certTaskInitializer;
    }

    public void setCertTaskInitializer(TaskInitializer certTaskInitializer) {
        this.certTaskInitializer = certTaskInitializer;
    }

    public InitDataStorageTask getInitDataStorageTask() {
        return this.initDataStorageTask;
    }

    public void setInitDataStorageTask(InitDataStorageTask initDataStorageTask) {
        this.initDataStorageTask = initDataStorageTask;
    }

    public ITaskTypeDAO getTaskTypeDao() {
        return this.taskTypeDao;
    }

    public void setTaskTypeDao(ITaskTypeDAO taskTypeDao) {
        this.taskTypeDao = taskTypeDao;
    }

    public List<TaskType> getTypes() {
        return this.types;
    }

    public void setTypes(List<TaskType> types) {
        this.types = types;
    }

    public InitDivertLogStorageTask getInitDivertLogStorageTask() {
        return this.initDivertLogStorageTask;
    }

    public void setInitDivertLogStorageTask(InitDivertLogStorageTask initDivertLogStorageTask) {
        this.initDivertLogStorageTask = initDivertLogStorageTask;
    }

    public void setAlarmService(IAlarmInitService alarmService) {
        this.alarmService = alarmService;
    }

    private static class InitTaskTypeThreadHolder {
        private static InitTaskTypeThread instance = new InitTaskTypeThread();

        private InitTaskTypeThreadHolder() {
        }
    }
}

