/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.sdk.job;

import com.hs.lego.cbb.task.sdk.TaskTimeUtil;
import com.hs.lego.cbb.task.sdk.model.Task;
import com.hs.lego.cbb.task.sdk.model.TaskResult;
import com.hs.lego.cbb.task.sdk.service.ITaskJobService;
import com.hs.lego.cbb.task.sdk.service.TaskExecuteType;
import com.hs.lego.cbb.task.sdk.service.TaskResultState;
import com.hs.lego.cbb.task.sdk.service.TaskStatus;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Trigger;
import org.springframework.scheduling.quartz.QuartzJobBean;

public abstract class BaseJobBean
extends QuartzJobBean {
    private static final int LOOP_COUNT = 100;
    private static final int SLEEP_TIME = 200;
    protected final transient Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_DUMP);

    private ITaskJobService doLoop() {
        ITaskJobService taskJobService = null;
        for (int i = 0; i < 100 && null == taskJobService; ++i) {
            try {
                taskJobService = (ITaskJobService)ServiceContext.getInstance().getService("taskJobService", ITaskJobService.class);
                TimeUnit.MILLISECONDS.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                this.log.error((Object)("InterruptedException: " + e.getMessage()));
                continue;
            }
            catch (RuntimeException ex) {
                this.log.error((Object)("Exception: " + ex.getMessage()));
            }
        }
        return taskJobService;
    }

    protected void executeInternal(JobExecutionContext jobexecutioncontext) throws JobExecutionException {
        ITaskJobService taskJobService = null;
        Task task = (Task)jobexecutioncontext.getTrigger().getJobDataMap().get((Object)"task");
        Date startTime = new Date();
        Trigger trigger = jobexecutioncontext.getTrigger();
        this.log.info((Object)("Task jobbean current time is " + startTime));
        if (null != task.getNextTime() && null != trigger.getNextFireTime()) {
            Date taskNextTime = task.getNextTime();
            this.log.info((Object)("Task jobbean taskNextTime time is " + taskNextTime));
            if (task.getNextTime().after(startTime)) {
                this.log.info((Object)"task.getNextTime().after(startTime) is  true");
                return;
            }
        }
        taskJobService = this.doLoop();
        this.log.info((Object)("Job " + trigger.getDescription() + "start."));
        TaskResultState state = null;
        task.setTaskStatus(Integer.valueOf(TaskStatus.running.getValue()));
        if (null != taskJobService) {
            taskJobService.updateTask(task);
        }
        String resultLink = "";
        try {
            this.log.info((Object)"executeJob(task)");
            resultLink = this.executeJob(task);
            this.log.info((Object)("resultLink = " + resultLink));
            state = resultLink.equals("") ? TaskResultState.fail : TaskResultState.sucess;
            this.log.info((Object)("state = " + state));
        }
        catch (RuntimeException e) {
            state = TaskResultState.fail;
            this.log.error((Object)"executeInternal exception.");
        }
        Date endTime = new Date();
        TaskResult result = new TaskResult();
        result.setTaskId(task);
        result.setStartTime(startTime);
        result.setEndTime(endTime);
        result.setResult(Integer.valueOf(state.getValue()));
        result.setResultLink(resultLink);
        result.setResultInfo("Task execute ok.");
        this.log.info((Object)("TaskId=" + task + ";StartTime=" + startTime + ";EndTime=" + endTime + ";Result=" + state.getValue() + ";ResultLink=" + resultLink));
        if (null != taskJobService) {
            taskJobService.updateTaskResult(result);
        }
        task.setPreTime(trigger.getPreviousFireTime());
        if (null != trigger.getEndTime() && trigger.getEndTime().before(endTime)) {
            task.setTaskStatus(Integer.valueOf(TaskStatus.finish.getValue()));
            task.setNextTime(null);
        } else {
            task = this.calculateTaskNextTime(task, trigger);
        }
        if (null != taskJobService) {
            taskJobService.updateTask(task);
        }
    }

    private Task calculateTaskNextTime(Task task, Trigger trigger) {
        Date nextTime = trigger.getNextFireTime();
        this.log.info((Object)("trigger.getNextFireTime() is " + nextTime));
        if (null != nextTime) {
            Date next = TaskTimeUtil.getTaskNextTime((Date)nextTime, (Task)task);
            task.setTaskStatus(Integer.valueOf(TaskStatus.idle.getValue()));
            task.setNextTime(next);
            return task;
        }
        Date currentTime = new Date();
        task.setTaskStatus(Integer.valueOf(TaskStatus.finish.getValue()));
        if (TaskExecuteType.single.getValue() == task.getExecuteType().intValue()) {
            if (currentTime.before(task.getBaseTime())) {
                task.setTaskStatus(Integer.valueOf(TaskStatus.idle.getValue()));
            }
        } else if (task.getPeriodtimes() == -1) {
            task.setTaskStatus(Integer.valueOf(TaskStatus.idle.getValue()));
        } else {
            Date endDate = TaskTimeUtil.getEndDateWithCount((Task)task);
            if (null != endDate && currentTime.before(endDate)) {
                task.setTaskStatus(Integer.valueOf(TaskStatus.idle.getValue()));
            }
        }
        return task;
    }

    public abstract String executeJob(Task var1);
}

