/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.sysjob;

import com.hs.lego.cbb.task.dao.ITaskDAO;
import com.hs.lego.cbb.task.dao.ITaskTypeDAO;
import com.hs.lego.cbb.task.manager.TaskManager;
import com.hs.lego.cbb.task.sdk.model.Task;
import com.hs.lego.cbb.task.sdk.model.TaskParameter;
import com.hs.lego.cbb.task.sdk.model.TaskType;
import com.hs.lego.cbb.task.sdk.service.TaskCategory;
import com.hs.lego.cbb.task.sdk.service.TaskPeriodType;
import com.hs.lego.cbb.task.sdk.service.TaskStatus;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.LogStorageUtil;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class InitDataStorageTask
implements Runnable {
    private int cycleDate = 30;
    private String sysOptReserDate = "90";
    private String eventReserDate = "30";
    private String filestyleValue = "2";
    private int defaultTimeHour = 2;
    private String sysOptType = "log_bk";
    private String eventType = "alarm_bk";
    private int sysOptTypeId = 1;
    private int eventTypeId = 2;
    private int firstDate = 120;
    private String time = "02:00:00";
    private String langValue = "1";
    private ITaskTypeDAO taskTypeDao;
    private ITaskDAO taskDao;
    private TaskManager taskManager;
    private Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_DUMP);

    public void init(int taskType) {
        HashMap<String, String> condition = new HashMap<String, String>();
        String filePath = this.getStorageFilePath(taskType);
        condition.put("taskType", "log_bk");
        if (taskType == this.sysOptTypeId) {
            condition.put("taskType", this.sysOptType);
        } else if (taskType == this.eventTypeId) {
            condition.put("taskType", this.eventType);
        }
        List taskList = this.taskDao.queryTask(condition);
        if (null == taskList || taskList.isEmpty()) {
            Task task = new Task();
            TaskType taskTypeTemp = null;
            if (taskType == this.sysOptTypeId) {
                task.setTaskName("SystemOptStorage");
                taskTypeTemp = this.taskTypeDao.readTaskType(this.sysOptType);
            } else if (taskType == this.eventTypeId) {
                this.firstDate = this.cycleDate + Integer.parseInt(this.eventReserDate);
                task.setTaskName("EventOptStorage");
                taskTypeTemp = this.taskTypeDao.readTaskType(this.eventType);
            }
            Date currentDate = new Date();
            Date date = this.getFirstStorageTime();
            if (null == date) {
                return;
            }
            task.setBaseTime(date);
            task.setCreateTime(currentDate);
            task.setExecuteType(Integer.valueOf(2));
            task.setIsNotifyFail(Boolean.valueOf(false));
            task.setPeriod(Integer.valueOf(this.cycleDate));
            task.setPeriodtimes(Integer.valueOf(-1));
            task.setPeriodType(Integer.valueOf(TaskPeriodType.date.getValue()));
            task.setLastModifyTime(currentDate);
            task.setTaskType(taskTypeTemp);
            task.setCreateUser(Long.valueOf(1L));
            task.setTaskCategory(Integer.valueOf(TaskCategory.system.getValue()));
            task.setTaskStatus(Integer.valueOf(TaskStatus.idle.getValue()));
            TaskParameter taskParameter = new TaskParameter();
            taskParameter.setParameter1(this.filestyleValue);
            if (taskType == this.sysOptTypeId) {
                taskParameter.setParameter2(this.sysOptReserDate);
            } else if (taskType == this.eventTypeId) {
                taskParameter.setParameter2(this.eventReserDate);
            }
            taskParameter.setParameter3(this.langValue);
            taskParameter.setParameter4(this.time);
            taskParameter.setParameter5(filePath);
            task.setParameter(taskParameter);
            task.setIsNotifyFail(Boolean.valueOf(false));
            task.setIsNotifySuccess(Boolean.valueOf(false));
            task.setIsSendMail(Boolean.valueOf(false));
            task.setIsSendNote(Boolean.valueOf(false));
            taskParameter.setTask(task);
            this.taskDao.addTask(task);
            this.taskManager.start(task);
        }
    }

    private Date getFirstStorageTime() {
        Date fristRunTime = null;
        SimpleDateFormat formatH = new SimpleDateFormat("H");
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date nextDay = new Date();
        int hour = Integer.parseInt(formatH.format(nextDay));
        Calendar cal = Calendar.getInstance();
        if (hour >= this.defaultTimeHour) {
            cal.add(5, this.firstDate + 1);
            nextDay = cal.getTime();
        } else {
            cal.add(5, this.firstDate);
            nextDay = cal.getTime();
        }
        try {
            fristRunTime = dateFormat.parse(formatDay.format(nextDay) + " " + this.time);
        }
        catch (ParseException e) {
            this.log.error((Object)("ParseException: " + e.getMessage()));
        }
        return fristRunTime;
    }

    private String getStorageFilePath(int taskType) {
        String currentPath = LogStorageUtil.DUMP_BASE_PATH + File.separator;
        if (taskType == this.sysOptTypeId) {
            currentPath = currentPath + "datastorage" + File.separator + "sysoptlog";
        } else if (taskType == this.eventTypeId) {
            currentPath = currentPath + "datastorage" + File.separator + "alarm";
        }
        return currentPath;
    }

    public ITaskTypeDAO getTaskTypeDao() {
        return this.taskTypeDao;
    }

    public void setTaskTypeDao(ITaskTypeDAO taskTypeDao) {
        this.taskTypeDao = taskTypeDao;
    }

    public ITaskDAO getTaskDao() {
        return this.taskDao;
    }

    public void setTaskDao(ITaskDAO taskDao) {
        this.taskDao = taskDao;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Override
    public void run() {
        this.init(this.sysOptTypeId);
        this.init(this.eventTypeId);
    }
}

