/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.sysjob;

import com.hs.lego.cbb.task.certjob.TaskConfig;
import com.hs.lego.cbb.task.dao.ITaskDAO;
import com.hs.lego.cbb.task.dao.ITaskTypeDAO;
import com.hs.lego.cbb.task.manager.TaskManager;
import com.hs.lego.cbb.task.sdk.model.Task;
import com.hs.lego.cbb.task.sdk.model.TaskParameter;
import com.hs.lego.cbb.task.sdk.model.TaskType;
import com.hs.lego.cbb.task.sdk.service.TaskExecuteType;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.LogStorageUtil;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class InitDivertLogStorageTask
implements Runnable {
    private String sysOptReserDate = "90";
    private String filestyleValue = "2";
    private String time = "00:00:00";
    private String langValue = "1";
    private ITaskTypeDAO taskTypeDao;
    private ITaskDAO taskDao;
    private TaskManager taskManager;
    private Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_DUMP);

    private Date getRunTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        Date nowTime = new Date();
        Date firstStartTime = null;
        try {
            Calendar c = Calendar.getInstance();
            c.setTime(nowTime);
            c.add(5, 1);
            firstStartTime = dateFormat.parse(formatDay.format(c.getTime()) + " 00:00:00");
        }
        catch (ParseException e) {
            firstStartTime = nowTime;
            this.log.error((Object)("init divert sheduler error,set current time as firststarttime! " + e.getMessage()));
        }
        return firstStartTime;
    }

    private Task createDefaultTask() {
        Task task = new Task();
        Integer periodDay = TaskConfig.getInstance().getPeriod();
        task.defaultSystemTask("DivertLogStorage", periodDay);
        Date firstStartTime = this.getRunTime();
        task.setBaseTime(firstStartTime);
        task.setExecuteType(Integer.valueOf(TaskExecuteType.period.getValue()));
        TaskParameter taskParams = task.getParameter();
        taskParams.setParameter1(this.filestyleValue);
        taskParams.setParameter2(this.sysOptReserDate);
        taskParams.setParameter3(this.langValue);
        taskParams.setParameter4(this.time);
        String filePath = this.getStorageFilePath() + File.separator + "sysoptlog";
        taskParams.setParameter5(filePath);
        TaskType taskType = this.taskTypeDao.readTaskType("divert_log_bk");
        task.setTaskType(taskType);
        return task;
    }

    public void init() {
        if (!this.checkTaskExists()) {
            this.log.info((Object)"divert log task doesn't exist,create a new task.");
            Task task = this.createDefaultTask();
            this.taskDao.addTask(task);
            this.taskManager.start(task);
        }
        this.log.info((Object)"TaskManager will schedule all the task.");
    }

    private boolean checkTaskExists() {
        boolean isExist = true;
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("taskType", "divert_log_bk");
        List taskList = this.taskDao.queryTask(condition);
        if (null == taskList || taskList.isEmpty()) {
            isExist = false;
        }
        return isExist;
    }

    private String getStorageFilePath() {
        return LogStorageUtil.DUMP_BASE_PATH + File.separator + "datastorage";
    }

    public ITaskTypeDAO getTaskTypeDao() {
        return this.taskTypeDao;
    }

    public void setTaskTypeDao(ITaskTypeDAO taskTypeDao) {
        this.taskTypeDao = taskTypeDao;
    }

    public ITaskDAO getTaskDao() {
        return this.taskDao;
    }

    public void setTaskDao(ITaskDAO taskDao) {
        this.taskDao = taskDao;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Override
    public void run() {
        this.init();
    }
}

