/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.sysjob;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.task.sdk.model.Task;
import com.hs.lego.cbb.task.sdk.model.TaskParameter;
import com.hs.lego.cbb.task.sdk.service.ITaskService;
import com.hs.lego.cbb.validity.service.ILogStorage;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.sdk.service.IFaultBackupService;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class StorageFactory {
    private static final int SLEEPCOUNT = 100;
    private static final long SLEEPTIME = 1000L;
    protected final transient Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_DUMP);
    private ILogStorage logService;
    private IFaultBackupService faultBackupService = null;
    private ITaskService taskService;
    private TaskParameter taskParameter = null;
    private String sysOptType = "log_bk";
    private String alarmType = "alarm_bk";
    private String fileStyle = "";
    private String lang = "";
    private String reserDate;
    private Map<String, Object> condition;

    public String dateStorage(String dateType) {
        String resultLink = "";
        Task task = null;
        this.log.info((Object)("System dateStorage begin dateType is " + AticUtil.getcleanedMessage((String)dateType)));
        for (int i = 0; null == this.taskService && i < 100; ++i) {
            this.taskService = (ITaskService)ServiceContext.getInstance().getService("taskService", ITaskService.class);
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                this.log.error((Object)e.getMessage());
            }
        }
        if (null != this.taskService) {
            this.log.info((Object)"taskService is  not null");
            this.condition = new HashMap<String, Object>();
            if (dateType.equals(this.sysOptType)) {
                this.condition.put("taskType", this.sysOptType);
                this.logService = this.getILogService();
            } else if (dateType.equals(this.alarmType)) {
                this.condition.put("taskType", this.alarmType);
                this.faultBackupService = this.getFaultBackupService();
            }
            this.log.info((Object)("condition" + this.condition.toString()));
            List taskList = this.taskService.queryTasks(this.condition);
            if (null == taskList || taskList.isEmpty()) {
                return "";
            }
            task = (Task)taskList.get(0);
            this.taskParameter = task.getParameter();
            if (null != this.taskParameter) {
                this.fileStyle = this.taskParameter.getParameter1();
                this.reserDate = this.taskParameter.getParameter2();
                this.lang = this.taskParameter.getParameter3();
                resultLink = this.dateStorageByType(dateType);
            }
        } else {
            this.log.info((Object)"taskService is null");
        }
        return resultLink;
    }

    private IFaultBackupService getFaultBackupService() {
        for (int i = 0; null == this.faultBackupService && i < 100; ++i) {
            try {
                this.faultBackupService = (IFaultBackupService)ServiceContext.getInstance().getService("faultBackupService", IFaultBackupService.class);
                continue;
            }
            catch (RuntimeException e) {
                this.log.error((Object)("taskService is null!" + e.getMessage()));
                continue;
            }
            finally {
                try {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.log.error((Object)("InterruptedException: " + e.getMessage()));
                }
            }
        }
        return this.faultBackupService;
    }

    private ILogStorage getILogService() {
        for (int i = 0; null == this.logService && i < 100; ++i) {
            try {
                this.logService = (ILogStorage)ServiceContext.getInstance().getService("logStorageImpl", ILogStorage.class);
                continue;
            }
            catch (RuntimeException e) {
                this.log.error((Object)("logService is null!" + e.getMessage()));
                this.log.error((Object)"getISysOptLogService taskService is null.");
                continue;
            }
            finally {
                try {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.log.error((Object)("InterruptedException: " + e.getMessage()));
                }
            }
        }
        return this.logService;
    }

    private String dateStorageByType(String dateType) {
        String resultLink = "";
        String fileTypes = this.getFileType(this.fileStyle);
        this.log.info((Object)("fileTypes=" + fileTypes));
        if (dateType.equals(this.sysOptType)) {
            if (null != this.logService) {
                resultLink = this.logService.transferLog(fileTypes, this.getEndTime(this.reserDate), this.getLang(this.lang));
            } else {
                this.log.info((Object)"System dateStorage ISysOptLog is null");
            }
        } else if (dateType.equals(this.alarmType)) {
            if (null != this.faultBackupService) {
                resultLink = this.faultBackupService.transferAlarm(fileTypes, this.getEndTime(this.reserDate), this.getLang(this.lang));
            } else {
                this.log.info((Object)"System dateStorage IFaultBackupService is null");
            }
        }
        this.log.info((Object)("resultLink=" + resultLink));
        return resultLink;
    }

    private long getEndTime(String resDate) {
        long endTime = -1L;
        if (null != resDate && !resDate.equals("")) {
            int reserDate1 = Integer.parseInt(resDate);
            Calendar cal = Calendar.getInstance();
            cal.add(5, -reserDate1);
            endTime = cal.getTime().getTime();
        }
        return endTime;
    }

    private String getFileType(String fileType) {
        String file = "";
        file = fileType.equals("1") ? "csv" : "excel";
        return file;
    }

    public String getAlarmType() {
        return this.alarmType;
    }

    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

    private String getLang(String language) {
        String langUa = "";
        langUa = language.equals("1") ? "en" : "zh";
        return langUa;
    }

    public ILogStorage getLogService() {
        return this.logService;
    }

    public void setLogService(ILogStorage logService) {
        this.logService = logService;
    }

    public ITaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(ITaskService taskService) {
        this.taskService = taskService;
    }

    public TaskParameter getTaskParameter() {
        return this.taskParameter;
    }

    public void setTaskParameter(TaskParameter taskParameter) {
        this.taskParameter = taskParameter;
    }

    public void setFaultBackupService(IFaultBackupService faultBackupService) {
        this.faultBackupService = faultBackupService;
    }
}

