var JSDebug = {
    markerColor:{
        gray: "gray", green : 'green', navy: 'navy', black : 'black', blue : 'blue', purple: 'purple',red :'red'
    },
    markerDesc: ["gray",  'green','navy', 'black','blue', 'purple', 'red'],
    logFilterItems: [
        {key:'gray', value:'gray'},
        {key:'green', value:'green'},
        {key:'navy', value:'navy'},
        {key:'black', value:'black'},
        {key:'blue', value:'blue'},
        {key:'purple', value:'purple'},
        {key:'red', value:'red'}
    ],
    defaultColor : 'gray',
    debugMode : false,
    infodiv: null,
    switchDiv:null,
    displaydiv: null,
    toolbarDiv: null,
    
    getToolbarDiv: function() {
        this.switchDiv = document.createElement('div') ;
        this.switchDiv.style.position = 'absolute';
        this.switchDiv.style.bottom = "0";
        this.switchDiv.style.left = "1%"; 
        this.switchDiv.style.display = '';
        
        var _btnShow = document.createElement('<input type="button" style="visibility: hide;" value="Debug" class="button_short"/>');
        _btnShow.style.display = '';
        _btnShow.onclick = function() {
            JSDebug.infodiv.style.display = '';
            _btnShow.style.display = 'none';
            _btnHide.style.display = '';

            var infoTb =  JSDebug.getInfoDisplay();
            var _rows = infoTb.rows;
            for(var  i = 0 ; i < _rows.length ; i++) {
                _rows[i].style.display = '';
            }
            
            logFilterDiv.style.display = "";
        }
        var _btnHide = document.createElement('<input type="button" value="Undebug" class="button_short"/>');
        _btnHide.style.display = 'none';
         _btnHide.onclick = function() {
            JSDebug.infodiv.style.display = 'none';
            _btnHide.style.display = 'none';
            _btnShow.style.display = '';
            logFilterDiv.style.display = "none";
        }
        
        this.switchDiv.appendChild(_btnShow);
        this.switchDiv.appendChild(_btnHide);
        
        var logFilterDiv = document.createElement('div') ;
        logFilterDiv.id = 'js-log-logfilterdiv';
        logFilterDiv.style.display = 'none';
       
        var cb;
        var _div;
        for(var i = 0 ; i < this.logFilterItems.length; i++) {
            cb = document.createElement('<input type="checkbox" name="logFilterCbs" checked="true" value="' + this.logFilterItems[i]["value"] + '"/>');
            cb.onpropertychange = function() {
                if(event.propertyName == 'checked') {
                    var _value = event.srcElement.value;
                    var _rows = JSDebug.getInfoDisplay().rows;
                    var _checked = event.srcElement.checked;
                    for(var i = 0 ; i < _rows.length; i++) {
                        if(_rows[i].value == _value) {
                            if(_checked) {
                                _rows[i].style.display = '';
                            } else {
                                _rows[i].style.display = 'none';
                            }
                        }
                    }
                }
            }
            _div = document.createElement('div') ;
            _div.style.display = '';
            _div.innerHTML = "<font color='"+ this.logFilterItems[i]["key"] +"'>" + this.logFilterItems[i]["value"] + "</font>";
            _div.style.textAlgin = 'top';
            logFilterDiv.appendChild(cb);
            logFilterDiv.appendChild(_div);
        }
        var linker_selectAll = document.createElement('a');
        linker_selectAll.className = 'a_noLink';
        linker_selectAll.style.paddingLeft = 10;
        linker_selectAll.innerHTML = '[All]';
        linker_selectAll.onclick = function() {
            var cbs = document.getElementsByName('logFilterCbs');
            for(var i = 0 ; i < cbs.length ; i++) {
                cbs[i].checked = true;
            }
        }
        var linker_clearAll = document.createElement('a');
        linker_clearAll.className = 'a_noLink';
        linker_clearAll.style.paddingLeft = 10;
        linker_clearAll.innerHTML = '[Clear]';
        linker_clearAll.onclick = function() {
            var cbs = document.getElementsByName('logFilterCbs');
            for(var i = 0 ; i < cbs.length ; i++) {
                cbs[i].checked = false;
            }
        }
        logFilterDiv.appendChild(linker_selectAll);
         logFilterDiv.appendChild(linker_clearAll);
        
         this.switchDiv.appendChild(logFilterDiv);
        document.body.appendChild(this.switchDiv);
    },
    getInfoDisplay : function() {
        if(this.infodiv) {
            return this.displayTb;
        } else {
            this.toolbarDiv = this.getToolbarDiv();
            
            this.infodiv = document.createElement('div') ;
            this.infodiv.style.border = '1 solid #cccccd';
            var dialogHeight;
            if(window.dialogHeight) {
                dialogHeight = window.dialogHeight.substring(0, window.dialogHeight.length - 2);
            } else {
                dialogHeight = document.body.scrollHeight;
            }
            this.infodiv.style.height =dialogHeight - 22;
            this.infodiv.style.textAlign = 'left';
            this.infodiv.style.position = 'absolute';
            this.infodiv.style.top = "2px";
            this.infodiv.style.bottom = "20px";
            this.infodiv.style.width= "98%";
            this.infodiv.style.left = "1%";
            this.infodiv.style.right = "1%";
            this.infodiv.style.backgroundColor = 'white';
            this.infodiv.style.display = 'none';
            
            var _btn = document.createElement('<input type="button" value="清空" class="button_short"/>');
            _btn.style.paddingLeft = "5px";
            _btn.style.paddingTop = "5px";
            _btn.onclick = function() {
                var rows = document.getElementById("debug-info-table").rows;
                for(var i = rows.length -1 ; i >= 0; i--) {
                    document.getElementById("debug-info-table").deleteRow(rows[i].rowIndex);
                }
            }
            this.infodiv.appendChild(_btn);
            
            this.displaydiv = document.createElement('div') ;
            var infoDivHeight = this.infodiv.style.height;
            infoDivHeight = infoDivHeight.substring(0, infoDivHeight.length - 2);
            this.displaydiv.style.height = infoDivHeight - 28;
            this.displaydiv.style.overflow = 'scroll';
            this.displaydiv.style.width = "98%";
            this.displaydiv.style.paddingLeft = '5px';
            this.displaydiv.style.paddingRight = '5px';
            this.displaydiv.id = 'debug-info-div';
            
            this.displayTb = document.createElement('<table id="debug-info-table"></table>') ;
            this.displayTb.cellPadding = '0px';
            this.displayTb.cellSpacing = '0px';
            this.displaydiv.appendChild(this.displayTb);
            this.infodiv.appendChild(this.displaydiv);
            document.body.appendChild(this.infodiv);
            
            return this.displayTb;
        }
    },
    debug : function(info,color) {
        if(this.debugMode) {
            if(color) {
                this.addRowInfo(info,color);
            } else {
                this.addRowInfo(info,this.defaultColor);
            }
        }
    },
    error : function() {
        if(this.debugMode) {
           this.addRowInfo(info, this.levels.error);
        }
    },
    addRowInfo : function(info, color) {
        info = "<font color='"+ this.markerColor[color] +"'>" + info + "</font>";
        var _tb = this.getInfoDisplay();
        var _tr =_tb.insertRow();
        _tr.value = color;
        var _td1 = _tr.insertCell();
        _td1.noWrap = 'true';
        _td1.vAlign = 'top';
        _td1.innerHTML = '<font color="'+ this.markerColor[color] +'"> [' + color + '] 调试信息('+ _tr.rowIndex +'): </font>';
        var _td2 = _tr.insertCell();
        _td2.innerHTML = info;
        return _tr;
    }
};
