var ConditionType = new Object;
ConditionType.deviceTypeID = "DEVICE_TYPE_ID";
ConditionType.deviceID = "DEVICE_ID";
ConditionType.curTime = "CUR_TIME";
ConditionType.protocolID = "PROTOCOL_ID";
ConditionType.statType = "qosStatType";
ConditionType.mailProtocol = "mailProtocol";
ConditionType.mailPolicy = "mailPolicy";
ConditionType.destIP = "DEST_IP";
ConditionType.imType = "imType";
ConditionType.qoServiceType = "qoServiceType";
ConditionType.visitType = "visitType";
ConditionType.rule = "rule";
ConditionType.urlStr = "urlStr";
ConditionType.collectionID = "COLLECTION_ID";
ConditionType.actionPath = "reportTaskActionPath";
ConditionType.attackType = "ATTACK_TYPE";
ConditionType.logType = "LOG_TYPE";
ConditionType.alarmLevel = "ALARM_LEVEL";
ConditionType.scanResult = "scanResult";
ConditionType.sortType = "sortType";
ConditionType.gateWay = "gateWay";
ConditionType.PROTOCOL_ID = "PROTOCOL_ID";
function StringBuffer() {
	this._ss = [];
}
StringBuffer.prototype.append = function(str) {
	this._ss.push(str);
	return this;
};
StringBuffer.prototype.toString = function() {
	return this._ss.join("");
};

function getEventObj(evt)
{  
    if(evt == null)
        evt = window.event || evt;
	var srcObj = evt.srcElement ? evt.srcElement : evt.target;
	return srcObj;
}

function isNumber(str) {
	var i;
	for (i = 0; i < str.length; i++) {
		var c = str.charAt(i);
		if (!isDigit(c)) {
			return false;
		}
	}
	return true;
}
function isDigit(c) {
	return ((c >= "0") && (c <= "9"));
}
function isInteger(str) {
	var regu = "^[0-9]+$";
	var re = new RegExp(regu);
	if (str.search(re) != -1) {
		return true;
	} else {
		return false;
	}
	return true;
}

function isEmpty(value) {
	return value == null || value.length == 0;
}
String.prototype.trim = function() {
	return this.replace(/(^\s+)|\s+$/g, "");
};
function lTrim(str) {
	var whitespace = new String(" \t\n\r");
	var s = new String(str);
	if (whitespace.indexOf(s.charAt(0)) != -1) {
		var j = 0, i = s.length;
		while (j < i && whitespace.indexOf(s.charAt(j)) != -1) {
			j++;
		}
		s = s.substring(j, i);
	}
	return s;
}
function rTrim(str) {
	var whitespace = new String(" \t\n\r");
	var s = new String(str);
	if (whitespace.indexOf(s.charAt(s.length - 1)) != -1) {
		var i = s.length - 1;
		while (i >= 0 && whitespace.indexOf(s.charAt(i)) != -1) {
			i--;
		}
		s = s.substring(0, i + 1);
	}
	return s;
}
function checkEmail(str) {
	var reg = /[\u4e00-\u9fa5]/g;
	if (reg.test(str))
		return false;
	var pattern = /[\u4e00-\u9fA5a-zA-Z0-9_.]{1,}@[\u4e00-\u9fA5a-zA-Z0-9_]{1,}\.[a-zA-Z0-9_]{1,}/g;
	if (str.match(pattern) == null) {
		return false;
	} else {
		return true;
	}
}
function containInvalidCharactor(str) {
	var reg = /[^\w\u4e00-\u9fa5 \.-]/g;
	return (reg.test(str)) ? true : false;
}

function grantInput(str) {
	var reg = /[^\w]/g;
	return (reg.test(str)) ? true : false;
}

function grantUserInput(str) {
	var reg = /[^\w\,]/g;
	return (reg.test(str)) ? true : false;
}

function checkFormatTime(str) {
	var reg = /^([1-9][0-9][0-9][0-9])-([0-1][0-9])-([0-3][0-9]) ([0-2][0-9]):([0-5][0-9]):([0-5][0-9])$/;

	if (!str) {
		return false;
	} else {

		if (!reg.test(str)) {
			return false;
		}

		var dataArr = str.split(' ');

		if (isDateString(dataArr[0]) == false) {
			return false;
		}
		var hour = dataArr[1].split(":")[0];

		if (hour > 23) {
			return false
		}


	}
}

function isDateString(sDate) {

	var iaMonthDays = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
	var iaDate = new Array(3);
	var year, month, day;
	if (arguments.length != 1) {
		return false;
	}
	iaDate = sDate.toString().split("-");
	if (iaDate.length != 3) {
		return false;
	}
	if (iaDate[1].length > 2 || iaDate[2].length > 2) {
		return false;
	}
	year = parseFloat(iaDate[0]);
	month = parseFloat(iaDate[1]);
	day = parseFloat(iaDate[2]);


	if (((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0)) {
		iaMonthDays[1] = 29;
	}
	if (month < 1 || month > 12) {
		return false;
	}
	if (day < 1 || day > iaMonthDays[month - 1]) {
		return false;
	}
	return true;
}

function openWindow(url) {

	window
			.showModalDialog(
					url,
					window,
					"dialogHeight:580px; dialogWidth:490px; toolbar:no;titlebar:no;menubar:no;scroll:no;resizable:no;location:no; status:no; left:300px; top:200px");
}

function getCookieDecode(offset) {
	var endstr = document.cookie.indexOf(";", offset);
	if (endstr == -1) {
		endstr = document.cookie.length;
	}
	return unescape(document.cookie.substring(offset, endstr));
}
function getCookie(name) {
	var arg = name + "=";
	var alen = arg.length;
	var clen = document.cookie.length;
	var i = 0;
	while (i < clen) {
		var j = i + alen;
		if (document.cookie.substring(i, j) == arg) {
			return getCookieDecode(j);
		}
		i = document.cookie.indexOf(" ", i) + 1;
		if (i == 0) {
			break;
		}
	}
	return null;
}
function setCookie(name, value) {
	var expdate = new Date();
	var argv = setCookie.arguments;
	var argc = setCookie.arguments.length;
	var expires = (argc > 2) ? argv[2] : null;
	var path = (argc > 3) ? argv[3] : null;
	var domain = (argc > 4) ? argv[4] : null;
	var secure = (argc > 5) ? argv[5] : false;
	if (expires != null) {
		expdate.setTime(expdate.getTime() + (expires * 1000));
	}
	document.cookie = name + "=" + escape(value)
			+ ((expires == null) ? "" : ("; expires=" + expdate.toGMTString()))
			+ ((path == null) ? "" : ("; path=" + path))
			+ ((domain == null) ? "" : ("; domain=" + domain))
			+ ((secure == true) ? "; secure" : "");
}
function selectAllCheckBox(allCheckBoxID, checkBoxName) {
	var checkBoxArr = document.getElementsByName(checkBoxName);
	for (var i = 0; i < checkBoxArr.length; i++) {
		checkBoxArr[i].checked = document.getElementById(allCheckBoxID).checked;
	}
}

var deviceNameObjId = "";

function showDeviceNameWindow(appType, deviceTypeId, nameObjId, noteObjId, path) {
	if (!checkTimeout(path)) {
		var timeflag = new Date().getTime();
		openWindow(path + '/jsp/util/device/device.jsp?appType=' + appType
				+ '&deviceTypeId=' + deviceTypeId + '&nameObjId=' + nameObjId
				+ '&noteObjId=' + noteObjId + '&timeflag=' + timeflag);
	}
}

function setDevNames(id, idStr, path) {
	this.deviceNamesObjId = id;
	this.idStr = idStr;
	this.backfillDevNames = function(nameAndId) {

		if (nameAndId == null)
			return;

		var devIds = nameAndId.split('|')[1];
		var devNameStr = nameAndId.split('|')[0];

		var devNames = devNameStr.split(',');
		var len = devNames.length;

		if (devNameStr.length > 80) {
			var arrTemp = new Array();
			var strTemp = "";
			for (var i = 0; i < len; i++) {
				if ((strTemp.length + devNames[i].length) < 80) {
					arrTemp[i] = devNames[i];
					strTemp += devNames[i];
				} else {
					break;
				}
			}
			document.getElementById(deviceNamesObjId).innerHTML = "[" + arrTemp + "...]";

			strTemp = "";
			for (var i = 0; i < len; i++) {
				if ((strTemp.length + devNames[i].length) < 80) {
					strTemp += devNames[i];
				} else {
					if (i < len - 1) {
						devNames[i + 1] = "\n" + devNames[i + 1];
					}
					strTemp = "";
				}
			}

			var deviceName_Full = document.getElementById('deviceName_Full');
			if (deviceName_Full == null) {
				deviceName_Full = document
						.createElement("<INPUT TYPE='hidden' id='deviceName_Full' NAME='deviceName_Full' VALUE='"
								+ devNames.toString() + "'>");
				document.getElementById(deviceNamesObjId).appendChild(deviceName_Full);
			}

			document.getElementById(deviceNamesObjId).title = devNames;
		} else {
			if (devNameStr == '')
				document.getElementById(deviceNamesObjId).innerHTML = '';
			else if (devIds != '0')
				document.getElementById(deviceNamesObjId).innerHTML = "[" + devNameStr + "]";
			else
				document.getElementById(deviceNamesObjId).innerHTML = devNameStr;
			document.getElementById(deviceNamesObjId).title = devNameStr;
		}

		document.getElementById(deviceNamesObjId).value = devIds;

		if (document.getElementById('dumpedDate')) {
			loadDateList();
		}

	}

	DwrDeviceProcess.getDeviceNamesByIDStr(idStr, {
		callback : backfillDevNames,
		errorHandler : function(errorMsg) {
			showErrorPage(errorMsg, path);
		}
	});
}

var freshExcuteMethod = "";
var freshInterval = "";
function getFreshObj(id, timesValue, timesDescri, excuteMethodName) {
	freshExcuteMethod = excuteMethodName;
	var freshTD = document.getElementById(id);
	var selectElement = document.createElement("select");
	selectElement.id = "freshSelect";
	selectElement.className = "input_select_template";
	selectElement.onchange = changeFreshSelect;
	for (var i = 0; i < timesDescri.length; i++) {
		selectElement.options[selectElement.length] = new Option(
				timesDescri[i], timesValue[i]);
	}
	freshTD.appendChild(selectElement);
	freshInterval = window.setInterval(freshExcuteMethod,
			parseInt(timesValue[0]));
}
function changeFreshSelect() {
	window.clearInterval(freshInterval);
	var freshValue = document.getElementById("freshSelect").value;
	if (freshValue == "manual") {
		return;
	}
	freshInterval = window.setInterval(freshExcuteMethod, parseInt(freshValue));
}
function initSelectObj(id, appType) {
	this.selectID_Global = id;
	var obj = this;
	this.setSelectObj = function(_datas) {
		var dataArr = [];
		for (var i = 0; i < _datas.length; i++) {
			dataArr.push({
				key : _datas[i].key,
				value : _datas[i].value
			});
		}

		addOptions(obj.selectID_Global, dataArr, "key", "value");
	}
	if (appType == "syslogLevel") {
		DwrListProcess.getSyslogLevels({
			callback : this.setSelectObj
		});
	}
	else if (appType == "deviceType") {
		DwrListProcess.getDeviceTypes({
			callback : this.setSelectObj
		});
	}
	else if (appType == "syslogType") {
		DwrListProcess.getLogTypes({
			callback : this.setSelectObj
		});

	}
	else if (appType == "loginType") {
		DwrListProcess.getLoginTypes({
			callback : this.setSelectObj
		});

	}
	else if (appType == "attackType") {
		DwrListProcess.getAttackTypes({
			callback : this.setSelectObj
		});
	}
	else if (appType == "basicProtocol") {
		DwrListProcess.getProtocols({
			callback : this.setSelectObj
		});
	} else {
		return;
	}
}

function keyValueObj(key, value) {
	this.key = key;
	this.value = value;
}

function addObject(arr, obj) {
	var len = arr.length;
	arr[len] = obj;
}

function changeContentAspect(linkId, contentId, moreConditionId, hideAspect,
		displayAspect) {
	var contentArea = document.getElementById(contentId);
	var contentLink = document.getElementById(linkId);
	if (contentLink.childNodes[0].nodeType == 3) {
		if (contentArea.style.display == "none") {
			contentArea.style.display = "";
			contentLink.innerHTML = "[" + hideAspect + "]"
		} else {
			contentArea.style.display = "none";
			contentLink.innerHTML = "[" + displayAspect + "]"
		}
	}
	else {
		var imgSrc = contentLink.childNodes[0].src;
		var imgChangeSrc = "";
		if (imgSrc.indexOf("close") != -1) {
			imgChangeSrc = imgSrc.replace("close", "open");
		} else {
			imgChangeSrc = imgSrc.replace("open", "close");
		}
		if (contentArea.style.display == "none") {
			contentArea.style.display = "";
			contentLink.innerHTML = "<img src=" + imgChangeSrc
					+ " class=image_vmiddle>";
			if (moreConditionId != "none") {
				document.getElementById(moreConditionId).style.display = "";
			}
		} else
		{
			contentArea.style.display = "none";
			contentLink.innerHTML = "<img src=" + imgChangeSrc
					+ " class=image_vmiddle>";
			if (moreConditionId != "none") {
				document.getElementById(moreConditionId).style.display = "none";
			}
		}
	}
}

function hideContentArea(linkId, contentId, displayAspect) {
	var contentArea = document.getElementById(contentId);
	var contentLink = document.getElementById(linkId);
	contentArea.style.display = "none";
	contentLink.innerHTML = "[" + displayAspect + "]"
}

function moveSelectedItems(from, to) {
	var listFrom = document.getElementById(from);
	var listTo = document.getElementById(to);

	for (var i = listFrom.options.length - 1; i >= 0; i--) {
		if (listFrom.options[i].selected) {
			listTo.appendChild(listFrom.options[i]);
		}
	}
}

function moveAllItems(from, to) {
	var listFrom = document.getElementById(from);
	var listTo = document.getElementById(to);

	for (var i = listFrom.options.length - 1; i >= 0; i--) {
		listTo.appendChild(listFrom.options[i]);
	}
}

function getIDsFromList(listid) {
	var result = "";
	var list = document.getElementById(listid);
	if (list.options.length > 0) {
		for (var i = 0, len = list.options.length; i < len; i++) {
			result += list.options[i].value + ",";
		}
		result = result.substring(0, result.length - 1);
	}
	return result;
}
function getCheckboxValues(checkboxname) {
	var checkbox = document.getElementsByName(checkboxname);
	var result = "";
	if (checkbox.length > 0) {
		for (var i = 0; i < checkbox.length; i++) {
			if (checkbox[i].value != null && checkbox[i].value != "") {
				result += checkbox[i].value + ",";
			}
		}
		result = result.substring(0, result.length - 1);
	}
	return result;
}

function openErrorWindow(url) {
	window
			.showModalDialog(
					url,
					window,
					"dialogHeight:195px; dialogWidth:450px; toolbar:no;menubar:no;scroll:no;resizable:no;location:no; status:no; left:300px; top:200px");
}
function showErrorPage(errorMsg, path) {
	if (errorMsg != null && errorMsg != "") {
		window.$ErrorMsg$ = errorMsg;
		var url = path + "/elog/jsp/errorpage/error.jsp";
		openErrorWindow(url);
	}
}

function checkAll(obj, cancel, select) {
	var names = document.getElementsByName("checkboxX");
	if (obj.id == "all") {
		for (var i = 0; i < names.length; i++) {
			names[i].checked = true;
		}

		document.getElementById("chooseAll").innerHTML = "[" + cancel + "]";
		obj.id = "zero";

	} else {
		for (var i = 0; i < names.length; i++) {
			names[i].checked = false;
		}
		document.getElementById("chooseAll").innerHTML = "[" + select + "]";
		obj.id = "all";
	}
}
function chooseObj(chooseid, choosename, ids, names, cols, choosetype) {
	this.chooseid = chooseid;
	this.choosename = choosename;
	this.ids = ids;
	this.names = names;
	this.cols = cols;
	this.choosetype = choosetype;
	this.loadChooseObj = loadChooseObj;
	this.getChooseObj = getChooseObj;
	this.setChooseObj = setChooseObj;
	this.getSelText = getSelText;
	this.getChooseObjByText = getChooseObjByText;
}
function loadChooseObj(doc, _width) {
	var chooseObj;
	if(doc != undefined) {
		chooseObj = doc.getElementById(this.chooseid);	
	} else {
		chooseObj = document.getElementById(this.chooseid);
	}
	if (chooseObj == undefined)
	{
	    chooseObj = ConditionUtils.getTopDocument().getElementById(this.chooseid);
	}
	
	var w;
	if(_width != undefined)
	{
		w = _width;
	}
	else
	{
		w = '580px';
	}
	
	var i = 0;
	var objHtml = new StringBuffer();
	var m = 0;
	var selectName;
	if (this.ids.length > 0) {
		objHtml.append("<table border=0 cellspacing=0 cellpadding=0 width='"+w+"' >")
		if (this.choosetype == 1) {
			for (i = 0; i < this.ids.length; i++) {
				if (i % this.cols == 0) {
					m = i;
					objHtml.append("  <tr>");
				}
				if (this.names[i].length > 28) {
					selectName = "<span class=\"div_clip\" style=\"width:150;\" title=\""
							+ this.names[i] + "\">" + this.names[i] + "</span>";
				} else {
					selectName = this.names[i];
				}
				objHtml.append("   <td width=19%")
				       .append("   <div class='x-form-check-wrap x-form-check-checked' onclick='LegoTag.clickCheckboxEvent(this,event);'>")
				       .append("   <div id="+ this.choosename
							+ this.ids[i] + " class='x-form-check-wrap-inner' onmouseout='LegoTag.removeClsEv(this,event,\"x-form-check-over\");' onmouseover='LegoTag.addClsEv(this,event,\"x-form-check-over\");' tabindex='0'>")
				       .append("   <img src='" + WEB_ROOT_ABS_PATH + "/elog/images/s.gif' class='x-form-check'>")
				       .append("   <input type='checkbox' name='" 
				            + this.choosename
							+ "' value='" + this.ids[i]
							+ "' class='x-form-checkbox x-form-field x-hidden'"
							+ "' checked='true' textvalue='" + this.names[i]
							+ "'/>" + selectName)
			           .append(" </div></div>")
				       .append("   </td>")
				if (i == m + this.cols) {
					objHtml.append("  </tr>");
				}
			}
		} else {
			var html_td;
			if (this.choosetype == 2) {
				html_td = "<td width=19%>";
			} else if (this.choosetype = 3)
			{
				html_td = "<td class=td_list_content width=19%>";
			}
            
			for (i = 0; i < this.ids.length; i++) {
				if (i % this.cols == 0) {
					m = i;
					objHtml.append("  <tr>")
				}
				objHtml.append(html_td)
				
				if (i == 0) {
					objHtml.append("   <div class='x-form-radio-wrap  x-form-check-checked' onkeydown='LegoTag.keydownRadioEvent(this,event)' onclick='LegoTag.clickRadioEvent(this,event);'")
					       .append("   <div onmouseout='LegoTag.removeClsEv(this,event,\"x-form-check-over\");' onmouseover='LegoTag.addClsEv(this,event,\"x-form-check-over\");' tabindex='0' class='x-form-radio-wrap-inner' id='reportStyle-1-focus'>")
					       .append("   <img src='" + WEB_ROOT_ABS_PATH + "/elog/images/s.gif' class='x-form-radio x-radiogroup-img'>")
					       .append("   <input type=radio id=" + this.choosename
								+ this.ids[i] + " name=" + this.choosename
								+ " value='" + this.ids[i]
								+ "' class='x-form-radio x-form-field x-hidden x-radiogroup-radio'"
								+ "' checked='true' textvalue='" + this.names[i]
								+ "'/>" + this.names[i])
				} else {
					objHtml.append("   <div class='x-form-radio-wrap' onkeydown='LegoTag.keydownRadioEvent(this,event)' onclick='LegoTag.clickRadioEvent(this,event);'")
					       .append("   <div onmouseout='LegoTag.removeClsEv(this,event,\"x-form-check-over\");' onmouseover='LegoTag.addClsEv(this,event,\"x-form-check-over\");' tabindex='0' class='x-form-radio-wrap-inner' id='reportStyle-1-focus'>")
					       .append("   <img src='" + WEB_ROOT_ABS_PATH + "/elog/images/s.gif' class='x-form-radio x-radiogroup-img'>")
					       .append("   <input type=radio id=" + this.choosename
								+ this.ids[i] + " name=" + this.choosename
								+ " value='" + this.ids[i] 
								+ "' class='x-form-radio x-form-field x-hidden x-radiogroup-radio'"
								+ "' textvalue='"
								+ this.names[i] + "'/>" + this.names[i])
				}
				objHtml.append("   </td>")
				if (i == m + this.cols) {
					objHtml.append("  </tr>")
				}
			}
		}
		objHtml.append("</table>");
	}
	chooseObj.innerHTML = objHtml;
}
function getSelText() {
	var objArr = jQuery("table>tbody>tr>td",document).find(":input[name='" + this.choosename + "']");
	var selText = "";
	
	
	jQuery.each(objArr,function(i,n){
	    if (jQuery(n).attr("checked") == true){
	        selText += "," + jQuery(n).attr("textvalue");
	    }
	});
	
	if (selText != "") {
		selText = selText.substring(1);
	}
	return selText;
}

function getChooseObjByText(text) {
	var objArr = document.getElementsByName(this.choosename);
	for (var i = 0; i < objArr.length; i++) {
		if (objArr[i].textvalue == text) {
			return objArr[i];
		}
	}
	return null;
}

function getChooseObj(doc, flag) {
	var chooseObj;
	if(doc != undefined && doc != null) {
		chooseObj = doc.getElementsByName(this.choosename);
	} else {
		chooseObj = document.getElementsByName(this.choosename);
	}
	
	var temp = "";
	if (chooseObj == null || chooseObj.length == 0) {
		
		chooseObj = ConditionUtils.getTopDocument().getElementsByName(this.choosename);
		if (chooseObj == null || chooseObj.length == 0) {
			return "";
		}
	}
	
	if(flag)
	{
		for (var m = 0; m < chooseObj.length; m++) 
		{
			if (chooseObj[m].type == "checkbox") {
				temp = temp + chooseObj[m].value + ",";
			}
		}
	}
	else
	{
		for (var m = 0; m < chooseObj.length; m++) {
		   
			if (chooseObj[m].type == "checkbox") {
			    var checkElt = jQuery(chooseObj[m]).parent("").parent("");
				if (checkElt.hasClass("x-form-check-checked")) {
					temp = temp + chooseObj[m].value + ",";
				}
			} else {
				if (chooseObj[m].type == "radio") {
					if (chooseObj[m].checked == true) {
						temp = temp + chooseObj[m].value + ",";
					}
				}
			}
		}
	}
	
	temp = temp.substring(0, temp.length - 1);
	return temp;
}

function checkedGroupLego(chkGroup, v) {
	
	var chooseObj = document.getElementsByName(chkGroup);
	
	for (var i = 0; i < chooseObj.length; i++) {
	
		var div = jQuery(chooseObj[i]).parent().parent();
		div.removeClass('x-form-check-checked');
		
		if ((parseInt(chooseObj[i].value) & v) != 0) {
			div.trigger('click');
		}
	}
}
function setChooseObj(ids,doc) {
	var chooseObj;
	if(doc != undefined && doc != null){
		chooseObj = doc.getElementsByName(this.choosename);
	} else {
		chooseObj = document.getElementsByName(this.choosename);
	}
	var temp = "";
	if (chooseObj.length == 0 || ids.length == 0) {
		return "";
	}
	if (this.choosetype == "1"){
		jQuery("#" +this.chooseid+ " .x-form-check-wrap").removeClass("x-form-check-checked");
		if (ids.length > 0 && ids[0] != -100){
			for (var i = 0; i < ids.length; i++){
				jQuery("#"+this.chooseid+ " .x-form-check-wrap").has(":input[value="+ids[i]+"]").addClass("x-form-check-checked");
			}
		}
	}else if(this.choosetype == "2"){
		jQuery("#" +this.chooseid+ " .x-form-radio-wrap").removeClass("x-form-check-checked");
		jQuery("#"+this.chooseid+ " .x-form-radio-wrap").has(":input[value="+ids+"]").addClass("x-form-check-checked");
	}
	
}
function getIFrameHeight(topTB, iframe, percent1, percent2) {

	var titleHeight = 0;
	if (document.getElementById("titleAndHelp") != null) {
		titleHeight = document.getElementById("titleAndHelp").offsetHeight;
	}
	var topAreaHeight = document.getElementById(topTB).offsetHeight;
	var windowHeight = 490;
	try {
	} catch (E) {
	}
	document.getElementById(iframe).height = windowHeight * percent1 - titleHeight - topAreaHeight;
	return windowHeight * percent2 - titleHeight - topAreaHeight;
}

function showTitle_Spe(id, titleInfo, doc) {
	var _html = "";
    if (doc == undefined){
       doc = document;
    }
	_html += "<table class=\"page_head\" cellspacing=\"0\">";
	_html += "     <tr>";
	_html += "        <td>";
	_html += "            <caption>" + titleInfo + "</caption>";
	_html += "        </td>";
	_html += "     </tr>";
	_html += "    <tr>";
	_html += "        <td class=\"page_head_underline\"></td>";
	_html += "     </tr>";
	_html += "</table>";
	 if(doc.getElementById(id))
	 {
	 	doc.getElementById(id).innerHTML = _html;	
	 }	 
}

function showTitleAndHelp_Spe(id, titleInfo, helpInfo, aArr, cookieName, path,
		alt1, alt2) {
	var newHelpInfo = weaveLink_Spe(helpInfo, aArr);
	var _html = "";

	_html += "<input type='hidden' id='cookNameZXCH' value='cookieName"
			+ cookieName + "'/>";
	_html += "<input type='hidden' id='title_helpe_path' value=" + path + "'/>";
	_html += "<table class=\"page_head\" cellspacing=\"0\">";
	_html += "     <tr>";
	_html += "        <td>";
	_html += "            <caption>";
	_html += titleInfo;
	_html += "                <img src=\"" + path
			+ "/images/showhelp.gif\" alt=\"" + alt1
			+ "\" onClick=\"showHelp_Spe(true)\" style=\"cursor: pointer;\">";
	_html += "            </caption>";
	_html += "        </td>";
	_html += "     </tr>";
	_html += "    <tr>";
	_html += "        <td class=\"page_head_underline\"></td>";
	_html += "     </tr>";
	_html += "</table>";

	_html += "<table class=\"table_default\" align=\"center\" cellspacing=\"0px\"";
	_html += "   id=\"tipTB\">";
	_html += "    <tr>";
	_html += "       <td>";
	_html += "           <table class=\"background\" align=\"center\" cellspacing=\"0px\">";
	_html += "               <tr>";
	_html += "                   <td class=\"td_12pxH\"></td>";
	_html += "               </tr>";
	_html += "               <tr>";
	_html += "                  <td>";
	_html += "                      <table class=\"table_help_98percent\" align=\"center\"";
	_html += "                          cellspacing=\"0px\">";
	_html += "                          <tr>";
	_html += "                              <td valign=\"top\">";
	_html += "                                  <img src=\"" + path
			+ "/images/tip.gif\"/>";
	_html += "                              </td>";
	_html += "                              <td width=\"100%\">";
	_html += "                                 <table>";
	_html += "                                     <tr>";
	_html += "                                         <td class=\"td_5pxH\"></td>";
	_html += "                                         <td width=\"100%\">";
	_html += "                                             <span id=\"helpInfo\" class=\"span_Text_help\" style=\"padding-top: 5px\">"
			+ newHelpInfo + "</span>";
	_html += "                                          </td>";
	_html += "                                          <td class=\"td_5pxH\"></td>";
	_html += "                                      </tr>";
	_html += "                                  </table>";
	_html += "                             </td>";
	_html += "                            <td valign=\"top\">";
	_html += "                                 <img src=\"" + path
			+ "/images/closehelp.gif\" alt=\" " + alt2 + "\"";
	_html += "                                    onClick=\"showHelp_Spe(false)\" style=\"cursor: pointer;\">";
	_html += "                            </td>";
	_html += "                        </tr>";
	_html += "                    </table>";
	_html += "                 </td>";
	_html += "             </tr>";
	_html += "            <tr>";
	_html += "                <td class=\"td_12pxH\"></td>";
	_html += "             </tr>";
	_html += "         </table>";
	_html += "        <table class=\"table_default\" cellspacing=\"0px\">";
	_html += "             <tr>";
	_html += "                  <td class=\"td_5pxH\"></td>";
	_html += "             </tr>";
	_html += "         </table>";
	_html += "     </td>";
	_html += "  </tr>";
	_html += " </table>";

	document.getElementById(id).innerHTML = _html;

	var cookieName = document.getElementById('cookNameZXCH').value;
	DwrCookieProcess.readCookie(cookieName, {
		callback : function(msg) {
			if (msg != 'hide') {
				document.getElementById("tipTB").style.display = "";
			} else {
				document.getElementById("tipTB").style.display = "none";
			}
			try {
				refreshHeight();
			} catch (e) {
			}
		}
	});
}

function weaveLink_Spe(str, aArr) {
	if (aArr == "" || aArr == null) {
		return str;
	}

	var aHeadArr = new Array();
	for (var i = 0; i < aArr.length; i++) {
		aHeadArr[i] = '<a onclick="javascript:{this.href=\'' + aArr[i]
				+ '\';}" class="a_noLink">';
	}
	var aTail = '</a>';
	var newStr = "";
	var tempArr = str.split("[");
	for (var i = 0; i < tempArr.length - 1; i++) {
		newStr += tempArr[i] + aHeadArr[i];
	}
	newStr += tempArr[tempArr.length - 1];

	var regs = /[]]/g;
	newStr = newStr.replace(regs, aTail);
	return newStr;
}

function showHelp_Spe(b) {
	if (!checkTimeout(document.getElementById("title_helpe_path").value)) {
		var cookieName = document.getElementById('cookNameZXCH').value;
		if (b) {
			if (document.getElementById("tipTB").style.display == "none") {
				document.getElementById("tipTB").style.display = "";
				DwrCookieProcess.setCookie(cookieName, "show");
				try {
					refreshHeight();
				} catch (e) {
				}
			}
		} else {
			if (document.getElementById("tipTB").style.display != "none") {
				document.getElementById("tipTB").style.display = "none";
				DwrCookieProcess.setCookie(cookieName, "hide");
				try {
					refreshHeight();
				} catch (e) {
				}
			}
		}
	}

}

function selectRow(selectObj, cols) {
	var dataTable = selectObj.parentNode;
	var listTr = dataTable.getElementsByTagName("tr");
	for (j = 1; j < listTr.length; j++) {
		var listTd = listTr[j].getElementsByTagName("td");

		for (i = 0; i < listTd.length; i++) {
			if (cols) {
				if (i != cols) {
					if (j % 2 == 0) {
						listTd[i].style.backgroundColor = "#F7FBFF";
					} else {
						listTd[i].style.backgroundColor = "";
					}
				}
			} else {
				if (j % 2 == 0) {
					listTd[i].style.backgroundColor = "#F7FBFF";
				} else {
					listTd[i].style.backgroundColor = "";
				}
			}

		}
	}
	var selectListTd = selectObj.getElementsByTagName("td");
	for (m = 0; m < selectListTd.length; m++) {

		if (cols) {
			if (m != cols) {
				selectListTd[m].style.backgroundColor = "#FFFFCC";
			}
		} else {
			selectListTd[m].style.backgroundColor = "#FFFFCC";
		}

	}
}

function selectRows(selectObj, cols) {
	var dataTable = selectObj.parentNode;
	var listTr = dataTable.getElementsByTagName("tr");
	for (j = 0; j < listTr.length; j++) {
		var listTd = listTr[j].getElementsByTagName("td");

		for (i = 0; i < listTd.length; i++) {
			if (cols) {
				if (i != cols) {
					if (j % 2 == 1) {
						listTd[i].style.backgroundColor = "#F7FBFF";
					} else {
						listTd[i].style.backgroundColor = "";
					}
				}
			} else {
				if (j % 2 == 1) {
					listTd[i].style.backgroundColor = "#F7FBFF";
				} else {
					listTd[i].style.backgroundColor = "";
				}
			}

		}
	}
	var selectListTd = selectObj.getElementsByTagName("td");
	for (m = 0; m < selectListTd.length; m++) {

		if (cols) {
			if (m != cols) {
				selectListTd[m].style.backgroundColor = "#FFFFCC";
			}
		} else {
			selectListTd[m].style.backgroundColor = "#FFFFCC";
		}

	}
}
function showDataTable(table_id, cols, doc) {
    if (doc == undefined){
       doc = document;
    }
	var dataTable = doc.getElementById(table_id);
	var listTr = dataTable.getElementsByTagName("tr");
	for (j = 1; j < listTr.length; j++) {
		var listTd = listTr[j].getElementsByTagName("td");

		for (i = 0; i < listTd.length; i++) {
			if (cols) {
				if (i != cols) {
					if (j % 2 == 0) {
						listTd[i].style.backgroundColor = "#F7FBFF";
					} else {
						listTd[i].style.backgroundColor = "";
					}
				}
			} else {
				if (j % 2 == 0) {
					listTd[i].style.backgroundColor = "#F7FBFF";
				} else {
					listTd[i].style.backgroundColor = "";
				}
			}

		}
	}
}

function CheckDataObj(id, errorCode) {
	this.id = id;
	this.errorCode = errorCode;
}
var pathWin = "";


function checkTimeout(path, freshRequest) {
	if (freshRequest == undefined) {
		freshRequest = false;
	}
	var returnObj = true;
	pathWin = path;

	var result = getAjaxData({
			url : "queryTemplateAction!isTimeOut.do",
			params : {}
		});
	if(result)
	{
		returnObj = result.data;	
	}	
	return false;
}

function isTimeOut(timeoutInfo) {
	if (timeoutInfo == null || timeoutInfo == undefined || timeoutInfo == "") {
		return false;
	} else {
		var infoArr = timeoutInfo.split('/');
		if (infoArr[0] == 'true') {
			timeout = infoArr[1];
			if (timeout == "0") {
				return false;
			} else if (timeout == "1") {
				top.window.location.href = pathWin + "/jsp/home/welcome.jsp";
				return true;
			} else {
				window.$ErrorMsg$ = timeout;
				window
						.showModalDialog(
								pathWin
										+ "/jsp/system/session/sysSessionTimeout.jsp",
								window,
								"dialogHeight:218px;dialogWidth:450px;toolbar:no;menubar:no;scroll:no;resizable:no;location:no; status:no; left:300px; top:200px");
				return true;
			}
		} else {
			return false;
		}
	}
	return false;
}

function disableElement_Ext(srcObjId, b,doc) {
    doc = (doc !=undefined) ? doc : document;
	var srcObj = doc.getElementById(srcObjId);
	srcObj.disabled = b;
	if (!b) {
		srcObj.className = 'input_text';
	} else {
		srcObj.className = 'input_text_disabled';
	}
}

function evalutePassword(password) {
	if (password.length < 8 || password.length > 16) {
		return false;
	}
	var numbers = "0123456789";
	var chars1 = "abcdefghijklmnopqrstuvwxyz";
	var chars2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
	var spec_chars = " `~!@#$%^&*()-_=+\|[{}];:,<.>/?'" + '"';
	var hasNumber = false;
	var hasChar1 = false;
	var hasChar2 = false;
	var hasSpec_chars = false;
	var c;
	for (var i = 0; i < password.length; i++) {
		c = password.charAt(i);
		if (numbers.indexOf(c) != -1) {
			hasNumber = true;
		}
		if (chars1.indexOf(c) != -1) {
			hasChar1 = true;
		}
		if (chars2.indexOf(c) != -1) {
			hasChar2 = true;
		}
		if (spec_chars.indexOf(c) != -1) {
			hasSpec_chars = true;
		}
	}
	return hasNumber && hasChar1 && hasChar2 && hasSpec_chars;
}

function hasSameElement(str, c) {
	var tempArr = str.split(c);
	var tempArr2 = new Array();
	var count = 0;
	for (var i = 0; i < tempArr.length; i++) {

		var j = i + 1;
		for (j; j < tempArr.length; j++) {
			if (tempArr[j] == tempArr[i]) {
				var existAready = false;;
				for (var k = 0; k < count; k++) {
					if (tempArr[j] == tempArr2[k]) {
						existAready = true;
						break;
					}
				}
				if (!existAready)
					tempArr2[count++] = tempArr[i];
			}
		}
	}
	return tempArr2.toString();
}

function resultPageQueryExcute() {
	document.forms[0].submit();
}

function ids2Int(ids) {
	var idArr = [];
	if (ids == null || ids == "") {
		return "";
	}
	idArr = ids.split(",");
	var result = 0;
	for (var i = 0; i < idArr.length; i++) {
		result |= parseInt(idArr[i]);
	}
	return result.toString();
}
function checkedGroup(chkGroup, v) {
	var checks = document.getElementsByName(chkGroup.choosename);
	for (var i = 0; i < checks.length; i++) {
		if ((parseInt(checks[i].value) & v) != 0) {
			checks[i].checked = "checked";
		}
	}
}

function checkedGroupByName(conditionName, v) {
	var checks = document.getElementsByName(conditionName);
	for (var i = 0; i < checks.length; i++) {
		if ((parseInt(checks[i].value) & v) != 0) {
			checks[i].checked = "checked";
		}
	}
}

function checkedUrlGroup(chkGroup, v) {
	var checks = document.getElementsByName(chkGroup.choosename);
	for (var i = 0; i < checks.length; i++) {
		if ((parseInt(checks[i].value) & v) == 0) {
			checks[i].checked = false;
		}
	}
}

function MaxLength(field, maxlimit) {
	var j = field.value.replace(/[^\x00-\xff]/g, "**").length;
	var tempString = field.value;
	var tt = "";
	if (j > maxlimit) {
		for (var i = 0; i < maxlimit; i++) {
			if (tt.replace(/[^\x00-\xff]/g, "**").length < maxlimit)
				tt = tempString.substr(0, i + 1);
			else
				break;
		}
		if (tt.replace(/[^\x00-\xff]/g, "**").length > maxlimit) {
			tt = tt.substr(0, tt.length - 1);
		}
		field.value = tt;
	}
}

function isIE() {
	if (window.attachEvent) {
		return true;
	}
	return false;
}

function addEvent(obj, eventType, fn) {
	if (isIE()) {
		obj.attachEvent("on" + eventType, fn);
	} else {
		obj.addEventListener(eventType, fn, false);
	}
}
function addOptions(selId, data, valueField, displayField)
{
	for (var i = 0; i < data.length; i++)
	{
		jQuery("#" + selId).append(jQuery("<option/>", {
			value : data[i][valueField],
			text : data[i][displayField]
		}));
	}
}
function addOptionsInsert(id, key, value) {
		jQuery("#" + id).append(jQuery("<option/>", {
			value : key,
			text : value
		}));
}
function getAjaxData(param)
{
	var rst;
	jQuery.ajax({
			url : param.url,
			type : "POST",
			data : param.params,
			dataType : "json",
			success : function(result, textStatus) {
				rst = result;
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {
			},
			complete : function(XMLHttpRequest, textStatus) {
			},
			async : false
		});
		return rst;
}
function isTrue(v)
{
	return v === true || v === "true";
}

function isFalse(v)
{
	return v===false||v==="false";
}
function defaultValue(v, dftV)
{
	if(v === undefined || v === null || v === ""){
		return dftV;
	}else{
		return v;
	}
}

function defaultValue(v, dftV)
{
	if(v === undefined || v === null || v === ""){
		return dftV;
	}else{
		return v;
	}
}

function nameArrProcess(nameArr,len) {
	var arrTemp = new Array();
	var strTemp = "";
	for (var i = 0; i < nameArr.length; i++) {
		if ((strTemp.length + nameArr[i].length) < len) {
			strTemp += nameArr[i];
			arrTemp[i] = nameArr[i];
		} else {
			arrTemp[i] = "...";
			break;
		}
	}
	return arrTemp;
}

function deviceDescProcess(devDesc,len) {
	var result = "";
	
	if (devDesc.length > len)
	{
	    result = devDesc.substring(0,len) + "...";
	}else
	{
	    result = devDesc;
	}
    return result;
}

	clickCheckboxEvent = function (src,e1,isChecked){
		var e = e1 || event;
		Ext.lib.Event.preventDefault(e);
		clickCheck (src,isChecked);
	}

	clickCheck = function (src,isChecked){
		var target = Ext.fly(src);
	
		target = target.findParent(".x-form-check-wrap",null,true);
		var cls = 'x-form-check-checked';
		var hcls = '.x-form-checkbox';
		if(target.hasClass("x-item-disabled")){
			return;
		}
		
		if(target.hasClass(cls)){
		    if (isChecked == false){
				target.child(hcls).dom.checked = ""
				target.removeClass(cls);
			}
		}else{
		    if (isChecked == true){
		        target.child(hcls).dom.checked = "checked";
		        target.addClass(cls);
		    }
		}
	}
	
    function checkAllCBs(event, obj, nameID) 
    {
        var _checkboxElt = jQuery("#" + nameID + " > table").find('.x-form-check-wrap');
        var clear = "[" + ResourceMgr.get('clear') + "]";
        var all = "[" + ResourceMgr.get('selectAll') + "]";
        
        var type = (obj.innerHTML.trim() == clear)?'clear':'all';
        var _img = _checkboxElt.find("img[class='x-form-check']");
        
        if (type == 'all'){
            jQuery.each(_img,function(){
                clickCheckboxEvent(this,event,true);
            });
            obj.innerHTML = clear;
        }else{
            jQuery.each(_img,function(){
                clickCheckboxEvent(this,event,false);
            });
            obj.innerHTML = all;
        }
    }
	    
var GridUtils = new Object();
		
GridUtils.getSelectAllData = function(){
	
}

GridUtils.gridOut = function(event){
	jQuery(event).removeClass('x-grid3-row-over');
}

GridUtils.gridOver = function(event){
	jQuery(event).addClass('x-grid3-row-over');			
}

GridUtils.gridDown = function(event){
	jQuery(event).toggleClass('x-grid3-row-selected');
}
	    
	var cmbParent;	
	var hideCmbObj;
	var hideCmbVal;
	var hideCmbLab;
	var hideCmbId;
	
	function showElement(id, isAdd)
	{
		var simpStr = jQuery('#'+id).attr('simpledata');
		
		if(simpStr != undefined) {
			var simpObj = eval(simpStr);
			
			if(simpObj[0] != undefined && isAdd == undefined) {
				LegoTag.setCombValue(id,simpObj[0][0],simpObj[0][1]);
				var hideCmbObj = jQuery('#comb_'+id);
				eval(hideCmbObj.attr('oncmbselect'));
			} else {
				if(isAdd) {
					LegoTag.setCombValue(id,simpObj[simpObj.length-1][0],simpObj[simpObj.length-1][1]);
					var hideCmbObj = jQuery('#comb_'+id);
					eval(hideCmbObj.attr('oncmbselect'));
				}
			}
		}
	}
	
	var paramObj ;
	function addAllElement(id,object)
	{
		var cmbObj = jQuery('#'+id);
		
		
		var element;
		if(jQuery.browser.mozilla)
		{
			cmbObj.attr('simpledata',JSON.stringify(object));
			cmbObj.attr('loadState','reload');
		} else {
			paramObj = object;
			hideCmbId = id;
			hideCmbObj = jQuery('#comb_'+id);
			
			jQuery('#img_'+id).bind('click',function(){
			
				cmbParent = jQuery('#x-combo-list-inner-'+hideCmbId);
				
				var firstElementId = cmbParent.find('>div').first().attr('id');
				
				cmbParent.empty();
				
				var nFirstEleId = parseInt(firstElementId.substr(7,firstElementId.length - 7));
				
				var lable;
				var value;
				var tmp = jQuery('#x-combo-list-'+hideCmbId);
				
				for(var v=0; v<paramObj.length; v++){
					
					hideCmbVal = paramObj[v][0];
					hideCmbLab = paramObj[v][1];
					
					element = jQuery('<div />',{
						id : 'ext-gen'+nFirstEleId,
						title : hideCmbLab,
						hideVal : hideCmbVal
					}).text(hideCmbLab).addClass('x-combo-list-item').css('cursor','pointer');
					
					
					nFirstEleId += 2;
					
					element.bind({
						mouseout : function(event){
							jQuery(this).removeClass('x-combo-selected');			
						},
						mouseover : function(event){
							cmbParent.find('>div').removeClass('x-combo-selected');	
							jQuery(this).toggleClass('x-combo-selected');	
						},
						click : function(){
						},
						mousedown : function() {
							LegoTag.setCombValue(hideCmbId,jQuery(this).attr('hideVal'),jQuery(this).attr('title'));
							eval(hideCmbObj.attr('oncmbselect'));
						}
					});
					
					tmp.css('height',(parseInt(tmp.css('height')) + 10));
					cmbParent.css('height',(parseInt(cmbParent.css('height')) + 10));
					
					cmbParent.append(element);
				}
				
				LegoTag.setCombValue(hideCmbId,hideCmbVal,hideCmbLab);
				eval(hideCmbObj.attr('oncmbselect'));
				
				element.addClass('x-combo-selected');
				
				jQuery('#img_'+id).unbind("click");
			});
		}
		
		if(object[object.length - 1] != undefined) 
		{
			LegoTag.setCombValue(hideCmbId,object[object.length - 1][0],object[object.length - 1][1]);
		}
	}
	
	function addElement(id,value,label,show)
	{
		var cmbObj = jQuery('#'+id);
		var simpStr = cmbObj.attr('simpledata');
		if(simpStr != undefined) {
			var addElement = [value,label];
			var simpObj = eval(simpStr);
			simpObj.push(addElement);	
		}
		
		cmbObj.attr('simpledata',JSON.stringify(simpObj));
		
		var element;
		if(jQuery.browser.mozilla)
		{
			cmbObj.attr('loadState','reload');
		} else {
			hideCmbVal = value;
			hideCmbLab = label;
			hideCmbId = id;
			hideCmbObj = jQuery('#comb_'+id);
			
			jQuery('#img_queryTemp').bind('click',function(){
				cmbParent = jQuery('#x-combo-list-inner-'+id);

				var lastElementId = cmbParent.find('>div').last().attr('id');
				
				var newElementId = parseInt(lastElementId.substring(7,lastElementId.length - 7));
				
				cmbParent.find('>div').removeClass('x-combo-selected');
				element = jQuery('<div />',{
					id : 'ext-gen'+newElementId + 2,
					title : label
				}).text(label).addClass('x-combo-list-item  x-combo-selected').css('cursor','pointer');
				
				var tmp = jQuery('#x-combo-list-'+id);
				tmp.css('height',(parseInt(tmp.css('height')) + 25));
				
				cmbParent.css('height',(parseInt(cmbParent.css('height')) + 25));
				
				element.bind({
					mouseout : function(event){
						jQuery(this).removeClass('x-combo-selected');			
					},
					mouseover : function(event){
						cmbParent.find('>div').removeClass('x-combo-selected');	
						jQuery(this).toggleClass('x-combo-selected');	
					},
					click : function(){
					},
					mousedown : function() {
						LegoTag.setCombValue(hideCmbId,hideCmbVal,hideCmbLab);	
						eval(hideCmbObj.attr('oncmbselect'));
					}
				});
				
				cmbParent.append(element);
				
				jQuery('#img_'+id).unbind("click");
			});
		}
		
		if(show) 
		{
			LegoTag.setCombValue(id,value,label);
		} 
	}
	
	function selectElement(id, param, type)
	{
		var cmbObj = jQuery('#'+id);
		var simpStr = cmbObj.attr('simpledata');
		
		var simpObj;
		if(simpStr != undefined){
			simpObj = eval(simpStr);
			
			if(type) {
				var value;
				for(var v=0; v<simpObj.length; v++) {
					if(simpObj[v][1] == param) {
						value = simpObj[v][0];
						break;
					}
				}
				
				LegoTag.setCombValue(id,value,param);
			} else {
				var label;
				
				for(var v=0; v<simpObj.length; v++) {
					
					if(simpObj[v][0] == param) {
						label = simpObj[v][1];
						break;
					}
				}
				
				LegoTag.setCombValue(id, param, label);		
			}
		} 
	}
	
	function deleteElement(id,value)
	{
		var cmbObj = jQuery('#'+id);
		var simpStr = cmbObj.attr('simpledata');
		
		var simpObj;
		if(simpStr != undefined){
			simpObj = eval(simpStr);
			
			var index;
			for(var v=0; v<simpObj.length; v++) {
				if(simpObj[v][0] == value) {
					index = v;
					break;
				}
			}
			
			simpObj.splice(index,1);
			
			cmbObj.attr('simpledata',JSON.stringify(simpObj));
			
			if(jQuery.browser.mozilla)
			{
				cmbObj.attr('loadState','reload');
			} else {
				var elements = jQuery('#x-combo-list-inner-'+id);

				elements.find('div').eq(index).remove();	
			} 
			
			if(simpObj[0] != undefined)
			{
				LegoTag.setCombValue(id,simpObj[0][0],simpObj[0][1]);	
			}
		} 
	}
	
	function removeAll(id)
	{
		var cmbObj = jQuery('#'+id);
		var simpStr = cmbObj.attr('simpledata');	
		
		if(simpStr != undefined){
			simpObj = eval(simpStr);
			
			for(var v=0; v<simpObj.length; v++) {
				LegoTag.delCombItem(id, simpObj[v][0], simpObj[v][1]);	
			}	
		}
	}
	
	function refreshCombHeight(id, optionSize, simpledata)
	{
		var _h = 18 + 18 * optionSize;
		if(_h > 150)
		{
			_h = 150;
		}
		jQuery('#x-combo-list-'+id).css('height', _h);
		jQuery('#x-combo-list-inner-'+id).css('height', _h);	
		
		if(simpledata != undefined)
		{
			jQuery('#'+id).attr('simpledata', simpledata);
		}
	}
	
	function validateCollectorName(logCollectorName) {
    	var REG_CollectorName = new RegExp(/^(?!null$)[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\w\-\u4e00-\u9fa5]*$/i);
    	if (!REG_CollectorName.test(logCollectorName) || logCollectorName.length > 32) {
			return false;
    	}
    	return true;
    }
    
    function validateCollectorIP(logCollectorIP) {
    	var REG_IP = new RegExp(/^((25[0-5]|2[0-4]\d|1\d{2}|0?[1-9]\d|0?0?\d).){3}(25[0-5]|2[0-4]\d|1\d{2}|0?[1-9]\d|0?0?\d)$/);
		if (!REG_IP.test(logCollectorIP)) {
			return false;
		}
    	return true;
    }