function keyupHandler_num(event) {
	
	event = event || window.event;
	
	var srcObj = event.srcElement ? event.srcElement : event.target;
	var _value = srcObj.value;
	var holdChars = srcObj.holdChars;
	var maxnum = srcObj.maxnum;
	var curPos = srcObj.curPos;
	var keyCode = event.keyCode;

	if (srcObj.oldValue.length <= _value.length || srcObj.paste
			|| srcObj.selectArea) {
		if (holdChars == null || holdChars == "") {
			index = _value.search(/\D/g);
			if (index != -1) {
				if(event.keyCode != 13) {
				    srcObj.value = srcObj.oldValue;
				    setCaret(srcObj, curPos);
				} else {
					srcObj.select();
				}
			}
			else if (_value.length > 1 && _value.charAt(0) == '0') {
				if(event.keyCode != 13) {
					srcObj.value = 0;
                    srcObj.select();
				} else {
					srcObj.select();
				}
			} else if (parseInt(_value) > maxnum) {
				if(event.keyCode != 13) {
					srcObj.value = maxnum;
                    srcObj.select();
				} else {
					srcObj.select();
				}
			}
		}
		else {

			var reg = new RegExp("[^" + holdChars + "0-9]", 'g');
			var result = reg.exec(_value);
			if (result != null) {
				if(event.keyCode != 13) {
					srcObj.value = srcObj.oldValue;
                    setCaret(srcObj, curPos);
				} else {
					srcObj.select();
				}
			}
		}
	}
	if(event.keyCode != 13) {
	    srcObj.oldValue = srcObj.value;
	} else {
		srcObj.oldValue = '';
	}
	srcObj.curPos = -1;
	srcObj.selectArea = null;
}

function NumberRange(num,mixnum,maxnum)
{
	if (num == undefined || num == null || num == "")
		return "";
	num = (num > mixnum ) ? num : mixnum ;
	num = (num < maxnum ) ? num : maxnum ; 
	return num;
}


function inputNumberOnly(event, maxnum,holdChars, minnum)
{
	var srcObj = event.srcElement ? event.srcElement : event.target;
	var str = srcObj.value;
	var _expr = /\D/g;
	var num = str.replace(_expr,"");
	if (maxnum != undefined && maxnum != null && maxnum != "")
	{
		num = (num < maxnum ) ? num : maxnum ;
	} 
	if (minnum != undefined && minnum != null && minnum != "")
	{
		num = (num > minnum ) ? num : minnum ;
	} 
	srcObj.value = num;
}


function numberOnly(event,maxnum, holdChars) {
	var srcObj = event.srcElement ? event.srcElement : event.target;
	if(srcObj.onkeyup == null || srcObj.onkeyup == 'undefined'){ 
	    srcObj.onkeyup = keyupHandler_num;
	}
	if (srcObj.oldValue == null) {
		srcObj.oldValue = srcObj.value;
	}
	srcObj.holdChars = holdChars;
	srcObj.maxnum = maxnum;
	if (srcObj.curPos == null || srcObj.curPos == -1) {
		srcObj.curPos = getCaret(srcObj);
	}
	if (event.ctrlKey && event.keyCode == 86) {
		srcObj.paste = true;
	}
	if (document.selection && srcObj.selectArea == null) {
		if (document.selection.type.toLowerCase() != "text"
				|| document.selection.createRange().parentElement() != srcObj) {
			srcObj.selectArea = false;
		} else
			srcObj.selectArea = true; 
	}
}
function numberOnlyVsm(event,maxnum) {
	event = event || window.event;

	var srcObj = event.srcElement ? event.srcElement : event.target;
	if(srcObj.onkeyup == null || srcObj.onkeyup == 'undefined'){ 
	    srcObj.onkeyup = keyupHandler_num;
	}
	if (srcObj.oldValue == null) {
		srcObj.oldValue = srcObj.value;
	}
	srcObj.maxnum = maxnum;
	if (srcObj.curPos == null || srcObj.curPos == -1) {
		srcObj.curPos = getCaret(srcObj);
	}
	if (event.ctrlKey && event.keyCode == 86) {
		srcObj.paste = true;
	}
	if (document.selection && srcObj.selectArea == null) {
		if (document.selection.type.toLowerCase() != "text"
				|| document.selection.createRange().parentElement() != srcObj) {
			srcObj.selectArea = false;
		} else
			srcObj.selectArea = true; 
	}
} 
function strLengthLess(event,len) {
	var srcObj = getEventObj(event);
	var str = srcObj.value;
	var keyCode = event.keyCode;
	if (keyCode == 37 || keyCode == 38 || keyCode == 39 || keyCode == 40
			|| keyCode == 8 || keyCode == 46 || keyCode == 9) {
		return true;
	}
	else if (event.ctrlKey && (keyCode == 67 || keyCode == 86 || keyCode == 88)) {
		if (keyCode == 86) {
			var clipboard = window.clipboardData;
			if (clipboard != null) {
				var clipStr = clipboard.getData('text');
				if(clipStr == null) return false;
				var selectAreaText = getSelectAreaText(srcObj);
				if (selectAreaText == '') {
					if ((str + clipStr).length > len) {
						var acceptLen = len - str.length;
						var newClipStr = clipStr.substring(0, acceptLen);
						window.clipboardData.setData('text', newClipStr);
					}
				} else {
					var tempLen = (str + clipStr).length
							- selectAreaText.length;
					if (tempLen > len) {
						var acceptLen = selectAreaText.length - (tempLen - len);
						var newClipStr = clipStr.substring(0, acceptLen);
						window.clipboardData.setData('text', newClipStr);
					}
				}
			}
		}
		return true;
	}
	else 
	{
		if (str.length >= len)
		{
			srcObj.value = str.substring(0,len);
			return event.returnValue = false;
		}
	}
}

function TEXTCOM_LEN(event,name,len) {
    var elements = document.getElementsByName(name);
    for (var idx = 0; idx < elements.length; idx++) {
        
    	elements[idx].pasteDealObj = {
    		srcElement:null,
    		pasteStr:'',
    		times:0
    	}
    	
        elements[idx].onbeforepaste = function() {
            var srcObj = event.srcElement ? event.srcElement : event.target;
            var range = document.selection.createRange();
            
            var pasteStr = window.clipboardData.getData('text');
            if(pasteStr == null) return null;
            if(srcObj.pasteDealObj.times == 0) {
            	srcObj.pasteDealObj.pasteStr = pasteStr;
                srcObj.pasteDealObj.times = 1;
                srcObj.pasteDealObj.srcElement = srcObj;
            }
            
            if(pasteStr.length > len) {
            	window.clipboardData.setData('text', pasteStr.substring(0,len));
            }
            
            if (range == null || range.text == '') {
                srcObj.cursorPos_old = getCurrorPos_TextArea(srcObj);
            } else {
                srcObj.cursorPos_old = getCurrorPos_TextArea(srcObj) - range.text.length;
                
                var oldV_head = srcObj.value.substring(0,srcObj.cursorPos_old);
                var oldV_tail = srcObj.value.substring(getCurrorPos_TextArea(srcObj),srcObj.value.length);
                srcObj.oldValue = oldV_head + oldV_tail;
                
                range.select();
            }
        };
        elements[idx].onkeydown = function () {
            var srcObj = event.srcElement ? event.srcElement : event.target;
            if(event.ctrlKey || event.shiftKey) return;
            
            if(event.keyCode == 13) srcObj.isEnter = true;
            var range = document.selection.createRange();
            if (range == null || range.text == '') {
                srcObj.cursorPos_old = getCurrorPos_TextArea(srcObj);
            } else {
                srcObj.cursorPos_old = getCurrorPos_TextArea(srcObj) - range.text.length;
                range.select();
            }
            
        };
        elements[idx].onpropertychange = function () {
            if(event.propertyName == 'value') {
                var srcObj = event.srcElement ? event.srcElement : event.target;
                if(srcObj.pasteDealObj.times != 0) {
                	 window.clipboardData.setData('text', srcObj.pasteDealObj.pasteStr);
                    srcObj.pasteDealObj.pasteStr = '';
                    srcObj.pasteDealObj.times = 0;
                    srcObj.pasteDealObj.srcElement = null;
                }
                
                if(srcObj.value.length > len) {
                    srcObj.callByPropertychange = true;  
                    srcObj.blur();
                } else {
                    srcObj.cursorPos_old = getCurrorPos_TextArea(srcObj); 
                    srcObj.oldValue = srcObj.value;
                }
            }
        };
        elements[idx].onfocus = function () {
            var srcObj = event.srcElement ? event.srcElement : event.target;
            srcObj.cursorPos_old = getCurrorPos_TextArea(srcObj);
            srcObj.oldValue = srcObj.value;
            
        };
        elements[idx].onkeyup = function () {
        };
        elements[idx].onblur = function() {
            var srcObj = event.srcElement ? event.srcElement : event.target;
            if(srcObj.value.length > len && srcObj.callByPropertychange) {
                if(srcObj.isEnter) {
                    srcObj.isEnter = false;
                    var cursorPos_new = srcObj.cursorPos_old;
                    srcObj.value = srcObj.oldValue;
                    srcObj.cursorPos_old = cursorPos_new;
                    
                } else {
                    var oV_Head = srcObj.oldValue.substring(0, srcObj.cursorPos_old);
                    var oV_Tail = srcObj.oldValue.substring(srcObj.cursorPos_old, srcObj.oldValue.length);
                    
                    var acceptLen = len - srcObj.oldValue.length ;
                    
                    var acceptStr = srcObj.value.substring(srcObj.cursorPos_old, srcObj.cursorPos_old + acceptLen);
                    var newStr = oV_Head + acceptStr + oV_Tail ;
                    
                    srcObj.oldValue = newStr;
                    var cursorPos_new = srcObj.cursorPos_old + acceptLen;   
                    srcObj.value = newStr;                                  
                    srcObj.cursorPos_old = cursorPos_new;                   
                }
                setCaret(srcObj, srcObj.cursorPos_old);                     
                srcObj.callByPropertychange = false;                       
            }                                                           
        }
    }
}


function inputTextCheckRealTiem(configObj) {
	var obj = document.getElementById(configObj.id);
	
	obj.configObj = configObj;			
	obj.reg = createRegByStr(configObj.argType,configObj.args);			
										
	obj.arg = configObj.args;
	obj.appType = configObj.argType;
	
	obj.onbeforepaste = function() {
    	var srcObj = event.srcElement;
        if (srcObj.reg != null){
            var clipStr = window.clipboardData.getData('text');
            if(clipStr == null) return false;
            window.clipboardData.setData('text', clipStr.replace(srcObj.reg, ''));
        }
	};
	obj.onkeydown = doKeyDown;
	obj.onkeyup = doKeyUp;
	obj.onblur = function () {
	    var srcObj = event.srcElement;
        var _value = srcObj.value;
        if(srcObj.reg != null) srcObj.value = _value.replace(srcObj.reg, '');
	};
	obj.onfocus = function () {
		var srcObj = event.srcElement;
		srcObj.oldValue = srcObj.value;
	}
	obj.doEnter = configObj.doEnter;
}

function doKeyDown() {
	var srcObj = event.srcElement;
	if (srcObj.oldValue == null) {
		srcObj.oldValue = srcObj.value;
	}
	if (srcObj.curPos == null || srcObj.curPos == -1) {
		srcObj.curPos = getCaret(srcObj);
	}
	if (event.ctrlKey && event.keyCode == 86) {
		srcObj.paste = true;
	}
	if (event.keyCode == 13) {
	   srcObj.doEnter();
	   return event.returnValue = false;
	}
	if (document.selection && srcObj.selectArea == null) {
		if (document.selection.type.toLowerCase() != "text"
				|| document.selection.createRange().parentElement() != srcObj) {
			srcObj.selectArea = false;
		} else
			srcObj.selectArea = true;
	}
}

function doKeyUp() {
	var srcObj = event.srcElement;
	var _value = srcObj.value;
	var arg = srcObj.arg;
	var type = srcObj.appType;
	var curPos = srcObj.curPos;
	var keyCode = event.keyCode;

	if (srcObj.oldValue.length <= _value.length || srcObj.paste
			|| srcObj.selectArea) {
		var reg = null;
		if ("Chars" == type) {
			reg = new RegExp("[^" + arg + "]", 'g');
		} else if('ReExp' == type) {
			var regStr = arg.toString();
			regStr = regStr.slice(regStr.indexOf('/') + 1, regStr.lastIndexOf('/'));
			reg = new RegExp(regStr, 'g');
		}
		if(reg != null){
			var result = reg.exec(_value);
			if (result != null) {
				srcObj.value = srcObj.oldValue;
				setCaret(srcObj, curPos);
			}
		}
	}
	srcObj.oldValue = srcObj.value;
	srcObj.curPos = -1;
	srcObj.selectArea = null;
}


function createRegByStr(type, arg) {
	var reg = null;
	if ("Chars" == type) {
		reg = new RegExp("[^" + arg + "]", 'g');
	} else if('ReExp' == type){
		var regStr = arg.toString();
		regStr = regStr.slice(regStr.indexOf('/') + 1, regStr.lastIndexOf('/'));
		reg = new RegExp(regStr, 'g');
	}
	return reg;
}

function getSelectAreaText(srcObj) {
	if (document.selection) {
		if (document.selection.type.toLowerCase() != "text"
				|| document.selection.createRange().parentElement() != srcObj) {

		} else {
			return document.selection.createRange().text;
		}
	}
	return '';
}

function getCurrorPos_TextArea(obj){
    var rngSel = document.selection.createRange();  
    var rngTxt = obj.createTextRange();             
    var flag = rngSel.getBookmark();                
    rngTxt.collapse();                              
    rngTxt.moveToBookmark(flag);                    
    rngTxt.moveStart('character',-obj.value.length);
    str = rngTxt.text.replace(/\r\n/g,' ');        
    return(str.length);                           
}



function validatePort(port)
{
	return port>=0 && port<=65535;
}