function addDivertTactics() {
	LegoTag.frameWindow(WEB_ROOT_ABS_PATH + "/atic/business/showAddOutboundDivert.do", "addOutDivertTactics", "title=" + ADD + ",height=550,width=700", false);
}
function btnShow() {
	var grid = LegoTag.getGridSelectedData("outboundDivertTacticsGrid");
	var bStop = 0;
	var bStart = 0;
	var zoneStatic = 0;
	for (var i = 0; grid[i]; i++) {
		if (grid[i].divertStatus == 1) {
			++bStop;
		}
		if (grid[i].divertStatus == 0) {
			++bStart;
		}
				
	} 
	LegoTag.setDisableds(["divert_btn_start"], bStart != grid.length || !grid.length);
	LegoTag.setDisableds(["divert_btn_stop"], bStop != grid.length || !grid.length);
	LegoTag.setDisableds(["divert_btn_del"], !grid.length );
}


function batchDelDivert(id) {
	var record = getRecord(id);
	var iStart = 0;
	var info;
	
	for (var i = 0; record[i]; i++) {
		if (record[i].divertStatus == 1) {
			++iStart;
		}
	}
	if (iStart) {
		if (!(record.length - 1)) {
			info = SINGLE_DEL_START_INFO;
		} else {
			info = MULTI_DEL_START_INFO;
		}
	}
	LegoTag.Msg.confirm(CONFIRM, info ? info : CONFIRM_DEL, function (btn) {
		if (btn == "yes") {
			var deleteIds = new Array();
			var deleteNames = new Array();
			for (var i = 0; i < record.length; i++) {
				deleteIds.push(record[i].id);
				deleteNames.push(record[i].sourceIp);
			}
			isDevOnLine(deleteIds,deleteNames);
		}
	});
}

function isDevOnLine(ids,deleteNames)
{
	 LegoTag.Ajax.request({						
			url : WEB_ROOT_ABS_PATH + "/atic/business/isDevOnLine.do",
			method : 'GET',
			params:{ids:ids}, 
			success : function(action) {
				if (action.responseText == "success") 
				{
					delDivert(ids,deleteNames);
				}
				else
				{
					var error = DEL_RISK_NE+"<br><br>"+ htmlEncode(action.responseText)+"<br><br>"+DEL_RISK_INFO;
					LegoTag.Msg.confirm(TIP_INFO,error, function(btn) {
									if (btn == 'yes') {
										delDivert(ids,deleteNames);
										}
								});
				}
			},
			failure : function() {
			}
		});
}


function delDivert(deleteIds,deleteNames)
{
  LegoTag.Msg.wait(DELETING);
  LegoTag.Ajax.request({
		timeout:1200000,
		url:WEB_ROOT_ABS_PATH + "/atic/business/deleteOutboundDivert.do", 
		method:"post", 
		params:{ids:deleteIds, names:deleteNames}, 
		success:function (response, options) {
			var info = response.responseText;
			if (info == "success") {
				LegoTag.Msg.succeed(DEL_SUCCESS, function () {
					window.location = WEB_ROOT_ABS_PATH + "/atic/business/listOutboundDivert.do?pageSize=" + PAGE_SIZE + "&start=" + PAGE_START;
				});
			} else {
				if (LegoTag.Msg.isVisible()) {
					LegoTag.Msg.hide();
				}
				if (info == "failure") {
					LegoTag.frameWindow(BATCH_URL, "deleteDivertTacticsResult", "title = " + DEL_RESLULT + ", height=500, width=650", false);
				}
			}
		},callback:function () {
				if (arguments[2].responseText.indexOf("!--exceptionpage,showexception--") >= 0)
				{
					
		    			window.location= WEB_ROOT_ABS_PATH + "/atic/business/listOutboundDivert.do?pageSize=" + PAGE_SIZE + "&start=" + PAGE_START;
		   				
				}}, failure:function () {
			Ext.MessageBox.alert("error");
		}});
}

function delAllDivert()
{
	LegoTag.Msg.confirm(CONFIRM, CONFIRM_DEL_ALL, function (btn) {
		if (btn == "yes") {
			LegoTag.Msg.wait(DELETING);
			delDivertForAll();
		}
	});

}

function delDivertForAll()
{
  LegoTag.Ajax.request({
		timeout:1200000,
		url:WEB_ROOT_ABS_PATH + "/atic/business/deleteAllOutboundDivert.do", 
		method:"post", 
		params:{}, 
		success:function (response, options) {
			var info = response.responseText;
			if (info == "success") {
				LegoTag.Msg.succeed(DEL_SUCCESS, function () {
					window.location = WEB_ROOT_ABS_PATH + "/atic/business/listOutboundDivert.do?pageSize=" + PAGE_SIZE + "&start=" + PAGE_START;
				});
			} else {
				if (LegoTag.Msg.isVisible()) {
					LegoTag.Msg.hide();
				}
				if (info == "failure") {
					LegoTag.Msg.failed(DEL_FAIL);
				}
			}
		},callback:function () {
				if (arguments[2].responseText.indexOf("!--exceptionpage,showexception--") >= 0)
				{
					
		    			window.location= WEB_ROOT_ABS_PATH + "/atic/business/listOutboundDivert.do?pageSize=" + PAGE_SIZE + "&start=" + PAGE_START;
		   				
				}}, failure:function () {
			Ext.MessageBox.alert("error");
		}});
}


function getZoneList(value, deviceId) {
	document.getElementById("zoneId").value = "";
	document.getElementById("queryZoneSim").value = "";
	document.getElementById("adv_zoneId").value = "";
	document.getElementById("adv_queryZoneSim").value = "";
}
function showAdvanceQuery(id) {
	var sStyle = document.getElementById(id).style;
	sStyle.display = (sStyle.display == "block" ? "none" : "block");
}
function simpleQuery() {
	document.getElementById("simpleSearchForm").submit();
}
function advanceQuery() {
	var form = document.getElementById("advanceSearchForm");
	var validInfo = LegoTag.validFormResult(form, true, true, TIP_INFO);
	
	var startTime = document.getElementById("advanced_divert_start_ip").value;
	var endTime = document.getElementById("advanced_divert_end_ip").value;
	
	if(startTime.trim().length > 0 && endTime.trim().length > 0)
	{
		var startDate = parseDate(startTime);
		var endDate = parseDate(endTime);
		
		if(startDate > endDate)
		{
			LegoTag.Msg.alert(TIP_INFO, STARTTIME_LESS_ENDTIME);
			return;
		}
	}
	if (validInfo) {
			  return;
		}

	form.submit();
		
}

var parseDate = function (strDate)
{
    var year, month, day, hour, minute, second;
    var date = strDate.split(" ");
    var foreDate = date[0];
    var backDate = date[1];
    
    var parseForeDate = foreDate.split("-");
    year = parseForeDate[0];
    month = parseForeDate[1];
    day = parseForeDate[2];
    
    var parseBackDate = backDate.split(":");
    hour = parseBackDate[0];
    minute = parseBackDate[1];
    second = parseBackDate[2];
    
    return new Date(year, month, day, hour, minute, second);
}

function getRecord(id) {
	if (!id) {
		return LegoTag.getGridSelectedData("outboundDivertTacticsGrid");
	}
	var allData = LegoTag.getGridAllData("outboundDivertTacticsGrid");
	for (var i = 0; allData[i]; i++) {
		if (allData[i].id == id) {
			return new Array(allData[i]);
		}
	}
}

    function validateStartDate(){
	    var elDateTime=document.getElementById("advanced_divert_start_ip");
	    
	  	return commonValidate(elDateTime);
	}
	function validateEndDate(){
	    var elDateTime=document.getElementById("advanced_divert_end_ip");
	  	return commonValidate(elDateTime);
	}
function commonValidate(elDateTime)
	{
		var dateVal = elDateTime.value;
		if(dateVal.trim().length<=0){
		return true;
		}
	  	var dateFormat = LegoTag.getDateFormat(Ext.get(elDateTime));
	    var retDate = Date.parseDate(dateVal, dateFormat);
	    if(retDate && retDate.format(dateFormat)!=dateVal)
   		{
    		return TIME_INVAIL;
   		}
	    
	    if(retDate)
	    {
	    	return true;
	    }
	    return TIME_INVAIL;
	}
 
