/*use when UPDATE B023  TO B025*/
USE lego;
ALTER TABLE `t_topoobject` ADD INDEX ( `ip_address` );
ALTER TABLE `t_atic_zone_info` ADD INDEX ( `zone_id` );
ALTER TABLE `t_vsm_zone_device` ADD INDEX ( `zone_id` );
ALTER TABLE `t_vsm_zone_device` ADD INDEX ( `device_id` );
ALTER TABLE `t_vsm_zone_service` ADD INDEX ( `device_id` );
ALTER TABLE `t_vsm_zone_service` ADD INDEX ( `zone_id` );
ALTER TABLE `t_vsm_zone_notexcel` ADD INDEX ( `service_id` );

USE sweb;
ALTER TABLE `atic_sig_cusidmap_upd` ADD INDEX ( `ATIC_ZONEID` );
ALTER TABLE `atic_sig_cusidmap_upd` ADD INDEX ( `SIG_ZONEID` );
ALTER TABLE `atic_zone_base_conf_upd` ADD INDEX ( `ZONE_ID` );
ALTER TABLE `atic_zone_limit_upd` ADD INDEX ( `ZONE_ID` );
ALTER TABLE `atic_zone_policy_upd` ADD INDEX ( `ZONE_ID` );
ALTER TABLE `atic_zone_service_upd` ADD INDEX ( `ZONE_ID` );

USE lego;
INSERT INTO atic_sig_sycinfo(infoKey,infoValue) VALUES('isLastTimeReachedUpperLimit','true');

ALTER TABLE `lego`.`t_vsm_zone_service` add column `description` varchar(255) NULL after `service_name`;
ALTER TABLE `lego`.`t_vsm_zone_device_status` add column `error_param` varchar(255) NULL after `has_change`;

/*B025 version divertDelay_Time unit change to seconds*/
/*new create table*/
DROP TABLE IF EXISTS `t_atic_logholdtime_temp`;

CREATE TABLE `t_atic_logholdtime_temp` (`pkid` INT(11) NOT NULL,`hold_time` INT(11) DEFAULT NULL,`tacticsLog_time` INT(11) DEFAULT NULL,`holdOriginal_time` INT(11) DEFAULT NULL,`holdHour_time` INT(11) DEFAULT NULL,`holdDay_time` INT(11) DEFAULT NULL,`dayReport_time` INT(11) DEFAULT NULL,`weekReport_time` INT(11) DEFAULT NULL,`monthReport_time` INT(11) DEFAULT NULL,`yearReport_time` INT(11) DEFAULT NULL,`divertDelay_Time` INT(11) DEFAULT NULL, PRIMARY KEY (`pkid`)) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin ;
/*backup data*/
INSERT INTO t_atic_logholdtime_temp(`pkid`, `hold_time`, `tacticsLog_time`, `holdOriginal_time`, `holdHour_time`, `holdDay_time`, `dayReport_time`, `weekReport_time`, `monthReport_time`, `yearReport_time`, `divertDelay_Time`) SELECT  pkid,  hold_time, tacticsLog_time,  holdOriginal_time,  holdHour_time,  holdDay_time,  dayReport_time,  weekReport_time,  monthReport_time,  yearReport_time,  divertDelay_Time FROM t_atic_logholdtime ;
/*delete data*/
delete from t_atic_logholdtime;

INSERT INTO `lego`.`t_atic_logholdtime` (`pkid`, `hold_time`, `tacticsLog_time`, `holdOriginal_time`, `holdHour_time`, `holdDay_time`, `dayReport_time`, `weekReport_time`, `monthReport_time`, `yearReport_time`, `divertDelay_Time`) VALUES((case when (SELECT COUNT(1) FROM t_atic_logholdtime_temp) > 0 then (SELECT pkid FROM t_atic_logholdtime_temp LIMIT 1) ELSE 0 END), (case when (SELECT COUNT(1) FROM t_atic_logholdtime_temp) > 0 then (SELECT hold_time FROM t_atic_logholdtime_temp LIMIT 1) ELSE 0 END),(case when (SELECT COUNT(1) FROM t_atic_logholdtime_temp) > 0 then (SELECT tacticsLog_time FROM t_atic_logholdtime_temp LIMIT 1) ELSE 90 END),(case when (SELECT COUNT(1) FROM t_atic_logholdtime_temp) > 0 then (SELECT holdOriginal_time FROM t_atic_logholdtime_temp LIMIT 1) ELSE 90 END),(case when (SELECT COUNT(1) FROM t_atic_logholdtime_temp) > 0 then (SELECT holdHour_time FROM t_atic_logholdtime_temp LIMIT 1) ELSE 12 END),(case when (SELECT COUNT(1) FROM t_atic_logholdtime_temp) > 0 then (SELECT holdDay_time FROM t_atic_logholdtime_temp LIMIT 1) ELSE 1 END),(case when (SELECT COUNT(1) FROM t_atic_logholdtime_temp) > 0 then (SELECT dayReport_time FROM t_atic_logholdtime_temp LIMIT 1) ELSE 60 END),(case when (SELECT COUNT(1) FROM t_atic_logholdtime_temp) > 0 then (SELECT weekReport_time FROM t_atic_logholdtime_temp LIMIT 1) ELSE 6 END),(case when (SELECT COUNT(1) FROM t_atic_logholdtime_temp) > 0 then (SELECT monthReport_time FROM t_atic_logholdtime_temp LIMIT 1) ELSE 1 END),(case when (SELECT COUNT(1) FROM t_atic_logholdtime_temp) > 0 then (SELECT yearReport_time FROM t_atic_logholdtime_temp LIMIT 1) ELSE 5 END),(case when (SELECT COUNT(1) FROM t_atic_logholdtime_temp) > 0 then (SELECT divertDelay_Time FROM t_atic_logholdtime_temp LIMIT 1) ELSE 300 END));

DROP TABLE IF EXISTS `t_atic_logholdtime_temp`;

/*else update table ,make sure no null*/
UPDATE `lego`.`t_atic_logholdtime` SET `hold_time` = (CASE WHEN ISNULL(`hold_time`) THEN 0 ELSE `hold_time`  END);
UPDATE `lego`.`t_atic_logholdtime` SET `tacticsLog_time` = (CASE WHEN ISNULL(`tacticsLog_time`) THEN 90 ELSE `tacticsLog_time` END);
UPDATE `lego`.`t_atic_logholdtime` SET `holdOriginal_time` = (CASE WHEN ISNULL(`holdOriginal_time`) THEN 90 ELSE `holdOriginal_time` END);
UPDATE `lego`.`t_atic_logholdtime` SET `holdHour_time` = (CASE WHEN ISNULL(`holdHour_time`) THEN 12 ELSE `holdHour_time` END);
UPDATE `lego`.`t_atic_logholdtime` SET `holdDay_time` = (CASE WHEN ISNULL(`holdDay_time`) THEN 1 ELSE `holdDay_time` END);
UPDATE `lego`.`t_atic_logholdtime` SET `dayReport_time` = (CASE WHEN ISNULL(`dayReport_time`) THEN 60 ELSE `dayReport_time` END);
UPDATE `lego`.`t_atic_logholdtime` SET `weekReport_time` = (CASE WHEN ISNULL(`weekReport_time`) THEN 6 ELSE `weekReport_time` END);
UPDATE `lego`.`t_atic_logholdtime` SET `monthReport_time` = (CASE WHEN ISNULL(`monthReport_time`) THEN 1 ELSE `monthReport_time` END);
UPDATE `lego`.`t_atic_logholdtime` SET `yearReport_time` = (CASE WHEN ISNULL(`yearReport_time`) THEN 5 ELSE `yearReport_time` END);
UPDATE `lego`.`t_atic_logholdtime` SET `divertDelay_Time` = (CASE WHEN ISNULL(`divertDelay_Time`) THEN 300 ELSE `divertDelay_Time` END);

UPDATE `lego`.`t_atic_divert_tactics` SET `vpn_name` = '' WHERE ISNULL(`vpn_name`);
