/* use when UPDATE B025 TO B026 */
USE `lego`;
DROP TABLE IF EXISTS `t_atic_vpn`;
CREATE TABLE `t_atic_vpn` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `moid` bigint(20) DEFAULT NULL,
  `vpn_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS  `atic_sig_sync_failed_info` (
  `pkid` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `SIG_ZONE_ID` BIGINT(20) NOT NULL,
  `FAILED_TYPE` INT(11) NOT NULL,
  `ZONE_NAME` VARCHAR(255) DEFAULT NULL,
  `ZONE_DESC` VARCHAR(255) DEFAULT NULL,
  `CONTACT` VARCHAR(255) DEFAULT NULL,
  `TELEPHONE` VARCHAR(255) DEFAULT NULL,
  `EMAIL` VARCHAR(255) DEFAULT NULL,
  `POST` VARCHAR(255) DEFAULT NULL,
  `ADDRESS` VARCHAR(255) DEFAULT NULL,
  `REMARK` VARCHAR(255) DEFAULT NULL,
  `START_IP` VARCHAR(255) DEFAULT NULL,
  `END_IP` VARCHAR(255) DEFAULT NULL,
  `ALARM_DESC_TYPE` INT(11) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DELIMITER $$

USE `lego`$$

DROP TRIGGER /*!50032 IF EXISTS */ `td_t_atic_vpn`$$

CREATE
    
    TRIGGER `td_t_atic_vpn` AFTER DELETE ON `t_atic_vpn` 
    FOR EACH ROW BEGIN
    	update t_vsm_zone_device set vpn_name = '' where device_id = old.moid and vpn_name = old.vpn_name;
    	DELETE FROM t_atic_divert_tactics WHERE device_id = old.moid AND vpn_name = old.vpn_name;
    END;
$$

DELIMITER ;

delete from T_operation_r_role where opt_id = 2017;
delete from T_operations where opt_id = 2017;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2017, 'secne.detall.group.list.edit.sigsas', '', '', 0, '2000-300-12-45');
insert into T_operation_r_role (role_id, opt_id) values (1, 2017);
insert into T_operation_r_role (role_id, opt_id) values (2, 2017);
ALTER TABLE `lego`.`atic_sig_sync_failed_info` ADD COLUMN `AREA_ID` BIGINT(20) NULL AFTER `ALARM_DESC_TYPE`;
