/*use when UPDATE B089 TO B091*/
USE lego;
ALTER TABLE lego.t_atic_divert_tactics_log MODIFY COLUMN remark varchar(1024);

ALTER TABLE t_atic_zombie_relation MODIFY COLUMN pkid int(11) NOT NULL AUTO_INCREMENT;

UPDATE t_vsm_zone_template SET device_type = 'AntiDDoS' WHERE device_type != 'SIG_sas';

DROP TABLE IF EXISTS `t_atic_device`;

CREATE TABLE `t_atic_device` (
  `moid` bigint(20) NOT NULL,
  `name` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `ip_address` varchar(50) COLLATE utf8_bin DEFAULT NULL,
  `device_type` int(11) DEFAULT NULL,
  `device_model` varchar(50) COLLATE utf8_bin DEFAULT NULL,
  `version` varchar(50) COLLATE utf8_bin DEFAULT NULL,
  `ddos_type` int(11) DEFAULT NULL,
  `cpu_number` int(11) DEFAULT NULL,
  `ftp_type` int(11) DEFAULT NULL,
  `ftp_user` varchar(50) COLLATE utf8_bin DEFAULT NULL,
  `ftp_password` varchar(50) COLLATE utf8_bin DEFAULT NULL,
  `ftp_port` int(11) DEFAULT NULL,
  PRIMARY KEY (`moid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

INSERT INTO lego.t_atic_device 
SELECT t_firewall.moid,t_managedobject.name,t_topoobject.ip_address,
CASE 
WHEN LOWER(t_ne.devtypename) LIKE '%nfa%' THEN 3
WHEN LOWER(t_ne.devtypename) LIKE  '%genie%' THEN 3
WHEN LOWER(t_ne.devtypename) LIKE  '%sys%' THEN 3
WHEN  LOWER(t_ne.devtypename) LIKE '%sig%' THEN 2 
ELSE 1
END AS devtype,SUBSTRING(t_ne.devtypename,1,12) AS devModel,t_ne.devosversionname,t_firewall.ddostype,1 AS cpu_number,1 AS ftp_type,NULL AS ftp_user,NULL AS ftp_password,22 AS ftp_port
FROM t_firewall,t_managedobject,t_topoobject,t_ne
WHERE t_firewall.moid = t_managedobject.moid AND t_managedobject.moid = t_topoobject.moid AND t_topoobject.moid = t_ne.moid;

INSERT INTO lego.t_atic_device 
SELECT t_secnesigsas.moid,t_managedobject.name,t_topoobject.ip_address, 
2  AS devtype,t_secnesigsas.devtypename,NULL AS VERSION,t_secnesigsas.ddostype,1 AS cpu_number,1 AS ftp_type,NULL AS ftp_user,NULL AS ftp_password,22 AS ftp_port
FROM t_managedobject,t_topoobject,t_secnesigsas
WHERE t_secnesigsas.moid = t_managedobject.moid AND t_managedobject.moid = t_topoobject.moid;

UPDATE lego.t_managedobject SET discriminator = 'Node', TYPE ='com.hs.lego.cbb.resource.sdk.model.Node' WHERE moid in (SELECT DISTINCT moid FROM t_atic_device);



DROP TABLE IF EXISTS `ireport_back_task`;
DROP TABLE IF EXISTS `t_commandsresultdetail`;
DROP TABLE IF EXISTS `t_batchdeployresult`;
DROP TABLE IF EXISTS `t_batchdeploytask`;
DROP TABLE IF EXISTS `t_devcpuinfo`;
DROP TABLE IF EXISTS `t_device_type`;
DROP TABLE IF EXISTS `t_entaliasmapping`;
DROP TABLE IF EXISTS `t_entitystateentry`;
DROP TABLE IF EXISTS `t_entphysical`;
DROP TABLE IF EXISTS `t_firewall`;
DROP TABLE IF EXISTS `t_frame`;
DROP TABLE IF EXISTS `t_hub`;
DROP TABLE IF EXISTS `t_ifdata`;
DROP TABLE IF EXISTS `t_ifextentry`;
DROP TABLE IF EXISTS `t_ifipaddrentry`;
DROP TABLE IF EXISTS `t_ifxentry`;
DROP TABLE IF EXISTS `t_interface`;
DROP TABLE IF EXISTS `t_ne`;
DROP TABLE IF EXISTS `t_port`;
DROP TABLE IF EXISTS `t_route`;
DROP TABLE IF EXISTS `t_secnesigsas`;
DROP TABLE IF EXISTS `t_secstatsession`;
DROP TABLE IF EXISTS `t_securityne`;
DROP TABLE IF EXISTS `t_slot`;
DROP TABLE IF EXISTS `t_subslot`;
DROP TABLE IF EXISTS `t_switch`;
DROP TABLE IF EXISTS `t_report_email`;
DROP TABLE IF EXISTS `t_report_report`;
DROP TABLE IF EXISTS `t_vsm_zone_operation_study`;
DROP TABLE IF EXISTS `t_vsm_zone_operation_study`;

CREATE TABLE `role_id_tmp` (
  `id` int(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

insert  into `role_id_tmp`(`id`) values (3),(73),(74),(75),(76),(77),(78),(80),(82),(83),(84),(115),(116),(117),(118),(119),(120),(122),(123),(124),(125),(130),(131);
insert  into `role_id_tmp`(`id`) values (132),(133),(134),(135),(136),(139),(140),(141),(142),(143),(144),(145),(146),(147),(148),(149),(150),(156),(157),(158),(159);
insert  into `role_id_tmp`(`id`) values (160),(161),(162),(163),(164),(165),(166),(167),(168),(169),(170),(171),(198),(199),(200),(201),(202),(203),(204),(2000),(2001),(2002),(2003),(2004),(2006),(2013),(2017);
insert  into `role_id_tmp`(`id`) values (2018),(2200),(2201),(2202),(2203),(2204),(2205),(2206),(2209),(2210),(2211),(2212),(2213),(2214),(2220),(2221),(2222),(2223),(2225),(2226),(2227),(2230),(2231),(2232);
insert  into `role_id_tmp`(`id`) values (2233),(2234),(2235),(2236),(2237),(2240),(2241),(2245),(2246),(2250),(2251),(2260),(2261),(2270),(2271),(2290),(2291),(2292),(2293),(2294),(2295),(2296),(2300),(2301);
insert  into `role_id_tmp`(`id`) values (2302),(2304),(2320),(2321),(2322),(2324),(2330),(2331),(2332),(2333),(2334),(2340),(2341),(2342),(2350),(2351),(2352),(2353),(2354),(2360),(2361),(2370),(2371),(2372),(2373);
insert  into `role_id_tmp`(`id`) values (2374),(2380),(2381),(2382),(2383),(2384),(2385),(2386),(2390),(2391),(2392),(2400),(2401),(2402),(2403),(2404),(2405),(2406),(2407),(2410),(2411),(2412),(2413),(2414),(2415);
insert  into `role_id_tmp`(`id`) values (2416),(2421),(2422),(2423),(2424),(2425),(2430),(2431),(2432),(2433),(2434),(2435),(2436),(2440),(2441),(2442),(2443),(2444),(2445),(2446),(2500),(2501),(2502);
insert  into `role_id_tmp`(`id`) values (4000),(4001),(4002),(4003),(4004),(4080),(4081),(4082),(4083),(4084),(4087),(4091);

DELETE FROM T_operation_r_role WHERE opt_id NOT IN(select id from role_id_tmp);

DELETE FROM t_operations WHERE opt_id NOT IN(select id from role_id_tmp);


CREATE TABLE `t_operation_r_role_temp` (
  `role_id` bigint(20) NOT NULL,
  `opt_id` bigint(20) NOT NULL,
  PRIMARY KEY (`role_id`,`opt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

delete from T_operation_r_role where opt_id = 3 and role_id = 1;
delete from T_operation_r_role where opt_id = 3 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 3;
delete from T_operation_r_role where opt_id = 3;
delete from T_operations where opt_id = 3;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(3, 'lego.res', '/nem/disc/deviceTable.do', '', 0, '2000');
insert into T_operation_r_role (role_id, opt_id) values (1, 3);
insert into T_operation_r_role (role_id, opt_id) values (2, 3);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 3;

delete from T_operation_r_role where opt_id = 73 and role_id = 1;
delete from T_operation_r_role where opt_id = 73 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 73;
delete from T_operation_r_role where opt_id = 73;
delete from T_operations where opt_id = 73;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(73, 'lego.event', '/cbb/fault/listFault.do', '', 0, '6000');
insert into T_operation_r_role (role_id, opt_id) values (1, 73);
insert into T_operation_r_role (role_id, opt_id) values (2, 73);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 73;
delete from T_operation_r_role where opt_id = 74 and role_id = 1;
delete from T_operation_r_role where opt_id = 74 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 74;
delete from T_operation_r_role where opt_id = 74;
delete from T_operations where opt_id = 74;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(74, 'lego.evtMgr', '', '', 0, '6000-100');
insert into T_operation_r_role (role_id, opt_id) values (1, 74);
insert into T_operation_r_role (role_id, opt_id) values (2, 74);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 74;
delete from T_operation_r_role where opt_id = 75 and role_id = 1;
delete from T_operation_r_role where opt_id = 75 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 75;
delete from T_operation_r_role where opt_id = 75;
delete from T_operations where opt_id = 75;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(75, 'lego.evtMgr.curtAlarm', '/cbb/fault/listFault.do', '', 0, '6000-100-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 75);
insert into T_operation_r_role (role_id, opt_id) values (2, 75);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 75;
delete from T_operation_r_role where opt_id = 76 and role_id = 1;
delete from T_operation_r_role where opt_id = 76 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 76;
delete from T_operation_r_role where opt_id = 76;
delete from T_operations where opt_id = 76;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(76, 'lego.evtMgr.curtAlarm.scan', '', '', 1, '6000-100-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 76);
insert into T_operation_r_role (role_id, opt_id) values (2, 76);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 76;
delete from T_operation_r_role where opt_id = 77 and role_id = 1;
delete from T_operation_r_role where opt_id = 77 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 77;
delete from T_operation_r_role where opt_id = 77;
delete from T_operations where opt_id = 77;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(77, 'lego.evtMgr.curtAlarm.clear', '', '', 0, '6000-100-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 77);
insert into T_operation_r_role (role_id, opt_id) values (2, 77);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 77;
delete from T_operation_r_role where opt_id = 78 and role_id = 1;
delete from T_operation_r_role where opt_id = 78 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 78;
delete from T_operation_r_role where opt_id = 78;
delete from T_operations where opt_id = 78;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(78, 'lego.evtMgr.curtAlarm.confirm', '', '', 0, '6000-100-10-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 78);
insert into T_operation_r_role (role_id, opt_id) values (2, 78);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 78;
delete from T_operation_r_role where opt_id = 80 and role_id = 1;
delete from T_operation_r_role where opt_id = 80 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 80;
delete from T_operation_r_role where opt_id = 80;
delete from T_operations where opt_id = 80;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(80, 'lego.evtMgr.curtAlarm.export', '', '', 0, '6000-100-10-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 80);
insert into T_operation_r_role (role_id, opt_id) values (2, 80);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 80;
delete from T_operation_r_role where opt_id = 82 and role_id = 1;
delete from T_operation_r_role where opt_id = 82 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 82;
delete from T_operation_r_role where opt_id = 82;
delete from T_operations where opt_id = 82;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(82, 'lego.evtMgr.hisAlarm', '/cbb/fault/listHistoryFault.do', '', 0, '6000-100-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 82);
insert into T_operation_r_role (role_id, opt_id) values (2, 82);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 82;
delete from T_operation_r_role where opt_id = 83 and role_id = 1;
delete from T_operation_r_role where opt_id = 83 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 83;
delete from T_operation_r_role where opt_id = 83;
delete from T_operations where opt_id = 83;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(83, 'lego.evtMgr.hisAlarm.scan', '', '', 1, '6000-100-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 83);
insert into T_operation_r_role (role_id, opt_id) values (2, 83);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 83;
delete from T_operation_r_role where opt_id = 84 and role_id = 1;
delete from T_operation_r_role where opt_id = 84 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 84;
delete from T_operation_r_role where opt_id = 84;
delete from T_operations where opt_id = 84;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(84, 'lego.evtMgr.hisAlarm.export', '', '', 0, '6000-100-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 84);
insert into T_operation_r_role (role_id, opt_id) values (2, 84);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 84;
delete from T_operation_r_role where opt_id = 115 and role_id = 1;
delete from T_operation_r_role where opt_id = 115 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 115;
delete from T_operation_r_role where opt_id = 115;
delete from T_operations where opt_id = 115;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(115, 'lego.event.notify', '', '', 0, '6000-500');
insert into T_operation_r_role (role_id, opt_id) values (1, 115);
insert into T_operation_r_role (role_id, opt_id) values (2, 115);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 115;
delete from T_operation_r_role where opt_id = 116 and role_id = 1;
delete from T_operation_r_role where opt_id = 116 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 116;
delete from T_operation_r_role where opt_id = 116;
delete from T_operations where opt_id = 116;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(116, 'lego.event.notify.message', '/cbb/fault/listNotifyRule.do', '', 0, '6000-500-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 116);
insert into T_operation_r_role (role_id, opt_id) values (2, 116);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 116;
delete from T_operation_r_role where opt_id = 117 and role_id = 1;
delete from T_operation_r_role where opt_id = 117 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 117;
delete from T_operation_r_role where opt_id = 117;
delete from T_operations where opt_id = 117;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(117, 'lego.event.notify.scan', '', '', 1, '6000-500-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 117);
insert into T_operation_r_role (role_id, opt_id) values (2, 117);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 117;
delete from T_operation_r_role where opt_id = 118 and role_id = 1;
delete from T_operation_r_role where opt_id = 118 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 118;
delete from T_operation_r_role where opt_id = 118;
delete from T_operations where opt_id = 118;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(118, 'lego.event.notify.add', '', '', 0, '6000-500-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 118);
insert into T_operation_r_role (role_id, opt_id) values (2, 118);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 118;
delete from T_operation_r_role where opt_id = 119 and role_id = 1;
delete from T_operation_r_role where opt_id = 119 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 119;
delete from T_operation_r_role where opt_id = 119;
delete from T_operations where opt_id = 119;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(119, 'lego.event.notify.delete', '', '', 0, '6000-500-10-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 119);
insert into T_operation_r_role (role_id, opt_id) values (2, 119);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 119;
delete from T_operation_r_role where opt_id = 120 and role_id = 1;
delete from T_operation_r_role where opt_id = 120 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 120;
delete from T_operation_r_role where opt_id = 120;
delete from T_operations where opt_id = 120;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(120, 'lego.event.notify.start', '', '', 0, '6000-500-10-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 120);
insert into T_operation_r_role (role_id, opt_id) values (2, 120);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 120;
delete from T_operation_r_role where opt_id = 122 and role_id = 1;
delete from T_operation_r_role where opt_id = 122 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 122;
delete from T_operation_r_role where opt_id = 122;
delete from T_operations where opt_id = 122;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(122, 'lego.event.notify.modify', '', '', 0, '6000-500-10-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 122);
insert into T_operation_r_role (role_id, opt_id) values (2, 122);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 122;
delete from T_operation_r_role where opt_id = 123 and role_id = 1;
delete from T_operation_r_role where opt_id = 123 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 123;
delete from T_operation_r_role where opt_id = 123;
delete from T_operations where opt_id = 123;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(123, 'lego.event.voice', '/nem/fault/getAudioSetting.do', '', 0, '6000-500-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 123);
insert into T_operation_r_role (role_id, opt_id) values (2, 123);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 123;
delete from T_operation_r_role where opt_id = 124 and role_id = 1;
delete from T_operation_r_role where opt_id = 124 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 124;
delete from T_operation_r_role where opt_id = 124;
delete from T_operations where opt_id = 124;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(124, 'lego.event.voice.scan', '', '', 1, '6000-500-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 124);
insert into T_operation_r_role (role_id, opt_id) values (2, 124);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 124;
delete from T_operation_r_role where opt_id = 125 and role_id = 1;
delete from T_operation_r_role where opt_id = 125 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 125;
delete from T_operation_r_role where opt_id = 125;
delete from T_operations where opt_id = 125;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(125, 'lego.event.voice.modify', '', '', 0, '6000-500-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 125);
insert into T_operation_r_role (role_id, opt_id) values (2, 125);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 125;
delete from T_operation_r_role where opt_id = 130 and role_id = 1;
delete from T_operation_r_role where opt_id = 130 and role_id = 2;
delete from T_operation_r_role where opt_id = 130 and role_id = 3;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 130;
delete from T_operation_r_role where opt_id = 130;
delete from T_operations where opt_id = 130;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(130, 'lego.sys', '/cbb/admin/adminList.do', '', 0, '8000');
insert into T_operation_r_role (role_id, opt_id) values (1, 130);
insert into T_operation_r_role (role_id, opt_id) values (2, 130);
insert into T_operation_r_role (role_id, opt_id) values (3, 130);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 130;
delete from T_operation_r_role where opt_id = 131 and role_id = 1;
delete from T_operation_r_role where opt_id = 131 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 131;
delete from T_operation_r_role where opt_id = 131;
delete from T_operations where opt_id = 131;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(131, 'lego.sys.operatorMgr', '', '', 0, '8000-300');
insert into T_operation_r_role (role_id, opt_id) values (1, 131);
insert into T_operation_r_role (role_id, opt_id) values (2, 131);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 131;
delete from T_operation_r_role where opt_id = 132 and role_id = 1;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 132;
delete from T_operation_r_role where opt_id = 132;
delete from T_operations where opt_id = 132;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(132, 'lego.sys.operatorMgr.operator', '/cbb/admin/adminList.do', '', 0, '8000-300-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 132);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 132;
delete from T_operation_r_role where opt_id = 133 and role_id = 1;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 133;
delete from T_operation_r_role where opt_id = 133;
delete from T_operations where opt_id = 133;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(133, 'lego.sys.operatorMgr.operator.scan', '', '', 1, '8000-300-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 133);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 133;
delete from T_operation_r_role where opt_id = 134 and role_id = 1;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 134;
delete from T_operation_r_role where opt_id = 134;
delete from T_operations where opt_id = 134;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(134, 'lego.sys.operatorMgr.operator.add', '', '', 0, '8000-300-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 134);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 134;
delete from T_operation_r_role where opt_id = 135 and role_id = 1;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 135;
delete from T_operation_r_role where opt_id = 135;
delete from T_operations where opt_id = 135;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(135, 'lego.sys.operatorMgr.operator.delete', '', '', 0, '8000-300-10-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 135);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 135;
delete from T_operation_r_role where opt_id = 136 and role_id = 1;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 136;
delete from T_operation_r_role where opt_id = 136;
delete from T_operations where opt_id = 136;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(136, 'lego.sys.operatorMgr.operator.edit', '', '', 0, '8000-300-10-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 136);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 136;
delete from T_operation_r_role where opt_id = 139 and role_id = 1;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 139;
delete from T_operation_r_role where opt_id = 139;
delete from T_operations where opt_id = 139;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(139, 'lego.sys.role', '/cbb/admin/roleList.do', '', 0, '8000-300-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 139);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 139;
delete from T_operation_r_role where opt_id = 140 and role_id = 1;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 140;
delete from T_operation_r_role where opt_id = 140;
delete from T_operations where opt_id = 140;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(140, 'lego.sys.role.scan', '', '', 1, '8000-300-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 140);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 140;
delete from T_operation_r_role where opt_id = 141 and role_id = 1;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 141;
delete from T_operation_r_role where opt_id = 141;
delete from T_operations where opt_id = 141;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(141, 'lego.sys.role.add', '', '', 0, '8000-300-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 141);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 141;
delete from T_operation_r_role where opt_id = 142 and role_id = 1;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 142;
delete from T_operation_r_role where opt_id = 142;
delete from T_operations where opt_id = 142;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(142, 'lego.sys.role.delete', '', '', 0, '8000-300-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 142);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 142;
delete from T_operation_r_role where opt_id = 143 and role_id = 1;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 143;
delete from T_operation_r_role where opt_id = 143;
delete from T_operations where opt_id = 143;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(143, 'lego.sys.role.edit', '', '', 0, '8000-300-20-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 143);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 143;
delete from T_operation_r_role where opt_id = 144 and role_id = 1;
delete from T_operation_r_role where opt_id = 144 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 144;
delete from T_operation_r_role where opt_id = 144;
delete from T_operations where opt_id = 144;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(144, 'lego.sys.onlineUserMgr', '/cbb/admin/onlineList.do', '', 0, '8000-300-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 144);
insert into T_operation_r_role (role_id, opt_id) values (2, 144);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 144;
delete from T_operation_r_role where opt_id = 145 and role_id = 1;
delete from T_operation_r_role where opt_id = 145 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 145;
delete from T_operation_r_role where opt_id = 145;
delete from T_operations where opt_id = 145;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(145, 'lego.sys.onlineUserMgr.scan', '', '', 1, '8000-300-30-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 145);
insert into T_operation_r_role (role_id, opt_id) values (2, 145);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 145;
delete from T_operation_r_role where opt_id = 146 and role_id = 1;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 146;
delete from T_operation_r_role where opt_id = 146;
delete from T_operations where opt_id = 146;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(146, 'lego.sys.onlineUserMgr.down', '', '', 0, '8000-300-30-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 146);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 146;
delete from T_operation_r_role where opt_id = 147 and role_id = 1;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 147;
delete from T_operation_r_role where opt_id = 147;
delete from T_operations where opt_id = 147;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(147, 'lego.sys.sysLoginPolicy', '/cbb/admin/passPolicy.do', '', 0, '8000-300-50');
insert into T_operation_r_role (role_id, opt_id) values (1, 147);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 147;
delete from T_operation_r_role where opt_id = 148 and role_id = 1;
delete from T_operation_r_role where opt_id = 148 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 148;
delete from T_operation_r_role where opt_id = 148;
delete from T_operations where opt_id = 148;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(148, 'lego.sys.sysLoginPolicy.scan', '', '', 1, '8000-300-50-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 148);
insert into T_operation_r_role (role_id, opt_id) values (2, 148);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 148;
delete from T_operation_r_role where opt_id = 149 and role_id = 1;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 149;
delete from T_operation_r_role where opt_id = 149;
delete from T_operations where opt_id = 149;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(149, 'lego.sys.sysLoginPolicy.modify', '', '', 0, '8000-300-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 149);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 149;
delete from T_operation_r_role where opt_id = 150 and role_id = 1;
delete from T_operation_r_role where opt_id = 150 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 150;
delete from T_operation_r_role where opt_id = 150;
delete from T_operations where opt_id = 150;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(150, 'lego.sys.systemInfo', '', '', 0, '8000-400');
insert into T_operation_r_role (role_id, opt_id) values (1, 150);
insert into T_operation_r_role (role_id, opt_id) values (2, 150);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 150;
delete from T_operation_r_role where opt_id = 156 and role_id = 1;
delete from T_operation_r_role where opt_id = 156 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 156;
delete from T_operation_r_role where opt_id = 156;
delete from T_operations where opt_id = 156;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(156, 'lego.sys.systemMonitor', '/core/system/perforView.do', '', 0, '8000-400-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 156);
insert into T_operation_r_role (role_id, opt_id) values (2, 156);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 156;
delete from T_operation_r_role where opt_id = 157 and role_id = 1;
delete from T_operation_r_role where opt_id = 157 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 157;
delete from T_operation_r_role where opt_id = 157;
delete from T_operations where opt_id = 157;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(157, 'lego.sys.systemMonitor.scan', '', '', 1, '8000-400-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 157);
insert into T_operation_r_role (role_id, opt_id) values (2, 157);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 157;
delete from T_operation_r_role where opt_id = 158 and role_id = 1;
delete from T_operation_r_role where opt_id = 158 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 158;
delete from T_operation_r_role where opt_id = 158;
delete from T_operations where opt_id = 158;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(158, 'lego.sys.systemMonitor.Threshold.modify', '', '', 0, '8000-400-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 158);
insert into T_operation_r_role (role_id, opt_id) values (2, 158);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 158;
delete from T_operation_r_role where opt_id = 159 and role_id = 1;
delete from T_operation_r_role where opt_id = 159 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 159;
delete from T_operation_r_role where opt_id = 159;
delete from T_operations where opt_id = 159;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(159, 'lego.sys.dataStorage', '', '', 0, '8000-500');
insert into T_operation_r_role (role_id, opt_id) values (1, 159);
insert into T_operation_r_role (role_id, opt_id) values (2, 159);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 159;
delete from T_operation_r_role where opt_id = 160 and role_id = 1;
delete from T_operation_r_role where opt_id = 160 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 160;
delete from T_operation_r_role where opt_id = 160;
delete from T_operations where opt_id = 160;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(160, 'lego.sys.dataStorage.sysOptLog', '/core/system/sysOptStorage.do', '', 0, '8000-500-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 160);
insert into T_operation_r_role (role_id, opt_id) values (2, 160);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 160;
delete from T_operation_r_role where opt_id = 161 and role_id = 1;
delete from T_operation_r_role where opt_id = 161 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 161;
delete from T_operation_r_role where opt_id = 161;
delete from T_operations where opt_id = 161;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(161, 'lego.sys.dataStorage.sysOptLog.scan', '', '', 1, '8000-500-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 161);
insert into T_operation_r_role (role_id, opt_id) values (2, 161);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 161;
delete from T_operation_r_role where opt_id = 162 and role_id = 1;
delete from T_operation_r_role where opt_id = 162 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 162;
delete from T_operation_r_role where opt_id = 162;
delete from T_operations where opt_id = 162;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(162, 'lego.sys.dataStorage.sysOptLog.modify', '', '', 0, '8000-500-10-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 162);
insert into T_operation_r_role (role_id, opt_id) values (2, 162);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 162;
delete from T_operation_r_role where opt_id = 163 and role_id = 1;
delete from T_operation_r_role where opt_id = 163 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 163;
delete from T_operation_r_role where opt_id = 163;
delete from T_operations where opt_id = 163;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(163, 'lego.sys.dataStorage.sysOptLog.delete', '', '', 0, '8000-500-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 163);
insert into T_operation_r_role (role_id, opt_id) values (2, 163);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 163;
delete from T_operation_r_role where opt_id = 164 and role_id = 1;
delete from T_operation_r_role where opt_id = 164 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 164;
delete from T_operation_r_role where opt_id = 164;
delete from T_operations where opt_id = 164;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(164, 'lego.sys.dataStorage.event', '/core/system/eventStorage.do', '', 0, '8000-500-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 164);
insert into T_operation_r_role (role_id, opt_id) values (2, 164);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 164;
delete from T_operation_r_role where opt_id = 165 and role_id = 1;
delete from T_operation_r_role where opt_id = 165 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 165;
delete from T_operation_r_role where opt_id = 165;
delete from T_operations where opt_id = 165;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(165, 'lego.sys.dataStorage.event.scan', '', '', 1, '8000-500-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 165);
insert into T_operation_r_role (role_id, opt_id) values (2, 165);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 165;
delete from T_operation_r_role where opt_id = 166 and role_id = 1;
delete from T_operation_r_role where opt_id = 166 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 166;
delete from T_operation_r_role where opt_id = 166;
delete from T_operations where opt_id = 166;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(166, 'lego.sys.dataStorage.event.modify', '', '', 0, '8000-500-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 166);
insert into T_operation_r_role (role_id, opt_id) values (2, 166);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 166;
delete from T_operation_r_role where opt_id = 167 and role_id = 1;
delete from T_operation_r_role where opt_id = 167 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 167;
delete from T_operation_r_role where opt_id = 167;
delete from T_operations where opt_id = 167;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(167, 'lego.sys.dataStorage.event.delete', '', '', 0, '8000-500-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 167);
insert into T_operation_r_role (role_id, opt_id) values (2, 167);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 167;
delete from T_operation_r_role where opt_id = 168 and role_id = 1;
delete from T_operation_r_role where opt_id = 168 and role_id = 2;
delete from T_operation_r_role where opt_id = 168 and role_id = 3;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 168;
delete from T_operation_r_role where opt_id = 168;
delete from T_operations where opt_id = 168;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(168, 'lego.sys.sysLog', '', '', 0, '8000-600');
insert into T_operation_r_role (role_id, opt_id) values (1, 168);
insert into T_operation_r_role (role_id, opt_id) values (2, 168);
insert into T_operation_r_role (role_id, opt_id) values (3, 168);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 168;
delete from T_operation_r_role where opt_id = 169 and role_id = 1;
delete from T_operation_r_role where opt_id = 169 and role_id = 2;
delete from T_operation_r_role where opt_id = 169 and role_id = 3;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 169;
delete from T_operation_r_role where opt_id = 169;
delete from T_operations where opt_id = 169;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(169, 'lego.sys.sysLog.operLog', '/core/system/sysLogQuery.do', '', 0, '8000-600-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 169);
insert into T_operation_r_role (role_id, opt_id) values (2, 169);
insert into T_operation_r_role (role_id, opt_id) values (3, 169);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 169;
delete from T_operation_r_role where opt_id = 170 and role_id = 1;
delete from T_operation_r_role where opt_id = 170 and role_id = 2;
delete from T_operation_r_role where opt_id = 170 and role_id = 3;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 170;
delete from T_operation_r_role where opt_id = 170;
delete from T_operations where opt_id = 170;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(170, 'lego.sys.sysLog.operLog.scan', '', '', 1, '8000-600-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 170);
insert into T_operation_r_role (role_id, opt_id) values (2, 170);
insert into T_operation_r_role (role_id, opt_id) values (3, 170);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 170;
delete from T_operation_r_role where opt_id = 171 and role_id = 1;
delete from T_operation_r_role where opt_id = 171 and role_id = 2;
delete from T_operation_r_role where opt_id = 171 and role_id = 3;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 171;
delete from T_operation_r_role where opt_id = 171;
delete from T_operations where opt_id = 171;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(171, 'lego.sys.sysLog.operLog.exportExl', '', '', 0, '8000-600-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 171);
insert into T_operation_r_role (role_id, opt_id) values (2, 171);
insert into T_operation_r_role (role_id, opt_id) values (3, 171);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 171;
delete from T_operation_r_role where opt_id = 198 and role_id = 1;
delete from T_operation_r_role where opt_id = 198 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 198;
delete from T_operation_r_role where opt_id = 198;
delete from T_operations where opt_id = 198;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(198, 'lego.sys.notifyServer', '', '', 0, '8000-1000');
insert into T_operation_r_role (role_id, opt_id) values (1, 198);
insert into T_operation_r_role (role_id, opt_id) values (2, 198);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 198;
delete from T_operation_r_role where opt_id = 199 and role_id = 1;
delete from T_operation_r_role where opt_id = 199 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 199;
delete from T_operation_r_role where opt_id = 199;
delete from T_operations where opt_id = 199;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(199, 'lego.sys.serverInfo', '/nem/fault/showserver.do', '', 0, '8000-1000-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 199);
insert into T_operation_r_role (role_id, opt_id) values (2, 199);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 199;
delete from T_operation_r_role where opt_id = 200 and role_id = 1;
delete from T_operation_r_role where opt_id = 200 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 200;
delete from T_operation_r_role where opt_id = 200;
delete from T_operations where opt_id = 200;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(200, 'lego.sys.server.scan', '', '', 1, '8000-1000-10-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 200);
insert into T_operation_r_role (role_id, opt_id) values (2, 200);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 200;
delete from T_operation_r_role where opt_id = 201 and role_id = 1;
delete from T_operation_r_role where opt_id = 201 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 201;
delete from T_operation_r_role where opt_id = 201;
delete from T_operations where opt_id = 201;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(201, 'lego.sys.serverEdit', '', '', 0, '8000-1000-10-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 201);
insert into T_operation_r_role (role_id, opt_id) values (2, 201);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 201;
delete from T_operation_r_role where opt_id = 202 and role_id = 1;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 202;
delete from T_operation_r_role where opt_id = 202;
delete from T_operations where opt_id = 202;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(202, 'lego.sys.user.authserver', '/cbb/admin/editRadiuConf.do', '', 0, '8000-300-60');
insert into T_operation_r_role (role_id, opt_id) values (1, 202);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 202;
delete from T_operation_r_role where opt_id = 203 and role_id = 1;
delete from T_operation_r_role where opt_id = 203 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 203;
delete from T_operation_r_role where opt_id = 203;
delete from T_operations where opt_id = 203;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(203, 'lego.sys.user.authserver.scan', '', '', 1, '8000-300-60-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 203);
insert into T_operation_r_role (role_id, opt_id) values (2, 203);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 203;
delete from T_operation_r_role where opt_id = 204 and role_id = 1;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 204;
delete from T_operation_r_role where opt_id = 204;
delete from T_operations where opt_id = 204;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(204, 'lego.sys.user.authserver.modify', '', '', 0, '8000-300-60-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 204);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 204;
delete from T_operation_r_role where opt_id = 2000 and role_id = 1;
delete from T_operation_r_role where opt_id = 2000 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2000;
delete from T_operation_r_role where opt_id = 2000;
delete from T_operations where opt_id = 2000;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2000, 'lego.resource.mgr', '', '', 0, '2000-300');
insert into T_operation_r_role (role_id, opt_id) values (1, 2000);
insert into T_operation_r_role (role_id, opt_id) values (2, 2000);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2000;
delete from T_operation_r_role where opt_id = 2001 and role_id = 1;
delete from T_operation_r_role where opt_id = 2001 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2001;
delete from T_operation_r_role where opt_id = 2001;
delete from T_operations where opt_id = 2001;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2001, 'lego.secne.device.list', '/VSM-SecNE-UI/secNEDataList.do', '', 0, '2000-300-12');
insert into T_operation_r_role (role_id, opt_id) values (1, 2001);
insert into T_operation_r_role (role_id, opt_id) values (2, 2001);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2001;
delete from T_operation_r_role where opt_id = 2002 and role_id = 1;
delete from T_operation_r_role where opt_id = 2002 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2002;
delete from T_operation_r_role where opt_id = 2002;
delete from T_operations where opt_id = 2002;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2002, 'lego.secne.device.list.scan', '', '', 1, '2000-300-12-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2002);
insert into T_operation_r_role (role_id, opt_id) values (2, 2002);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2002;
delete from T_operation_r_role where opt_id = 2003 and role_id = 1;
delete from T_operation_r_role where opt_id = 2003 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2003;
delete from T_operation_r_role where opt_id = 2003;
delete from T_operations where opt_id = 2003;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2003, 'lego.secne.device.list.protocol', '', '', 0, '2000-300-12-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 2003);
insert into T_operation_r_role (role_id, opt_id) values (2, 2003);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2003;
delete from T_operation_r_role where opt_id = 2004 and role_id = 1;
delete from T_operation_r_role where opt_id = 2004 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2004;
delete from T_operation_r_role where opt_id = 2004;
delete from T_operations where opt_id = 2004;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2004, 'lego.secne.device.list.synchronization', '', '', 0, '2000-300-12-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 2004);
insert into T_operation_r_role (role_id, opt_id) values (2, 2004);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2004;
delete from T_operation_r_role where opt_id = 2006 and role_id = 1;
delete from T_operation_r_role where opt_id = 2006 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2006;
delete from T_operation_r_role where opt_id = 2006;
delete from T_operations where opt_id = 2006;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2006, 'lego.secne.device.list.delete', '', '', 0, '2000-300-12-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 2006);
insert into T_operation_r_role (role_id, opt_id) values (2, 2006);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2006;
delete from T_operation_r_role where opt_id = 2013 and role_id = 1;
delete from T_operation_r_role where opt_id = 2013 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2013;
delete from T_operation_r_role where opt_id = 2013;
delete from T_operations where opt_id = 2013;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2013, 'lego.secne.device.list.modify.nename', '', '', 0, '2000-300-12-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 2013);
insert into T_operation_r_role (role_id, opt_id) values (2, 2013);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2013;
delete from T_operation_r_role where opt_id = 2017 and role_id = 1;
delete from T_operation_r_role where opt_id = 2017 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2017;
delete from T_operation_r_role where opt_id = 2017;
delete from T_operations where opt_id = 2017;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2017, 'secne.detall.group.list.edit.sigsas', '', '', 0, '2000-300-12-45');
insert into T_operation_r_role (role_id, opt_id) values (1, 2017);
insert into T_operation_r_role (role_id, opt_id) values (2, 2017);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2017;
delete from T_operation_r_role where opt_id = 2018 and role_id = 1;
delete from T_operation_r_role where opt_id = 2018 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2018;
delete from T_operation_r_role where opt_id = 2018;
delete from T_operations where opt_id = 2018;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2018, 'vsm.secne.ddos.add.device', '', '', 0, '2000-300-12-7');
insert into T_operation_r_role (role_id, opt_id) values (1, 2018);
insert into T_operation_r_role (role_id, opt_id) values (2, 2018);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2018;
delete from T_operation_r_role where opt_id = 2200 and role_id = 1;
delete from T_operation_r_role where opt_id = 2200 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2200;
delete from T_operation_r_role where opt_id = 2200;
delete from T_operations where opt_id = 2200;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2200, 'atic.bis.policyApply', '/vsm/policy/ddos/viewAllZonePolicys.do', '', 0, '6500-100-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 2200);
insert into T_operation_r_role (role_id, opt_id) values (2, 2200);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2200;
delete from T_operation_r_role where opt_id = 2201 and role_id = 1;
delete from T_operation_r_role where opt_id = 2201 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2201;
delete from T_operation_r_role where opt_id = 2201;
delete from T_operations where opt_id = 2201;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2201, 'atic.bis.policy.view', '', '', 1, '6500-100-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2201);
insert into T_operation_r_role (role_id, opt_id) values (2, 2201);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2201;
delete from T_operation_r_role where opt_id = 2202 and role_id = 1;
delete from T_operation_r_role where opt_id = 2202 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2202;
delete from T_operation_r_role where opt_id = 2202;
delete from T_operations where opt_id = 2202;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2202, 'atic.bis.policy.deploy', '', '', 0, '6500-100-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 2202);
insert into T_operation_r_role (role_id, opt_id) values (2, 2202);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2202;
delete from T_operation_r_role where opt_id = 2203 and role_id = 1;
delete from T_operation_r_role where opt_id = 2203 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2203;
delete from T_operation_r_role where opt_id = 2203;
delete from T_operations where opt_id = 2203;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2203, 'atic.bis.policy.remove', '', '', 0, '6500-100-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 2203);
insert into T_operation_r_role (role_id, opt_id) values (2, 2203);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2203;
delete from T_operation_r_role where opt_id = 2204 and role_id = 1;
delete from T_operation_r_role where opt_id = 2204 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2204;
delete from T_operation_r_role where opt_id = 2204;
delete from T_operations where opt_id = 2204;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2204, 'atic.bis.policy.learning', '', '', 0, '6500-100-20-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 2204);
insert into T_operation_r_role (role_id, opt_id) values (2, 2204);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2204;
delete from T_operation_r_role where opt_id = 2205 and role_id = 1;
delete from T_operation_r_role where opt_id = 2205 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2205;
delete from T_operation_r_role where opt_id = 2205;
delete from T_operations where opt_id = 2205;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2205, 'atic.bis.policy.baseline', '', '', 0, '6500-100-20-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 2205);
insert into T_operation_r_role (role_id, opt_id) values (2, 2205);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2205;
delete from T_operation_r_role where opt_id = 2206 and role_id = 1;
delete from T_operation_r_role where opt_id = 2206 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2206;
delete from T_operation_r_role where opt_id = 2206;
delete from T_operations where opt_id = 2206;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2206, 'atic.bis.policy.configuration', '', '', 0, '6500-100-20-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 2206);
insert into T_operation_r_role (role_id, opt_id) values (2, 2206);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2206;
delete from T_operation_r_role where opt_id = 2209 and role_id = 1;
delete from T_operation_r_role where opt_id = 2209 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2209;
delete from T_operation_r_role where opt_id = 2209;
delete from T_operations where opt_id = 2209;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2209, 'atic.bis.policy.exception', '', '', 0, '6500-100-20-45');
insert into T_operation_r_role (role_id, opt_id) values (1, 2209);
insert into T_operation_r_role (role_id, opt_id) values (2, 2209);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2209;
delete from T_operation_r_role where opt_id = 2210 and role_id = 1;
delete from T_operation_r_role where opt_id = 2210 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2210;
delete from T_operation_r_role where opt_id = 2210;
delete from T_operations where opt_id = 2210;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2210, 'atic.bis.defendGroup', '/atic/business/listDefendGroup.do', '', 0, '6500-100-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 2210);
insert into T_operation_r_role (role_id, opt_id) values (2, 2210);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2210;
delete from T_operation_r_role where opt_id = 2211 and role_id = 1;
delete from T_operation_r_role where opt_id = 2211 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2211;
delete from T_operation_r_role where opt_id = 2211;
delete from T_operations where opt_id = 2211;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2211, 'atic.bis.defendGroup.search', '', '', 1, '6500-100-30-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2211);
insert into T_operation_r_role (role_id, opt_id) values (2, 2211);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2211;
delete from T_operation_r_role where opt_id = 2212 and role_id = 1;
delete from T_operation_r_role where opt_id = 2212 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2212;
delete from T_operation_r_role where opt_id = 2212;
delete from T_operations where opt_id = 2212;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2212, 'atic.bis.defendGroup.create', '', '', 0, '6500-100-30-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 2212);
insert into T_operation_r_role (role_id, opt_id) values (2, 2212);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2212;
delete from T_operation_r_role where opt_id = 2213 and role_id = 1;
delete from T_operation_r_role where opt_id = 2213 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2213;
delete from T_operation_r_role where opt_id = 2213;
delete from T_operations where opt_id = 2213;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2213, 'atic.bis.defendGroup.delete', '', '', 0, '6500-100-30-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 2213);
insert into T_operation_r_role (role_id, opt_id) values (2, 2213);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2213;
delete from T_operation_r_role where opt_id = 2214 and role_id = 1;
delete from T_operation_r_role where opt_id = 2214 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2214;
delete from T_operation_r_role where opt_id = 2214;
delete from T_operations where opt_id = 2214;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2214, 'atic.bis.defendGroup.modify', '', '', 0, '6500-100-30-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 2214);
insert into T_operation_r_role (role_id, opt_id) values (2, 2214);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2214;
delete from T_operation_r_role where opt_id = 2220 and role_id = 1;
delete from T_operation_r_role where opt_id = 2220 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2220;
delete from T_operation_r_role where opt_id = 2220;
delete from T_operations where opt_id = 2220;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2220, 'atic.bis.trafficDivert', '/atic/business/trafficDivert.do', '', 0, '6500-100-40');
insert into T_operation_r_role (role_id, opt_id) values (1, 2220);
insert into T_operation_r_role (role_id, opt_id) values (2, 2220);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2220;
delete from T_operation_r_role where opt_id = 2221 and role_id = 1;
delete from T_operation_r_role where opt_id = 2221 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2221;
delete from T_operation_r_role where opt_id = 2221;
delete from T_operations where opt_id = 2221;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2221, 'atic.bis.trafficDivert.search', '', '', 1, '6500-100-40-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2221);
insert into T_operation_r_role (role_id, opt_id) values (2, 2221);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2221;
delete from T_operation_r_role where opt_id = 2222 and role_id = 1;
delete from T_operation_r_role where opt_id = 2222 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2222;
delete from T_operation_r_role where opt_id = 2222;
delete from T_operations where opt_id = 2222;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2222, 'atic.bis.trafficDivert.create', '', '', 0, '6500-100-40-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 2222);
insert into T_operation_r_role (role_id, opt_id) values (2, 2222);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2222;
delete from T_operation_r_role where opt_id = 2223 and role_id = 1;
delete from T_operation_r_role where opt_id = 2223 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2223;
delete from T_operation_r_role where opt_id = 2223;
delete from T_operations where opt_id = 2223;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2223, 'atic.bis.trafficDivert.delete', '', '', 0, '6500-100-40-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 2223);
insert into T_operation_r_role (role_id, opt_id) values (2, 2223);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2223;
delete from T_operation_r_role where opt_id = 2225 and role_id = 1;
delete from T_operation_r_role where opt_id = 2225 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2225;
delete from T_operation_r_role where opt_id = 2225;
delete from T_operations where opt_id = 2225;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2225, 'atic.bis.trafficDivert.enable', '', '', 0, '6500-100-40-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 2225);
insert into T_operation_r_role (role_id, opt_id) values (2, 2225);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2225;
delete from T_operation_r_role where opt_id = 2226 and role_id = 1;
delete from T_operation_r_role where opt_id = 2226 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2226;
delete from T_operation_r_role where opt_id = 2226;
delete from T_operations where opt_id = 2226;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2226, 'atic.bis.trafficDivert.disable', '', '', 0, '6500-100-40-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 2226);
insert into T_operation_r_role (role_id, opt_id) values (2, 2226);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2226;
delete from T_operation_r_role where opt_id = 2227 and role_id = 1;
delete from T_operation_r_role where opt_id = 2227 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2227;
delete from T_operation_r_role where opt_id = 2227;
delete from T_operations where opt_id = 2227;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2227, 'atic.bis.trafficDivert.export', '', '', 0, '6500-100-40-35');
insert into T_operation_r_role (role_id, opt_id) values (1, 2227);
insert into T_operation_r_role (role_id, opt_id) values (2, 2227);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2227;
delete from T_operation_r_role where opt_id = 2230 and role_id = 1;
delete from T_operation_r_role where opt_id = 2230 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2230;
delete from T_operation_r_role where opt_id = 2230;
delete from T_operations where opt_id = 2230;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2230, 'atic.bis.pcapCapture', '/atic/business/pcapCapture.do', '', 0, '6500-100-50');
insert into T_operation_r_role (role_id, opt_id) values (1, 2230);
insert into T_operation_r_role (role_id, opt_id) values (2, 2230);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2230;
delete from T_operation_r_role where opt_id = 2231 and role_id = 1;
delete from T_operation_r_role where opt_id = 2231 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2231;
delete from T_operation_r_role where opt_id = 2231;
delete from T_operations where opt_id = 2231;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2231, 'atic.bis.pcapCapture.task.search', '', '', 1, '6500-100-50-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2231);
insert into T_operation_r_role (role_id, opt_id) values (2, 2231);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2231;
delete from T_operation_r_role where opt_id = 2232 and role_id = 1;
delete from T_operation_r_role where opt_id = 2232 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2232;
delete from T_operation_r_role where opt_id = 2232;
delete from T_operations where opt_id = 2232;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2232, 'atic.bis.pcapCapture.task.create', '', '', 0, '6500-100-50-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 2232);
insert into T_operation_r_role (role_id, opt_id) values (2, 2232);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2232;
delete from T_operation_r_role where opt_id = 2233 and role_id = 1;
delete from T_operation_r_role where opt_id = 2233 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2233;
delete from T_operation_r_role where opt_id = 2233;
delete from T_operations where opt_id = 2233;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2233, 'atic.bis.pcapCapture.task.delete', '', '', 0, '6500-100-50-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 2233);
insert into T_operation_r_role (role_id, opt_id) values (2, 2233);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2233;
delete from T_operation_r_role where opt_id = 2234 and role_id = 1;
delete from T_operation_r_role where opt_id = 2234 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2234;
delete from T_operation_r_role where opt_id = 2234;
delete from T_operations where opt_id = 2234;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2234, 'atic.bis.pcapCapture.task.enable', '', '', 0, '6500-100-50-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 2234);
insert into T_operation_r_role (role_id, opt_id) values (2, 2234);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2234;
delete from T_operation_r_role where opt_id = 2235 and role_id = 1;
delete from T_operation_r_role where opt_id = 2235 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2235;
delete from T_operation_r_role where opt_id = 2235;
delete from T_operations where opt_id = 2235;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2235, 'atic.bis.pcapCapture.task.disable', '', '', 0, '6500-100-50-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 2235);
insert into T_operation_r_role (role_id, opt_id) values (2, 2235);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2235;
delete from T_operation_r_role where opt_id = 2236 and role_id = 1;
delete from T_operation_r_role where opt_id = 2236 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2236;
delete from T_operation_r_role where opt_id = 2236;
delete from T_operations where opt_id = 2236;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2236, 'atic.bis.pcapCapture.file.delete', '', '', 0, '6500-100-50-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 2236);
insert into T_operation_r_role (role_id, opt_id) values (2, 2236);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2236;
delete from T_operation_r_role where opt_id = 2237 and role_id = 1;
delete from T_operation_r_role where opt_id = 2237 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2237;
delete from T_operation_r_role where opt_id = 2237;
delete from T_operations where opt_id = 2237;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2237, 'atic.bis.packet.file.operation', '', '', 0, '6500-100-50-35');
insert into T_operation_r_role (role_id, opt_id) values (1, 2237);
insert into T_operation_r_role (role_id, opt_id) values (2, 2237);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2237;
delete from T_operation_r_role where opt_id = 2240 and role_id = 1;
delete from T_operation_r_role where opt_id = 2240 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2240;
delete from T_operation_r_role where opt_id = 2240;
delete from T_operations where opt_id = 2240;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2240, 'atic.analysis.flow', '/atic/analysis/showFluxAnalysisReport.do', '', 0, '7100-100-10');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2240);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2240);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2240;
delete from T_operation_r_role where opt_id = 2241 and role_id = 1;
delete from T_operation_r_role where opt_id = 2241 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2241;
delete from T_operation_r_role where opt_id = 2241;
delete from T_operations where opt_id = 2241;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2241, 'atic.analysis.flow.scan', '', '', 1, '7100-100-10-5');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2241);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2241);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2241;
delete from T_operation_r_role where opt_id = 2245 and role_id = 1;
delete from T_operation_r_role where opt_id = 2245 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2245;
delete from T_operation_r_role where opt_id = 2245;
delete from T_operations where opt_id = 2245;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2245, 'atic.analysis.http', 'atic/analysis/showHttpAnalysisReport.do?reportType=atic', '', 0, '7100-100-33');
insert into T_operation_r_role (role_id, opt_id) values (1, 2245);
insert into T_operation_r_role (role_id, opt_id) values (2, 2245);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2245;
delete from T_operation_r_role where opt_id = 2246 and role_id = 1;
delete from T_operation_r_role where opt_id = 2246 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2246;
delete from T_operation_r_role where opt_id = 2246;
delete from T_operations where opt_id = 2246;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2246, 'atic.analysis.http.scan', '', '', 1, '7100-100-33-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2246);
insert into T_operation_r_role (role_id, opt_id) values (2, 2246);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2246;
delete from T_operation_r_role where opt_id = 2250 and role_id = 1;
delete from T_operation_r_role where opt_id = 2250 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2250;
delete from T_operation_r_role where opt_id = 2250;
delete from T_operations where opt_id = 2250;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2250, 'atic.analysis.attack', '/atic/analysis/showAttackAnalysisReport.do', '', 0, '7100-100-20');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2250);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2250);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2250;
delete from T_operation_r_role where opt_id = 2251 and role_id = 1;
delete from T_operation_r_role where opt_id = 2251 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2251;
delete from T_operation_r_role where opt_id = 2251;
delete from T_operations where opt_id = 2251;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2251, 'atic.analysis.attack.scan', '', '', 1, '7100-100-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2251);
insert into T_operation_r_role (role_id, opt_id) values (2, 2251);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2251;
delete from T_operation_r_role where opt_id = 2260 and role_id = 1;
delete from T_operation_r_role where opt_id = 2260 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2260;
delete from T_operation_r_role where opt_id = 2260;
delete from T_operations where opt_id = 2260;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2260, 'atic.analysis.dns', '/atic/analysis/showDnsAnalysisReport.do', '', 0, '7100-100-30');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2260);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2260);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2260;
delete from T_operation_r_role where opt_id = 2261 and role_id = 1;
delete from T_operation_r_role where opt_id = 2261 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2261;
delete from T_operation_r_role where opt_id = 2261;
delete from T_operations where opt_id = 2261;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2261, 'atic.analysis.dns.scan', '', '', 1, '7100-100-30-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2261);
insert into T_operation_r_role (role_id, opt_id) values (2, 2261);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2261;
delete from T_operation_r_role where opt_id = 2270 and role_id = 1;
delete from T_operation_r_role where opt_id = 2270 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2270;
delete from T_operation_r_role where opt_id = 2270;
delete from T_operations where opt_id = 2270;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2270, 'atic.report.synthesisReport', '/atic/report/synthesisReport.do', '', 0, '7100-100-50');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2270);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2270);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2270;
delete from T_operation_r_role where opt_id = 2271 and role_id = 1;
delete from T_operation_r_role where opt_id = 2271 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2271;
delete from T_operation_r_role where opt_id = 2271;
delete from T_operations where opt_id = 2271;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2271, 'atic.report.synthesisReport.scan', '', '', 1, '7100-100-50-5');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2271);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2271);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2271;
delete from T_operation_r_role where opt_id = 2290 and role_id = 1;
delete from T_operation_r_role where opt_id = 2290 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2290;
delete from T_operation_r_role where opt_id = 2290;
delete from T_operations where opt_id = 2290;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2290, 'atic.report.ddos.reportTask', '/atic/report/listReportTask.do', '', 0, '7100-100-70');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2290);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2290);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2290;
delete from T_operation_r_role where opt_id = 2291 and role_id = 1;
delete from T_operation_r_role where opt_id = 2291 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2291;
delete from T_operation_r_role where opt_id = 2291;
delete from T_operations where opt_id = 2291;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2291, 'atic.report.ddos.reportTask.scan', '', '', 1, '7100-100-70-5');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2291);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2291);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2291;
delete from T_operation_r_role where opt_id = 2292 and role_id = 1;
delete from T_operation_r_role where opt_id = 2292 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2292;
delete from T_operation_r_role where opt_id = 2292;
delete from T_operations where opt_id = 2292;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2292, 'atic.report.ddos.reportTask.create', '', '', 0, '7100-100-70-10');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2292);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2292);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2292;
delete from T_operation_r_role where opt_id = 2293 and role_id = 1;
delete from T_operation_r_role where opt_id = 2293 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2293;
delete from T_operation_r_role where opt_id = 2293;
delete from T_operations where opt_id = 2293;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2293, 'atic.report.ddos.reportTask.delete', '', '', 0, '7100-100-70-15');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2293);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2293);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2293;
delete from T_operation_r_role where opt_id = 2294 and role_id = 1;
delete from T_operation_r_role where opt_id = 2294 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2294;
delete from T_operation_r_role where opt_id = 2294;
delete from T_operations where opt_id = 2294;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2294, 'atic.report.ddos.reportTask.enable', '', '', 0, '7100-100-70-25');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2294);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2294);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2294;
delete from T_operation_r_role where opt_id = 2295 and role_id = 1;
delete from T_operation_r_role where opt_id = 2295 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2295;
delete from T_operation_r_role where opt_id = 2295;
delete from T_operations where opt_id = 2295;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2295, 'atic.report.ddos.reportTask.disable', '', '', 0, '7100-100-70-30');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2295);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2295);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2295;
delete from T_operation_r_role where opt_id = 2296 and role_id = 1;
delete from T_operation_r_role where opt_id = 2296 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2296;
delete from T_operation_r_role where opt_id = 2296;
delete from T_operations where opt_id = 2296;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2296, 'atic.report.ddos.reportTask.modify', '', '', 0, '7100-100-70-20');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2296);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2296);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2296;
delete from T_operation_r_role where opt_id = 2300 and role_id = 1;
delete from T_operation_r_role where opt_id = 2300 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2300;
delete from T_operation_r_role where opt_id = 2300;
delete from T_operations where opt_id = 2300;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2300, 'atic.report.ddos.downloadReport', '/atic/report/reportDownload.do', '', 0, '7100-100-80');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2300);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2300);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2300;
delete from T_operation_r_role where opt_id = 2301 and role_id = 1;
delete from T_operation_r_role where opt_id = 2301 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2301;
delete from T_operation_r_role where opt_id = 2301;
delete from T_operations where opt_id = 2301;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2301, 'atic.report.ddos.downloadReport.scan', '', '', 1, '7100-100-80-5');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2301);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2301);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2301;
delete from T_operation_r_role where opt_id = 2302 and role_id = 1;
delete from T_operation_r_role where opt_id = 2302 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2302;
delete from T_operation_r_role where opt_id = 2302;
delete from T_operations where opt_id = 2302;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2302, 'atic.report.ddos.downloadReport.delete', '', '', 0, '7100-100-80-10');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2302);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2302);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2302;
delete from T_operation_r_role where opt_id = 2304 and role_id = 1;
delete from T_operation_r_role where opt_id = 2304 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2304;
delete from T_operation_r_role where opt_id = 2304;
delete from T_operations where opt_id = 2304;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2304, 'atic.report.ddos.downloadReport.download', '', '', 0, '7100-100-80-15');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2304);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2304);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2304;
delete from T_operation_r_role where opt_id = 2320 and role_id = 1;
delete from T_operation_r_role where opt_id = 2320 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2320;
delete from T_operation_r_role where opt_id = 2320;
delete from T_operations where opt_id = 2320;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2320, 'atic.bis.globalPolicy', '/neglobalconf/business/abnormalConfig.do', '', 0, '6500-100-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 2320);
insert into T_operation_r_role (role_id, opt_id) values (2, 2320);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2320;
delete from T_operation_r_role where opt_id = 2321 and role_id = 1;
delete from T_operation_r_role where opt_id = 2321 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2321;
delete from T_operation_r_role where opt_id = 2321;
delete from T_operations where opt_id = 2321;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2321, 'atic.bis.globalPolicy.scan', '', '', 1, '6500-100-25-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2321);
insert into T_operation_r_role (role_id, opt_id) values (2, 2321);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2321;
delete from T_operation_r_role where opt_id = 2322 and role_id = 1;
delete from T_operation_r_role where opt_id = 2322 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2322;
delete from T_operation_r_role where opt_id = 2322;
delete from T_operations where opt_id = 2322;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2322, 'atic.bis.globalPolicy.config', '', '', 0, '6500-100-25-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 2322);
insert into T_operation_r_role (role_id, opt_id) values (2, 2322);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2322;
delete from T_operation_r_role where opt_id = 2324 and role_id = 1;
delete from T_operation_r_role where opt_id = 2324 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2324;
delete from T_operation_r_role where opt_id = 2324;
delete from T_operations where opt_id = 2324;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2324, 'atic.bis.globalPolicy.save', '', '', 0, '6500-100-25-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 2324);
insert into T_operation_r_role (role_id, opt_id) values (2, 2324);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2324;
delete from T_operation_r_role where opt_id = 2330 and role_id = 1;
delete from T_operation_r_role where opt_id = 2330 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2330;
delete from T_operation_r_role where opt_id = 2330;
delete from T_operations where opt_id = 2330;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2330, 'atic.bis.policyTemplate', '/vsm/policy/ddos/viewAllZoneTemplate.do', '', 0, '6500-100-60');
insert into T_operation_r_role (role_id, opt_id) values (1, 2330);
insert into T_operation_r_role (role_id, opt_id) values (2, 2330);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2330;
delete from T_operation_r_role where opt_id = 2331 and role_id = 1;
delete from T_operation_r_role where opt_id = 2331 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2331;
delete from T_operation_r_role where opt_id = 2331;
delete from T_operations where opt_id = 2331;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2331, 'atic.bis.policyTemplate.scan', '', '', 1, '6500-100-60-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2331);
insert into T_operation_r_role (role_id, opt_id) values (2, 2331);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2331;
delete from T_operation_r_role where opt_id = 2332 and role_id = 1;
delete from T_operation_r_role where opt_id = 2332 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2332;
delete from T_operation_r_role where opt_id = 2332;
delete from T_operations where opt_id = 2332;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2332, 'atic.bis.policyTemplate.create', '', '', 0, '6500-100-60-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 2332);
insert into T_operation_r_role (role_id, opt_id) values (2, 2332);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2332;
delete from T_operation_r_role where opt_id = 2333 and role_id = 1;
delete from T_operation_r_role where opt_id = 2333 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2333;
delete from T_operation_r_role where opt_id = 2333;
delete from T_operations where opt_id = 2333;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2333, 'atic.bis.policyTemplate.delete', '', '', 0, '6500-100-60-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 2333);
insert into T_operation_r_role (role_id, opt_id) values (2, 2333);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2333;
delete from T_operation_r_role where opt_id = 2334 and role_id = 1;
delete from T_operation_r_role where opt_id = 2334 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2334;
delete from T_operation_r_role where opt_id = 2334;
delete from T_operations where opt_id = 2334;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2334, 'atic.bis.policyTemplate.modify', '', '', 0, '6500-100-60-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 2334);
insert into T_operation_r_role (role_id, opt_id) values (2, 2334);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2334;
delete from T_operation_r_role where opt_id = 2340 and role_id = 1;
delete from T_operation_r_role where opt_id = 2340 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2340;
delete from T_operation_r_role where opt_id = 2340;
delete from T_operations where opt_id = 2340;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2340, 'atic.sys.antiDdos.data', '/atic/system/antiDdosData.do', '', 0, '8000-500-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 2340);
insert into T_operation_r_role (role_id, opt_id) values (2, 2340);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2340;
delete from T_operation_r_role where opt_id = 2341 and role_id = 1;
delete from T_operation_r_role where opt_id = 2341 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2341;
delete from T_operation_r_role where opt_id = 2341;
delete from T_operations where opt_id = 2341;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2341, 'atic.sys.antiDdos.data.scan', '', '', 1, '8000-500-30-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2341);
insert into T_operation_r_role (role_id, opt_id) values (2, 2341);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2341;
delete from T_operation_r_role where opt_id = 2342 and role_id = 1;
delete from T_operation_r_role where opt_id = 2342 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2342;
delete from T_operation_r_role where opt_id = 2342;
delete from T_operations where opt_id = 2342;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2342, 'atic.sys.antiDdos.data.modify', '', '', 0, '8000-500-30-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 2342);
insert into T_operation_r_role (role_id, opt_id) values (2, 2342);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2342;
/*2350 to 2354 for HA*/
delete from T_operation_r_role where opt_id = 2360 and role_id = 1;
delete from T_operation_r_role where opt_id = 2360 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2360;
delete from T_operation_r_role where opt_id = 2360;
delete from T_operations where opt_id = 2360;
INSERT INTO T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2360, 'atic.analysis.bot', '/atic/analysis/showBotAnalysisReport.do', '', 0, '7100-100-40');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2360);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2360);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2360;
delete from T_operation_r_role where opt_id = 2361 and role_id = 1;
delete from T_operation_r_role where opt_id = 2361 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2361;
delete from T_operation_r_role where opt_id = 2361;
delete from T_operations where opt_id = 2361;
INSERT INTO T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2361, 'atic.analysis.bot.scan', '', '', 1, '7100-100-40-5');
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (1, 2361);
INSERT INTO T_operation_r_role (role_id, opt_id) VALUES (2, 2361);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2361;
delete from T_operation_r_role where opt_id = 2370 and role_id = 1;
delete from T_operation_r_role where opt_id = 2370 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2370;
delete from T_operation_r_role where opt_id = 2370;
delete from T_operations where opt_id = 2370;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2370, 'atic.bis.filter', '/vsm/policy/ddos/viewAllFilterTemplate.do', '', 0, '6500-100-70');
insert into T_operation_r_role (role_id, opt_id) values (1, 2370);
insert into T_operation_r_role (role_id, opt_id) values (2, 2370);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2370;
delete from T_operation_r_role where opt_id = 2371 and role_id = 1;
delete from T_operation_r_role where opt_id = 2371 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2371;
delete from T_operation_r_role where opt_id = 2371;
delete from T_operations where opt_id = 2371;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2371, 'atic.bis.filter.scan', '', '', 1, '6500-100-70-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2371);
insert into T_operation_r_role (role_id, opt_id) values (2, 2371);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2371;
delete from T_operation_r_role where opt_id = 2372 and role_id = 1;
delete from T_operation_r_role where opt_id = 2372 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2372;
delete from T_operation_r_role where opt_id = 2372;
delete from T_operations where opt_id = 2372;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2372, 'atic.bis.filter.create', '', '', 0, '6500-100-70-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 2372);
insert into T_operation_r_role (role_id, opt_id) values (2, 2372);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2372;
delete from T_operation_r_role where opt_id = 2373 and role_id = 1;
delete from T_operation_r_role where opt_id = 2373 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2373;
delete from T_operation_r_role where opt_id = 2373;
delete from T_operations where opt_id = 2373;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2373, 'atic.bis.filter.delete', '', '', 0, '6500-100-70-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 2373);
insert into T_operation_r_role (role_id, opt_id) values (2, 2373);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2373;
delete from T_operation_r_role where opt_id = 2374 and role_id = 1;
delete from T_operation_r_role where opt_id = 2374 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2374;
delete from T_operation_r_role where opt_id = 2374;
delete from T_operations where opt_id = 2374;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2374, 'atic.bis.filter.modify', '', '', 0, '6500-100-70-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 2374);
insert into T_operation_r_role (role_id, opt_id) values (2, 2374);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2374;
delete from T_operation_r_role where opt_id = 2380 and role_id = 1;
delete from T_operation_r_role where opt_id = 2380 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2380;
delete from T_operation_r_role where opt_id = 2380;
delete from T_operations where opt_id = 2380;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2380, 'atic.sys.config.backup.recovery', '/atic/system/configBackupList.do', '', 0, '8000-1100-10');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2380);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2380);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2380;
delete from T_operation_r_role where opt_id = 2381 and role_id = 1;
delete from T_operation_r_role where opt_id = 2381 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2381;
delete from T_operation_r_role where opt_id = 2381;
delete from T_operations where opt_id = 2381;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2381, 'atic.sys.config.backup.recovery.scan', '', '', 1, '8000-1100-10-5');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2381);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2381);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2381;
delete from T_operation_r_role where opt_id = 2382 and role_id = 1;
delete from T_operation_r_role where opt_id = 2382 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2382;
delete from T_operation_r_role where opt_id = 2382;
delete from T_operations where opt_id = 2382;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2382, 'atic.system.config.backup', '', '', 0, '8000-1100-10-10');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2382);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2382);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2382;
delete from T_operation_r_role where opt_id = 2383 and role_id = 1;
delete from T_operation_r_role where opt_id = 2383 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2383;
delete from T_operation_r_role where opt_id = 2383;
delete from T_operations where opt_id = 2383;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2383, 'atic.system.config.recovery', '', '', 0, '8000-1100-10-15');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2383);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2383);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2383;
delete from T_operation_r_role where opt_id = 2384 and role_id = 1;
delete from T_operation_r_role where opt_id = 2384 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2384;
delete from T_operation_r_role where opt_id = 2384;
delete from T_operations where opt_id = 2384;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2384, 'atic.system.config.import', '', '', 0, '8000-1100-10-20');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2384);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2384);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2384;
delete from T_operation_r_role where opt_id = 2385 and role_id = 1;
delete from T_operation_r_role where opt_id = 2385 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2385;
delete from T_operation_r_role where opt_id = 2385;
delete from T_operations where opt_id = 2385;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2385, 'atic.system.config.export', '', '', 0, '8000-1100-10-25');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2385);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2385);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2385;
delete from T_operation_r_role where opt_id = 2386 and role_id = 1;
delete from T_operation_r_role where opt_id = 2386 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2386;
delete from T_operation_r_role where opt_id = 2386;
delete from T_operations where opt_id = 2386;
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2386, 'atic.system.config.delete', '', '', 0, '8000-1100-10-30');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2386);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2386);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2386;
delete from T_operation_r_role where opt_id = 2390 and role_id = 1;
delete from T_operation_r_role where opt_id = 2390 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2390;
delete from T_operation_r_role where opt_id = 2390;
delete from T_operations where opt_id = 2390;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2390, 'atic.report.reportConfig', '/atic/report/showReportConfig.do', '', 0, '7100-100-45');
insert into T_operation_r_role (role_id, opt_id) values (1, 2390);
insert into T_operation_r_role (role_id, opt_id) values (2, 2390);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2390;
delete from T_operation_r_role where opt_id = 2391 and role_id = 1;
delete from T_operation_r_role where opt_id = 2391 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2391;
delete from T_operation_r_role where opt_id = 2391;
delete from T_operations where opt_id = 2391;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2391, 'atic.report.reportConfig.scan', '', '', 1, '7100-100-45-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2391);
insert into T_operation_r_role (role_id, opt_id) values (2, 2391);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2391;
delete from T_operation_r_role where opt_id = 2392 and role_id = 1;
delete from T_operation_r_role where opt_id = 2392 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2392;
delete from T_operation_r_role where opt_id = 2392;
delete from T_operations where opt_id = 2392;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2392, 'atic.report.reportConfig.modify', '', '', 0, '7100-100-45-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 2392);
insert into T_operation_r_role (role_id, opt_id) values (2, 2392);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2392;
delete from T_operation_r_role where opt_id = 2400 and role_id = 1;
delete from T_operation_r_role where opt_id = 2400 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2400;
delete from T_operation_r_role where opt_id = 2400;
delete from T_operations where opt_id = 2400;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2400, 'atic.bis.zone.ip.domain', '/vsm/policy/ddos/listIpDomain.do', '', 0, '6500-100-80');
insert into T_operation_r_role (role_id, opt_id) values (1, 2400);
insert into T_operation_r_role (role_id, opt_id) values (2, 2400);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2400;
delete from T_operation_r_role where opt_id = 2401 and role_id = 1;
delete from T_operation_r_role where opt_id = 2401 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2401;
delete from T_operation_r_role where opt_id = 2401;
delete from T_operations where opt_id = 2401;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2401, 'atic.destip.domain.scan', '', '', 1, '6500-100-80-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2401);
insert into T_operation_r_role (role_id, opt_id) values (2, 2401);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2401;
delete from T_operation_r_role where opt_id = 2402 and role_id = 1;
delete from T_operation_r_role where opt_id = 2402 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2402;
delete from T_operation_r_role where opt_id = 2402;
delete from T_operations where opt_id = 2402;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2402, 'atic.destip.domain.create', '', '', 0, '6500-100-80-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 2402);
insert into T_operation_r_role (role_id, opt_id) values (2, 2402);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2402;
delete from T_operation_r_role where opt_id = 2403 and role_id = 1;
delete from T_operation_r_role where opt_id = 2403 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2403;
delete from T_operation_r_role where opt_id = 2403;
delete from T_operations where opt_id = 2403;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2403, 'atic.destip.domain.delete', '', '', 0, '6500-100-80-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 2403);
insert into T_operation_r_role (role_id, opt_id) values (2, 2403);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2403;
delete from T_operation_r_role where opt_id = 2404 and role_id = 1;
delete from T_operation_r_role where opt_id = 2404 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2404;
delete from T_operation_r_role where opt_id = 2404;
delete from T_operations where opt_id = 2404;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2404, 'atic.destip.domain.modify', '', '', 0, '6500-100-80-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 2404);
insert into T_operation_r_role (role_id, opt_id) values (2, 2404);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2404;
delete from T_operation_r_role where opt_id = 2405 and role_id = 1;
delete from T_operation_r_role where opt_id = 2405 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2405;
delete from T_operation_r_role where opt_id = 2405;
delete from T_operations where opt_id = 2405;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2405, 'atic.destip.domain.import', '', '', 0, '6500-100-80-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 2405);
insert into T_operation_r_role (role_id, opt_id) values (2, 2405);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2405;
delete from T_operation_r_role where opt_id = 2406 and role_id = 1;
delete from T_operation_r_role where opt_id = 2406 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2406;
delete from T_operation_r_role where opt_id = 2406;
delete from T_operations where opt_id = 2406;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2406, 'atic.destip.domain.export', '', '', 0, '6500-100-80-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 2406);
insert into T_operation_r_role (role_id, opt_id) values (2, 2406);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2406;
delete from T_operation_r_role where opt_id = 2407 and role_id = 1;
delete from T_operation_r_role where opt_id = 2407 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2407;
delete from T_operation_r_role where opt_id = 2407;
delete from T_operations where opt_id = 2407;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2407, 'atic.destip.domain.exportAll', '', '', 0, '6500-100-80-35');
insert into T_operation_r_role (role_id, opt_id) values (1, 2407);
insert into T_operation_r_role (role_id, opt_id) values (2, 2407);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2407;
delete from T_operation_r_role where opt_id = 2410 and role_id = 1;
delete from T_operation_r_role where opt_id = 2410 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2410;
delete from T_operation_r_role where opt_id = 2410;
delete from T_operations where opt_id = 2410;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2410, 'atic.bis.blackholeDivert', '/atic/business/blackholeDivertList.do', '', 0, '6500-100-45');
insert into T_operation_r_role (role_id, opt_id) values (1, 2410);
insert into T_operation_r_role (role_id, opt_id) values (2, 2410);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2410;
delete from T_operation_r_role where opt_id = 2411 and role_id = 1;
delete from T_operation_r_role where opt_id = 2411 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2411;
delete from T_operation_r_role where opt_id = 2411;
delete from T_operations where opt_id = 2411;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2411, 'atic.bis.blackholeDivert.search', '', '', 1, '6500-100-45-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2411);
insert into T_operation_r_role (role_id, opt_id) values (2, 2411);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2411;
delete from T_operation_r_role where opt_id = 2412 and role_id = 1;
delete from T_operation_r_role where opt_id = 2412 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2412;
delete from T_operation_r_role where opt_id = 2412;
delete from T_operations where opt_id = 2412;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2412, 'atic.bis.blackhole.divert.create', '', '', 0, '6500-100-45-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 2412);
insert into T_operation_r_role (role_id, opt_id) values (2, 2412);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2412;
delete from T_operation_r_role where opt_id = 2413 and role_id = 1;
delete from T_operation_r_role where opt_id = 2413 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2413;
delete from T_operation_r_role where opt_id = 2413;
delete from T_operations where opt_id = 2413;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2413, 'atic.bis.blackhole.divert.delete', '', '', 0, '6500-100-45-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 2413);
insert into T_operation_r_role (role_id, opt_id) values (2, 2413);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2413;
delete from T_operation_r_role where opt_id = 2414 and role_id = 1;
delete from T_operation_r_role where opt_id = 2414 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2414;
delete from T_operation_r_role where opt_id = 2414;
delete from T_operations where opt_id = 2414;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2414, 'atic.bis.blackhole.divert.enable', '', '', 0, '6500-100-45-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 2414);
insert into T_operation_r_role (role_id, opt_id) values (2, 2414);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2414;
delete from T_operation_r_role where opt_id = 2415 and role_id = 1;
delete from T_operation_r_role where opt_id = 2415 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2415;
delete from T_operation_r_role where opt_id = 2415;
delete from T_operations where opt_id = 2415;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2415, 'atic.bis.blackhole.divert.disable', '', '', 0, '6500-100-45-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 2415);
insert into T_operation_r_role (role_id, opt_id) values (2, 2415);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2415;
delete from T_operation_r_role where opt_id = 2416 and role_id = 1;
delete from T_operation_r_role where opt_id = 2416 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2416;
delete from T_operation_r_role where opt_id = 2416;
delete from T_operations where opt_id = 2416;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2416, 'atic.bis.blackhole.divert.config', '', '', 0, '6500-100-45-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 2416);
insert into T_operation_r_role (role_id, opt_id) values (2, 2416);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2416;
delete from T_operation_r_role where opt_id = 2421 and role_id = 1;
delete from T_operation_r_role where opt_id = 2421 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2421;
delete from T_operation_r_role where opt_id = 2421;
delete from T_operations where opt_id = 2421;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2421, 'atic.bis.policy.addZone', '', '', 0, '6500-100-20-6');
insert into T_operation_r_role (role_id, opt_id) values (1, 2421);
insert into T_operation_r_role (role_id, opt_id) values (2, 2421);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2421;
delete from T_operation_r_role where opt_id = 2422 and role_id = 1;
delete from T_operation_r_role where opt_id = 2422 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2422;
delete from T_operation_r_role where opt_id = 2422;
delete from T_operations where opt_id = 2422;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2422, 'atic.bis.policy.deleteZone', '', '', 0, '6500-100-20-7');
insert into T_operation_r_role (role_id, opt_id) values (1, 2422);
insert into T_operation_r_role (role_id, opt_id) values (2, 2422);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2422;
delete from T_operation_r_role where opt_id = 2423 and role_id = 1;
delete from T_operation_r_role where opt_id = 2423 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2423;
delete from T_operation_r_role where opt_id = 2423;
delete from T_operations where opt_id = 2423;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2423, 'atic.bis.policy.modifyZone', '', '', 0, '6500-100-20-8');
insert into T_operation_r_role (role_id, opt_id) values (1, 2423);
insert into T_operation_r_role (role_id, opt_id) values (2, 2423);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2423;
delete from T_operation_r_role where opt_id = 2424 and role_id = 1;
delete from T_operation_r_role where opt_id = 2424 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2424;
delete from T_operation_r_role where opt_id = 2424;
delete from T_operations where opt_id = 2424;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2424, 'atic.bis.policy.importZone', '', '', 0, '6500-100-20-16');
insert into T_operation_r_role (role_id, opt_id) values (1, 2424);
insert into T_operation_r_role (role_id, opt_id) values (2, 2424);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2424;
delete from T_operation_r_role where opt_id = 2425 and role_id = 1;
delete from T_operation_r_role where opt_id = 2425 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2425;
delete from T_operation_r_role where opt_id = 2425;
delete from T_operations where opt_id = 2425;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2425, 'atic.bis.policy.exportZone', '', '', 0, '6500-100-20-17');
insert into T_operation_r_role (role_id, opt_id) values (1, 2425);
insert into T_operation_r_role (role_id, opt_id) values (2, 2425);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2425;
delete from T_operation_r_role where opt_id = 2430 and role_id = 1;
delete from T_operation_r_role where opt_id = 2430 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2430;
delete from T_operation_r_role where opt_id = 2430;
delete from T_operations where opt_id = 2430;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2430, 'atic.bis.libraryFile', '/atic/business/listLibraryFile.do', '', 0, '6500-100-85');
insert into T_operation_r_role (role_id, opt_id) values (1, 2430);
insert into T_operation_r_role (role_id, opt_id) values (2, 2430);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2430;
delete from T_operation_r_role where opt_id = 2431 and role_id = 1;
delete from T_operation_r_role where opt_id = 2431 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2431;
delete from T_operation_r_role where opt_id = 2431;
delete from T_operations where opt_id = 2431;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2431, 'atic.bis.libraryFile.scan', '', '', 1, '6500-100-85-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 2431);
insert into T_operation_r_role (role_id, opt_id) values (2, 2431);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2431;
delete from T_operation_r_role where opt_id = 2432 and role_id = 1;
delete from T_operation_r_role where opt_id = 2432 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2432;
delete from T_operation_r_role where opt_id = 2432;
delete from T_operations where opt_id = 2432;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2432, 'atic.bis.libraryFile.deploy', '', '', 0, '6500-100-85-2');
insert into T_operation_r_role (role_id, opt_id) values (1, 2432);
insert into T_operation_r_role (role_id, opt_id) values (2, 2432);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2432;
delete from T_operation_r_role where opt_id = 2433 and role_id = 1;
delete from T_operation_r_role where opt_id = 2433 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2433;
delete from T_operation_r_role where opt_id = 2433;
delete from T_operations where opt_id = 2433;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2433, 'atic.bis.libraryFile.import', '', '', 0, '6500-100-85-3');
insert into T_operation_r_role (role_id, opt_id) values (1, 2433);
insert into T_operation_r_role (role_id, opt_id) values (2, 2433);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2433;
delete from T_operation_r_role where opt_id = 2434 and role_id = 1;
delete from T_operation_r_role where opt_id = 2434 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2434;
delete from T_operation_r_role where opt_id = 2434;
delete from T_operations where opt_id = 2434;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2434, 'atic.bis.libraryFile.export', '', '', 0, '6500-100-85-4');
insert into T_operation_r_role (role_id, opt_id) values (1, 2434);
insert into T_operation_r_role (role_id, opt_id) values (2, 2434);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2434;
delete from T_operation_r_role where opt_id = 2435 and role_id = 1;
delete from T_operation_r_role where opt_id = 2435 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2435;
delete from T_operation_r_role where opt_id = 2435;
delete from T_operations where opt_id = 2435;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2435, 'atic.bis.libraryFile.delete', '', '', 0, '6500-100-85-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2435);
insert into T_operation_r_role (role_id, opt_id) values (2, 2435);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2435;
delete from T_operation_r_role where opt_id = 2436 and role_id = 1;
delete from T_operation_r_role where opt_id = 2436 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2436;
delete from T_operation_r_role where opt_id = 2436;
delete from T_operations where opt_id = 2436;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2436, 'atic.bis.libraryFile.sync', '', '', 0, '6500-100-85-6');
insert into T_operation_r_role (role_id, opt_id) values (1, 2436);
insert into T_operation_r_role (role_id, opt_id) values (2, 2436);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2436;
delete from T_operation_r_role where opt_id = 2440 and role_id = 1;
delete from T_operation_r_role where opt_id = 2440 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2440;
delete from T_operation_r_role where opt_id = 2440;
delete from T_operations where opt_id = 2440;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2440, 'atic.bis.locationCustom', '/atic/business/listLocationCustom.do', '', 0, '6500-100-90');
insert into T_operation_r_role (role_id, opt_id) values (1, 2440);
insert into T_operation_r_role (role_id, opt_id) values (2, 2440);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2440;
delete from T_operation_r_role where opt_id = 2441 and role_id = 1;
delete from T_operation_r_role where opt_id = 2441 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2441;
delete from T_operation_r_role where opt_id = 2441;
delete from T_operations where opt_id = 2441;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2441, 'atic.bis.locationCustom.scan', '', '', 1, '6500-100-90-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 2441);
insert into T_operation_r_role (role_id, opt_id) values (2, 2441);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2441;
delete from T_operation_r_role where opt_id = 2442 and role_id = 1;
delete from T_operation_r_role where opt_id = 2442 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2442;
delete from T_operation_r_role where opt_id = 2442;
delete from T_operations where opt_id = 2442;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2442, 'atic.bis.locationCustom.create', '', '', 0, '6500-100-90-2');
insert into T_operation_r_role (role_id, opt_id) values (1, 2442);
insert into T_operation_r_role (role_id, opt_id) values (2, 2442);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2442;
delete from T_operation_r_role where opt_id = 2443 and role_id = 1;
delete from T_operation_r_role where opt_id = 2443 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2443;
delete from T_operation_r_role where opt_id = 2443;
delete from T_operations where opt_id = 2443;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2443, 'atic.bis.locationCustom.delete', '', '', 0, '6500-100-90-3');
insert into T_operation_r_role (role_id, opt_id) values (1, 2443);
insert into T_operation_r_role (role_id, opt_id) values (2, 2443);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2443;
delete from T_operation_r_role where opt_id = 2444 and role_id = 1;
delete from T_operation_r_role where opt_id = 2444 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2444;
delete from T_operation_r_role where opt_id = 2444;
delete from T_operations where opt_id = 2444;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2444, 'atic.bis.locationCustom.modify', '', '', 0, '6500-100-90-4');
insert into T_operation_r_role (role_id, opt_id) values (1, 2444);
insert into T_operation_r_role (role_id, opt_id) values (2, 2444);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2444;
delete from T_operation_r_role where opt_id = 2445 and role_id = 1;
delete from T_operation_r_role where opt_id = 2445 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2445;
delete from T_operation_r_role where opt_id = 2445;
delete from T_operations where opt_id = 2445;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2445, 'atic.bis.locationCustom.deploy', '', '', 0, '6500-100-90-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2445);
insert into T_operation_r_role (role_id, opt_id) values (2, 2445);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2445;
delete from T_operation_r_role where opt_id = 2446 and role_id = 1;
delete from T_operation_r_role where opt_id = 2446 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2446;
delete from T_operation_r_role where opt_id = 2446;
delete from T_operations where opt_id = 2446;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2446, 'atic.bis.locationCustom.undeploy', '', '', 0, '6500-100-90-6');
insert into T_operation_r_role (role_id, opt_id) values (1, 2446);
insert into T_operation_r_role (role_id, opt_id) values (2, 2446);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2446;
delete from T_operation_r_role where opt_id = 2500 and role_id = 1;
delete from T_operation_r_role where opt_id = 2500 and role_id = 2;
delete from T_operation_r_role where opt_id = 2500 and role_id = 3;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2500;
delete from T_operation_r_role where opt_id = 2500;
delete from T_operations where opt_id = 2500;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2500, 'atic.sys.log.devsyslog', '/atic/system/viewDevSyslog.do', '', 0, '8000-600-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 2500);
insert into T_operation_r_role (role_id, opt_id) values (2, 2500);
insert into T_operation_r_role (role_id, opt_id) values (3, 2500);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2500;
delete from T_operation_r_role where opt_id = 2501 and role_id = 1;
delete from T_operation_r_role where opt_id = 2501 and role_id = 2;
delete from T_operation_r_role where opt_id = 2501 and role_id = 3;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2501;
delete from T_operation_r_role where opt_id = 2501;
delete from T_operations where opt_id = 2501;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2501, 'atic.sys.log.devsyslog.scan', '', '', 1, '8000-600-20-1');
insert into T_operation_r_role (role_id, opt_id) values (1, 2501);
insert into T_operation_r_role (role_id, opt_id) values (2, 2501);
insert into T_operation_r_role (role_id, opt_id) values (3, 2501);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2501;
delete from T_operation_r_role where opt_id = 2502 and role_id = 1;
delete from T_operation_r_role where opt_id = 2502 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 2502;
delete from T_operation_r_role where opt_id = 2502;
delete from T_operations where opt_id = 2502;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2502, 'atic.sys.log.devsyslog.exportExcel', '', '', 1, '8000-600-20-2');
insert into T_operation_r_role (role_id, opt_id) values (1, 2502);
insert into T_operation_r_role (role_id, opt_id) values (2, 2502);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 2502;

delete from T_operation_r_role where opt_id = 4000 and role_id = 1;
delete from T_operation_r_role where opt_id = 4000 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 4000;
delete from T_operation_r_role where opt_id = 4000;
delete from T_operations where opt_id = 4000;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(4000, 'elog.common.collector.manage.scan', '', '', 1, '2000-300-20-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 4000);
insert into T_operation_r_role (role_id, opt_id) values (2, 4000);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 4000;
delete from T_operation_r_role where opt_id = 4001 and role_id = 1;
delete from T_operation_r_role where opt_id = 4001 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 4001;
delete from T_operation_r_role where opt_id = 4001;
delete from T_operations where opt_id = 4001;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(4001, 'elog.common.collector.manage.create', '', '', 0, '2000-300-20-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 4001);
insert into T_operation_r_role (role_id, opt_id) values (2, 4001);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 4001;
delete from T_operation_r_role where opt_id = 4002 and role_id = 1;
delete from T_operation_r_role where opt_id = 4002 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 4002;
delete from T_operation_r_role where opt_id = 4002;
delete from T_operations where opt_id = 4002;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(4002, 'elog.common.collector.manage.delete', '', '', 0, '2000-300-20-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 4002);
insert into T_operation_r_role (role_id, opt_id) values (2, 4002);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 4002;
delete from T_operation_r_role where opt_id = 4003 and role_id = 1;
delete from T_operation_r_role where opt_id = 4003 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 4003;
delete from T_operation_r_role where opt_id = 4003;
delete from T_operations where opt_id = 4003;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(4003, 'elog.common.collector.manage.correlatedNE', '', '', 0, '2000-300-20-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 4003);
insert into T_operation_r_role (role_id, opt_id) values (2, 4003);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 4003;
delete from T_operation_r_role where opt_id = 4004 and role_id = 1;
delete from T_operation_r_role where opt_id = 4004 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 4004;
delete from T_operation_r_role where opt_id = 4004;
delete from T_operations where opt_id = 4004;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(4004, 'elog.common.collector.manage.edit', '', '', 0, '2000-300-20-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 4004);
insert into T_operation_r_role (role_id, opt_id) values (2, 4004);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 4004;
delete from T_operation_r_role where opt_id = 4080 and role_id = 1;
delete from T_operation_r_role where opt_id = 4080 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 4080;
delete from T_operation_r_role where opt_id = 4080;
delete from T_operations where opt_id = 4080;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(4080, 'elog.menu.common.collector.manage', '/common/collectorAction!queryLogCollector.do', '', 0, '2000-300-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 4080);
insert into T_operation_r_role (role_id, opt_id) values (2, 4080);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 4080;
delete from T_operation_r_role where opt_id = 4081 and role_id = 1;
delete from T_operation_r_role where opt_id = 4081 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 4081;
delete from T_operation_r_role where opt_id = 4081;
delete from T_operations where opt_id = 4081;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(4081, 'lego.busi', '/pages/firstpage.jsp', '', 0, '6500');
insert into T_operation_r_role (role_id, opt_id) values (1, 4081);
insert into T_operation_r_role (role_id, opt_id) values (2, 4081);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 4081;
delete from T_operation_r_role where opt_id = 4082 and role_id = 1;
delete from T_operation_r_role where opt_id = 4082 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 4082;
delete from T_operation_r_role where opt_id = 4082;
delete from T_operations where opt_id = 4082;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(4082, 'atic.bis.ddos', '', '', 0, '6500-100');
insert into T_operation_r_role (role_id, opt_id) values (1, 4082);
insert into T_operation_r_role (role_id, opt_id) values (2, 4082);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 4082;
delete from T_operation_r_role where opt_id = 4083 and role_id = 1;
delete from T_operation_r_role where opt_id = 4083 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 4083;
delete from T_operation_r_role where opt_id = 4083;
delete from T_operations where opt_id = 4083;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(4083, 'lego.report', '', '', 0, '7100');
insert into T_operation_r_role (role_id, opt_id) values (1, 4083);
insert into T_operation_r_role (role_id, opt_id) values (2, 4083);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 4083;
delete from T_operation_r_role where opt_id = 4084 and role_id = 1;
delete from T_operation_r_role where opt_id = 4084 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 4084;
delete from T_operation_r_role where opt_id = 4084;
delete from T_operations where opt_id = 4084;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(4084, 'atic.report', '', '', 0, '7100-100');
insert into T_operation_r_role (role_id, opt_id) values (1, 4084);
insert into T_operation_r_role (role_id, opt_id) values (2, 4084);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 4084;
delete from T_operation_r_role where opt_id = 4087 and role_id = 1;
delete from T_operation_r_role where opt_id = 4087 and role_id = 2;
insert into t_operation_r_role_temp
select * from T_operation_r_role where opt_id = 4087;
delete from T_operation_r_role where opt_id = 4087;
delete from T_operations where opt_id = 4087;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(4087, 'lego.sys.maintenance', '', '', 0, '8000-1100');
insert into T_operation_r_role (role_id, opt_id) values (1, 4087);
insert into T_operation_r_role (role_id, opt_id) values (2, 4087);
insert into T_operation_r_role
select * from T_operation_r_role_temp where opt_id = 4087;
/* 4091 for HA*/

DROP TABLE IF EXISTS `t_operation_r_role_temp`;
DROP TABLE IF EXISTS `role_id_tmp`;
