/*use when UPDATE V5R1C20 TO V5R1C30B001*/
USE `lego`;

CREATE TABLE IF NOT EXISTS `t_vsm_zone_nfa_policy` (
  `pkid` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `zone_id` BIGINT(20) DEFAULT NULL,
  `service_id` BIGINT(20) DEFAULT NULL,
  `direction` VARCHAR(3) DEFAULT NULL,
  `name` VARCHAR(255) DEFAULT NULL,
  `enable` INT(11) DEFAULT NULL,
  `pps_enable` INT(11) DEFAULT NULL,
  `pps_threshold` INT(11) DEFAULT NULL,
  `pps_unit` VARCHAR(4) DEFAULT NULL,
  `bps_enable` INT(11) DEFAULT NULL,
  `bps_threshold` INT(11) DEFAULT NULL,
  `bps_unit` VARCHAR(4) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `t_atic_device_nfa` (
`moid` BIGINT(20) NOT NULL,
`api_key` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8_bin',
`restful_port` INT(11) NULL DEFAULT NULL,
`syslog_dst_ip` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8_bin',
`syslog_dst_port` INT(11) NULL DEFAULT NULL,
`trap_dst_ip` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8_bin',
`trap_security_name` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8_bin',
`trap_dst_port` INT(11) NULL DEFAULT NULL,
`location` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8_bin',
`contact` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8_bin',
PRIMARY KEY (`moid`)
)
COLLATE='utf8_bin'
ENGINE=InnoDB;

CREATE TABLE IF NOT EXISTS `t_atic_device_router` (
`moid` BIGINT(20) NOT NULL,
`flow_src_ip` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8_bin',
`flow_dst_port` INT(11) NULL DEFAULT NULL,
`sample_mode` INT(11) NULL DEFAULT NULL,
`sample_ratio` INT(11) NULL DEFAULT NULL,
`age_time` INT(11) NULL DEFAULT NULL,
`cpu_oid` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8_bin',
`memery_oid` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8_bin',
PRIMARY KEY (`moid`)
)
COLLATE='utf8_bin'
ENGINE=InnoDB;


CREATE TABLE IF NOT EXISTS `t_atic_device_nfa_router` (
	`pkid` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`nfa_id` BIGINT(20) NULL DEFAULT NULL,
	`router_id` BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (`pkid`)
)
COLLATE='utf8_bin'
ENGINE=InnoDB;



/*use when UPDATE V5R1C30BOO1 TO V5R1C30B003*/

CREATE TABLE IF NOT EXISTS `t_vsm_filter` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `filter_type` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `filter_action` int(11) DEFAULT NULL,
  `filter_alert` int(11) DEFAULT NULL,
  `filter_Id` int(11) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;


Alter table `t_vsm_filter` add column `device_type` varchar(255) default 'AntiDDoS' after `filter_Id`;

update t_vsm_filter set device_type = 'ALL' where filter_name in ('DNS_Amplification','Chargen_Amplification','SNMP_Amplification','TFTP_Amplification','NTP_Amplification','NetBIOS_Amplification','SSDP_Amplification_Attack','QOTD_Amplification','Quake_Network_Protocol','Steam_Protocol_Amplification','Portmapper_Amplification','Microsoft_SQL_Resolution_Service_Amplification','RIPV1_Amplification_Attack');

UPDATE t_vsm_zone_dnsflood SET cache_poisoning_enable = NULL, dns_reflect_enable = NULL;
UPDATE t_vsm_zone_tcpflood SET syn_ack_flood_enable = NULL,syn_ack_flood_alert_rate = NULL;


/*use when UPDATE V5R1C30BO12 TO V5R1C30B013*/
DROP PROCEDURE IF EXISTS add_column;
DELIMITER //
CREATE PROCEDURE add_column() BEGIN
	IF NOT EXISTS(SELECT * FROM information_schema.columns
	       WHERE table_name = 't_vsm_filter_device_zone_info' AND column_name ='delete_flag' OR column_name='deploy_state')
	THEN
	  ALTER TABLE `t_vsm_filter_device_zone_info` ADD COLUMN `delete_flag` BIGINT(20) NULL  DEFAULT '0' AFTER `preference`;
	  ALTER TABLE `t_vsm_filter_device_zone_info` ADD COLUMN `deploy_state` VARCHAR(255) DEFAULT 'UNDEPLOY' AFTER `delete_flag`;
	END IF;
END;
//
DELIMITER ;
CALL add_column(); 


DROP PROCEDURE IF EXISTS add_neconf;
DELIMITER //
CREATE PROCEDURE add_neconf() BEGIN
	IF NOT EXISTS(SELECT * FROM information_schema.columns
	       WHERE table_name = 't_vsm_neconf_abnormaldfn' AND column_name ='filter_error_msg_key' OR column_name='filter_deploy_state' OR column_name='filter_error_param')
	THEN
	 ALTER TABLE t_vsm_neconf_abnormaldfn  ADD  COLUMN `filter_error_msg_key` VARCHAR(255) COLLATE utf8_bin DEFAULT '\-\-' AFTER `blist_error_msg_key`;
	 ALTER TABLE t_vsm_neconf_abnormaldfn  ADD  COLUMN `filter_deploy_state` VARCHAR(255) COLLATE utf8_bin DEFAULT 'UNDEPLOY' AFTER `filter_error_msg_key`;
	 ALTER TABLE t_vsm_neconf_abnormaldfn  ADD  COLUMN `filter_error_param` TEXT COLLATE utf8_bin AFTER `filter_deploy_state`;
	END IF;
END;
//
DELIMITER ;
CALL add_neconf(); 


/*use when UPDATE V5R1C30BO13 TO V5R1C30B015*/

UPDATE t_topoobject t SET t.supportPing = FALSE WHERE t.main_type IN('SIG_i18n','SyslogDevice_i18n','SIG9800Device_i18n');



/*use when UPDATE V5R1C30BO15 TO V5R1C30B017*/

ALTER TABLE t_fault  CHANGE  `fault_param` `fault_param` VARCHAR(1024) COLLATE utf8_bin;
ALTER TABLE t_fault_detail  CHANGE  `fault_param` `fault_param` VARCHAR(1024) COLLATE utf8_bin;
ALTER TABLE t_fault_statistic  CHANGE  `fault_param` `fault_param` VARCHAR(1024) COLLATE utf8_bin;



/*use when UPDATE V5R1C30BO17 TO V5R1C30B019*/

ALTER TABLE t_vsm_zone_baseline_study CHANGE `zone_id` `zone_id` BIGINT(20) AFTER `pkid`;
DROP PROCEDURE IF EXISTS add_baselineName;
DELIMITER //
CREATE PROCEDURE add_baselineName() BEGIN
	IF NOT EXISTS(SELECT * FROM information_schema.columns
	       WHERE table_name = 't_vsm_zone_baseline_study' AND column_name = 'name' or column_name = 'start_mode' or column_name ='stop_mode')
	THEN
	 ALTER TABLE t_vsm_zone_baseline_study ADD COLUMN `name` VARCHAR(255) AFTER `zone_id`;
	 ALTER TABLE t_vsm_zone_baseline_study ADD COLUMN `start_mode` INT(11);
     ALTER TABLE t_vsm_zone_baseline_study ADD COLUMN `stop_mode` INT(11);
	END IF;
	END;	  
//
DELIMITER ;
CALL add_baselineName();

UPDATE t_vsm_zone_baseline_study SET `start_mode` = 1 WHERE `start_mode`='' OR `start_mode` IS NULL;
UPDATE t_vsm_zone_baseline_study SET `stop_mode` = 1 WHERE `stop_mode`='' OR `stop_mode` IS NULL;
UPDATE t_vsm_zone_baseline_study SET `name`='defaultName' WHERE `name` ='' OR `name` IS NULL;




/*use when UPDATE V5R1C30BO22 TO V5R1C30B023*/

ALTER TABLE t_fault  CHANGE  `fault_param` `fault_param` VARCHAR(4000) COLLATE utf8_bin;
ALTER TABLE t_fault_detail  CHANGE  `fault_param` `fault_param` VARCHAR(4000) COLLATE utf8_bin;
ALTER TABLE t_fault_statistic  CHANGE  `fault_param` `fault_param` VARCHAR(4000) COLLATE utf8_bin;



/*use when UPDATE V5R1C30BO23 TO V5R1C30B025*/

DELETE FROM t_operation_r_role WHERE opt_id in (2360,2361);
DELETE FROM t_operations WHERE opt_id in (2360,2361);

UPDATE t_operations SET ismaster = 0 WHERE opt_id IN (2502,2517);



/*use when UPDATE V5R1C30BO26 TO V5R1C30B028*/

delete from T_operation_r_role where opt_id = 2343;
delete from T_operations where opt_id = 2343;
delete from T_operation_r_role where opt_id = 2344;
delete from T_operations where opt_id = 2344;
delete from T_operation_r_role where opt_id = 2345;
delete from T_operations where opt_id = 2345;
delete from T_operation_r_role where opt_id = 2346;
delete from T_operations where opt_id = 2346;
delete from T_operation_r_role where opt_id = 2347;
delete from T_operations where opt_id = 2347;
delete from T_operation_r_role where opt_id = 2348;
delete from T_operations where opt_id = 2348;
delete from T_operation_r_role where opt_id = 2349;
delete from T_operations where opt_id = 2349;
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(85, 'lego.evtMgr.alarm.severity.rule', '/atic/business/listFaultSeverityRule.do', '', 0, '6000-100-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 85);
insert into T_operation_r_role (role_id, opt_id) values (2, 85);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(86, 'lego.evtMgr.alarm.severity.rule.scan', '', '', 1, '6000-100-30-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 86);
insert into T_operation_r_role (role_id, opt_id) values (2, 86);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(87, 'lego.sys.faultSeverityRule.modify', '', '', 0, '6000-100-30-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 87);
insert into T_operation_r_role (role_id, opt_id) values (2, 87);

insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2343, 'atic.sys.config.backup.recovery', '/atic/system/configBackupList.do', '', 0, '8000-500-40');
insert into T_operation_r_role (role_id, opt_id) values (1, 2343);
insert into T_operation_r_role (role_id, opt_id) values (2, 2343);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2344, 'atic.sys.config.backup.recovery.scan', '', '', 1, '8000-500-40-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2344);
insert into T_operation_r_role (role_id, opt_id) values (2, 2344);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2345, 'atic.system.config.backup', '', '', 0, '8000-500-40-10');
insert into T_operation_r_role (role_id, opt_id) values (1, 2345);
insert into T_operation_r_role (role_id, opt_id) values (2, 2345);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2346, 'atic.system.config.recovery', '', '', 0, '8000-500-40-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 2346);
insert into T_operation_r_role (role_id, opt_id) values (2, 2346);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2347, 'atic.system.config.import', '', '', 0, '8000-500-40-20');
insert into T_operation_r_role (role_id, opt_id) values (1, 2347);
insert into T_operation_r_role (role_id, opt_id) values (2, 2347);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2348, 'atic.system.config.export', '', '', 0, '8000-500-40-25');
insert into T_operation_r_role (role_id, opt_id) values (1, 2348);
insert into T_operation_r_role (role_id, opt_id) values (2, 2348);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2349, 'atic.system.config.delete', '', '', 0, '8000-500-40-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 2349);
insert into T_operation_r_role (role_id, opt_id) values (2, 2349);

























