USE `lego`;

ALTER TABLE `t_vsm_zone_ddos_policy` DROP COLUMN `blackhole_mode`, ADD COLUMN `blackhole_type` INT(11) NULL AFTER `blackhole_threshold`;

/*start procedure to opt_zoneddospolicy*/
DELIMITER $$
DROP PROCEDURE IF EXISTS `opt_zoneddospolicy`$$
CREATE PROCEDURE `opt_zoneddospolicy`()
 BEGIN
   DECLARE zoneId BIGINT(20);
   DECLARE s INT DEFAULT 0;   
   DECLARE  cur_zoneddospolicy CURSOR FOR SELECT zone_id FROM t_vsm_zone_ddos_policy WHERE blackhole_enable=TRUE AND blackhole_type IS NULL;  
   DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET s=1; 

   OPEN cur_zoneddospolicy;
	   FETCH cur_zoneddospolicy INTO zoneId;
	   WHILE s <> 1 DO
		UPDATE t_vsm_zone_ddos_policy SET blackhole_type=0 WHERE zone_id=zoneId; 
		FETCH cur_zoneddospolicy INTO zoneId;	
	END WHILE;
  CLOSE cur_zoneddospolicy;
 END$$

DELIMITER ;
CALL opt_zoneddospolicy();
DROP PROCEDURE IF EXISTS `opt_zoneddospolicy`;
/*end procedure to opt_zoneddospolicy*/

DROP PROCEDURE if EXISTS add_column_audit_enable_for_zone_ddos_policy;
delimiter //
CREATE PROCEDURE add_column_audit_enable_for_zone_ddos_policy()
BEGIN
    IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE table_name = 't_vsm_zone_ddos_policy' AND column_name ='audit_enable')
    THEN
      ALTER TABLE `t_vsm_zone_ddos_policy` ADD COLUMN `audit_enable` bit(1) DEFAULT b'0' AFTER `dos_enable`;
    END IF;
	IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE table_name = 't_vsm_neconf_abnormaldfn' AND column_name ='domain_error_msg_key')
    THEN
      ALTER TABLE `t_vsm_neconf_abnormaldfn` ADD COLUMN `domain_error_msg_key` blob  AFTER `ssl_decryption`;
    END IF;
	IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE table_name = 't_vsm_neconf_abnormaldfn' AND column_name ='domain_deploy_state')
    THEN
      ALTER TABLE `t_vsm_neconf_abnormaldfn` ADD COLUMN `domain_deploy_state` varchar (30) DEFAULT 'UNDEPLOY' AFTER `domain_error_msg_key`;
    END IF;
END;
//
delimiter ;
call add_column_audit_enable_for_zone_ddos_policy();
DROP PROCEDURE if exists  add_column_audit_enable_for_zone_ddos_policy;

DROP TABLE if EXISTS t_vsm_neconf_domain_whitelist;
create table `t_vsm_neconf_domain_whitelist` (
	`pkid` bigint(11) unsigned not null AUTO_INCREMENT,
	`device_id` varchar (200),
	`domain_white` varchar (200),
	`delete_flag` varchar (2),
	`deploy_state` varchar (30),
	PRIMARY KEY (`pkid`)
); 

insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2450, 'atic.bis.onekeyCollection', '/atic/business/onekeyCollection.do', '', 0, '6500-200-30');
insert into T_operation_r_role (role_id, opt_id) values (1, 2450);
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2451, 'atic.bis.onekeyCollection.scan', '', '', 1, '6500-200-30-5');
insert into T_operation_r_role (role_id, opt_id) values (1, 2451);

/*流量对比，流量分布由均值改为峰值,topN-防护对象流量topn，ip流量topn*/
DELETE FROM t_atic_homepage_portal WHERE pkid IN(SELECT pkid FROM t_atic_homepage_entity WHERE device_ip IN ('-1','-2'));
DELETE FROM t_atic_homepage_entity WHERE device_ip IN ('-1','-2');

/*域名审计权限*/
insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2335, 'atic.bis.globalPolicy.domainwhitelistConfig', '', '', 0, '6500-100-25-55');
insert into T_operation_r_role (role_id, opt_id) values (1, 2335);
insert into T_operation_r_role (role_id, opt_id) values (2, 2335);



