USE `lego`;
DROP PROCEDURE IF EXISTS add_column_t_vsm_zone_tcpflood;
DELIMITER //
CREATE PROCEDURE add_column_t_vsm_zone_tcpflood()
  BEGIN
    IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE TABLE_SCHEMA='lego' AND table_name = 't_vsm_zone_tcpflood' AND column_name ='synflood_defendmode_enable') THEN
      ALTER TABLE t_vsm_zone_tcpflood ADD COLUMN synflood_defendmode_enable  BIT(1);
    END IF;	   
	IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE TABLE_SCHEMA='lego' AND table_name = 't_vsm_zone_tcpflood' AND column_name ='synack_source_enable')  THEN
      ALTER TABLE t_vsm_zone_tcpflood ADD COLUMN synack_source_enable  BIT(1);
    END IF;
	IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE TABLE_SCHEMA='lego' AND table_name = 't_vsm_zone_tcpflood' AND column_name ='synack_firstpacket_enable') THEN
      ALTER TABLE t_vsm_zone_tcpflood ADD COLUMN synack_firstpacket_enable  BIT(1);
    END IF;
	IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE TABLE_SCHEMA='lego' AND table_name = 't_vsm_zone_tcpflood' AND column_name ='synack_lower_limit')  THEN
      ALTER TABLE t_vsm_zone_tcpflood ADD COLUMN synack_lower_limit  INT(11);
    END IF;
	IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE TABLE_SCHEMA='lego' AND table_name = 't_vsm_zone_tcpflood' AND column_name ='synack_upper_limit') THEN
      ALTER TABLE t_vsm_zone_tcpflood ADD COLUMN synack_upper_limit  INT(11);
    END IF;	
	 UPDATE t_vsm_zone_tcpflood SET synflood_defendmode_enable = 1 WHERE synflood_Mode IS NOT NULL; 
  END;
//
DELIMITER ;
CALL add_column_t_vsm_zone_tcpflood();
DROP PROCEDURE IF EXISTS add_column_t_vsm_zone_tcpflood;

/*默认模板更新8个--begin*/
DELIMITER $$
-- function:计算拆分后字符串的个数函数
DROP FUNCTION IF EXISTS calc_length $$
CREATE FUNCTION calc_length(str VARCHAR(255), splitstr VARCHAR(5)) RETURNS INT(11)
BEGIN 
	RETURN LENGTH(str)-LENGTH(REPLACE(str, splitstr, ''))+1;
END $$

-- function:分割字符，取第x个
DELIMITER $$
DROP FUNCTION IF EXISTS `get_split_string` $$
CREATE FUNCTION `get_split_string`
( f_string VARCHAR(1000),f_delimiter VARCHAR(5),f_order INT)
	RETURNS VARCHAR(255) CHARSET utf8
BEGIN
	DECLARE result VARCHAR(255) DEFAULT ''; 
	SET result = REVERSE(SUBSTRING_INDEX(REVERSE(SUBSTRING_INDEX(f_string,f_delimiter,f_order)),f_delimiter,1));
	RETURN result;
END$$
DELIMITER ;

DROP PROCEDURE IF EXISTS update_default_policy_mode;
-- 创建存储过程
DELIMITER ;//
CREATE PROCEDURE update_default_policy_mode()
BEGIN
	DECLARE current_template_name VARCHAR(255);
	DECLARE current_template_id INT DEFAULT 11;
	DECLARE template_names VARCHAR(255);
	DECLARE cnt INT DEFAULT 8; 
	DECLARE i INT DEFAULT 0;
	
	SET template_names = 'General-Server,WEB-Server,DNS-Caching-Server,DNS-Authoritative-Server,Financial-Server,E-Commerce-Server,Game-Server-Standard,Game-Server-Super';
	
	WHILE i < cnt
	DO
		SET i = i + 1;
		SET current_template_name = get_split_string(template_names,',',i);
		
		#获取模板pkid
		IF EXISTS(SELECT * FROM `t_vsm_zone_template` WHERE `template_name`= current_template_name) THEN
      		SELECT pkid INTO current_template_id FROM `t_vsm_zone_template` WHERE `template_name`= current_template_name;
      		#删除模板对应的策略
			DELETE FROM t_vsm_zone_dnsflood WHERE pkid IN (SELECT DISTINCT children_id FROM t_vsm_zone_template_items WHERE template_id=current_template_id AND TYPE = 'DNS');
			DELETE FROM t_vsm_zone_httpflood WHERE pkid IN (SELECT DISTINCT children_id FROM t_vsm_zone_template_items WHERE template_id=current_template_id AND TYPE = 'HTTP');
			DELETE FROM t_vsm_zone_httpsflood WHERE pkid IN (SELECT DISTINCT children_id FROM t_vsm_zone_template_items WHERE template_id=current_template_id AND TYPE = 'HTTPS');
			DELETE FROM t_vsm_zone_icmpflood WHERE pkid IN (SELECT DISTINCT children_id FROM t_vsm_zone_template_items WHERE template_id=current_template_id AND TYPE = 'ICMP');
			DELETE FROM t_vsm_zone_otherflood WHERE pkid IN (SELECT DISTINCT children_id FROM t_vsm_zone_template_items WHERE template_id=current_template_id AND TYPE = 'Other');
			DELETE FROM t_vsm_zone_sipflood WHERE pkid IN (SELECT DISTINCT children_id FROM t_vsm_zone_template_items WHERE template_id=current_template_id AND TYPE = 'SIP');
			DELETE FROM t_vsm_zone_tcpflood WHERE pkid IN (SELECT DISTINCT children_id FROM t_vsm_zone_template_items WHERE template_id=current_template_id AND TYPE = 'TCP');
			DELETE FROM t_vsm_zone_udpflood WHERE pkid IN (SELECT DISTINCT children_id FROM t_vsm_zone_template_items WHERE template_id=current_template_id AND TYPE = 'UDP');
			DELETE FROM t_vsm_zone_topnstudy WHERE pkid IN (SELECT DISTINCT children_id FROM t_vsm_zone_template_items WHERE template_id=current_template_id AND TYPE = 'TOPNSTUDY');
			#删除默认模板
			DELETE FROM t_vsm_zone_template_items WHERE template_id = current_template_id;		
			DELETE FROM t_vsm_zone_template WHERE pkid = current_template_id;
    	END IF;
	END WHILE;
END;//
DELIMITER ;
-- 调用存储过程
CALL update_default_policy_mode();
-- 清除临时数据
DROP PROCEDURE IF EXISTS update_default_policy_mode;
DROP FUNCTION IF EXISTS calc_length;
DROP FUNCTION IF EXISTS get_split_string;
/*end procedure to update_default_policy_mode*/

#最新的模板内容

INSERT INTO t_vsm_zone_template(template_name,protocol,device_type,template_desc,add_time,direction) VALUES ('Game-Server-Standard','DEFAULT','AntiDDoS','',UNIX_TIMESTAMP(NOW()),'1');
INSERT INTO t_vsm_zone_template(template_name,protocol,device_type,template_desc,add_time,direction) VALUES ('Game-Server-Super','DEFAULT','AntiDDoS','',UNIX_TIMESTAMP(NOW()),'1');
INSERT INTO t_vsm_zone_template(template_name,protocol,device_type,template_desc,add_time,direction) VALUES ('WEB-Server','DEFAULT','AntiDDoS','',UNIX_TIMESTAMP(NOW()),'1');
INSERT INTO t_vsm_zone_template(template_name,protocol,device_type,template_desc,add_time,direction) VALUES ('E-Commerce-Server','DEFAULT','AntiDDoS','',UNIX_TIMESTAMP(NOW()),'1');
INSERT INTO t_vsm_zone_template(template_name,protocol,device_type,template_desc,add_time,direction) VALUES ('Financial-Server','DEFAULT','AntiDDoS','',UNIX_TIMESTAMP(NOW()),'1');
INSERT INTO t_vsm_zone_template(template_name,protocol,device_type,template_desc,add_time,direction) VALUES ('DNS-Caching-Server','DEFAULT','AntiDDoS','',UNIX_TIMESTAMP(NOW()),'1');
INSERT INTO t_vsm_zone_template(template_name,protocol,device_type,template_desc,add_time,direction) VALUES ('DNS-Authoritative-Server','DEFAULT','AntiDDoS','',UNIX_TIMESTAMP(NOW()),'1');
INSERT INTO t_vsm_zone_template(template_name,protocol,device_type,template_desc,add_time,direction) VALUES ('General-TCP-Server','DEFAULT','AntiDDoS','',UNIX_TIMESTAMP(NOW()),'1');
INSERT INTO t_vsm_zone_template(template_name,protocol,device_type,template_desc,add_time,direction) VALUES ('General-UDP-Server','DEFAULT','AntiDDoS','',UNIX_TIMESTAMP(NOW()),'1');

insert into `t_vsm_ip_finger_defend` (`service_id`, `ip_finger_defend_enable`) values(NULL,NULL);
insert into `t_vsm_ip_finger_defend` (`service_id`, `ip_finger_defend_enable`) values(NULL,NULL);
insert into `t_vsm_ip_finger_defend` (`service_id`, `ip_finger_defend_enable`) values(NULL,NULL);
insert into `t_vsm_ip_finger_defend` (`service_id`, `ip_finger_defend_enable`) values(NULL,NULL);
insert into `t_vsm_ip_finger_defend` (`service_id`, `ip_finger_defend_enable`) values(NULL,NULL);
insert into `t_vsm_ip_finger_defend` (`service_id`, `ip_finger_defend_enable`) values(NULL,NULL);
insert into `t_vsm_ip_finger_defend` (`service_id`, `ip_finger_defend_enable`) values(NULL,NULL);
insert into `t_vsm_ip_finger_defend` (`service_id`, `ip_finger_defend_enable`) values(NULL,NULL);
insert into `t_vsm_ip_finger_defend` (`service_id`, `ip_finger_defend_enable`) values(NULL,NULL);

insert into `t_vsm_zone_dnsflood` (`service_id`, `dns_cache_server_enable`, `dns_auth_server_enable`, `dns_block`, `dns_defend_enable`, `dns_flood_enable`, `defend_mode`, `alert_rate`, `reply_flood_enable`, `reply_flood_src_dec_enable`, `reply_flood_sess_check_enable`, `reply_flood_alert_rate`, `no_such_name_check_enable`, `no_such_name_check_alert_ratio`, `access_monitor_enable`, `srcip_req_limit_enable`, `srcip_req_alert_rate`, `srcip_other_req_mode`, `srcip_resp_limit_enable`, `srcip_resp_alert_rate`, `srcip_other_resp_mode`, `domain_req_limit_enable`, `domain_req_alert_rate`, `packet_size_limit_enable`, `packet_size_alert_rate`, `cache_poisoning_enable`, `domain_defend_enable`, `dns_domain_enable`, `dns_domaincatch_enable`, `dns_userfinger_enable`, `limit_enable`, `limit_rate`, `dns_statistic_enable`, `dns_destory_enable`, `dns_reflect_enable`, `dns_request_len_enable`, `dns_response_len_enable`, `dns_request_message_len`, `dns_response_message_len`, `dns_response_enable`, `response_domain_alert_rate`, `response_domain_enable`, `request_domain_enable`, `sourceIp_response_enable`, `sourceIp_request_enable`, `staticFinger_request_enable`, `staticFinger_response_enable`, `dns_refelct_alertRate`, `format_check_enable`, `request__ttl_check_enable`, `reply__ttl_check_enable`, `request_ttl_check_mode`, `reply_ttl_check_mode`, `request_ttl_alert_rate`, `reply_ttl_alert_rate`, `topn_statistic_domain_enable`, `topn_cache_enable`, `learn_number`, `topn_statistic_sourceip_enable`, `sample_rate`, `topn_statistic_enable`, `format_check_ratio`, `direction`, `dns_enable`, `dns_lower_limit`, `dns_upper_limit`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'200',NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,'','','','',NULL,'','','',NULL,NULL,NULL,NULL,'','',NULL,'',NULL,'',NULL,'1',NULL,NULL,NULL);
insert into `t_vsm_zone_dnsflood` (`service_id`, `dns_cache_server_enable`, `dns_auth_server_enable`, `dns_block`, `dns_defend_enable`, `dns_flood_enable`, `defend_mode`, `alert_rate`, `reply_flood_enable`, `reply_flood_src_dec_enable`, `reply_flood_sess_check_enable`, `reply_flood_alert_rate`, `no_such_name_check_enable`, `no_such_name_check_alert_ratio`, `access_monitor_enable`, `srcip_req_limit_enable`, `srcip_req_alert_rate`, `srcip_other_req_mode`, `srcip_resp_limit_enable`, `srcip_resp_alert_rate`, `srcip_other_resp_mode`, `domain_req_limit_enable`, `domain_req_alert_rate`, `packet_size_limit_enable`, `packet_size_alert_rate`, `cache_poisoning_enable`, `domain_defend_enable`, `dns_domain_enable`, `dns_domaincatch_enable`, `dns_userfinger_enable`, `limit_enable`, `limit_rate`, `dns_statistic_enable`, `dns_destory_enable`, `dns_reflect_enable`, `dns_request_len_enable`, `dns_response_len_enable`, `dns_request_message_len`, `dns_response_message_len`, `dns_response_enable`, `response_domain_alert_rate`, `response_domain_enable`, `request_domain_enable`, `sourceIp_response_enable`, `sourceIp_request_enable`, `staticFinger_request_enable`, `staticFinger_response_enable`, `dns_refelct_alertRate`, `format_check_enable`, `request__ttl_check_enable`, `reply__ttl_check_enable`, `request_ttl_check_mode`, `reply_ttl_check_mode`, `request_ttl_alert_rate`, `reply_ttl_alert_rate`, `topn_statistic_domain_enable`, `topn_cache_enable`, `learn_number`, `topn_statistic_sourceip_enable`, `sample_rate`, `topn_statistic_enable`, `format_check_ratio`, `direction`, `dns_enable`, `dns_lower_limit`, `dns_upper_limit`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'200',NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,'','','','',NULL,'','','',NULL,NULL,NULL,NULL,'','',NULL,'',NULL,'',NULL,'1',NULL,NULL,NULL);
insert into `t_vsm_zone_dnsflood` (`service_id`, `dns_cache_server_enable`, `dns_auth_server_enable`, `dns_block`, `dns_defend_enable`, `dns_flood_enable`, `defend_mode`, `alert_rate`, `reply_flood_enable`, `reply_flood_src_dec_enable`, `reply_flood_sess_check_enable`, `reply_flood_alert_rate`, `no_such_name_check_enable`, `no_such_name_check_alert_ratio`, `access_monitor_enable`, `srcip_req_limit_enable`, `srcip_req_alert_rate`, `srcip_other_req_mode`, `srcip_resp_limit_enable`, `srcip_resp_alert_rate`, `srcip_other_resp_mode`, `domain_req_limit_enable`, `domain_req_alert_rate`, `packet_size_limit_enable`, `packet_size_alert_rate`, `cache_poisoning_enable`, `domain_defend_enable`, `dns_domain_enable`, `dns_domaincatch_enable`, `dns_userfinger_enable`, `limit_enable`, `limit_rate`, `dns_statistic_enable`, `dns_destory_enable`, `dns_reflect_enable`, `dns_request_len_enable`, `dns_response_len_enable`, `dns_request_message_len`, `dns_response_message_len`, `dns_response_enable`, `response_domain_alert_rate`, `response_domain_enable`, `request_domain_enable`, `sourceIp_response_enable`, `sourceIp_request_enable`, `staticFinger_request_enable`, `staticFinger_response_enable`, `dns_refelct_alertRate`, `format_check_enable`, `request__ttl_check_enable`, `reply__ttl_check_enable`, `request_ttl_check_mode`, `reply_ttl_check_mode`, `request_ttl_alert_rate`, `reply_ttl_alert_rate`, `topn_statistic_domain_enable`, `topn_cache_enable`, `learn_number`, `topn_statistic_sourceip_enable`, `sample_rate`, `topn_statistic_enable`, `format_check_ratio`, `direction`, `dns_enable`, `dns_lower_limit`, `dns_upper_limit`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'200',NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,'','','','',NULL,'','','',NULL,NULL,NULL,NULL,'','',NULL,'',NULL,'',NULL,'1',NULL,NULL,NULL);
insert into `t_vsm_zone_dnsflood` (`service_id`, `dns_cache_server_enable`, `dns_auth_server_enable`, `dns_block`, `dns_defend_enable`, `dns_flood_enable`, `defend_mode`, `alert_rate`, `reply_flood_enable`, `reply_flood_src_dec_enable`, `reply_flood_sess_check_enable`, `reply_flood_alert_rate`, `no_such_name_check_enable`, `no_such_name_check_alert_ratio`, `access_monitor_enable`, `srcip_req_limit_enable`, `srcip_req_alert_rate`, `srcip_other_req_mode`, `srcip_resp_limit_enable`, `srcip_resp_alert_rate`, `srcip_other_resp_mode`, `domain_req_limit_enable`, `domain_req_alert_rate`, `packet_size_limit_enable`, `packet_size_alert_rate`, `cache_poisoning_enable`, `domain_defend_enable`, `dns_domain_enable`, `dns_domaincatch_enable`, `dns_userfinger_enable`, `limit_enable`, `limit_rate`, `dns_statistic_enable`, `dns_destory_enable`, `dns_reflect_enable`, `dns_request_len_enable`, `dns_response_len_enable`, `dns_request_message_len`, `dns_response_message_len`, `dns_response_enable`, `response_domain_alert_rate`, `response_domain_enable`, `request_domain_enable`, `sourceIp_response_enable`, `sourceIp_request_enable`, `staticFinger_request_enable`, `staticFinger_response_enable`, `dns_refelct_alertRate`, `format_check_enable`, `request__ttl_check_enable`, `reply__ttl_check_enable`, `request_ttl_check_mode`, `reply_ttl_check_mode`, `request_ttl_alert_rate`, `reply_ttl_alert_rate`, `topn_statistic_domain_enable`, `topn_cache_enable`, `learn_number`, `topn_statistic_sourceip_enable`, `sample_rate`, `topn_statistic_enable`, `format_check_ratio`, `direction`, `dns_enable`, `dns_lower_limit`, `dns_upper_limit`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'200',NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,'','','','',NULL,'','','',NULL,NULL,NULL,NULL,'','',NULL,'',NULL,'',NULL,'1',NULL,NULL,NULL);
insert into `t_vsm_zone_dnsflood` (`service_id`, `dns_cache_server_enable`, `dns_auth_server_enable`, `dns_block`, `dns_defend_enable`, `dns_flood_enable`, `defend_mode`, `alert_rate`, `reply_flood_enable`, `reply_flood_src_dec_enable`, `reply_flood_sess_check_enable`, `reply_flood_alert_rate`, `no_such_name_check_enable`, `no_such_name_check_alert_ratio`, `access_monitor_enable`, `srcip_req_limit_enable`, `srcip_req_alert_rate`, `srcip_other_req_mode`, `srcip_resp_limit_enable`, `srcip_resp_alert_rate`, `srcip_other_resp_mode`, `domain_req_limit_enable`, `domain_req_alert_rate`, `packet_size_limit_enable`, `packet_size_alert_rate`, `cache_poisoning_enable`, `domain_defend_enable`, `dns_domain_enable`, `dns_domaincatch_enable`, `dns_userfinger_enable`, `limit_enable`, `limit_rate`, `dns_statistic_enable`, `dns_destory_enable`, `dns_reflect_enable`, `dns_request_len_enable`, `dns_response_len_enable`, `dns_request_message_len`, `dns_response_message_len`, `dns_response_enable`, `response_domain_alert_rate`, `response_domain_enable`, `request_domain_enable`, `sourceIp_response_enable`, `sourceIp_request_enable`, `staticFinger_request_enable`, `staticFinger_response_enable`, `dns_refelct_alertRate`, `format_check_enable`, `request__ttl_check_enable`, `reply__ttl_check_enable`, `request_ttl_check_mode`, `reply_ttl_check_mode`, `request_ttl_alert_rate`, `reply_ttl_alert_rate`, `topn_statistic_domain_enable`, `topn_cache_enable`, `learn_number`, `topn_statistic_sourceip_enable`, `sample_rate`, `topn_statistic_enable`, `format_check_ratio`, `direction`, `dns_enable`, `dns_lower_limit`, `dns_upper_limit`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'200',NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,'','','','',NULL,'','','',NULL,NULL,NULL,NULL,'','',NULL,'',NULL,'',NULL,'1',NULL,NULL,NULL);
insert into `t_vsm_zone_dnsflood` (`service_id`, `dns_cache_server_enable`, `dns_auth_server_enable`, `dns_block`, `dns_defend_enable`, `dns_flood_enable`, `defend_mode`, `alert_rate`, `reply_flood_enable`, `reply_flood_src_dec_enable`, `reply_flood_sess_check_enable`, `reply_flood_alert_rate`, `no_such_name_check_enable`, `no_such_name_check_alert_ratio`, `access_monitor_enable`, `srcip_req_limit_enable`, `srcip_req_alert_rate`, `srcip_other_req_mode`, `srcip_resp_limit_enable`, `srcip_resp_alert_rate`, `srcip_other_resp_mode`, `domain_req_limit_enable`, `domain_req_alert_rate`, `packet_size_limit_enable`, `packet_size_alert_rate`, `cache_poisoning_enable`, `domain_defend_enable`, `dns_domain_enable`, `dns_domaincatch_enable`, `dns_userfinger_enable`, `limit_enable`, `limit_rate`, `dns_statistic_enable`, `dns_destory_enable`, `dns_reflect_enable`, `dns_request_len_enable`, `dns_response_len_enable`, `dns_request_message_len`, `dns_response_message_len`, `dns_response_enable`, `response_domain_alert_rate`, `response_domain_enable`, `request_domain_enable`, `sourceIp_response_enable`, `sourceIp_request_enable`, `staticFinger_request_enable`, `staticFinger_response_enable`, `dns_refelct_alertRate`, `format_check_enable`, `request__ttl_check_enable`, `reply__ttl_check_enable`, `request_ttl_check_mode`, `reply_ttl_check_mode`, `request_ttl_alert_rate`, `reply_ttl_alert_rate`, `topn_statistic_domain_enable`, `topn_cache_enable`, `learn_number`, `topn_statistic_sourceip_enable`, `sample_rate`, `topn_statistic_enable`, `format_check_ratio`, `direction`, `dns_enable`, `dns_lower_limit`, `dns_upper_limit`) values(NULL,'',NULL,NULL,'','','3','5000','','',NULL,'2000',NULL,NULL,NULL,'','100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','200',NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,'','','','',NULL,'','','',NULL,NULL,NULL,NULL,'','',NULL,'',NULL,'','500','1',NULL,'1','4');
insert into `t_vsm_zone_dnsflood` (`service_id`, `dns_cache_server_enable`, `dns_auth_server_enable`, `dns_block`, `dns_defend_enable`, `dns_flood_enable`, `defend_mode`, `alert_rate`, `reply_flood_enable`, `reply_flood_src_dec_enable`, `reply_flood_sess_check_enable`, `reply_flood_alert_rate`, `no_such_name_check_enable`, `no_such_name_check_alert_ratio`, `access_monitor_enable`, `srcip_req_limit_enable`, `srcip_req_alert_rate`, `srcip_other_req_mode`, `srcip_resp_limit_enable`, `srcip_resp_alert_rate`, `srcip_other_resp_mode`, `domain_req_limit_enable`, `domain_req_alert_rate`, `packet_size_limit_enable`, `packet_size_alert_rate`, `cache_poisoning_enable`, `domain_defend_enable`, `dns_domain_enable`, `dns_domaincatch_enable`, `dns_userfinger_enable`, `limit_enable`, `limit_rate`, `dns_statistic_enable`, `dns_destory_enable`, `dns_reflect_enable`, `dns_request_len_enable`, `dns_response_len_enable`, `dns_request_message_len`, `dns_response_message_len`, `dns_response_enable`, `response_domain_alert_rate`, `response_domain_enable`, `request_domain_enable`, `sourceIp_response_enable`, `sourceIp_request_enable`, `staticFinger_request_enable`, `staticFinger_response_enable`, `dns_refelct_alertRate`, `format_check_enable`, `request__ttl_check_enable`, `reply__ttl_check_enable`, `request_ttl_check_mode`, `reply_ttl_check_mode`, `request_ttl_alert_rate`, `reply_ttl_alert_rate`, `topn_statistic_domain_enable`, `topn_cache_enable`, `learn_number`, `topn_statistic_sourceip_enable`, `sample_rate`, `topn_statistic_enable`, `format_check_ratio`, `direction`, `dns_enable`, `dns_lower_limit`, `dns_upper_limit`) values(NULL,NULL,'',NULL,'','','2','5000','','',NULL,'500',NULL,NULL,NULL,'','1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','200',NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,'','','','',NULL,'','','',NULL,NULL,NULL,NULL,'','',NULL,'',NULL,'','500','1',NULL,'1','4');
insert into `t_vsm_zone_dnsflood` (`service_id`, `dns_cache_server_enable`, `dns_auth_server_enable`, `dns_block`, `dns_defend_enable`, `dns_flood_enable`, `defend_mode`, `alert_rate`, `reply_flood_enable`, `reply_flood_src_dec_enable`, `reply_flood_sess_check_enable`, `reply_flood_alert_rate`, `no_such_name_check_enable`, `no_such_name_check_alert_ratio`, `access_monitor_enable`, `srcip_req_limit_enable`, `srcip_req_alert_rate`, `srcip_other_req_mode`, `srcip_resp_limit_enable`, `srcip_resp_alert_rate`, `srcip_other_resp_mode`, `domain_req_limit_enable`, `domain_req_alert_rate`, `packet_size_limit_enable`, `packet_size_alert_rate`, `cache_poisoning_enable`, `domain_defend_enable`, `dns_domain_enable`, `dns_domaincatch_enable`, `dns_userfinger_enable`, `limit_enable`, `limit_rate`, `dns_statistic_enable`, `dns_destory_enable`, `dns_reflect_enable`, `dns_request_len_enable`, `dns_response_len_enable`, `dns_request_message_len`, `dns_response_message_len`, `dns_response_enable`, `response_domain_alert_rate`, `response_domain_enable`, `request_domain_enable`, `sourceIp_response_enable`, `sourceIp_request_enable`, `staticFinger_request_enable`, `staticFinger_response_enable`, `dns_refelct_alertRate`, `format_check_enable`, `request__ttl_check_enable`, `reply__ttl_check_enable`, `request_ttl_check_mode`, `reply_ttl_check_mode`, `request_ttl_alert_rate`, `reply_ttl_alert_rate`, `topn_statistic_domain_enable`, `topn_cache_enable`, `learn_number`, `topn_statistic_sourceip_enable`, `sample_rate`, `topn_statistic_enable`, `format_check_ratio`, `direction`, `dns_enable`, `dns_lower_limit`, `dns_upper_limit`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'200',NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,'','','','',NULL,'','','',NULL,NULL,NULL,NULL,'','',NULL,'',NULL,'',NULL,'1',NULL,NULL,NULL);
insert into `t_vsm_zone_dnsflood` (`service_id`, `dns_cache_server_enable`, `dns_auth_server_enable`, `dns_block`, `dns_defend_enable`, `dns_flood_enable`, `defend_mode`, `alert_rate`, `reply_flood_enable`, `reply_flood_src_dec_enable`, `reply_flood_sess_check_enable`, `reply_flood_alert_rate`, `no_such_name_check_enable`, `no_such_name_check_alert_ratio`, `access_monitor_enable`, `srcip_req_limit_enable`, `srcip_req_alert_rate`, `srcip_other_req_mode`, `srcip_resp_limit_enable`, `srcip_resp_alert_rate`, `srcip_other_resp_mode`, `domain_req_limit_enable`, `domain_req_alert_rate`, `packet_size_limit_enable`, `packet_size_alert_rate`, `cache_poisoning_enable`, `domain_defend_enable`, `dns_domain_enable`, `dns_domaincatch_enable`, `dns_userfinger_enable`, `limit_enable`, `limit_rate`, `dns_statistic_enable`, `dns_destory_enable`, `dns_reflect_enable`, `dns_request_len_enable`, `dns_response_len_enable`, `dns_request_message_len`, `dns_response_message_len`, `dns_response_enable`, `response_domain_alert_rate`, `response_domain_enable`, `request_domain_enable`, `sourceIp_response_enable`, `sourceIp_request_enable`, `staticFinger_request_enable`, `staticFinger_response_enable`, `dns_refelct_alertRate`, `format_check_enable`, `request__ttl_check_enable`, `reply__ttl_check_enable`, `request_ttl_check_mode`, `reply_ttl_check_mode`, `request_ttl_alert_rate`, `reply_ttl_alert_rate`, `topn_statistic_domain_enable`, `topn_cache_enable`, `learn_number`, `topn_statistic_sourceip_enable`, `sample_rate`, `topn_statistic_enable`, `format_check_ratio`, `direction`, `dns_enable`, `dns_lower_limit`, `dns_upper_limit`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'200',NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,'','','','',NULL,'','','',NULL,NULL,NULL,NULL,'','',NULL,'',NULL,'',NULL,'1',NULL,NULL,NULL);

insert into `t_vsm_zone_httpflood` (`service_id`, `http_block`, `http_defend_enable`, `http_rate_enable`, `http_alert_rate`, `http_source_auth_enable`, `max_times`, `timeout`, `finger_learn_enable`, `learn_period`, `match_times`, `http_uri_enable`, `detect_uri_enable`, `illegal_ratio_number`, `illegal_ratio_interval`, `illegal_minnum`, `defend_mode`, `behavior_detect_enable`, `detect_number`, `detect_interval`, `detect_minnum`, `limit_enable`, `limit_rate`, `host_filter_nable`, `host_filter_mode`, `host_filter_rate`, `http_user_finger_enable`, `http_after_auth_syn_enable`, `after_auth_syn_rate`, `after_auth_syn_action`, `http_after_auth_ack_enable`, `after_auth_ack_rate`, `after_auth_ack_action`, `http_dest_alertrate_enable`, `http_dest_qps_enable`, `http_dest_qps_alert_rate`, `http_proxy_enable`, `http_srcstatic_enable`, `http_src_mode`, `http_srcstatic_rate`, `http_src_qps_rate`, `http_webdetect_enable`, `web_title`, `slow_attack_enable`, `slow_check_packet_num`, `slow_conn_num`, `slow_content_length`, `slow_payload_length`, `http_first_packet_enable`, `http_lower_limit`, `http_upper_limit`, `direction`, `http_proxy_header_enable`, `http_proxy_header`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_httpflood` (`service_id`, `http_block`, `http_defend_enable`, `http_rate_enable`, `http_alert_rate`, `http_source_auth_enable`, `max_times`, `timeout`, `finger_learn_enable`, `learn_period`, `match_times`, `http_uri_enable`, `detect_uri_enable`, `illegal_ratio_number`, `illegal_ratio_interval`, `illegal_minnum`, `defend_mode`, `behavior_detect_enable`, `detect_number`, `detect_interval`, `detect_minnum`, `limit_enable`, `limit_rate`, `host_filter_nable`, `host_filter_mode`, `host_filter_rate`, `http_user_finger_enable`, `http_after_auth_syn_enable`, `after_auth_syn_rate`, `after_auth_syn_action`, `http_after_auth_ack_enable`, `after_auth_ack_rate`, `after_auth_ack_action`, `http_dest_alertrate_enable`, `http_dest_qps_enable`, `http_dest_qps_alert_rate`, `http_proxy_enable`, `http_srcstatic_enable`, `http_src_mode`, `http_srcstatic_rate`, `http_src_qps_rate`, `http_webdetect_enable`, `web_title`, `slow_attack_enable`, `slow_check_packet_num`, `slow_conn_num`, `slow_content_length`, `slow_payload_length`, `http_first_packet_enable`, `http_lower_limit`, `http_upper_limit`, `direction`, `http_proxy_header_enable`, `http_proxy_header`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_httpflood` (`service_id`, `http_block`, `http_defend_enable`, `http_rate_enable`, `http_alert_rate`, `http_source_auth_enable`, `max_times`, `timeout`, `finger_learn_enable`, `learn_period`, `match_times`, `http_uri_enable`, `detect_uri_enable`, `illegal_ratio_number`, `illegal_ratio_interval`, `illegal_minnum`, `defend_mode`, `behavior_detect_enable`, `detect_number`, `detect_interval`, `detect_minnum`, `limit_enable`, `limit_rate`, `host_filter_nable`, `host_filter_mode`, `host_filter_rate`, `http_user_finger_enable`, `http_after_auth_syn_enable`, `after_auth_syn_rate`, `after_auth_syn_action`, `http_after_auth_ack_enable`, `after_auth_ack_rate`, `after_auth_ack_action`, `http_dest_alertrate_enable`, `http_dest_qps_enable`, `http_dest_qps_alert_rate`, `http_proxy_enable`, `http_srcstatic_enable`, `http_src_mode`, `http_srcstatic_rate`, `http_src_qps_rate`, `http_webdetect_enable`, `web_title`, `slow_attack_enable`, `slow_check_packet_num`, `slow_conn_num`, `slow_content_length`, `slow_payload_length`, `http_first_packet_enable`, `http_lower_limit`, `http_upper_limit`, `direction`, `http_proxy_header_enable`, `http_proxy_header`) values(NULL,NULL,'',NULL,'8000','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','5000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_httpflood` (`service_id`, `http_block`, `http_defend_enable`, `http_rate_enable`, `http_alert_rate`, `http_source_auth_enable`, `max_times`, `timeout`, `finger_learn_enable`, `learn_period`, `match_times`, `http_uri_enable`, `detect_uri_enable`, `illegal_ratio_number`, `illegal_ratio_interval`, `illegal_minnum`, `defend_mode`, `behavior_detect_enable`, `detect_number`, `detect_interval`, `detect_minnum`, `limit_enable`, `limit_rate`, `host_filter_nable`, `host_filter_mode`, `host_filter_rate`, `http_user_finger_enable`, `http_after_auth_syn_enable`, `after_auth_syn_rate`, `after_auth_syn_action`, `http_after_auth_ack_enable`, `after_auth_ack_rate`, `after_auth_ack_action`, `http_dest_alertrate_enable`, `http_dest_qps_enable`, `http_dest_qps_alert_rate`, `http_proxy_enable`, `http_srcstatic_enable`, `http_src_mode`, `http_srcstatic_rate`, `http_src_qps_rate`, `http_webdetect_enable`, `web_title`, `slow_attack_enable`, `slow_check_packet_num`, `slow_conn_num`, `slow_content_length`, `slow_payload_length`, `http_first_packet_enable`, `http_lower_limit`, `http_upper_limit`, `direction`, `http_proxy_header_enable`, `http_proxy_header`) values(NULL,NULL,'',NULL,'8000','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','5000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_httpflood` (`service_id`, `http_block`, `http_defend_enable`, `http_rate_enable`, `http_alert_rate`, `http_source_auth_enable`, `max_times`, `timeout`, `finger_learn_enable`, `learn_period`, `match_times`, `http_uri_enable`, `detect_uri_enable`, `illegal_ratio_number`, `illegal_ratio_interval`, `illegal_minnum`, `defend_mode`, `behavior_detect_enable`, `detect_number`, `detect_interval`, `detect_minnum`, `limit_enable`, `limit_rate`, `host_filter_nable`, `host_filter_mode`, `host_filter_rate`, `http_user_finger_enable`, `http_after_auth_syn_enable`, `after_auth_syn_rate`, `after_auth_syn_action`, `http_after_auth_ack_enable`, `after_auth_ack_rate`, `after_auth_ack_action`, `http_dest_alertrate_enable`, `http_dest_qps_enable`, `http_dest_qps_alert_rate`, `http_proxy_enable`, `http_srcstatic_enable`, `http_src_mode`, `http_srcstatic_rate`, `http_src_qps_rate`, `http_webdetect_enable`, `web_title`, `slow_attack_enable`, `slow_check_packet_num`, `slow_conn_num`, `slow_content_length`, `slow_payload_length`, `http_first_packet_enable`, `http_lower_limit`, `http_upper_limit`, `direction`, `http_proxy_header_enable`, `http_proxy_header`) values(NULL,NULL,'',NULL,'8000','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','5000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_httpflood` (`service_id`, `http_block`, `http_defend_enable`, `http_rate_enable`, `http_alert_rate`, `http_source_auth_enable`, `max_times`, `timeout`, `finger_learn_enable`, `learn_period`, `match_times`, `http_uri_enable`, `detect_uri_enable`, `illegal_ratio_number`, `illegal_ratio_interval`, `illegal_minnum`, `defend_mode`, `behavior_detect_enable`, `detect_number`, `detect_interval`, `detect_minnum`, `limit_enable`, `limit_rate`, `host_filter_nable`, `host_filter_mode`, `host_filter_rate`, `http_user_finger_enable`, `http_after_auth_syn_enable`, `after_auth_syn_rate`, `after_auth_syn_action`, `http_after_auth_ack_enable`, `after_auth_ack_rate`, `after_auth_ack_action`, `http_dest_alertrate_enable`, `http_dest_qps_enable`, `http_dest_qps_alert_rate`, `http_proxy_enable`, `http_srcstatic_enable`, `http_src_mode`, `http_srcstatic_rate`, `http_src_qps_rate`, `http_webdetect_enable`, `web_title`, `slow_attack_enable`, `slow_check_packet_num`, `slow_conn_num`, `slow_content_length`, `slow_payload_length`, `http_first_packet_enable`, `http_lower_limit`, `http_upper_limit`, `direction`, `http_proxy_header_enable`, `http_proxy_header`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_httpflood` (`service_id`, `http_block`, `http_defend_enable`, `http_rate_enable`, `http_alert_rate`, `http_source_auth_enable`, `max_times`, `timeout`, `finger_learn_enable`, `learn_period`, `match_times`, `http_uri_enable`, `detect_uri_enable`, `illegal_ratio_number`, `illegal_ratio_interval`, `illegal_minnum`, `defend_mode`, `behavior_detect_enable`, `detect_number`, `detect_interval`, `detect_minnum`, `limit_enable`, `limit_rate`, `host_filter_nable`, `host_filter_mode`, `host_filter_rate`, `http_user_finger_enable`, `http_after_auth_syn_enable`, `after_auth_syn_rate`, `after_auth_syn_action`, `http_after_auth_ack_enable`, `after_auth_ack_rate`, `after_auth_ack_action`, `http_dest_alertrate_enable`, `http_dest_qps_enable`, `http_dest_qps_alert_rate`, `http_proxy_enable`, `http_srcstatic_enable`, `http_src_mode`, `http_srcstatic_rate`, `http_src_qps_rate`, `http_webdetect_enable`, `web_title`, `slow_attack_enable`, `slow_check_packet_num`, `slow_conn_num`, `slow_content_length`, `slow_payload_length`, `http_first_packet_enable`, `http_lower_limit`, `http_upper_limit`, `direction`, `http_proxy_header_enable`, `http_proxy_header`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_httpflood` (`service_id`, `http_block`, `http_defend_enable`, `http_rate_enable`, `http_alert_rate`, `http_source_auth_enable`, `max_times`, `timeout`, `finger_learn_enable`, `learn_period`, `match_times`, `http_uri_enable`, `detect_uri_enable`, `illegal_ratio_number`, `illegal_ratio_interval`, `illegal_minnum`, `defend_mode`, `behavior_detect_enable`, `detect_number`, `detect_interval`, `detect_minnum`, `limit_enable`, `limit_rate`, `host_filter_nable`, `host_filter_mode`, `host_filter_rate`, `http_user_finger_enable`, `http_after_auth_syn_enable`, `after_auth_syn_rate`, `after_auth_syn_action`, `http_after_auth_ack_enable`, `after_auth_ack_rate`, `after_auth_ack_action`, `http_dest_alertrate_enable`, `http_dest_qps_enable`, `http_dest_qps_alert_rate`, `http_proxy_enable`, `http_srcstatic_enable`, `http_src_mode`, `http_srcstatic_rate`, `http_src_qps_rate`, `http_webdetect_enable`, `web_title`, `slow_attack_enable`, `slow_check_packet_num`, `slow_conn_num`, `slow_content_length`, `slow_payload_length`, `http_first_packet_enable`, `http_lower_limit`, `http_upper_limit`, `direction`, `http_proxy_header_enable`, `http_proxy_header`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_httpflood` (`service_id`, `http_block`, `http_defend_enable`, `http_rate_enable`, `http_alert_rate`, `http_source_auth_enable`, `max_times`, `timeout`, `finger_learn_enable`, `learn_period`, `match_times`, `http_uri_enable`, `detect_uri_enable`, `illegal_ratio_number`, `illegal_ratio_interval`, `illegal_minnum`, `defend_mode`, `behavior_detect_enable`, `detect_number`, `detect_interval`, `detect_minnum`, `limit_enable`, `limit_rate`, `host_filter_nable`, `host_filter_mode`, `host_filter_rate`, `http_user_finger_enable`, `http_after_auth_syn_enable`, `after_auth_syn_rate`, `after_auth_syn_action`, `http_after_auth_ack_enable`, `after_auth_ack_rate`, `after_auth_ack_action`, `http_dest_alertrate_enable`, `http_dest_qps_enable`, `http_dest_qps_alert_rate`, `http_proxy_enable`, `http_srcstatic_enable`, `http_src_mode`, `http_srcstatic_rate`, `http_src_qps_rate`, `http_webdetect_enable`, `web_title`, `slow_attack_enable`, `slow_check_packet_num`, `slow_conn_num`, `slow_content_length`, `slow_payload_length`, `http_first_packet_enable`, `http_lower_limit`, `http_upper_limit`, `direction`, `http_proxy_header_enable`, `http_proxy_header`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);

insert into `t_vsm_zone_httpsflood` (`service_id`, `https_block`, `https_defend_enable`, `https_alert_rate`, `limit_enable`, `limit_rate`, `https_user_finger_enable`, `https_src_enable`, `https_src_mode`, `https_ssl_enable`, `https_nego_num`, `https_nego_interval`, `https_ill_num`, `https_ill_interval`, `https_srcstatic_enable`, `https_srcstatic_rate`, `direction`, `https_nego_check_enable`, `https_session_check_enable`, `https_decrypt_enable`, `https_decrypt_alert_rate`, `server_code_enable`, `server_code_period`, `server_code_times`, `finger_learn_enable`, `learn_period`, `match_times`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_httpsflood` (`service_id`, `https_block`, `https_defend_enable`, `https_alert_rate`, `limit_enable`, `limit_rate`, `https_user_finger_enable`, `https_src_enable`, `https_src_mode`, `https_ssl_enable`, `https_nego_num`, `https_nego_interval`, `https_ill_num`, `https_ill_interval`, `https_srcstatic_enable`, `https_srcstatic_rate`, `direction`, `https_nego_check_enable`, `https_session_check_enable`, `https_decrypt_enable`, `https_decrypt_alert_rate`, `server_code_enable`, `server_code_period`, `server_code_times`, `finger_learn_enable`, `learn_period`, `match_times`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_httpsflood` (`service_id`, `https_block`, `https_defend_enable`, `https_alert_rate`, `limit_enable`, `limit_rate`, `https_user_finger_enable`, `https_src_enable`, `https_src_mode`, `https_ssl_enable`, `https_nego_num`, `https_nego_interval`, `https_ill_num`, `https_ill_interval`, `https_srcstatic_enable`, `https_srcstatic_rate`, `direction`, `https_nego_check_enable`, `https_session_check_enable`, `https_decrypt_enable`, `https_decrypt_alert_rate`, `server_code_enable`, `server_code_period`, `server_code_times`, `finger_learn_enable`, `learn_period`, `match_times`) values(NULL,NULL,'','2000',NULL,NULL,NULL,'',NULL,'',NULL,NULL,'3','15',NULL,NULL,'1',NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_httpsflood` (`service_id`, `https_block`, `https_defend_enable`, `https_alert_rate`, `limit_enable`, `limit_rate`, `https_user_finger_enable`, `https_src_enable`, `https_src_mode`, `https_ssl_enable`, `https_nego_num`, `https_nego_interval`, `https_ill_num`, `https_ill_interval`, `https_srcstatic_enable`, `https_srcstatic_rate`, `direction`, `https_nego_check_enable`, `https_session_check_enable`, `https_decrypt_enable`, `https_decrypt_alert_rate`, `server_code_enable`, `server_code_period`, `server_code_times`, `finger_learn_enable`, `learn_period`, `match_times`) values(NULL,NULL,'','2000',NULL,NULL,NULL,'',NULL,'',NULL,NULL,'3','15',NULL,NULL,'1',NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_httpsflood` (`service_id`, `https_block`, `https_defend_enable`, `https_alert_rate`, `limit_enable`, `limit_rate`, `https_user_finger_enable`, `https_src_enable`, `https_src_mode`, `https_ssl_enable`, `https_nego_num`, `https_nego_interval`, `https_ill_num`, `https_ill_interval`, `https_srcstatic_enable`, `https_srcstatic_rate`, `direction`, `https_nego_check_enable`, `https_session_check_enable`, `https_decrypt_enable`, `https_decrypt_alert_rate`, `server_code_enable`, `server_code_period`, `server_code_times`, `finger_learn_enable`, `learn_period`, `match_times`) values(NULL,NULL,'','2000',NULL,NULL,NULL,'',NULL,'',NULL,NULL,'3','15',NULL,NULL,'1',NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_httpsflood` (`service_id`, `https_block`, `https_defend_enable`, `https_alert_rate`, `limit_enable`, `limit_rate`, `https_user_finger_enable`, `https_src_enable`, `https_src_mode`, `https_ssl_enable`, `https_nego_num`, `https_nego_interval`, `https_ill_num`, `https_ill_interval`, `https_srcstatic_enable`, `https_srcstatic_rate`, `direction`, `https_nego_check_enable`, `https_session_check_enable`, `https_decrypt_enable`, `https_decrypt_alert_rate`, `server_code_enable`, `server_code_period`, `server_code_times`, `finger_learn_enable`, `learn_period`, `match_times`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_httpsflood` (`service_id`, `https_block`, `https_defend_enable`, `https_alert_rate`, `limit_enable`, `limit_rate`, `https_user_finger_enable`, `https_src_enable`, `https_src_mode`, `https_ssl_enable`, `https_nego_num`, `https_nego_interval`, `https_ill_num`, `https_ill_interval`, `https_srcstatic_enable`, `https_srcstatic_rate`, `direction`, `https_nego_check_enable`, `https_session_check_enable`, `https_decrypt_enable`, `https_decrypt_alert_rate`, `server_code_enable`, `server_code_period`, `server_code_times`, `finger_learn_enable`, `learn_period`, `match_times`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_httpsflood` (`service_id`, `https_block`, `https_defend_enable`, `https_alert_rate`, `limit_enable`, `limit_rate`, `https_user_finger_enable`, `https_src_enable`, `https_src_mode`, `https_ssl_enable`, `https_nego_num`, `https_nego_interval`, `https_ill_num`, `https_ill_interval`, `https_srcstatic_enable`, `https_srcstatic_rate`, `direction`, `https_nego_check_enable`, `https_session_check_enable`, `https_decrypt_enable`, `https_decrypt_alert_rate`, `server_code_enable`, `server_code_period`, `server_code_times`, `finger_learn_enable`, `learn_period`, `match_times`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_httpsflood` (`service_id`, `https_block`, `https_defend_enable`, `https_alert_rate`, `limit_enable`, `limit_rate`, `https_user_finger_enable`, `https_src_enable`, `https_src_mode`, `https_ssl_enable`, `https_nego_num`, `https_nego_interval`, `https_ill_num`, `https_ill_interval`, `https_srcstatic_enable`, `https_srcstatic_rate`, `direction`, `https_nego_check_enable`, `https_session_check_enable`, `https_decrypt_enable`, `https_decrypt_alert_rate`, `server_code_enable`, `server_code_period`, `server_code_times`, `finger_learn_enable`, `learn_period`, `match_times`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

insert into `t_vsm_zone_icmpflood` (`service_id`, `icmp_block_enable`, `icmp_defend_enable`, `icmp_max_speed_enable`, `icmp_max_speed`, `icmp_userfinger_enable`, `icmp_new_destsession_limit_enable`, `icmp_new_destsession_limit`, `icmp_limitsub_enable`, `direction`) values(NULL,NULL,NULL,'','200',NULL,NULL,NULL,'','1');
insert into `t_vsm_zone_icmpflood` (`service_id`, `icmp_block_enable`, `icmp_defend_enable`, `icmp_max_speed_enable`, `icmp_max_speed`, `icmp_userfinger_enable`, `icmp_new_destsession_limit_enable`, `icmp_new_destsession_limit`, `icmp_limitsub_enable`, `direction`) values(NULL,NULL,NULL,'','200',NULL,NULL,NULL,'','1');
insert into `t_vsm_zone_icmpflood` (`service_id`, `icmp_block_enable`, `icmp_defend_enable`, `icmp_max_speed_enable`, `icmp_max_speed`, `icmp_userfinger_enable`, `icmp_new_destsession_limit_enable`, `icmp_new_destsession_limit`, `icmp_limitsub_enable`, `direction`) values(NULL,NULL,NULL,'','200',NULL,NULL,NULL,'','1');
insert into `t_vsm_zone_icmpflood` (`service_id`, `icmp_block_enable`, `icmp_defend_enable`, `icmp_max_speed_enable`, `icmp_max_speed`, `icmp_userfinger_enable`, `icmp_new_destsession_limit_enable`, `icmp_new_destsession_limit`, `icmp_limitsub_enable`, `direction`) values(NULL,NULL,NULL,'','200',NULL,NULL,NULL,'','1');
insert into `t_vsm_zone_icmpflood` (`service_id`, `icmp_block_enable`, `icmp_defend_enable`, `icmp_max_speed_enable`, `icmp_max_speed`, `icmp_userfinger_enable`, `icmp_new_destsession_limit_enable`, `icmp_new_destsession_limit`, `icmp_limitsub_enable`, `direction`) values(NULL,NULL,NULL,'','200',NULL,NULL,NULL,'','1');
insert into `t_vsm_zone_icmpflood` (`service_id`, `icmp_block_enable`, `icmp_defend_enable`, `icmp_max_speed_enable`, `icmp_max_speed`, `icmp_userfinger_enable`, `icmp_new_destsession_limit_enable`, `icmp_new_destsession_limit`, `icmp_limitsub_enable`, `direction`) values(NULL,NULL,NULL,'','200',NULL,NULL,NULL,'','1');
insert into `t_vsm_zone_icmpflood` (`service_id`, `icmp_block_enable`, `icmp_defend_enable`, `icmp_max_speed_enable`, `icmp_max_speed`, `icmp_userfinger_enable`, `icmp_new_destsession_limit_enable`, `icmp_new_destsession_limit`, `icmp_limitsub_enable`, `direction`) values(NULL,NULL,NULL,'','200',NULL,NULL,NULL,'','1');
insert into `t_vsm_zone_icmpflood` (`service_id`, `icmp_block_enable`, `icmp_defend_enable`, `icmp_max_speed_enable`, `icmp_max_speed`, `icmp_userfinger_enable`, `icmp_new_destsession_limit_enable`, `icmp_new_destsession_limit`, `icmp_limitsub_enable`, `direction`) values(NULL,NULL,NULL,'','200',NULL,NULL,NULL,'','1');
insert into `t_vsm_zone_icmpflood` (`service_id`, `icmp_block_enable`, `icmp_defend_enable`, `icmp_max_speed_enable`, `icmp_max_speed`, `icmp_userfinger_enable`, `icmp_new_destsession_limit_enable`, `icmp_new_destsession_limit`, `icmp_limitsub_enable`, `direction`) values(NULL,NULL,NULL,'','200',NULL,NULL,NULL,'','1');

insert into `t_vsm_zone_otherflood` (`service_id`, `other_block`, `other_defend_enable`, `other_alert_rate`, `car_defence_enable`, `car_alert_rate`, `other_defence_enable`, `finger_learn_enable`, `finger_alert`, `learn_mode`, `offset`, `finger_length`, `other_limitsub_enable`, `direction`, `other_new_destsession_limit_enable`, `other_new_destsession_limit`) values(NULL,NULL,'','5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','1',NULL,NULL);
insert into `t_vsm_zone_otherflood` (`service_id`, `other_block`, `other_defend_enable`, `other_alert_rate`, `car_defence_enable`, `car_alert_rate`, `other_defence_enable`, `finger_learn_enable`, `finger_alert`, `learn_mode`, `offset`, `finger_length`, `other_limitsub_enable`, `direction`, `other_new_destsession_limit_enable`, `other_new_destsession_limit`) values(NULL,NULL,'','5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','1',NULL,NULL);
insert into `t_vsm_zone_otherflood` (`service_id`, `other_block`, `other_defend_enable`, `other_alert_rate`, `car_defence_enable`, `car_alert_rate`, `other_defence_enable`, `finger_learn_enable`, `finger_alert`, `learn_mode`, `offset`, `finger_length`, `other_limitsub_enable`, `direction`, `other_new_destsession_limit_enable`, `other_new_destsession_limit`) values(NULL,NULL,'','5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','1',NULL,NULL);
insert into `t_vsm_zone_otherflood` (`service_id`, `other_block`, `other_defend_enable`, `other_alert_rate`, `car_defence_enable`, `car_alert_rate`, `other_defence_enable`, `finger_learn_enable`, `finger_alert`, `learn_mode`, `offset`, `finger_length`, `other_limitsub_enable`, `direction`, `other_new_destsession_limit_enable`, `other_new_destsession_limit`) values(NULL,NULL,'','5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','1',NULL,NULL);
insert into `t_vsm_zone_otherflood` (`service_id`, `other_block`, `other_defend_enable`, `other_alert_rate`, `car_defence_enable`, `car_alert_rate`, `other_defence_enable`, `finger_learn_enable`, `finger_alert`, `learn_mode`, `offset`, `finger_length`, `other_limitsub_enable`, `direction`, `other_new_destsession_limit_enable`, `other_new_destsession_limit`) values(NULL,NULL,'','10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','1',NULL,NULL);
insert into `t_vsm_zone_otherflood` (`service_id`, `other_block`, `other_defend_enable`, `other_alert_rate`, `car_defence_enable`, `car_alert_rate`, `other_defence_enable`, `finger_learn_enable`, `finger_alert`, `learn_mode`, `offset`, `finger_length`, `other_limitsub_enable`, `direction`, `other_new_destsession_limit_enable`, `other_new_destsession_limit`) values(NULL,NULL,'','5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','1',NULL,NULL);
insert into `t_vsm_zone_otherflood` (`service_id`, `other_block`, `other_defend_enable`, `other_alert_rate`, `car_defence_enable`, `car_alert_rate`, `other_defence_enable`, `finger_learn_enable`, `finger_alert`, `learn_mode`, `offset`, `finger_length`, `other_limitsub_enable`, `direction`, `other_new_destsession_limit_enable`, `other_new_destsession_limit`) values(NULL,NULL,'','5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','1',NULL,NULL);
insert into `t_vsm_zone_otherflood` (`service_id`, `other_block`, `other_defend_enable`, `other_alert_rate`, `car_defence_enable`, `car_alert_rate`, `other_defence_enable`, `finger_learn_enable`, `finger_alert`, `learn_mode`, `offset`, `finger_length`, `other_limitsub_enable`, `direction`, `other_new_destsession_limit_enable`, `other_new_destsession_limit`) values(NULL,NULL,'','5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','1',NULL,NULL);
insert into `t_vsm_zone_otherflood` (`service_id`, `other_block`, `other_defend_enable`, `other_alert_rate`, `car_defence_enable`, `car_alert_rate`, `other_defence_enable`, `finger_learn_enable`, `finger_alert`, `learn_mode`, `offset`, `finger_length`, `other_limitsub_enable`, `direction`, `other_new_destsession_limit_enable`, `other_new_destsession_limit`) values(NULL,NULL,'','5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','1',NULL,NULL);

insert into `t_vsm_zone_sipflood` (`service_id`, `sip_block`, `sip_defend_enable`, `sip_alert_rate`, `limit_enable`, `limit_rate`, `sip_src_detect_enable`, `sip_srcip_limit_enable`, `sip_src_other_limit_enable`, `sip_src_other_limit_mode`, `sip_src_other_rate`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_sipflood` (`service_id`, `sip_block`, `sip_defend_enable`, `sip_alert_rate`, `limit_enable`, `limit_rate`, `sip_src_detect_enable`, `sip_srcip_limit_enable`, `sip_src_other_limit_enable`, `sip_src_other_limit_mode`, `sip_src_other_rate`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_sipflood` (`service_id`, `sip_block`, `sip_defend_enable`, `sip_alert_rate`, `limit_enable`, `limit_rate`, `sip_src_detect_enable`, `sip_srcip_limit_enable`, `sip_src_other_limit_enable`, `sip_src_other_limit_mode`, `sip_src_other_rate`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_sipflood` (`service_id`, `sip_block`, `sip_defend_enable`, `sip_alert_rate`, `limit_enable`, `limit_rate`, `sip_src_detect_enable`, `sip_srcip_limit_enable`, `sip_src_other_limit_enable`, `sip_src_other_limit_mode`, `sip_src_other_rate`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_sipflood` (`service_id`, `sip_block`, `sip_defend_enable`, `sip_alert_rate`, `limit_enable`, `limit_rate`, `sip_src_detect_enable`, `sip_srcip_limit_enable`, `sip_src_other_limit_enable`, `sip_src_other_limit_mode`, `sip_src_other_rate`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_sipflood` (`service_id`, `sip_block`, `sip_defend_enable`, `sip_alert_rate`, `limit_enable`, `limit_rate`, `sip_src_detect_enable`, `sip_srcip_limit_enable`, `sip_src_other_limit_enable`, `sip_src_other_limit_mode`, `sip_src_other_rate`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_sipflood` (`service_id`, `sip_block`, `sip_defend_enable`, `sip_alert_rate`, `limit_enable`, `limit_rate`, `sip_src_detect_enable`, `sip_srcip_limit_enable`, `sip_src_other_limit_enable`, `sip_src_other_limit_mode`, `sip_src_other_rate`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_sipflood` (`service_id`, `sip_block`, `sip_defend_enable`, `sip_alert_rate`, `limit_enable`, `limit_rate`, `sip_src_detect_enable`, `sip_srcip_limit_enable`, `sip_src_other_limit_enable`, `sip_src_other_limit_mode`, `sip_src_other_rate`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_sipflood` (`service_id`, `sip_block`, `sip_defend_enable`, `sip_alert_rate`, `limit_enable`, `limit_rate`, `sip_src_detect_enable`, `sip_srcip_limit_enable`, `sip_src_other_limit_enable`, `sip_src_other_limit_mode`, `sip_src_other_rate`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');

insert into `t_vsm_zone_tcpflood` (`service_id`, `tcp_block`, `tcp_defend_enable`, `tcp_proxy_enable`, `tcp_proxy_rate`, `tcp_basic_enable`, `synflood_enable`, `synflood_mode`, `synflood_alert_rate`, `syn_ack_flood_enable`, `syn_ack_flood_alert_rate`, `ack_flood_enable`, `ack_flood_mode`, `ack_flood_alert_rate`, `tcp_frag_enable`, `tcp_frag_mode`, `tcp_frag_alert_rate`, `fin_rst_flood_enable`, `fin_rst_flood_alert_rate`, `tcp_ratio_enable`, `tcp_ratio_protion`, `tcp_ratio_limit_mode`, `tcp_ratio_limit_rate`, `tcp_limit_enable`, `tcp_limit_sub_enable`, `max_speed`, `tcp_frag_limit_enable`, `frag_max_speed`, `tcp_conn_enable`, `tcp_desttip_enable`, `tcp_desttip_num`, `tcp_new_destip_enable`, `tcp_new_destip_rate`, `tcp_srctip_enable`, `tcp_srctip_num`, `tcp_new_srctip_enable`, `tcp_new_srctip_rate`, `tcp_new_srctip_interval`, `illegal_session_enable`, `window_size_check_enable`, `window_size`, `illegal_conn_enable`, `illegal_min_conn_num_enable`, `illegal_conn_num`, `sack_check_enable`, `sack_check_max_number`, `illegal_conn_num_interval`, `illegal_conn_count`, `illegal_conn_count_interval`, `tcp_abnormal_enable`, `tcp_abnormal_alert_rate`, `defend_mode`, `slow_con_dectect_enable`, `detect_number`, `detect_interval`, `ack_session_check_enable`, `ack_content_check_enable`, `mssCheck_enable`, `syn_ratio_enable`, `syn_ratio_limit_rate`, `syn_ratio_duration`, `syn_max_packets`, `syn_max_packets_duration`, `tcp_new_destsession_limit_enable`, `tcp_new_destsession_limit`, `direction`, `first_packet_check_lower_limit`, `first_packet_check_upper_limit`, `tcp_enable`, `tcp_lower_limit`, `tcp_upper_limit`, `synfirst_packet_check_enable`, `syn_ratio_limit_packets`, `syn_blacklist_enable`, `syn_exception_times`, `syn_total_check_times`, `session_check_enable`, `session_conn_rate`, `session_check_duration`, `ack_check_enable`, `ack_min_packets_num`, `big_packet_length`, `big_packet_ratio`, `syn_check_enable`, `syn_packets_num`, `synflood_defendmode_enable`, `synack_firstpacket_enable`, `synack_lower_limit`, `synack_upper_limit`, `synack_source_enable`, `source_limit_enable`, `source_limit_bandwidth_enable`, `source_limit_bandwidth_rate`, `source_limit_packets_enable`, `source_limit_packets_rate`, `source_limit_illegal_times`, `source_limit_total_times`, `source_limit_interval`) values(NULL,NULL,'',NULL,'1000','','','1','2000','','500','','1','10000','','0','200','','2000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'5000',NULL,'500','','150','','120','3','',NULL,NULL,NULL,'','1',NULL,NULL,'30','30','15','','200','0',NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','6',NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','0','6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_tcpflood` (`service_id`, `tcp_block`, `tcp_defend_enable`, `tcp_proxy_enable`, `tcp_proxy_rate`, `tcp_basic_enable`, `synflood_enable`, `synflood_mode`, `synflood_alert_rate`, `syn_ack_flood_enable`, `syn_ack_flood_alert_rate`, `ack_flood_enable`, `ack_flood_mode`, `ack_flood_alert_rate`, `tcp_frag_enable`, `tcp_frag_mode`, `tcp_frag_alert_rate`, `fin_rst_flood_enable`, `fin_rst_flood_alert_rate`, `tcp_ratio_enable`, `tcp_ratio_protion`, `tcp_ratio_limit_mode`, `tcp_ratio_limit_rate`, `tcp_limit_enable`, `tcp_limit_sub_enable`, `max_speed`, `tcp_frag_limit_enable`, `frag_max_speed`, `tcp_conn_enable`, `tcp_desttip_enable`, `tcp_desttip_num`, `tcp_new_destip_enable`, `tcp_new_destip_rate`, `tcp_srctip_enable`, `tcp_srctip_num`, `tcp_new_srctip_enable`, `tcp_new_srctip_rate`, `tcp_new_srctip_interval`, `illegal_session_enable`, `window_size_check_enable`, `window_size`, `illegal_conn_enable`, `illegal_min_conn_num_enable`, `illegal_conn_num`, `sack_check_enable`, `sack_check_max_number`, `illegal_conn_num_interval`, `illegal_conn_count`, `illegal_conn_count_interval`, `tcp_abnormal_enable`, `tcp_abnormal_alert_rate`, `defend_mode`, `slow_con_dectect_enable`, `detect_number`, `detect_interval`, `ack_session_check_enable`, `ack_content_check_enable`, `mssCheck_enable`, `syn_ratio_enable`, `syn_ratio_limit_rate`, `syn_ratio_duration`, `syn_max_packets`, `syn_max_packets_duration`, `tcp_new_destsession_limit_enable`, `tcp_new_destsession_limit`, `direction`, `first_packet_check_lower_limit`, `first_packet_check_upper_limit`, `tcp_enable`, `tcp_lower_limit`, `tcp_upper_limit`, `synfirst_packet_check_enable`, `syn_ratio_limit_packets`, `syn_blacklist_enable`, `syn_exception_times`, `syn_total_check_times`, `session_check_enable`, `session_conn_rate`, `session_check_duration`, `ack_check_enable`, `ack_min_packets_num`, `big_packet_length`, `big_packet_ratio`, `syn_check_enable`, `syn_packets_num`, `synflood_defendmode_enable`, `synack_firstpacket_enable`, `synack_lower_limit`, `synack_upper_limit`, `synack_source_enable`, `source_limit_enable`, `source_limit_bandwidth_enable`, `source_limit_bandwidth_rate`, `source_limit_packets_enable`, `source_limit_packets_rate`, `source_limit_illegal_times`, `source_limit_total_times`, `source_limit_interval`) values(NULL,NULL,'',NULL,'1000','','','1','2000','','500','','1','10000','','0','200','','2000',NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'5000',NULL,'500','','100','','80','3','',NULL,NULL,NULL,'','1',NULL,NULL,'30','30','15','','200','0',NULL,NULL,NULL,'',NULL,NULL,'','80','3','20','3',NULL,NULL,'1','1','6',NULL,NULL,NULL,'','20','','3','10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','0','6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_tcpflood` (`service_id`, `tcp_block`, `tcp_defend_enable`, `tcp_proxy_enable`, `tcp_proxy_rate`, `tcp_basic_enable`, `synflood_enable`, `synflood_mode`, `synflood_alert_rate`, `syn_ack_flood_enable`, `syn_ack_flood_alert_rate`, `ack_flood_enable`, `ack_flood_mode`, `ack_flood_alert_rate`, `tcp_frag_enable`, `tcp_frag_mode`, `tcp_frag_alert_rate`, `fin_rst_flood_enable`, `fin_rst_flood_alert_rate`, `tcp_ratio_enable`, `tcp_ratio_protion`, `tcp_ratio_limit_mode`, `tcp_ratio_limit_rate`, `tcp_limit_enable`, `tcp_limit_sub_enable`, `max_speed`, `tcp_frag_limit_enable`, `frag_max_speed`, `tcp_conn_enable`, `tcp_desttip_enable`, `tcp_desttip_num`, `tcp_new_destip_enable`, `tcp_new_destip_rate`, `tcp_srctip_enable`, `tcp_srctip_num`, `tcp_new_srctip_enable`, `tcp_new_srctip_rate`, `tcp_new_srctip_interval`, `illegal_session_enable`, `window_size_check_enable`, `window_size`, `illegal_conn_enable`, `illegal_min_conn_num_enable`, `illegal_conn_num`, `sack_check_enable`, `sack_check_max_number`, `illegal_conn_num_interval`, `illegal_conn_count`, `illegal_conn_count_interval`, `tcp_abnormal_enable`, `tcp_abnormal_alert_rate`, `defend_mode`, `slow_con_dectect_enable`, `detect_number`, `detect_interval`, `ack_session_check_enable`, `ack_content_check_enable`, `mssCheck_enable`, `syn_ratio_enable`, `syn_ratio_limit_rate`, `syn_ratio_duration`, `syn_max_packets`, `syn_max_packets_duration`, `tcp_new_destsession_limit_enable`, `tcp_new_destsession_limit`, `direction`, `first_packet_check_lower_limit`, `first_packet_check_upper_limit`, `tcp_enable`, `tcp_lower_limit`, `tcp_upper_limit`, `synfirst_packet_check_enable`, `syn_ratio_limit_packets`, `syn_blacklist_enable`, `syn_exception_times`, `syn_total_check_times`, `session_check_enable`, `session_conn_rate`, `session_check_duration`, `ack_check_enable`, `ack_min_packets_num`, `big_packet_length`, `big_packet_ratio`, `syn_check_enable`, `syn_packets_num`, `synflood_defendmode_enable`, `synack_firstpacket_enable`, `synack_lower_limit`, `synack_upper_limit`, `synack_source_enable`, `source_limit_enable`, `source_limit_bandwidth_enable`, `source_limit_bandwidth_rate`, `source_limit_packets_enable`, `source_limit_packets_rate`, `source_limit_illegal_times`, `source_limit_total_times`, `source_limit_interval`) values(NULL,NULL,'',NULL,'1000','','','1','2000','','500','','1','20000','','0','200','','2000',NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'10000',NULL,'1000','','200','','150','3','',NULL,NULL,NULL,'','1',NULL,NULL,'10','30','15','','200','0',NULL,NULL,NULL,'',NULL,NULL,'','90','10','200','10',NULL,NULL,'1','1','6',NULL,NULL,NULL,'','200','','3','10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','0','6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_tcpflood` (`service_id`, `tcp_block`, `tcp_defend_enable`, `tcp_proxy_enable`, `tcp_proxy_rate`, `tcp_basic_enable`, `synflood_enable`, `synflood_mode`, `synflood_alert_rate`, `syn_ack_flood_enable`, `syn_ack_flood_alert_rate`, `ack_flood_enable`, `ack_flood_mode`, `ack_flood_alert_rate`, `tcp_frag_enable`, `tcp_frag_mode`, `tcp_frag_alert_rate`, `fin_rst_flood_enable`, `fin_rst_flood_alert_rate`, `tcp_ratio_enable`, `tcp_ratio_protion`, `tcp_ratio_limit_mode`, `tcp_ratio_limit_rate`, `tcp_limit_enable`, `tcp_limit_sub_enable`, `max_speed`, `tcp_frag_limit_enable`, `frag_max_speed`, `tcp_conn_enable`, `tcp_desttip_enable`, `tcp_desttip_num`, `tcp_new_destip_enable`, `tcp_new_destip_rate`, `tcp_srctip_enable`, `tcp_srctip_num`, `tcp_new_srctip_enable`, `tcp_new_srctip_rate`, `tcp_new_srctip_interval`, `illegal_session_enable`, `window_size_check_enable`, `window_size`, `illegal_conn_enable`, `illegal_min_conn_num_enable`, `illegal_conn_num`, `sack_check_enable`, `sack_check_max_number`, `illegal_conn_num_interval`, `illegal_conn_count`, `illegal_conn_count_interval`, `tcp_abnormal_enable`, `tcp_abnormal_alert_rate`, `defend_mode`, `slow_con_dectect_enable`, `detect_number`, `detect_interval`, `ack_session_check_enable`, `ack_content_check_enable`, `mssCheck_enable`, `syn_ratio_enable`, `syn_ratio_limit_rate`, `syn_ratio_duration`, `syn_max_packets`, `syn_max_packets_duration`, `tcp_new_destsession_limit_enable`, `tcp_new_destsession_limit`, `direction`, `first_packet_check_lower_limit`, `first_packet_check_upper_limit`, `tcp_enable`, `tcp_lower_limit`, `tcp_upper_limit`, `synfirst_packet_check_enable`, `syn_ratio_limit_packets`, `syn_blacklist_enable`, `syn_exception_times`, `syn_total_check_times`, `session_check_enable`, `session_conn_rate`, `session_check_duration`, `ack_check_enable`, `ack_min_packets_num`, `big_packet_length`, `big_packet_ratio`, `syn_check_enable`, `syn_packets_num`, `synflood_defendmode_enable`, `synack_firstpacket_enable`, `synack_lower_limit`, `synack_upper_limit`, `synack_source_enable`, `source_limit_enable`, `source_limit_bandwidth_enable`, `source_limit_bandwidth_rate`, `source_limit_packets_enable`, `source_limit_packets_rate`, `source_limit_illegal_times`, `source_limit_total_times`, `source_limit_interval`) values(NULL,NULL,'',NULL,'1000','','','1','2000','','500','','1','20000','','0','200','','2000',NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'10000',NULL,'1000','','200','','150','3','',NULL,NULL,NULL,'','1',NULL,NULL,'10','30','15','','200','0',NULL,NULL,NULL,'',NULL,NULL,'','90','10','200','10',NULL,NULL,'1','1','6',NULL,NULL,NULL,'','200','','3','10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','0','6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_tcpflood` (`service_id`, `tcp_block`, `tcp_defend_enable`, `tcp_proxy_enable`, `tcp_proxy_rate`, `tcp_basic_enable`, `synflood_enable`, `synflood_mode`, `synflood_alert_rate`, `syn_ack_flood_enable`, `syn_ack_flood_alert_rate`, `ack_flood_enable`, `ack_flood_mode`, `ack_flood_alert_rate`, `tcp_frag_enable`, `tcp_frag_mode`, `tcp_frag_alert_rate`, `fin_rst_flood_enable`, `fin_rst_flood_alert_rate`, `tcp_ratio_enable`, `tcp_ratio_protion`, `tcp_ratio_limit_mode`, `tcp_ratio_limit_rate`, `tcp_limit_enable`, `tcp_limit_sub_enable`, `max_speed`, `tcp_frag_limit_enable`, `frag_max_speed`, `tcp_conn_enable`, `tcp_desttip_enable`, `tcp_desttip_num`, `tcp_new_destip_enable`, `tcp_new_destip_rate`, `tcp_srctip_enable`, `tcp_srctip_num`, `tcp_new_srctip_enable`, `tcp_new_srctip_rate`, `tcp_new_srctip_interval`, `illegal_session_enable`, `window_size_check_enable`, `window_size`, `illegal_conn_enable`, `illegal_min_conn_num_enable`, `illegal_conn_num`, `sack_check_enable`, `sack_check_max_number`, `illegal_conn_num_interval`, `illegal_conn_count`, `illegal_conn_count_interval`, `tcp_abnormal_enable`, `tcp_abnormal_alert_rate`, `defend_mode`, `slow_con_dectect_enable`, `detect_number`, `detect_interval`, `ack_session_check_enable`, `ack_content_check_enable`, `mssCheck_enable`, `syn_ratio_enable`, `syn_ratio_limit_rate`, `syn_ratio_duration`, `syn_max_packets`, `syn_max_packets_duration`, `tcp_new_destsession_limit_enable`, `tcp_new_destsession_limit`, `direction`, `first_packet_check_lower_limit`, `first_packet_check_upper_limit`, `tcp_enable`, `tcp_lower_limit`, `tcp_upper_limit`, `synfirst_packet_check_enable`, `syn_ratio_limit_packets`, `syn_blacklist_enable`, `syn_exception_times`, `syn_total_check_times`, `session_check_enable`, `session_conn_rate`, `session_check_duration`, `ack_check_enable`, `ack_min_packets_num`, `big_packet_length`, `big_packet_ratio`, `syn_check_enable`, `syn_packets_num`, `synflood_defendmode_enable`, `synack_firstpacket_enable`, `synack_lower_limit`, `synack_upper_limit`, `synack_source_enable`, `source_limit_enable`, `source_limit_bandwidth_enable`, `source_limit_bandwidth_rate`, `source_limit_packets_enable`, `source_limit_packets_rate`, `source_limit_illegal_times`, `source_limit_total_times`, `source_limit_interval`) values(NULL,NULL,'',NULL,'1000','','','1','2000','','500','','1','20000','','0','200','','2000',NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'5000',NULL,'500','','200','','150','3','',NULL,NULL,NULL,'','1',NULL,NULL,'10','30','15','','200','0',NULL,NULL,NULL,'',NULL,NULL,'','90','10','200','10',NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,'200','','3','10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','0','6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_tcpflood` (`service_id`, `tcp_block`, `tcp_defend_enable`, `tcp_proxy_enable`, `tcp_proxy_rate`, `tcp_basic_enable`, `synflood_enable`, `synflood_mode`, `synflood_alert_rate`, `syn_ack_flood_enable`, `syn_ack_flood_alert_rate`, `ack_flood_enable`, `ack_flood_mode`, `ack_flood_alert_rate`, `tcp_frag_enable`, `tcp_frag_mode`, `tcp_frag_alert_rate`, `fin_rst_flood_enable`, `fin_rst_flood_alert_rate`, `tcp_ratio_enable`, `tcp_ratio_protion`, `tcp_ratio_limit_mode`, `tcp_ratio_limit_rate`, `tcp_limit_enable`, `tcp_limit_sub_enable`, `max_speed`, `tcp_frag_limit_enable`, `frag_max_speed`, `tcp_conn_enable`, `tcp_desttip_enable`, `tcp_desttip_num`, `tcp_new_destip_enable`, `tcp_new_destip_rate`, `tcp_srctip_enable`, `tcp_srctip_num`, `tcp_new_srctip_enable`, `tcp_new_srctip_rate`, `tcp_new_srctip_interval`, `illegal_session_enable`, `window_size_check_enable`, `window_size`, `illegal_conn_enable`, `illegal_min_conn_num_enable`, `illegal_conn_num`, `sack_check_enable`, `sack_check_max_number`, `illegal_conn_num_interval`, `illegal_conn_count`, `illegal_conn_count_interval`, `tcp_abnormal_enable`, `tcp_abnormal_alert_rate`, `defend_mode`, `slow_con_dectect_enable`, `detect_number`, `detect_interval`, `ack_session_check_enable`, `ack_content_check_enable`, `mssCheck_enable`, `syn_ratio_enable`, `syn_ratio_limit_rate`, `syn_ratio_duration`, `syn_max_packets`, `syn_max_packets_duration`, `tcp_new_destsession_limit_enable`, `tcp_new_destsession_limit`, `direction`, `first_packet_check_lower_limit`, `first_packet_check_upper_limit`, `tcp_enable`, `tcp_lower_limit`, `tcp_upper_limit`, `synfirst_packet_check_enable`, `syn_ratio_limit_packets`, `syn_blacklist_enable`, `syn_exception_times`, `syn_total_check_times`, `session_check_enable`, `session_conn_rate`, `session_check_duration`, `ack_check_enable`, `ack_min_packets_num`, `big_packet_length`, `big_packet_ratio`, `syn_check_enable`, `syn_packets_num`, `synflood_defendmode_enable`, `synack_firstpacket_enable`, `synack_lower_limit`, `synack_upper_limit`, `synack_source_enable`, `source_limit_enable`, `source_limit_bandwidth_enable`, `source_limit_bandwidth_rate`, `source_limit_packets_enable`, `source_limit_packets_rate`, `source_limit_illegal_times`, `source_limit_total_times`, `source_limit_interval`) values(NULL,NULL,'',NULL,'1000','','','1','500','','500','','1','2000','','0','200','','500',NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'500',NULL,'100','','30','','20','3','',NULL,NULL,NULL,'','1',NULL,NULL,'10','30','5','','200','0',NULL,NULL,NULL,'',NULL,NULL,'','80','3','20','3',NULL,NULL,'1','1','6',NULL,NULL,NULL,'','20','','3','10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','0','6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_tcpflood` (`service_id`, `tcp_block`, `tcp_defend_enable`, `tcp_proxy_enable`, `tcp_proxy_rate`, `tcp_basic_enable`, `synflood_enable`, `synflood_mode`, `synflood_alert_rate`, `syn_ack_flood_enable`, `syn_ack_flood_alert_rate`, `ack_flood_enable`, `ack_flood_mode`, `ack_flood_alert_rate`, `tcp_frag_enable`, `tcp_frag_mode`, `tcp_frag_alert_rate`, `fin_rst_flood_enable`, `fin_rst_flood_alert_rate`, `tcp_ratio_enable`, `tcp_ratio_protion`, `tcp_ratio_limit_mode`, `tcp_ratio_limit_rate`, `tcp_limit_enable`, `tcp_limit_sub_enable`, `max_speed`, `tcp_frag_limit_enable`, `frag_max_speed`, `tcp_conn_enable`, `tcp_desttip_enable`, `tcp_desttip_num`, `tcp_new_destip_enable`, `tcp_new_destip_rate`, `tcp_srctip_enable`, `tcp_srctip_num`, `tcp_new_srctip_enable`, `tcp_new_srctip_rate`, `tcp_new_srctip_interval`, `illegal_session_enable`, `window_size_check_enable`, `window_size`, `illegal_conn_enable`, `illegal_min_conn_num_enable`, `illegal_conn_num`, `sack_check_enable`, `sack_check_max_number`, `illegal_conn_num_interval`, `illegal_conn_count`, `illegal_conn_count_interval`, `tcp_abnormal_enable`, `tcp_abnormal_alert_rate`, `defend_mode`, `slow_con_dectect_enable`, `detect_number`, `detect_interval`, `ack_session_check_enable`, `ack_content_check_enable`, `mssCheck_enable`, `syn_ratio_enable`, `syn_ratio_limit_rate`, `syn_ratio_duration`, `syn_max_packets`, `syn_max_packets_duration`, `tcp_new_destsession_limit_enable`, `tcp_new_destsession_limit`, `direction`, `first_packet_check_lower_limit`, `first_packet_check_upper_limit`, `tcp_enable`, `tcp_lower_limit`, `tcp_upper_limit`, `synfirst_packet_check_enable`, `syn_ratio_limit_packets`, `syn_blacklist_enable`, `syn_exception_times`, `syn_total_check_times`, `session_check_enable`, `session_conn_rate`, `session_check_duration`, `ack_check_enable`, `ack_min_packets_num`, `big_packet_length`, `big_packet_ratio`, `syn_check_enable`, `syn_packets_num`, `synflood_defendmode_enable`, `synack_firstpacket_enable`, `synack_lower_limit`, `synack_upper_limit`, `synack_source_enable`, `source_limit_enable`, `source_limit_bandwidth_enable`, `source_limit_bandwidth_rate`, `source_limit_packets_enable`, `source_limit_packets_rate`, `source_limit_illegal_times`, `source_limit_total_times`, `source_limit_interval`) values(NULL,NULL,'',NULL,'1000','','','1','500','','500','','1','2000','','0','200','','500',NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'500',NULL,'100','','30','','20','3','',NULL,NULL,NULL,'','1',NULL,NULL,'10','30','5','','200','0',NULL,NULL,NULL,'',NULL,NULL,'','80','3','20','3',NULL,NULL,'1','1','6',NULL,NULL,NULL,'','20','','3','10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','0','6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_tcpflood` (`service_id`, `tcp_block`, `tcp_defend_enable`, `tcp_proxy_enable`, `tcp_proxy_rate`, `tcp_basic_enable`, `synflood_enable`, `synflood_mode`, `synflood_alert_rate`, `syn_ack_flood_enable`, `syn_ack_flood_alert_rate`, `ack_flood_enable`, `ack_flood_mode`, `ack_flood_alert_rate`, `tcp_frag_enable`, `tcp_frag_mode`, `tcp_frag_alert_rate`, `fin_rst_flood_enable`, `fin_rst_flood_alert_rate`, `tcp_ratio_enable`, `tcp_ratio_protion`, `tcp_ratio_limit_mode`, `tcp_ratio_limit_rate`, `tcp_limit_enable`, `tcp_limit_sub_enable`, `max_speed`, `tcp_frag_limit_enable`, `frag_max_speed`, `tcp_conn_enable`, `tcp_desttip_enable`, `tcp_desttip_num`, `tcp_new_destip_enable`, `tcp_new_destip_rate`, `tcp_srctip_enable`, `tcp_srctip_num`, `tcp_new_srctip_enable`, `tcp_new_srctip_rate`, `tcp_new_srctip_interval`, `illegal_session_enable`, `window_size_check_enable`, `window_size`, `illegal_conn_enable`, `illegal_min_conn_num_enable`, `illegal_conn_num`, `sack_check_enable`, `sack_check_max_number`, `illegal_conn_num_interval`, `illegal_conn_count`, `illegal_conn_count_interval`, `tcp_abnormal_enable`, `tcp_abnormal_alert_rate`, `defend_mode`, `slow_con_dectect_enable`, `detect_number`, `detect_interval`, `ack_session_check_enable`, `ack_content_check_enable`, `mssCheck_enable`, `syn_ratio_enable`, `syn_ratio_limit_rate`, `syn_ratio_duration`, `syn_max_packets`, `syn_max_packets_duration`, `tcp_new_destsession_limit_enable`, `tcp_new_destsession_limit`, `direction`, `first_packet_check_lower_limit`, `first_packet_check_upper_limit`, `tcp_enable`, `tcp_lower_limit`, `tcp_upper_limit`, `synfirst_packet_check_enable`, `syn_ratio_limit_packets`, `syn_blacklist_enable`, `syn_exception_times`, `syn_total_check_times`, `session_check_enable`, `session_conn_rate`, `session_check_duration`, `ack_check_enable`, `ack_min_packets_num`, `big_packet_length`, `big_packet_ratio`, `syn_check_enable`, `syn_packets_num`, `synflood_defendmode_enable`, `synack_firstpacket_enable`, `synack_lower_limit`, `synack_upper_limit`, `synack_source_enable`, `source_limit_enable`, `source_limit_bandwidth_enable`, `source_limit_bandwidth_rate`, `source_limit_packets_enable`, `source_limit_packets_rate`, `source_limit_illegal_times`, `source_limit_total_times`, `source_limit_interval`) values(NULL,NULL,'',NULL,'1000','','','1','2000','','2000','','1','20000','','0','200','','2000',NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'10000',NULL,'1000','','200','','150','3','',NULL,NULL,NULL,'','1',NULL,NULL,'30','30','15','','200','0',NULL,NULL,NULL,'',NULL,NULL,'','90','10','200','10',NULL,NULL,'1','1','6',NULL,NULL,NULL,'','200','','3','10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','0','6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
insert into `t_vsm_zone_tcpflood` (`service_id`, `tcp_block`, `tcp_defend_enable`, `tcp_proxy_enable`, `tcp_proxy_rate`, `tcp_basic_enable`, `synflood_enable`, `synflood_mode`, `synflood_alert_rate`, `syn_ack_flood_enable`, `syn_ack_flood_alert_rate`, `ack_flood_enable`, `ack_flood_mode`, `ack_flood_alert_rate`, `tcp_frag_enable`, `tcp_frag_mode`, `tcp_frag_alert_rate`, `fin_rst_flood_enable`, `fin_rst_flood_alert_rate`, `tcp_ratio_enable`, `tcp_ratio_protion`, `tcp_ratio_limit_mode`, `tcp_ratio_limit_rate`, `tcp_limit_enable`, `tcp_limit_sub_enable`, `max_speed`, `tcp_frag_limit_enable`, `frag_max_speed`, `tcp_conn_enable`, `tcp_desttip_enable`, `tcp_desttip_num`, `tcp_new_destip_enable`, `tcp_new_destip_rate`, `tcp_srctip_enable`, `tcp_srctip_num`, `tcp_new_srctip_enable`, `tcp_new_srctip_rate`, `tcp_new_srctip_interval`, `illegal_session_enable`, `window_size_check_enable`, `window_size`, `illegal_conn_enable`, `illegal_min_conn_num_enable`, `illegal_conn_num`, `sack_check_enable`, `sack_check_max_number`, `illegal_conn_num_interval`, `illegal_conn_count`, `illegal_conn_count_interval`, `tcp_abnormal_enable`, `tcp_abnormal_alert_rate`, `defend_mode`, `slow_con_dectect_enable`, `detect_number`, `detect_interval`, `ack_session_check_enable`, `ack_content_check_enable`, `mssCheck_enable`, `syn_ratio_enable`, `syn_ratio_limit_rate`, `syn_ratio_duration`, `syn_max_packets`, `syn_max_packets_duration`, `tcp_new_destsession_limit_enable`, `tcp_new_destsession_limit`, `direction`, `first_packet_check_lower_limit`, `first_packet_check_upper_limit`, `tcp_enable`, `tcp_lower_limit`, `tcp_upper_limit`, `synfirst_packet_check_enable`, `syn_ratio_limit_packets`, `syn_blacklist_enable`, `syn_exception_times`, `syn_total_check_times`, `session_check_enable`, `session_conn_rate`, `session_check_duration`, `ack_check_enable`, `ack_min_packets_num`, `big_packet_length`, `big_packet_ratio`, `syn_check_enable`, `syn_packets_num`, `synflood_defendmode_enable`, `synack_firstpacket_enable`, `synack_lower_limit`, `synack_upper_limit`, `synack_source_enable`, `source_limit_enable`, `source_limit_bandwidth_enable`, `source_limit_bandwidth_rate`, `source_limit_packets_enable`, `source_limit_packets_rate`, `source_limit_illegal_times`, `source_limit_total_times`, `source_limit_interval`) values(NULL,NULL,NULL,NULL,'1000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','5','','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

insert into `t_vsm_zone_udpflood` (`service_id`, `udp_block`, `udp_defend_enable`, `alert_speed_enable`, `alert_speed`, `udp_check_enable`, `udp_fingerlearn_enable`, `frag_alert_speed_enable`, `frag_alert_speed`, `frag_check_enable`, `frag_fingerlearn_enable`, `packet_length_learn`, `learn_mode`, `offset`, `fingerprint_length`, `udp_limit_enable`, `udp_max_speed_enable`, `udp_max_speed`, `udp_frag_max_speed_enable`, `udp_frag_max_speed`, `udp_userfinger_enable`, `udp_rel_service_name`, `upd_rel_service_type`, `udp_rel_service_alert_rate`, `udp_rel_service_enable`, `udp_new_destsession_limit_enable`, `udp_new_destsession_limit`, `direction`, `udp_abnormal_enable`, `udp_abnormal_alert_rate`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','1','','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_udpflood` (`service_id`, `udp_block`, `udp_defend_enable`, `alert_speed_enable`, `alert_speed`, `udp_check_enable`, `udp_fingerlearn_enable`, `frag_alert_speed_enable`, `frag_alert_speed`, `frag_check_enable`, `frag_fingerlearn_enable`, `packet_length_learn`, `learn_mode`, `offset`, `fingerprint_length`, `udp_limit_enable`, `udp_max_speed_enable`, `udp_max_speed`, `udp_frag_max_speed_enable`, `udp_frag_max_speed`, `udp_userfinger_enable`, `udp_rel_service_name`, `upd_rel_service_type`, `udp_rel_service_alert_rate`, `udp_rel_service_enable`, `udp_new_destsession_limit_enable`, `udp_new_destsession_limit`, `direction`, `udp_abnormal_enable`, `udp_abnormal_alert_rate`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','1','','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_udpflood` (`service_id`, `udp_block`, `udp_defend_enable`, `alert_speed_enable`, `alert_speed`, `udp_check_enable`, `udp_fingerlearn_enable`, `frag_alert_speed_enable`, `frag_alert_speed`, `frag_check_enable`, `frag_fingerlearn_enable`, `packet_length_learn`, `learn_mode`, `offset`, `fingerprint_length`, `udp_limit_enable`, `udp_max_speed_enable`, `udp_max_speed`, `udp_frag_max_speed_enable`, `udp_frag_max_speed`, `udp_userfinger_enable`, `udp_rel_service_name`, `upd_rel_service_type`, `udp_rel_service_alert_rate`, `udp_rel_service_enable`, `udp_new_destsession_limit_enable`, `udp_new_destsession_limit`, `direction`, `udp_abnormal_enable`, `udp_abnormal_alert_rate`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','1','','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_udpflood` (`service_id`, `udp_block`, `udp_defend_enable`, `alert_speed_enable`, `alert_speed`, `udp_check_enable`, `udp_fingerlearn_enable`, `frag_alert_speed_enable`, `frag_alert_speed`, `frag_check_enable`, `frag_fingerlearn_enable`, `packet_length_learn`, `learn_mode`, `offset`, `fingerprint_length`, `udp_limit_enable`, `udp_max_speed_enable`, `udp_max_speed`, `udp_frag_max_speed_enable`, `udp_frag_max_speed`, `udp_userfinger_enable`, `udp_rel_service_name`, `upd_rel_service_type`, `udp_rel_service_alert_rate`, `udp_rel_service_enable`, `udp_new_destsession_limit_enable`, `udp_new_destsession_limit`, `direction`, `udp_abnormal_enable`, `udp_abnormal_alert_rate`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','1','','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_udpflood` (`service_id`, `udp_block`, `udp_defend_enable`, `alert_speed_enable`, `alert_speed`, `udp_check_enable`, `udp_fingerlearn_enable`, `frag_alert_speed_enable`, `frag_alert_speed`, `frag_check_enable`, `frag_fingerlearn_enable`, `packet_length_learn`, `learn_mode`, `offset`, `fingerprint_length`, `udp_limit_enable`, `udp_max_speed_enable`, `udp_max_speed`, `udp_frag_max_speed_enable`, `udp_frag_max_speed`, `udp_userfinger_enable`, `udp_rel_service_name`, `upd_rel_service_type`, `udp_rel_service_alert_rate`, `udp_rel_service_enable`, `udp_new_destsession_limit_enable`, `udp_new_destsession_limit`, `direction`, `udp_abnormal_enable`, `udp_abnormal_alert_rate`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','1','','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_udpflood` (`service_id`, `udp_block`, `udp_defend_enable`, `alert_speed_enable`, `alert_speed`, `udp_check_enable`, `udp_fingerlearn_enable`, `frag_alert_speed_enable`, `frag_alert_speed`, `frag_check_enable`, `frag_fingerlearn_enable`, `packet_length_learn`, `learn_mode`, `offset`, `fingerprint_length`, `udp_limit_enable`, `udp_max_speed_enable`, `udp_max_speed`, `udp_frag_max_speed_enable`, `udp_frag_max_speed`, `udp_userfinger_enable`, `udp_rel_service_name`, `upd_rel_service_type`, `udp_rel_service_alert_rate`, `udp_rel_service_enable`, `udp_new_destsession_limit_enable`, `udp_new_destsession_limit`, `direction`, `udp_abnormal_enable`, `udp_abnormal_alert_rate`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','1','','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_udpflood` (`service_id`, `udp_block`, `udp_defend_enable`, `alert_speed_enable`, `alert_speed`, `udp_check_enable`, `udp_fingerlearn_enable`, `frag_alert_speed_enable`, `frag_alert_speed`, `frag_check_enable`, `frag_fingerlearn_enable`, `packet_length_learn`, `learn_mode`, `offset`, `fingerprint_length`, `udp_limit_enable`, `udp_max_speed_enable`, `udp_max_speed`, `udp_frag_max_speed_enable`, `udp_frag_max_speed`, `udp_userfinger_enable`, `udp_rel_service_name`, `upd_rel_service_type`, `udp_rel_service_alert_rate`, `udp_rel_service_enable`, `udp_new_destsession_limit_enable`, `udp_new_destsession_limit`, `direction`, `udp_abnormal_enable`, `udp_abnormal_alert_rate`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','1','','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_udpflood` (`service_id`, `udp_block`, `udp_defend_enable`, `alert_speed_enable`, `alert_speed`, `udp_check_enable`, `udp_fingerlearn_enable`, `frag_alert_speed_enable`, `frag_alert_speed`, `frag_check_enable`, `frag_fingerlearn_enable`, `packet_length_learn`, `learn_mode`, `offset`, `fingerprint_length`, `udp_limit_enable`, `udp_max_speed_enable`, `udp_max_speed`, `udp_frag_max_speed_enable`, `udp_frag_max_speed`, `udp_userfinger_enable`, `udp_rel_service_name`, `upd_rel_service_type`, `udp_rel_service_alert_rate`, `udp_rel_service_enable`, `udp_new_destsession_limit_enable`, `udp_new_destsession_limit`, `direction`, `udp_abnormal_enable`, `udp_abnormal_alert_rate`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','1','','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL);
insert into `t_vsm_zone_udpflood` (`service_id`, `udp_block`, `udp_defend_enable`, `alert_speed_enable`, `alert_speed`, `udp_check_enable`, `udp_fingerlearn_enable`, `frag_alert_speed_enable`, `frag_alert_speed`, `frag_check_enable`, `frag_fingerlearn_enable`, `packet_length_learn`, `learn_mode`, `offset`, `fingerprint_length`, `udp_limit_enable`, `udp_max_speed_enable`, `udp_max_speed`, `udp_frag_max_speed_enable`, `udp_frag_max_speed`, `udp_userfinger_enable`, `udp_rel_service_name`, `upd_rel_service_type`, `udp_rel_service_alert_rate`, `udp_rel_service_enable`, `udp_new_destsession_limit_enable`, `udp_new_destsession_limit`, `direction`, `udp_abnormal_enable`, `udp_abnormal_alert_rate`) values(NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','','200','','5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','','500');

insert into `t_vsm_zone_topnstudy` (`service_id`, `http_host_enable`, `http_host_simple`, `http_uri_enable`, `http_uri_simple`, `http_srcip_enable`, `http_srcip_simple`, `dns_query_domain_enable`, `dns_query_domain_simple`, `topn_cache_enable`, `topn_cache_num`, `dns_query_srcip_enable`, `dns_query_srcip_simple`, `dns_req_srcip_enable`, `dns_req_srcip_simple`, `https_enable`, `https_simple`, `sip_srcip_enable`, `sip_srcip_simple`, `sip_caller_enable`, `sip_caller_simple`, `sip_callee_enable`, `sip_callee_simple`, `tcp_newconn_enable`, `tcp_newconn_simple`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_topnstudy` (`service_id`, `http_host_enable`, `http_host_simple`, `http_uri_enable`, `http_uri_simple`, `http_srcip_enable`, `http_srcip_simple`, `dns_query_domain_enable`, `dns_query_domain_simple`, `topn_cache_enable`, `topn_cache_num`, `dns_query_srcip_enable`, `dns_query_srcip_simple`, `dns_req_srcip_enable`, `dns_req_srcip_simple`, `https_enable`, `https_simple`, `sip_srcip_enable`, `sip_srcip_simple`, `sip_caller_enable`, `sip_caller_simple`, `sip_callee_enable`, `sip_callee_simple`, `tcp_newconn_enable`, `tcp_newconn_simple`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_topnstudy` (`service_id`, `http_host_enable`, `http_host_simple`, `http_uri_enable`, `http_uri_simple`, `http_srcip_enable`, `http_srcip_simple`, `dns_query_domain_enable`, `dns_query_domain_simple`, `topn_cache_enable`, `topn_cache_num`, `dns_query_srcip_enable`, `dns_query_srcip_simple`, `dns_req_srcip_enable`, `dns_req_srcip_simple`, `https_enable`, `https_simple`, `sip_srcip_enable`, `sip_srcip_simple`, `sip_caller_enable`, `sip_caller_simple`, `sip_callee_enable`, `sip_callee_simple`, `tcp_newconn_enable`, `tcp_newconn_simple`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_topnstudy` (`service_id`, `http_host_enable`, `http_host_simple`, `http_uri_enable`, `http_uri_simple`, `http_srcip_enable`, `http_srcip_simple`, `dns_query_domain_enable`, `dns_query_domain_simple`, `topn_cache_enable`, `topn_cache_num`, `dns_query_srcip_enable`, `dns_query_srcip_simple`, `dns_req_srcip_enable`, `dns_req_srcip_simple`, `https_enable`, `https_simple`, `sip_srcip_enable`, `sip_srcip_simple`, `sip_caller_enable`, `sip_caller_simple`, `sip_callee_enable`, `sip_callee_simple`, `tcp_newconn_enable`, `tcp_newconn_simple`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_topnstudy` (`service_id`, `http_host_enable`, `http_host_simple`, `http_uri_enable`, `http_uri_simple`, `http_srcip_enable`, `http_srcip_simple`, `dns_query_domain_enable`, `dns_query_domain_simple`, `topn_cache_enable`, `topn_cache_num`, `dns_query_srcip_enable`, `dns_query_srcip_simple`, `dns_req_srcip_enable`, `dns_req_srcip_simple`, `https_enable`, `https_simple`, `sip_srcip_enable`, `sip_srcip_simple`, `sip_caller_enable`, `sip_caller_simple`, `sip_callee_enable`, `sip_callee_simple`, `tcp_newconn_enable`, `tcp_newconn_simple`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_topnstudy` (`service_id`, `http_host_enable`, `http_host_simple`, `http_uri_enable`, `http_uri_simple`, `http_srcip_enable`, `http_srcip_simple`, `dns_query_domain_enable`, `dns_query_domain_simple`, `topn_cache_enable`, `topn_cache_num`, `dns_query_srcip_enable`, `dns_query_srcip_simple`, `dns_req_srcip_enable`, `dns_req_srcip_simple`, `https_enable`, `https_simple`, `sip_srcip_enable`, `sip_srcip_simple`, `sip_caller_enable`, `sip_caller_simple`, `sip_callee_enable`, `sip_callee_simple`, `tcp_newconn_enable`, `tcp_newconn_simple`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_topnstudy` (`service_id`, `http_host_enable`, `http_host_simple`, `http_uri_enable`, `http_uri_simple`, `http_srcip_enable`, `http_srcip_simple`, `dns_query_domain_enable`, `dns_query_domain_simple`, `topn_cache_enable`, `topn_cache_num`, `dns_query_srcip_enable`, `dns_query_srcip_simple`, `dns_req_srcip_enable`, `dns_req_srcip_simple`, `https_enable`, `https_simple`, `sip_srcip_enable`, `sip_srcip_simple`, `sip_caller_enable`, `sip_caller_simple`, `sip_callee_enable`, `sip_callee_simple`, `tcp_newconn_enable`, `tcp_newconn_simple`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_topnstudy` (`service_id`, `http_host_enable`, `http_host_simple`, `http_uri_enable`, `http_uri_simple`, `http_srcip_enable`, `http_srcip_simple`, `dns_query_domain_enable`, `dns_query_domain_simple`, `topn_cache_enable`, `topn_cache_num`, `dns_query_srcip_enable`, `dns_query_srcip_simple`, `dns_req_srcip_enable`, `dns_req_srcip_simple`, `https_enable`, `https_simple`, `sip_srcip_enable`, `sip_srcip_simple`, `sip_caller_enable`, `sip_caller_simple`, `sip_callee_enable`, `sip_callee_simple`, `tcp_newconn_enable`, `tcp_newconn_simple`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');
insert into `t_vsm_zone_topnstudy` (`service_id`, `http_host_enable`, `http_host_simple`, `http_uri_enable`, `http_uri_simple`, `http_srcip_enable`, `http_srcip_simple`, `dns_query_domain_enable`, `dns_query_domain_simple`, `topn_cache_enable`, `topn_cache_num`, `dns_query_srcip_enable`, `dns_query_srcip_simple`, `dns_req_srcip_enable`, `dns_req_srcip_simple`, `https_enable`, `https_simple`, `sip_srcip_enable`, `sip_srcip_simple`, `sip_caller_enable`, `sip_caller_simple`, `sip_callee_enable`, `sip_callee_simple`, `tcp_newconn_enable`, `tcp_newconn_simple`, `direction`) values(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1');

insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-8,(select max(pkid) from t_vsm_zone_otherflood)-8,'Other');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-8,(select max(pkid) from t_vsm_zone_sipflood)-8,'SIP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-8,(select max(pkid) from t_vsm_zone_dnsflood)-8,'DNS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-8,(select max(pkid) from t_vsm_zone_httpsflood)-8,'HTTPS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-8,(select max(pkid) from t_vsm_zone_httpflood)-8,'HTTP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-8,(select max(pkid) from t_vsm_zone_icmpflood)-8,'ICMP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-8,(select max(pkid) from t_vsm_zone_udpflood)-8,'UDP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-8,(select max(pkid) from t_vsm_zone_tcpflood)-8,'TCP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-8,(select max(pkid) from t_vsm_zone_topnstudy)-8,'TOPNSTUDY');

insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-7,(select max(pkid) from t_vsm_zone_otherflood)-7,'Other');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-7,(select max(pkid) from t_vsm_zone_sipflood)-7,'SIP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-7,(select max(pkid) from t_vsm_zone_dnsflood)-7,'DNS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-7,(select max(pkid) from t_vsm_zone_httpsflood)-7,'HTTPS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-7,(select max(pkid) from t_vsm_zone_httpflood)-7,'HTTP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-7,(select max(pkid) from t_vsm_zone_icmpflood)-7,'ICMP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-7,(select max(pkid) from t_vsm_zone_udpflood)-7,'UDP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-7,(select max(pkid) from t_vsm_zone_tcpflood)-7,'TCP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-7,(select max(pkid) from t_vsm_zone_topnstudy)-7,'TOPNSTUDY');

insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-6,(select max(pkid) from t_vsm_zone_otherflood)-6,'Other');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-6,(select max(pkid) from t_vsm_zone_sipflood)-6,'SIP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-6,(select max(pkid) from t_vsm_zone_dnsflood)-6,'DNS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-6,(select max(pkid) from t_vsm_zone_httpsflood)-6,'HTTPS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-6,(select max(pkid) from t_vsm_zone_httpflood)-6,'HTTP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-6,(select max(pkid) from t_vsm_zone_icmpflood)-6,'ICMP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-6,(select max(pkid) from t_vsm_zone_udpflood)-6,'UDP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-6,(select max(pkid) from t_vsm_zone_tcpflood)-6,'TCP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-6,(select max(pkid) from t_vsm_zone_topnstudy)-6,'TOPNSTUDY');

insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-5,(select max(pkid) from t_vsm_zone_otherflood)-5,'Other');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-5,(select max(pkid) from t_vsm_zone_sipflood)-5,'SIP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-5,(select max(pkid) from t_vsm_zone_dnsflood)-5,'DNS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-5,(select max(pkid) from t_vsm_zone_httpsflood)-5,'HTTPS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-5,(select max(pkid) from t_vsm_zone_httpflood)-5,'HTTP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-5,(select max(pkid) from t_vsm_zone_icmpflood)-5,'ICMP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-5,(select max(pkid) from t_vsm_zone_udpflood)-5,'UDP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-5,(select max(pkid) from t_vsm_zone_tcpflood)-5,'TCP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-5,(select max(pkid) from t_vsm_zone_topnstudy)-5,'TOPNSTUDY');

insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-4,(select max(pkid) from t_vsm_zone_otherflood)-4,'Other');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-4,(select max(pkid) from t_vsm_zone_sipflood)-4,'SIP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-4,(select max(pkid) from t_vsm_zone_dnsflood)-4,'DNS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-4,(select max(pkid) from t_vsm_zone_httpsflood)-4,'HTTPS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-4,(select max(pkid) from t_vsm_zone_httpflood)-4,'HTTP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-4,(select max(pkid) from t_vsm_zone_icmpflood)-4,'ICMP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-4,(select max(pkid) from t_vsm_zone_udpflood)-4,'UDP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-4,(select max(pkid) from t_vsm_zone_tcpflood)-4,'TCP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-4,(select max(pkid) from t_vsm_zone_topnstudy)-4,'TOPNSTUDY');

insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-3,(select max(pkid) from t_vsm_zone_otherflood)-3,'Other');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-3,(select max(pkid) from t_vsm_zone_sipflood)-3,'SIP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-3,(select max(pkid) from t_vsm_zone_dnsflood)-3,'DNS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-3,(select max(pkid) from t_vsm_zone_httpsflood)-3,'HTTPS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-3,(select max(pkid) from t_vsm_zone_httpflood)-3,'HTTP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-3,(select max(pkid) from t_vsm_zone_icmpflood)-3,'ICMP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-3,(select max(pkid) from t_vsm_zone_udpflood)-3,'UDP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-3,(select max(pkid) from t_vsm_zone_tcpflood)-3,'TCP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-3,(select max(pkid) from t_vsm_zone_topnstudy)-3,'TOPNSTUDY');

insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-2,(select max(pkid) from t_vsm_zone_otherflood)-2,'Other');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-2,(select max(pkid) from t_vsm_zone_sipflood)-2,'SIP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-2,(select max(pkid) from t_vsm_zone_dnsflood)-2,'DNS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-2,(select max(pkid) from t_vsm_zone_httpsflood)-2,'HTTPS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-2,(select max(pkid) from t_vsm_zone_httpflood)-2,'HTTP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-2,(select max(pkid) from t_vsm_zone_icmpflood)-2,'ICMP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-2,(select max(pkid) from t_vsm_zone_udpflood)-2,'UDP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-2,(select max(pkid) from t_vsm_zone_tcpflood)-2,'TCP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-2,(select max(pkid) from t_vsm_zone_topnstudy)-2,'TOPNSTUDY');

insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-1,(select max(pkid) from t_vsm_zone_otherflood)-1,'Other');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-1,(select max(pkid) from t_vsm_zone_sipflood)-1,'SIP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-1,(select max(pkid) from t_vsm_zone_dnsflood)-1,'DNS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-1,(select max(pkid) from t_vsm_zone_httpsflood)-1,'HTTPS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-1,(select max(pkid) from t_vsm_zone_httpflood)-1,'HTTP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-1,(select max(pkid) from t_vsm_zone_icmpflood)-1,'ICMP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-1,(select max(pkid) from t_vsm_zone_udpflood)-1,'UDP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-1,(select max(pkid) from t_vsm_zone_tcpflood)-1,'TCP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template)-1,(select max(pkid) from t_vsm_zone_topnstudy)-1,'TOPNSTUDY');

insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template),(select max(pkid) from t_vsm_zone_otherflood),'Other');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template),(select max(pkid) from t_vsm_zone_sipflood),'SIP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template),(select max(pkid) from t_vsm_zone_dnsflood),'DNS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template),(select max(pkid) from t_vsm_zone_httpsflood),'HTTPS');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template),(select max(pkid) from t_vsm_zone_httpflood),'HTTP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template),(select max(pkid) from t_vsm_zone_icmpflood),'ICMP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template),(select max(pkid) from t_vsm_zone_udpflood),'UDP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template),(select max(pkid) from t_vsm_zone_tcpflood),'TCP');
insert into t_vsm_zone_template_items(template_id,children_id,type) values ((select max(pkid) from t_vsm_zone_template),(select max(pkid) from t_vsm_zone_topnstudy),'TOPNSTUDY');

/*默认模板更新--end*/

/* 误防漏防 添加默认指标信息 */
DROP TABLE IF EXISTS `t_atic_streamonitor_measurename`;
CREATE TABLE IF NOT EXISTS `t_atic_streamonitor_measurename` (  `pkid` INT(11) NOT NULL AUTO_INCREMENT,  `name` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,  `description` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,  `type` INT(11) DEFAULT NULL,  PRIMARY KEY (`pkid`)) ENGINE=MYISAM DEFAULT CHARSET=utf8;
insert  into `t_atic_streamonitor_measurename`(`pkid`,`name`,`description`,`type`) values (1,'synPps','基于目的IP的SYN pps',0),(2,'srcSynPps','基于源的IP的SYN pps',0),(3,'ackPps','基于目的IP的ACK pps',0),(4,'srcAckKbps','基于源的IP的ACK Kbps',0),(5,'synAckRatio','基于目的IP的SYN/ACK比例',0),(6,'tcpIncreaseCon','基于目的IP的TCP新建连接数',0),(7,'tcpConcurCon','基于目的IP的TCP并发连接数',0),(8,'srcIncreaseCon','基于源的IP的新建连接数',0),(9,'srcConcurCon','基于源的IP的并发连接数',0),(10,'httpQps','HTTP基于目的IP的HTTP qps',0),(11,'udpKbps','基于目的IP的UDP Kbps',0),(12,'dnsRequestPps','基于目的IP的DNS pps',0),(13,'attackTypeSet_11','ACK攻击',1),(14,'attackTypeSet_45','DNS攻击',1),(15,'attackTypeSet_27','HTTP攻击',1),(16,'httpQps','HTTP基于目的IP的HTTP qps',1),(17,'attackTypeSet_10','SYN攻击',1),(18,'attackTypeSet_19','UDP攻击',1),(19,'blackTypeSet_15','慢速攻击黑名单',1),(20,'ackPps','基于目的IP的ACK pps',1),(21,'dnsRequestPps','基于目的IP的DNS pps',1),(22,'synPps','基于目的IP的SYN pps',1),(23,'tcpConcurCon','基于目的IP的TCP并发连接数',1),(24,'tcpIncreaseCon','基于目的IP的TCP新建连接数',1),(25,'udpKbps','基于目的IP的UDP Kbps',1),(26,'srcIncreaseCon','基于源的IP的新建连接数',1),(27,'blackTypeSet_23','SYN黑名单',1),(28,'blackTypeSet_24','ACK黑名单',1),(29,'blackTypeSet_5','TCP连接异常黑名单',1);


DROP TABLE IF EXISTS `t_atic_streamonitor_ruleconditionrelationship`;
CREATE TABLE `t_atic_streamonitor_ruleconditionrelationship` (
	`pkid` INT(11) NOT NULL AUTO_INCREMENT ,
	`ruleId` INT ,
	`measureName` VARCHAR (255),
	`operator` INT ,
	`targetValue` VARCHAR (255),
	`groupId` INT ,
	`conditionInGroupId` INT ,
	`logicOperator` INT ,
	`type` INT,
	PRIMARY KEY  (`pkid`)
)ENGINE=MYISAM DEFAULT CHARSET=utf8; 

/* 插入数据到误防漏防规则 条件关系表 */
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('1','1','srcAckKbps','0','5000','1','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('2','1','ackPps','0','5000','2','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('3','1','tcpConcurCon','0','1000','3','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('4','1','synAckRatio','1','20','3','2','1','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('5','1','ackPps','0','5000','4','1','1','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('6','2','srcSynPps','0','5000','1','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('7','2','synPps','0','10000','2','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('8','2','synAckRatio','0','40','3','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('9','2','tcpConcurCon','0','5000','3','2','1','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('10','2','synPps','0','10000','4','1','1','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('11','3','srcIncreaseCon','0','5000','1','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('12','3','srcConcurCon','0','2000','1','2','1','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('13','3','tcpIncreaseCon','0','1000','2','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('14','3','tcpConcurCon','0','1000','2','2','1','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('15','4','httpQps','0','5000','1','2','1','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('16','4','srcIncreaseCon','0','500','2','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('17','4','srcConcurCon','0','2000','2','2','1','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('18','4','httpQps','0','5000','3','1','1','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('19','5','udpKbps','0','10000','1','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('20','6','dnsRequestPps','0','5000','1','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('21','7','srcIncreaseCon','1','80','1','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('22','7','synPps','1','80','1','2','1','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('23','7','tcpIncreaseCon','1','80','2','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('24','7','attackTypeSet_10','0','1','3','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('25','7','blackTypeSet_23','0','1','3','2','1','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('26','8','ackPps','1','80','1','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('27','8','attackTypeSet_11','0','1','2','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('28','8','blackTypeSet_24','0','1','2','2','1','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('29','9','tcpIncreaseCon','1','80','1','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('30','9','tcpConcurCon','1','80','1','2','1','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('31','9','blackTypeSet_5','0','1','3','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('32','10','httpQps','1','80','1','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('33','10','attackTypeSet_27','0','1','2','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('34','10','blackTypeSet_15','0','1','2','2','1','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('35','11','udpKbps','1','80','1','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('36','11','attackTypeSet_19','0','1','2','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('37','12','dnsRequestPps','1','80','1','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('38','12','attackTypeSet_45','0','1','2','1','0','1');

DROP TABLE IF EXISTS `t_atic_streamonitor_rule`;
CREATE TABLE `t_atic_streamonitor_rule` (
	`pkid` INT(11) NOT NULL AUTO_INCREMENT,
	`ruleName` VARCHAR (255),
	`description` VARCHAR (255),
	PRIMARY KEY  (`pkid`) 
)ENGINE=MYISAM DEFAULT CHARSET=utf8;
/* 插入数据到误防漏防规则表 */
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('1','ACKDefenseLeakageCheck','Check whether ACK defense policy is applied or configured properly');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('2','SYNDefenseLeakageCheck','Check whether SYN defense policy is applied or configured properly');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('3','TCPDefenseLeakageCheck','Check whether TCP defense policy is applied or configured properly');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('4','HTTPDefenseLeakageCheck','Check whether HTTP defense policy is applied or configured properly');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('5','UDPDefenseLeakageCheck','Check whether UDP defense policy is applied or configured properly');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('6','DNSDefenseLeakageCheck','Check whether DNS defense policy is applied or configured properly');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('7','SYNDefenseNegativeCheck','Check whether SYN defense policy is applied unproperly');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('8','ACKDefenseNegativeCheck','Check whether ACK defense policy is applied unproperly');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('9','TCPNewCurConDefenseNegativeCheck','Check whether TCP new and concurrent connection defense policy is applied unproperly');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('10','HTTPDefenseNegativeCheck','Check whether HTTP defense policy is applied unproperly');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('11','UDPDefenseNegativeCheck','Check whether UDP defense policy is applied unproperly');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('12','DNSReqDefenseNegativeCheck','Check whether DNS Request defense policy is applied unproperly');

/*删除设备全局部署中的接口防御字段*/
DROP PROCEDURE IF EXISTS del_column_t_vsm_neconf_abnormaldfn;
DELIMITER //
CREATE PROCEDURE del_column_t_vsm_neconf_abnormaldfn()
  BEGIN
    IF  EXISTS(SELECT * FROM information_schema.columns
           WHERE TABLE_SCHEMA='lego' AND table_name = 't_vsm_neconf_abnormaldfn' AND column_name ='interface_defence') THEN
      ALTER TABLE t_vsm_neconf_abnormaldfn DROP COLUMN interface_defence;
    END IF;	 	
  END;
//
DELIMITER ;
CALL del_column_t_vsm_neconf_abnormaldfn();
DROP PROCEDURE IF EXISTS del_column_t_vsm_neconf_abnormaldfn;
