USE `lego`;

-- 证书管理的预置证书信息
DROP PROCEDURE if EXISTS create_t_system_cert_mgt;
delimiter //
CREATE PROCEDURE create_t_system_cert_mgt()
  BEGIN
		  IF NOT EXISTS (select * from information_schema.`COLUMNS` where TABLE_NAME = 't_system_cert_mgt') THEN
				CREATE TABLE `t_system_cert_mgt` (
          `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
          `cert_alias` varchar(128) COLLATE utf8_bin DEFAULT NULL,
          `cert_type` varchar(32) COLLATE utf8_bin DEFAULT NULL,
          `cert_file` longtext COLLATE utf8_bin,
          `cert_dname` varchar(1024) COLLATE utf8_bin DEFAULT NULL,
          `validity_period` varchar(128) COLLATE utf8_bin DEFAULT NULL,
          PRIMARY KEY (`pkid`)
        ) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
        INSERT INTO `t_system_cert_mgt` (`pkid`, `cert_alias`, `cert_type`, `cert_file`, `cert_dname`, `validity_period`) VALUES ('1', 'api_damddos_com', null, null, 'CN=api.damddos.com, OU=IT, O=\\u4E2D\\u56FD\\u7535\\u4FE1\\u80A1\\u4EFD\\u6709\\u9650\\u516C\\u53F8\\u7F51\\u7EDC\\u5B89\\u5168\\u4EA7\\u54C1\\u8FD0\\u8425\\u4E2D\\u5FC3, L=\\u5317\\u4EAC, C=CN', '2018-03-13 - 2020-05-11');
        INSERT INTO `t_system_cert_mgt` (`pkid`, `cert_alias`, `cert_type`, `cert_file`, `cert_dname`, `validity_period`) VALUES ('2', 'advanced_anti_ddos', null, null, 'CN=*.myhuaweicloud.com, OU=Cloudbu SRE Dept, O=\"Huawei Software Technologies Co., Ltd\", L=Nanjing, ST=Jiangsu, C=CN', '2019-04-16 - 2021-06-14');
        INSERT INTO `t_system_cert_mgt` (`pkid`, `cert_alias`, `cert_type`, `cert_file`, `cert_dname`, `validity_period`) VALUES ('3', 'huaweicloud_iam', null, null, 'CN=*.myhuaweicloud.com, OU=Cloudbu SRE Dept, O="Huawei Software Technologies Co., Ltd", L=Nanjing, ST=Jiangsu, C=CN', '2019-04-16 - 2021-06-14');
        INSERT INTO `t_system_cert_mgt` (`pkid`, `cert_alias`, `cert_type`, `cert_file`, `cert_dname`, `validity_period`) VALUES ('4', 'nexusguard_cloud_anti_ddos', null, null, 'CN=nexusguard.com, O=Nexusguard Limited, L=Tsuen Wan, ST=New Territories, C=HK', '2019-01-14 - 2020-12-18');
        INSERT INTO `t_system_cert_mgt` (`pkid`, `cert_alias`, `cert_type`, `cert_file`, `cert_dname`, `validity_period`) VALUES ('5', 'unicom_soc_yaxin', null, null, 'CN=localhost, OU=localhost, O=localhost, L=BJ, ST=BJ, C=CN', '2017-12-15 - 2117-11-21');
        INSERT INTO `t_system_cert_mgt` (`pkid`, `cert_alias`, `cert_type`, `cert_file`, `cert_dname`, `validity_period`) VALUES ('6', 'iam_cn_north_4', null, null, 'CN=iam.cn-north-4.myhuaweicloud.com, OU=Cloudbu SRE Dept, O="Huawei Software Technologies Co., Ltd", L=NanJing, ST=JiangSu, C=CN', '2019-09-28 - 2020-09-27');
        INSERT INTO `t_system_cert_mgt` (`pkid`, `cert_alias`, `cert_type`, `cert_file`, `cert_dname`, `validity_period`) VALUES ('7', 'iam_cn_north_1', null, null, 'CN=*.cn-north-1.myhuaweicloud.com, O="Huawei Software Technologies Co., Ltd.", OU=Cloudbu SRE Dept, L=Nanjing, ST=Jiangsu, C=CN', '2019-05-27 - 2021-05-27');
     END IF;

    IF EXISTS (select * from information_schema.`COLUMNS` where TABLE_NAME = 't_system_cert_mgt') THEN
        IF NOT EXISTS(SELECT * FROM t_system_cert_mgt WHERE cert_alias = 'api_damddos_com') THEN
          INSERT INTO `t_system_cert_mgt` (`cert_alias`, `cert_type`, `cert_file`, `cert_dname`, `validity_period`) VALUES ('api_damddos_com', null, null, 'CN=api.damddos.com, OU=IT, O=\\u4E2D\\u56FD\\u7535\\u4FE1\\u80A1\\u4EFD\\u6709\\u9650\\u516C\\u53F8\\u7F51\\u7EDC\\u5B89\\u5168\\u4EA7\\u54C1\\u8FD0\\u8425\\u4E2D\\u5FC3, L=\\u5317\\u4EAC, C=CN', '2018-03-13 - 2020-05-11');
        END IF;
        IF NOT EXISTS(SELECT * FROM t_system_cert_mgt WHERE cert_alias = 'advanced_anti_ddos') THEN
          INSERT INTO `t_system_cert_mgt` (`cert_alias`, `cert_type`, `cert_file`, `cert_dname`, `validity_period`) VALUES ('advanced_anti_ddos', null, null, 'CN=*.myhuaweicloud.com, OU=Cloudbu SRE Dept, O=\"Huawei Software Technologies Co., Ltd\", L=Nanjing, ST=Jiangsu, C=CN', '2019-04-16 - 2021-06-14');
        END IF;
         IF NOT EXISTS(SELECT * FROM t_system_cert_mgt WHERE cert_alias = 'huaweicloud_iam') THEN
          INSERT INTO `t_system_cert_mgt` (`cert_alias`, `cert_type`, `cert_file`, `cert_dname`, `validity_period`) VALUES ('huaweicloud_iam', null, null, 'CN=*.myhuaweicloud.com, OU=Cloudbu SRE Dept, O="Huawei Software Technologies Co., Ltd", L=Nanjing, ST=Jiangsu, C=CN	', '2019-04-16 - 2021-06-14');
        END IF;
        IF NOT EXISTS(SELECT * FROM t_system_cert_mgt WHERE cert_alias = 'nexusguard_cloud_anti_ddos') THEN
          INSERT INTO `t_system_cert_mgt` (`cert_alias`, `cert_type`, `cert_file`, `cert_dname`, `validity_period`) VALUES ('nexusguard_cloud_anti_ddos', null, null, 'CN=nexusguard.com, O=Nexusguard Limited, L=Tsuen Wan, ST=New Territories, C=HK', '2019-01-14 - 2020-12-18');
        END IF;
        IF NOT EXISTS(SELECT * FROM t_system_cert_mgt WHERE cert_alias = 'unicom_soc_yaxin') THEN
          INSERT INTO `t_system_cert_mgt` (`cert_alias`, `cert_type`, `cert_file`, `cert_dname`, `validity_period`) VALUES ('unicom_soc_yaxin', null, null, 'CN=localhost, OU=localhost, O=localhost, L=BJ, ST=BJ, C=CN', '2017-12-15 - 2117-11-21');
        END IF;
        IF NOT EXISTS(SELECT * FROM t_system_cert_mgt WHERE cert_alias = 'iam_cn_north_4') THEN
          INSERT INTO `t_system_cert_mgt` (`cert_alias`, `cert_type`, `cert_file`, `cert_dname`, `validity_period`) VALUES ('iam_cn_north_4', null, null, 'CN=iam.cn-north-4.myhuaweicloud.com, OU=Cloudbu SRE Dept, O="Huawei Software Technologies Co., Ltd", L=NanJing, ST=JiangSu, C=CN', '2019-09-28 - 2020-09-27');
        END IF;
        IF NOT EXISTS(SELECT * FROM t_system_cert_mgt WHERE cert_alias = 'iam_cn_north_1') THEN
          INSERT INTO `t_system_cert_mgt` (`cert_alias`, `cert_type`, `cert_file`, `cert_dname`, `validity_period`) VALUES ('iam_cn_north_1', null, null, 'CN=*.cn-north-1.myhuaweicloud.com, O="Huawei Software Technologies Co., Ltd.", OU=Cloudbu SRE Dept, L=Nanjing, ST=Jiangsu, C=CN', '2019-05-27 - 2021-05-27');
        END IF;
    	END IF;
  END;
//
delimiter ;
call create_t_system_cert_mgt();
DROP PROCEDURE if EXISTS create_t_system_cert_mgt;

-- 联通任务配置表删除无用冗余字段
DROP PROCEDURE IF EXISTS t_atic_unicom_config_drop_column;
DELIMITER //
CREATE PROCEDURE t_atic_unicom_config_drop_column()
  BEGIN
        IF EXISTS (SELECT * FROM information_schema.`COLUMNS` WHERE TABLE_NAME = 't_atic_unicom_config' AND COLUMN_NAME = 'data_flag') THEN
                ALTER TABLE t_atic_unicom_config DROP COLUMN `data_flag`;
		END IF;
		IF EXISTS (SELECT * FROM information_schema.`COLUMNS` WHERE TABLE_NAME = 't_atic_unicom_config' AND COLUMN_NAME = 'check_certificate') THEN
                ALTER TABLE t_atic_unicom_config DROP COLUMN `check_certificate`;
		END IF;
		IF EXISTS (SELECT * FROM information_schema.`COLUMNS` WHERE TABLE_NAME = 't_atic_unicom_config' AND COLUMN_NAME = 'max_size') THEN
                ALTER TABLE t_atic_unicom_config DROP COLUMN `max_size`;
		END IF;
		IF EXISTS (SELECT * FROM information_schema.`COLUMNS` WHERE TABLE_NAME = 't_atic_unicom_config' AND COLUMN_NAME = 'sleep_time') THEN
                ALTER TABLE t_atic_unicom_config DROP COLUMN `sleep_time`;
		END IF;
		IF EXISTS (SELECT * FROM information_schema.`COLUMNS` WHERE TABLE_NAME = 't_atic_unicom_config' AND COLUMN_NAME = 'upload_clean_log_command') THEN
                ALTER TABLE t_atic_unicom_config DROP COLUMN `upload_clean_log_command`;
		END IF;
  END;
//
DELIMITER ;
CALL t_atic_unicom_config_drop_column();
DROP PROCEDURE IF EXISTS t_atic_unicom_config_drop_column;

-- 新增过滤器模板
INSERT INTO t_vsm_filter(filter_Id,filter_name,filter_type,filter_action,filter_alert,device_type,filter_mode) SELECT (MAX(filter_Id)+1),'ARMS_Amplification_Attack','UDP','3',NULL,'AntiDDoS','0' FROM t_vsm_filter;
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'ARMS_Amplification_Attack'),'source-port','3283');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'ARMS_Amplification_Attack'),'packet-length','256~1500');
INSERT INTO t_vsm_filter(filter_Id,filter_name,filter_type,filter_action,filter_alert,device_type,filter_mode) SELECT (MAX(filter_Id)+1),'OpenVPN_Amplification_Attack','UDP','3',NULL,'AntiDDoS','0' FROM t_vsm_filter;
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'OpenVPN_Amplification_Attack'),'source-port','1194');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'OpenVPN_Amplification_Attack'),'packet-length','42~1500');
-- 新增硬件过滤器模板
INSERT INTO `t_vsm_np_filter` (`filter_index`, `filter_name`, `ip_type`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`) SELECT (MAX(filter_index)+1) ,'ARMS_Amplification_Attack','IPV4','UDP',NULL,1,10000 FROM `t_vsm_np_filter`;
INSERT INTO `t_vsm_np_filter` (`filter_index`, `filter_name`, `ip_type`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`) SELECT (MAX(filter_index)+1) ,'OpenVPN_Amplification_Attack','IPV4','UDP',NULL,1,10000 FROM `t_vsm_np_filter`;
INSERT INTO `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) VALUES((SELECT pkid FROM t_vsm_np_filter WHERE filter_name = 'ARMS_Amplification_Attack'),(SELECT pkid FROM t_vsm_np_filter WHERE filter_name='ARMS_Amplification_Attack'),NULL,NULL,NULL,3283,256,1500,NULL);
INSERT INTO `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) VALUES((SELECT pkid FROM t_vsm_np_filter WHERE filter_name = 'OpenVPN_Amplification_Attack'),(SELECT pkid FROM t_vsm_np_filter WHERE filter_name='OpenVPN_Amplification_Attack'),NULL,NULL,NULL,1194,42,1500,NULL);

-- 删除Token开关
DROP PROCEDURE if EXISTS drop_column_of_unicom;
delimiter //
CREATE PROCEDURE drop_column_of_unicom()
  BEGIN
		IF EXISTS (select * from information_schema.`COLUMNS` where TABLE_NAME = 't_atic_unicom_config' and COLUMN_NAME = 'check_token') 
			THEN
				ALTER TABLE t_atic_unicom_config DROP COLUMN check_token;
    	END if;
  END;
//
delimiter ;
call drop_column_of_unicom;
DROP PROCEDURE if EXISTS drop_column_of_unicom;

DELETE FROM T_operation_r_role WHERE role_id=2 AND opt_id IN (2346,2347,2348,2357,2358);
DELETE FROM T_operation_r_role WHERE role_id=1 AND opt_id IN (2357,2358);

-- 新增syn-ack flood策略
ALTER TABLE t_vsm_zone_tcpflood ADD COLUMN synack_illegal_session_enable BIT(1) DEFAULT NULL;
ALTER TABLE t_vsm_zone_tcpflood ADD COLUMN synack_illegal_conn_count INT(11) DEFAULT NULL;
ALTER TABLE t_vsm_zone_tcpflood ADD COLUMN synack_illegal_conn_count_interval INT(11) DEFAULT NULL;
ALTER TABLE t_vsm_zone_tcpflood ADD COLUMN synAck_illegal_conn_num INT(11) DEFAULT NULL;
ALTER TABLE t_vsm_zone_tcpflood ADD COLUMN synAck_illegal_conn_num_interval INT(11) DEFAULT NULL;

