USE `lego`;

UPDATE t_vsm_np_filter_rule SET packet_end_len = 9600 WHERE filter_id = (SELECT PKID FROM t_vsm_np_filter WHERE filter_name = 'IPMI_Amplification_Attack');
UPDATE t_vsm_np_filter_rule SET packet_end_len = 9600 WHERE filter_id = (SELECT PKID FROM t_vsm_np_filter WHERE filter_name = 'CoAP_Amplification_Attack');

-- 删除预制证书
DROP PROCEDURE if EXISTS column_cert_alias_set_empty;
delimiter //
CREATE PROCEDURE column_cert_alias_set_empty()
  BEGIN
    IF EXISTS (select * from information_schema.`COLUMNS` where TABLE_NAME = 't_vsm_restful_server_config' and COLUMN_NAME = 'black_cert_alias') THEN
      UPDATE `t_vsm_restful_server_config` set black_cert_alias = '' WHERE black_cert_alias IN ('api_damddos_com', 'advanced_anti_ddos', 'huaweicloud_iam', 'nexusguard_cloud_anti_ddos', 'unicom_soc_yaxin', 'iam_cn_north_4', 'iam_cn_north_1');
    END IF;
    IF EXISTS (select * from information_schema.`COLUMNS` where TABLE_NAME = 't_vsm_restful_server_config' and COLUMN_NAME = 'cloud_cert_alias') THEN
      UPDATE `t_vsm_restful_server_config` set cloud_cert_alias = '' WHERE cloud_cert_alias IN ('api_damddos_com', 'advanced_anti_ddos', 'huaweicloud_iam', 'nexusguard_cloud_anti_ddos', 'unicom_soc_yaxin', 'iam_cn_north_4', 'iam_cn_north_1');
    END IF;

    IF EXISTS (select * from information_schema.`COLUMNS` where TABLE_NAME = 't_atic_cloudclean_config' and COLUMN_NAME = 'cert_alias') THEN
      UPDATE `t_atic_cloudclean_config` SET cert_alias = '' WHERE cert_alias IN ('api_damddos_com', 'advanced_anti_ddos', 'huaweicloud_iam', 'nexusguard_cloud_anti_ddos', 'unicom_soc_yaxin', 'iam_cn_north_4', 'iam_cn_north_1');
    END IF;

    IF EXISTS (select * from information_schema.`COLUMNS` where TABLE_NAME = 't_atic_blackhole_api_config' and COLUMN_NAME = 'cert_alias') THEN
      UPDATE `t_atic_blackhole_api_config` SET cert_alias = '' WHERE cert_alias IN ('api_damddos_com', 'advanced_anti_ddos', 'huaweicloud_iam', 'nexusguard_cloud_anti_ddos', 'unicom_soc_yaxin', 'iam_cn_north_4', 'iam_cn_north_1');
    END IF;

    IF EXISTS (select * from information_schema.`COLUMNS` where TABLE_NAME = 't_atic_device' and COLUMN_NAME = 'restful_cert_alias') THEN
      UPDATE `t_atic_device` SET restful_cert_alias = '' WHERE restful_cert_alias IN ('api_damddos_com', 'advanced_anti_ddos', 'huaweicloud_iam', 'nexusguard_cloud_anti_ddos', 'unicom_soc_yaxin', 'iam_cn_north_4', 'iam_cn_north_1');
    END IF;

    IF EXISTS (select * from information_schema.`COLUMNS` where TABLE_NAME = 't_atic_unicom_config' and COLUMN_NAME = 'cert_alias') THEN
      UPDATE `t_atic_unicom_config` SET cert_alias = '' WHERE cert_alias IN ('api_damddos_com', 'advanced_anti_ddos', 'huaweicloud_iam', 'nexusguard_cloud_anti_ddos', 'unicom_soc_yaxin', 'iam_cn_north_4', 'iam_cn_north_1');
    END IF;

    IF EXISTS (select * from information_schema.`COLUMNS` where TABLE_NAME = 't_atic_sysconfig') THEN
      IF EXISTS (SELECT * FROM `t_atic_sysconfig` WHERE `sys_var` = 'huaweiCloudConfig') THEN
        UPDATE `t_atic_sysconfig` SET sys_value = REPLACE(sys_value, 'api_damddos_com', '') WHERE sys_var = 'huaweiCloudConfig' AND locate('api_damddos_com', sys_value) > 0;
        UPDATE `t_atic_sysconfig` SET sys_value = REPLACE(sys_value, 'advanced_anti_ddos', '') WHERE sys_var = 'huaweiCloudConfig' AND locate('advanced_anti_ddos', sys_value) > 0;
        UPDATE `t_atic_sysconfig` SET sys_value = REPLACE(sys_value, 'huaweicloud_iam', '') WHERE sys_var = 'huaweiCloudConfig' AND locate('huaweicloud_iam', sys_value) > 0;
        UPDATE `t_atic_sysconfig` SET sys_value = REPLACE(sys_value, 'nexusguard_cloud_anti_ddos', '') WHERE sys_var = 'huaweiCloudConfig' AND locate('nexusguard_cloud_anti_ddos', sys_value) > 0;
        UPDATE `t_atic_sysconfig` SET sys_value = REPLACE(sys_value, 'unicom_soc_yaxin', '') WHERE sys_var = 'huaweiCloudConfig' AND locate('unicom_soc_yaxin', sys_value) > 0;
        UPDATE `t_atic_sysconfig` SET sys_value = REPLACE(sys_value, 'iam_cn_north_4', '') WHERE sys_var = 'huaweiCloudConfig' AND locate('iam_cn_north_4', sys_value) > 0;
        UPDATE `t_atic_sysconfig` SET sys_value = REPLACE(sys_value, 'iam_cn_north_1', '') WHERE sys_var = 'huaweiCloudConfig' AND locate('iam_cn_north_1', sys_value) > 0;
      END IF;
    END IF;
  END;
//
delimiter ;
call column_cert_alias_set_empty();
DROP PROCEDURE if EXISTS column_cert_alias_set_empty;