
function validTime(yourTime)
{
    var array = yourTime.split(":");    
    if(array.length != 3)
    {        
        return false ;
    }     
    mytime = pad(array[0],2) + ':' + pad(array[1],2) + ':' + pad(array[2],2)
    
    validMyTime1 = /^2[0-3]:[0-5][0-9]:[0-5][0-9]$/ ;
    validMyTime2 = /^[0-1][0-9]:[0-5][0-9]:[0-5][0-9]$/ ;
    
    return validMyTime1.test(mytime) || validMyTime2.test(mytime); 
}

function validYear(myYear)
{
	validMyYear1 = /^19[0-9][0-9]$/ ;
	validMyYear2 = /^20[0-3][0-8]$/ ;
	return validMyYear1.test(myYear) || validMyYear2.test(myYear);
}

function validMonth(myMonth)
{
	myMonth = pad(myMonth,2);
	validMyMonth1 = /^0[1-9]$/ ;
	validMyMonth2 = /^1[0-2]$/ ;
	return validMyMonth1.test(myMonth) || validMyMonth2.test(myMonth);
}

function validDay(myDay)
{
	myDay = pad(myDay,2);
	validMyDay1 = /^0[1-9]$/ ;
	validMyDay2 = /^[1-2][0-9]$/ ;
	validMyDay3 = /^3[0-1]$/ ;
	return validMyDay1.test(myDay) || validMyDay2.test(myDay) || validMyDay3.test(myDay);
}

var daysOfMonth = new Array
(
  31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
);

var daysOfMonthLY = new Array
(
  31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
);

var moy = new Array();

var dow = new Array();

var button = new Array(3);
var size = 'width="100" height="22" align="center"';
var border = 'border="1"';

var CalendarMonth;
var CalendarYear;
var CalendarDay;

var oldColor;
var oldBgColor;

var today = new Date();
var day;   
var month; 
var year;  
var mytime = '00:00:00';

var nowYear;
var nowMonth;
var nowDay;	
var TimeObj = new TimeControl();

var dayObj = null;
var RECIEVEDINFO = window.dialogArguments;

function CalendarSelect(Month,Year, offset) 
{
	if (offset == null) offset = 0;

	if (window.changeMonth){ }
	else 
	{
		return '';
	}

	if (window.changeYear) { }
	else 
	{
		return '';
	}

	if (window.changeDay) { }
	else 
	{
		return '';
	}

	var output = '';
	output += '<form name="Cal">';
	output += CalendarHead(Month,Year,true);
	output += '</form>';
	return output;
}

function CalendarHead(Month,Year,Select) 
{	
	var output = '';
	output += '<table cellspacing="0"><tr>' ;
	output += '<td width="50%" align="right">' ;
		
	if (Select) 
	{		
		output += begin.toString(mytime);   
	}
	output += '</td></tr></table>';
		
	output += '<table cellpadding="0" cellspacing="0" align="center" class="table">'
	        + '<tr height="20" class="tableHead">';
	output += '<table width="100%" border="0">';
	output += '<tr>';
	output += '<td width="10%" Height="40px">'; 
	output += '</td>';
	output += '<td width="30%">'; 
	output += '<input type="button" style="cursor: pointer;" class="button" value="' + button[0] + '" onClick="pSubmit()">';
	output += '</td>';
	output += '<td width="30%">'; 
	output += '<input type="button" style="cursor: pointer;" class="button" value="' + button[1] + '" onClick="cleanall()">';
	output += '</td>';
	output += '<td width="30%">'; 
	output += '<input type="button" style="cursor: pointer;" class="button" value="' + button[2] + '" onClick="self.close()">';
	output += '</td>';
	output += '</tr>';
	output += '</table>';
	        
	return output;
}


function cleanall()
{	
	if(defaultDate != null && defaultDate != "")
	{
		year	  = defaultDate.substring(0,4) - 0;
		nowYear   = defaultDate.substring(0,4) - 0;
		if (!validYear(year)) 
		{
			year = y2k(today.getYear());
			nowYear = y2k(today.getYear());
		}
		
		month 	  = defaultDate.substring(5,7) - 0;
		nowMonth  = defaultDate.substring(5,7) - 0;
		if (!validMonth(month)) 
		{
			month = today.getMonth() + 1;
			nowMonth = today.getMonth() + 1;
		}

		day  	  = defaultDate.substring(8,10) - 0;	
		nowDay    = defaultDate.substring(8,10) - 0;
		if (!validDay(day)) 
		{
			day = today.getDate();
			nowDay = today.getDate();
		}
		
		mytime    = defaultDate.substring(11,19);
		if (!validTime(mytime)) 
		{
			updateClock();
		}
	}
	else
	{	
		day   	  = today.getDate();
		month 	  = today.getMonth() + 1;
		year  	  = y2k(today.getYear());
		nowDay    = today.getDate();
		nowMonth  = today.getMonth() + 1;
		nowYear   = y2k(today.getYear());
		updateClock();
	}
	RECIEVEDINFO[0].value = year + "-" + pad(month,2) + "-" + pad(day,2) + " " + mytime;
	createPage();
}

function pSubmit()
{
	CalDay(day, month, year);
	self.close();
}

function setYMD(Y, M, D)
{
	year = Y;
	mont = M;
	day = D;
}

function getAnOptionValue(what) {
  return what.options[what.options.selectedIndex].value;
}

function CalMonth() {
	
  CalendarMonth = getAnOptionValue(document.Cal.Month) - 0;
  changeMonth(CalendarMonth);
}

function CalYear() {
  CalendarYear = getAnOptionValue(document.Cal.Year) - 0;
  changeYear(CalendarYear);
}

function pad(num, size) 
{
	  num = '' + num;
	  while (num.length < size) num = '0' + num;
	  return num;
}



function changeMonth(CalendarMonth) 
{
  	month = CalendarMonth + '';
  	createPage();
}

function changeYear(CalendarYear) 
{
  	year = CalendarYear + '';
	createPage();
}

function changeDay(day,month,year) 
{
	day = CalendarDay + '';
}

function createPage()
{
	if (window.CalendarSelect)
	{	
  		document.all.item("calender").innerHTML = CalendarSelect(month,year,0);
  	}
}

function onClick1()
{	
	if (month != 1)
	{
		month --;
		changeMonth(month);
	}
	else
	{	
		if (year == 1900) 
		{
			month = 12;
			year = 2038;
		}
		else
		{
			month = 12;
			year --;
		}
		changeMonth(month);
		changeYear(year);
	}
}

function onClick2()
{
	if (month != 12)
	{
		month ++;		
		changeMonth(month);		
	}
	else
	{
		if (year == 2038) 
		{
			month = 1;
			year = 1900;
		}
		else
		{
			month = 1;
			year ++;
		}

		changeMonth(month);
		changeYear(year);
	}
}



function onFocus(obj)
{
	if (dayObj != null) 
	{
		dayObj.style.color = oldColor;
		dayObj.style.backgroundColor = oldBgColor;
	}
	oldColor = window.event.srcElement.style.color;
	oldBgColor = window.event.srcElement.style.backgroundColor;
	dayObj = obj;
	window.event.srcElement.style.color = '#FFFFFF';
	window.event.srcElement.style.backgroundColor = '#C0C0C0';
}


function y2k(num) {
  return (num < 1000) ? num + 1900 : num;
}

function padout(num) 
{
  return (num < 10) ? '0' + num : num;
}

function updateClock() 
{
  var time = new Date();

  var m = padout(time.getMinutes());
  var h = padout(time.getHours());
  var s = padout(time.getSeconds());

  mytime = h + ':' + m + ':' + s;  
}

function isLeapYear(num) 
{
	if (((num % 4 == 0) && (num % 100 != 0)) || (num % 400 == 0))
		return true;
	return false;
}

function adjustDate(Y,M,D)
{
	var days = daysOfMonth;
	
	if (isLeapYear(Y))
	{
		days = daysOfMonthLY;
	}

	if (D > days[M-1])
	{
		D = days[M-1];
	}
	else if (D < 1) 
	{
		D = 1;
	}
	else
	{
		D = D;
	}
	return Y + "-" + pad(M,2) + "-" + pad(D,2);
}

function initTimeControl(beginTime,endTime)
{
    var output = "";
    output += "<table cellspacing='0'><tr>";
    output += "<td>";
    output += TimeObj.toString('00:00:00');
    output += "</td>";
    output += "</tr></table>";		        
    document.all.item(beginTime).innerHTML=output;
    
    var TimeObj2 = new TimeControl();
    var output2 = "";
          output2 += "<table cellspacing='0'><tr>";
          output2 += "<td>";
          output2 += TimeObj2.toString('23:59:59');
          output2 += "</td>";
          output2 += "</tr></table>";                
    document.all.item(endTime).innerHTML=output2;
    return TimeObj2
}