

var TimeControlHandler = 
{
	TIMEALL:{},
    TIMEidCounter: 0 ,
    GetCounter: function ()
    {
		this.TIMEidCounter++ ;
        return this.TIMEidCounter;
    },
    onKeyDown: function(obj)
    {
        var srcObj = getEventObj(obj);
        var id = parseInt(srcObj.name.substr(12,4),10);
        this.TIMEALL[id].timeKeyDown(srcObj,obj);
    },
	timeControlClick: function(obj)
	{
	    obj = getEventObj(obj);
        var id = parseInt(obj.name.substr(12,4),10);
        this.TIMEALL[id].timeControlClick(obj);
	},
	saveId: function(obj)
	{
	    obj = getEventObj(obj);
        var id = parseInt(obj.name.substr(12,4),10);
        this.TIMEALL[id].saveId(obj);
	},
	mouseSelect: function(obj)
	{
	    obj = getEventObj(obj);
        var id = parseInt(obj.name.substr(12,4),10);
        this.TIMEALL[id].mouseSelect(obj);
	},
	addTime: function(obj)
	{
        obj = getEventObj(obj);
        var id = parseInt(obj.name.substr(12,4),10);
        this.TIMEALL[id].addTime(obj);
	},
	reduceTime: function(obj)
	{
	    obj = getEventObj(obj);
        var id = parseInt(obj.name.substr(12,4),10);
        this.TIMEALL[id].reduceTime(obj);
	},
	onTimePaste: function(obj)
	{
	    obj = getEventObj(obj);
		var id = parseInt(obj.name.substr(12,4),10);
		return this.TIMEALL[id].onTimePaste(obj);
	}
}

function TimeControl()
{
    for(var i=0 ; i<8; i++ )
    {
        this[i] = TimeControlHandler.GetCounter();
    }
    TimeControlHandler.TIMEALL[this[0]] = this ;
}

TimeControl.prototype.toString = function(defaultTime)
{
	var time;
	var hour;
	var minute;
	var second;	
	if (defaultTime != null || defaultTime != "")
	{
		time = defaultTime.split(":");
		hour = parseInt(time[0],10);
		minute = time[1];
		second = time[2];
	}
	else
	{
		hour = "";
		minute = "";
		second = "";
	}
	var strResult = "<table class='timeControl_wrap' name=\"TimeControl_"+this[0]+"\" id=\"TimeControl_"+this[0]+"\" cellpadding=0 cellspacing=0>";
	strResult += "<input type=hidden name=\"TimeControl_"+this[0]+"\" id=\"TimeControl_"+this[4]+"\" >";
	strResult += "<input type=hidden name=\"TimeControl_"+this[0]+"\" id=\"TimeControl_"+this[5]+"\" >";
	strResult += "<tr>";
	strResult += "<td rowspan=2 align=\"right\" style=\"WHITE-SPACE: nowrap\">";
	strResult += "<div class=\"TimeControlOuter\" name=\"TimeControl_"+this[0]+"\" align=center style=\"padding-right:4px\">";
	strResult += "<input class=\"TimeControlInner\" type=text name=\"TimeControl_"+this[0]+"\" id=\"TimeControl_"+this[1]+"\" maxlength=2  value=\""+hour+"\">:";
	strResult += "<input class=\"TimeControlInner\" type=text name=\"TimeControl_"+this[0]+"\" id=\"TimeControl_"+this[2]+"\" maxlength=2  value=\""+minute+"\">:";
	strResult += "<input class=\"TimeControlInner\" type=text name=\"TimeControl_"+this[0]+"\" id=\"TimeControl_"+this[3]+"\" maxlength=2  value=\""+second+"\">";
	strResult += "</div>";
	strResult += "</td>";
	strResult += "<td valign=\"bottom\" align=\"left\"><input type='button' name=\"TimeControl_"+this[0]+"\" id=\"TimeControl_"+this[6]+"\" class='button_add_time'></td>";
	strResult += "</tr>";
	strResult += "<tr>";
	strResult += "<td valign=\"top\" align=\"left\"><input type='button' name=\"TimeControl_"+this[0]+"\" id=\"TimeControl_"+this[7]+"\" class='button_reduce_time'></td>";
	strResult += "</tr>";
	strResult += "</table>";	
	return strResult;
}

TimeControl.prototype.enable = function(type)
{
	var time = "TimeControl_"+this[0];
	var time1 = "TimeControl_"+this[1];
	var time2 = "TimeControl_"+this[2];
	var time3 = "TimeControl_"+this[3];
	var timeObj = document.getElementById(time);
	var timeObj1 = document.getElementById(time1);
	var timeObj2 = document.getElementById(time2);
	var timeObj3 = document.getElementById(time3);
	if(type == 1)
	{
		timeObj.disabled = false;
		timeObj1.disabled = false;
		timeObj2.disabled = false;
		timeObj3.disabled = false;
		return;
	}
	if (type == 0)
	{
		timeObj.disabled = true;
		timeObj1.disabled = true;
		timeObj2.disabled = true;
		timeObj3.disabled = true;
		return;	
	}
}

TimeControl.prototype.timeJudgeDisabled = function()
{
	var time = "TimeControl_"+this[0];
	var time1 = "TimeControl_"+this[1];
	var time2 = "TimeControl_"+this[2];
	var time3 = "TimeControl_"+this[3];
	var timeObj = document.getElementById(time);
	var timeObj1 = document.getElementById(time1);
	var timeObj2 = document.getElementById(time2);
	var timeObj3 = document.getElementById(time3);

	if (timeObj.diabled == true || timeObj1.disabled == true || timeObj2.disabled == true || timeObj3.disabled == true)
	{
		return true;
	}
	else
	{
		return false;
	}
}


TimeControl.prototype.getTime = function()
{
	var time1 = "TimeControl_"+this[1];
	var time2 = "TimeControl_"+this[2];
	var time3 = "TimeControl_"+this[3];
	var objTime1 = document.getElementById(time1);
	var objTime2 = document.getElementById(time2);
	var objTime3 = document.getElementById(time3);

	if (objTime1.value == "" && objTime2.value == "" && objTime3.value == "")
	{
		return "";
	}
	else
	{
		var strHour = objTime1.value;
		if (strHour == '')
		{
			strHour = 0;
		}
		var strMinute = objTime2.value;
		if (strMinute == '')
		{
			strMinute = 0;
		}
		strMinute = this.showZeroField(parseInt(strMinute,10));
		
		var strSecond = objTime3.value;
		if (strSecond == '')
		{
			strSecond = 0;
		}
		strSecond = this.showZeroField(parseInt(strSecond,10));

		objTime1.value = strHour;
		objTime2.value = strMinute;
		objTime3.value = strSecond;
		return strHour+":"+strMinute+":"+strSecond;
	}
}

TimeControl.prototype.showZeroField = function(inValue)
{
	if (inValue > 9)
	{
		return inValue;
	}
	return "0" + inValue;
}


TimeControl.prototype.getPos = function(obj)
{
	var ml = obj.value.length;
	var pos = 0;
	
	if (window.event){
	    var rng = document.selection.createRange();
	    rng.moveEnd("character",ml);
	    try{
		  pos = ml-rng.text.length;
	    }
	    catch (e){
	    }
	}else{
	  pos = obj.selectionStart;
	}
	
	return pos;
}

TimeControl.prototype.setTime = function(timeStr)
{
	var time = timeStr.split(":");
	var time1 = "TimeControl_"+this[1];
	var time2 = "TimeControl_"+this[2];
	var time3 = "TimeControl_"+this[3];
	var objTime1 = document.getElementById(time1);
	var objTime2 = document.getElementById(time2);
	var objTime3 = document.getElementById(time3);
	if ((time[0] == "" || time[0] == null) && (time[1] == "" || time[1] == null) && (time[2] == "" || time[2] == null))
	{
		objTime1.value = "";
		objTime2.value = "";
		objTime3.value = "";
	}
	else
	{
		if (time[0] > 0 && time[0]<=23)
		{
			time[0] = parseInt(time[0],10);
			objTime1.value = time[0];
		}
		else
		{
			objTime1.value = "0";
		}

		if (time[1] > 0 && time[1]<=59)
		{
			objTime2.value = this.showZeroField(parseInt(time[1],10));
		}
		else
		{
			objTime2.value = "00";
		}

		if (time[2]>0 && time[2]<=59)
		{
			objTime3.value = this.showZeroField(parseInt(time[2],10));
		}
		else
		{
			objTime3.value = "00";
		}
		return true;
	}

}

TimeControl.prototype.timeControlClick = function(obj)
{
	if ((document.getElementById("TimeControl_"+this[1]).value == '')
		&&(document.getElementById("TimeControl_"+this[2]).value == '')
		&&(document.getElementById("TimeControl_"+this[3]).value == ''))
	{
		var today = new Date();
		var time1 = "TimeControl_"+this[1];
		var time2 = "TimeControl_"+this[2];
		var time3 = "TimeControl_"+this[3];
		var nowTimeHours = today.getHours();
		var nowTimeMinutes = today.getMinutes();
		var nowTimeSeconds = today.getSeconds();
		var objTime1 = document.getElementById(time1);
		var objTime2 = document.getElementById(time2);
		var objTime3 = document.getElementById(time3);
		objTime1.value = nowTimeHours;
		objTime2.value = this.showZeroField(parseInt(nowTimeMinutes,10));
		objTime3.value = this.showZeroField(parseInt(nowTimeSeconds,10));
	}
	var timeControlUp = document.getElementById("TimeControl_"+this[6]);
	var timeControlDown = document.getElementById("TimeControl_"+this[7]);
	timeControlUp.disabled = false;
	timeControlDown.disabled = false;
}

TimeControl.prototype.nextField = function(obj)
{
	obj.blur();
	var nextTime = parseInt(obj.id.substr(12,4),10);
	nextTime = nextTime + 1;
	if(nextTime >= this[3])
	{
		nextTime = this[3];
	}
	nextTime = "TimeControl_" + nextTime;
	var nextTimeObj = document.getElementById(nextTime);
	nextTimeObj.select();
}

TimeControl.prototype.previousField = function(obj)
{
	obj.blur();
	preTime = parseInt(obj.id.substr(12,4),10);
	preTime = preTime - 1;
	if (preTime <= this[1])
	{
		preTime = this[1];
	}
	preTime = "TimeControl_" + preTime;
    var preTimeObj = document.getElementById(preTime);
	preTimeObj.focus();
}
function judge(event){
  if (window.event){
      event.returnValue = false;
  }else{
      event.preventDefault();
  }
}
TimeControl.prototype.timeKeyDown = function(obj,event)
{
	var e = window.event || event;
	var code = e.keyCode||e.which;
	
	var cursorPos = this.getPos(obj);
	var tempTime="";
	
	if(code>=96&&code<=105)
	{
		code = code - 48;
	}
	var tempNum = String.fromCharCode(code);
    
    if(!((code>=8&&code<=9) || ((e.ctrlKey == true) && (code == 88 || code == 67 || code == 86)) ||(code>=37&&code<=40)||(code==46)||(code>=48&&code<=57)||(code>=96&&code<=105)))
	{
		judge(e);
	}
	
    if (e.shiftKey == true)
    {
		judge(e);
    }


	if (code == 9)
	{
		if(!(parseInt(obj.id.substr(12,4),10)==this[3]))
		{
			this.nextField(obj);
			judge(e);
		}
		
		return;
	}

	if (code == 38)
	{
		var currentField = document.getElementById("TimeControl_"+this[4]);
		currentField.value = obj.id;
		var add = document.getElementById("TimeControl_"+this[6]);
		add.click();
		return ;
	}

	if (code == 40)
	{
		var currentField = document.getElementById("TimeControl_"+this[4]);
		currentField.value = obj.id;
		var reduce = document.getElementById("TimeControl_"+this[7]);
		reduce.click();
		return;
	}

	if (code == 39)
	{
		if (cursorPos == obj.value.length)
		{
			this.nextField(obj);
			judge(e);
		}
		return;
	}
	
	if (code == 37)
	{
		if (cursorPos == 0)
		{
			this.previousField(obj);
			judge(e);
		}
		return;
	}

	if (document.getElementById("TimeControl_"+this[5]).value == 1)
	{
		document.getElementById("TimeControl_"+this[5]).value = 0;
		return false;
	}
	else
	{
		var temptext = "TimeControl_"+this[1];
		if (obj.id == temptext)
		{
			switch (cursorPos)
			{
				case 0:
				{
					var tempHour = tempNum+obj.value.charAt(0)+obj.value.charAt(1);
					var num = parseInt(tempHour,10);
					if (num>=24)
					{
						judge(e);
					}
					else
					{
						if ((obj.value.length>=1) && (tempNum == 0))
						{
							judge(e);
						}
					}
				}
				break;
				case 1:
				{
					tempMinu = obj.value.charAt(0)+tempNum+obj.value.charAt(1);
					var num = parseInt(tempMinu,10);
					if (num>=24)
					{
						judge(e);
					}
					else
					{
						if ((obj.value == 0) && (code>=48 && code<=57))
						{
							judge(e);
						}
					}
				}
				break;
			}
		}
		else
		{
			switch (cursorPos)
			{
				case 0:
				{
					tempHour = tempNum+obj.value.charAt(0)+obj.value.charAt(1);
					var num = parseInt(tempHour,10);
					if (num>=60)
					{
						judge(e);
					}
					else
					{
					}
				}
				break;
				case 1:
				{
					tempMinu = obj.value.charAt(0)+tempNum+obj.value.charAt(1);
					var num = parseInt(tempMinu,10);
					if (num>=60)
					{
						judge(e);
					}
				}
				break;
			}
		}
	}
}



TimeControl.prototype.saveId = function(obj)
{
	var currentTimeField = document.getElementById("TimeControl_"+this[4]);
	currentTimeField.value = obj.id;

	var time1 = "TimeControl_"+this[1];
	var time2 = "TimeControl_"+this[2];
	var time3 = "TimeControl_"+this[3];
	var objTime1 = document.getElementById(time1);
	var objTime2 = document.getElementById(time2);
	var objTime3 = document.getElementById(time3);

	if (obj.id == ("TimeControl_"+this[1]))
	{
		if (parseInt(obj.value,10) >= 0 && parseInt(obj.value,10) <= 23)
		{
			obj.value = parseInt(obj.value);
		}
		else
		{
			obj.value = "";
			if ((objTime1.value == "" || objTime1.value == null) 
				&& (objTime2.value == "" || objTime2.value == null)
				&& (objTime3.value == "" || objTime3.value == null))
			{
				obj.value = "";
			}
			else
			{
				obj.value = 0;
			}
			
		}
	}

	if (obj.id != ("TimeControl_"+this[1]))
	{
		if (parseInt(obj.value,10) <= 59 && parseInt(obj.value,10) >= 0)
		{
			obj.value = this.showZeroField(parseInt(obj.value,10));
		}
		else
		{
			obj.value = "";
			if ((objTime1.value == "" || objTime1.value == null) 
				&& (objTime2.value == "" || objTime2.value == null)
				&& (objTime3.value == "" || objTime3.value == null))
			{
				obj.value = "";
			}
			else
			{
				obj.value = "00";
			}
		}
	}
}


TimeControl.prototype.addTime = function(obj)
{
	this.timeControlClick();
	var objFieldId = document.getElementById("TimeControl_"+this[4]).value;
	if (objFieldId == "" || objFieldId == null)
	{
		objFieldId = "TimeControl_"+this[3];
	}

	var objField = document.getElementById(objFieldId);

	if (objField.id ==  "TimeControl_"+this[1])
	{ 
		this.hourAdd();
	}

	if (objField.id == "TimeControl_"+this[2])
	{
		this.minuteAdd();
	}
	if (objField.id == "TimeControl_"+this[3])
	{
		this.secondAdd();
	}
}

TimeControl.prototype.hourAdd = function()
{
	var time1Add = document.getElementById("TimeControl_"+this[1]);
	if (time1Add.value == "" || time1Add.value == null || time1Add.value == "null")
	{
		time1Add.value = "0";
	}

	time1Add.value = parseInt(time1Add.value,10) + 1;
	if (time1Add.value > 23)
	{
		time1Add.value = 0 ;
	}
}

TimeControl.prototype.minuteAdd = function()
{
	var time2Add = document.getElementById("TimeControl_"+this[2]);
	if (time2Add.value == "" || time2Add.value == null || time2Add.value == "null")
	{
		time2Add.value = "0";
	}
	time2Add.value =  parseInt(time2Add.value,10) + 1;
	if (time2Add.value > 59)
	{
		time2Add.value = "00";
		this.hourAdd();
	}
	time2Add.value = this.showZeroField(parseInt(time2Add.value,10));
}

TimeControl.prototype.secondAdd = function ()
{
	var time3Add = document.getElementById("TimeControl_"+this[3]);
	if (time3Add.value == "" || time3Add.value == null || time3Add.value == "null")
	{
		time3Add.value = "0";
	}
	time3Add.value =  parseInt(time3Add.value,10) + 1;
	if (time3Add.value > 59)
	{
		time3Add.value = "00";
		this.minuteAdd();
	}
	time3Add.value = this.showZeroField(parseInt(time3Add.value,10));
}

TimeControl.prototype.reduceTime = function (obj)
{
	this.timeControlClick();
	var objFieldId = document.getElementById("TimeControl_"+this[4]).value;
	if (objFieldId == "" || objFieldId == null)
	{
		objFieldId = "TimeControl_"+this[3];
	}

	var objField = document.getElementById(objFieldId);

	if (objField.id == "TimeControl_"+this[1])
	{
		this.hourReduce();
	}

	if (objField.id == "TimeControl_"+this[2])
	{
		this.minuteReduce();
	}
	if (objField.id == "TimeControl_"+this[3])
	{
		this.secondReduce();
	}
}

TimeControl.prototype.hourReduce = function()
{
	var time1Reduce = document.getElementById("TimeControl_"+this[1]);
	if (time1Reduce.value == "" || time1Reduce.value == null || time1Reduce.value == "null")
	{
		time1Reduce.value = "0";
	}
	time1Reduce.value = parseInt(time1Reduce.value,10) - 1;
	if (time1Reduce.value < 0)
	{
		time1Reduce.value = 23 ;
	}
}

TimeControl.prototype.minuteReduce = function()
{
	var time2Reduce = document.getElementById("TimeControl_"+this[2]);
	if (time2Reduce.value == "" || time2Reduce.value == null || time2Reduce.value == "null")
	{
		time2Reduce.value = "0";
	}
	time2Reduce.value =  parseInt(time2Reduce.value,10) - 1;
	if (time2Reduce.value < 0)
	{
		time2Reduce.value = "59";
		this.hourReduce();
	}
	time2Reduce.value = this.showZeroField(parseInt(time2Reduce.value,10));

}

TimeControl.prototype.secondReduce = function()
{
	var time3Reduce = document.getElementById("TimeControl_"+this[3]);
	if (time3Reduce.value == "" || time3Reduce.value == null || time3Reduce.value == "null")
	{
		time3Reduce.value = "0";
	}
	time3Reduce.value =  parseInt(time3Reduce.value,10) - 1;
	if (time3Reduce.value < 0)
	{
		time3Reduce.value = "59";
		this.minuteReduce();
	}
	time3Reduce.value = this.showZeroField(parseInt(time3Reduce.value,10));

}

TimeControl.prototype.mouseSelect = function (obj)
{
	var currentTimeSelect = document.getElementById("TimeControl_"+this[5]);
	currentTimeSelect.value = 1;
}

TimeControl.prototype.onTimePaste = function (obj)
{
	var s = window.clipboardData.getData('text'); 
	var flag = 1;
	for(i=0;i<s.length;i++) 
	{
		if((s.charAt(i)>='0' && s.charAt(i)<='9')) 
		{
			flag = 1;
		}
		else
		{
			flag = 0;
			break;
		}
	}
	
	if(flag == 1)
	{
		return true;
	}
	else
		return false;
}
