var MIN_VALUE = 1;
var PPS_VALUE = 2147483647;
var PPS_K_VALUE = 4294967;
var PPS_M_VALUE = 4294;
var PPS_G_VALUE = 4;

var BPS_VALUE = 2147483647;
var BPS_M_VALUE = 4294967;
var BPS_G_VALUE = 4294;

var nfaPolicies = ["hostTotal","tcpAbnormalFlood","tcpSynFlood","tcpFragmentFlood",
		"tcpAckFlood","tcpRstFinFlood","udpFlood","udpFragmentFlood",
		"dnsQueryFlood","dnsReplyFlood","httpFlood","httpsFlood",
		"sipFlood","icmpFlood","otherFlood","darkIp"];
var policyDetails = ["Name","PpsUnit","PpsThreshold","BpsUnit","BpsThreshold"];//顺序必须保证
function verifyForm(PACKET_RATE_THRESHOLD,BANDWIDTH_THRESHOLD,ERROR){
	var isCorrect = true;
	var name = "";
	var enable = "";
	var ppsUnit = "";
	var ppsValue = "";
	for(var i = 0; i < nfaPolicies.length; i++){
		var j = 0;
		name = document.getElementById(nfaPolicies[i] + policyDetails[j++]).value;
		ppsUnit = document.getElementById(nfaPolicies[i] + policyDetails[j++]).value;
		ppsValue = document.getElementById(nfaPolicies[i] + policyDetails[j++]).value;
		var bpsUnit = document.getElementById(nfaPolicies[i] + policyDetails[j++]).value;
		var bpsValue = document.getElementById(nfaPolicies[i] + policyDetails[j++]).value;
		isCorrect = verifyPacketRateThreshold(ppsUnit,ppsValue);
		name = htmlEncode(name);
		if(isCorrect == false){
			var msg = name + PACKET_RATE_THRESHOLD + ERROR;
			LegoTag.Msg.failed(msg);
			break;
		}
		isCorrect = verifyBandwidthThreshold(bpsUnit,bpsValue);
		if(isCorrect == false){
			var msg = name + BANDWIDTH_THRESHOLD + ERROR;
			LegoTag.Msg.failed(msg);
			break;
		}
	}
	return isCorrect;
}

function verifyPacketRateThreshold(ppsUnit,ppsValue){
	var isCorrect = true;
	if (ppsUnit.indexOf("K") >= 0 || ppsUnit == "") {
		console.log("ppsUnit indexOf K");
		isCorrect = verifyNumberScope(ppsValue,PPS_K_VALUE);
	} else if (ppsUnit.indexOf("M") >= 0) {
		console.log("ppsUnit indexOf M");
		isCorrect = verifyNumberScope(ppsValue,PPS_M_VALUE);
	} else if (ppsUnit.indexOf("G") >= 0) {
		console.log("ppsUnit indexOf G");
		isCorrect = verifyNumberScope(ppsValue,PPS_G_VALUE);
	} else {
		console.log("ppsUnit indexOf pps");
		isCorrect = verifyNumberScope(ppsValue,PPS_VALUE);
	}
	return isCorrect;
}

function verifyBandwidthThreshold(bpsUnit,bpsValue){
	var isCorrect = true;
	if (bpsUnit.indexOf("M") >= 0) {
		console.log("bpsUnit indexOf M");
		isCorrect = verifyNumberScope(bpsValue,BPS_M_VALUE);
	} else if (bpsUnit.indexOf("G") >= 0) {
		console.log("bpsUnit indexOf G");
		isCorrect = verifyNumberScope(bpsValue,BPS_G_VALUE);
	} else {
		console.log("bpsUnit indexOf K");
		isCorrect = verifyNumberScope(bpsValue,BPS_VALUE);
	}
	return isCorrect;
}

function verifyNumberScope(value,maxValue){
	console.log(value + " " + MIN_VALUE + " " + maxValue);
	if(value < MIN_VALUE || value > maxValue){
		return false;
	}
	return true;
}

