var ConditionUtils = {
	override : function(o, oo) {
		for (var m in oo) {
			o[m] = oo[m];
		}
		return o;
	},

	isTrue: function(v) { return v===true||v==="true"}	,
	isFalse: function(v) { return v===false||v==="false"}	,
	
	createCombobox : function(param) {
		return jQuery.sexyCombo.create(param);
	},
	
	createChooseObjGroup : function(param) {
		param.columns = this.df(param.columns, 4);
		param.type = this.df(param.type, "checkbox");

		var container = jQuery("#" + param.containerId);
		var tab = jQuery("<table border='0' cellspacing='0' cellpadding='0'></tr>");
		var tr = jQuery("<tr></tr>");
		var rows = [];
		jQuery.each(param.data, function(i, _obj) {
			if (i > 0 && (i % param.columns) === 0) {
				rows.push(tr);
				tr = jQuery("<tr></tr>");
			}
			var td = jQuery("<td width='19%' nowrap></td>");
			var _label = _obj[param.displayField];
			if (_label.length > 10) {
				_label = _label.substring(0, 10) + "...";
			}
			jQuery("<input type='" + param.type + "' value='"
					+ _obj[param.valueField] + "' name='" + param.name + "'/>")
					.data("text", _obj[param.displayField]).appendTo(td);
			jQuery("<label title='" + _obj[param.displayField] + "'>" + _label
					+ "</label>").appendTo(td);
			td.appendTo(tr);
			if (i == param.data.length - 1) {
				rows.push(tr);
			}
		})

		jQuery.each(rows, function(i, _row) {
			_row.appendTo(tab);
		});
		tab.appendTo(container);
	},
	df : function(v, defv) {
		if (v)
			return v;
		return defv;
	},
	el : function(el, doc) {
		if (typeof el == 'string') {
			doc = doc?doc: document;
			return doc.getElementById(el);
		}
		return el;
	},
	sel: function(el) {
		el = this.el(el);
		if(el) {
			el.style.display = "";
		}
	},
	hel: function(el) {
		el = this.el(el);
		if(el) {
			el.style.display = "none";
		}
	},
	getTopDocument : function() {
		var pw = this.getTopWindow();
		if(this.isFrame(pw)) {
			pw = this.getTopWindowNotFrame(pw);
		}
		return pw.document;
	},
	isFrame : function(win){
		return win.document.body.tagName == "FRAMESET";
	},
	getTopWindowNotFrame : function(win){
		var cur = window;
		while(cur.parent != win)
		{
			cur = cur.parent;
		}
		return cur;
	},
	getTopWindow : function() {
		var pw = window;
		while (pw != pw.parent) {
			pw = pw.parent;
		}
		return pw;
	},
	showBodySrollbar : function(b,doc) {
		doc = doc?doc:document;
		var temp_h1 = doc.body.clientHeight;
		var temp_h2 = doc.documentElement.clientHeight;
		var isXhtml = (temp_h2<=temp_h1&&temp_h2!=0)?true:false; 
		var htmlbody = isXhtml?doc.documentElement:doc.body;
		
		if(b === false) {
			htmlbody.style.overflow = "hidden";
		}
		else 
			htmlbody.style.overflow = "auto";
	},
	createIPAddress : function(param) {
		var ip = createIPCom({
			imgPath : param.imgPath,
			ipName : param.ipName,
			hasPort : param.hasPort,
			add : param.add,
			index : param.container.children().length
		});
		param.container.append(ip);
	},
	createIPDouble : function(param) {
		var cp = createIPDouble({
			imgPath : param.imgPath,
			firstName : param.firstName,
			secondName : param.secondName,
			hasPort : param.hasPort,
			add : param.add,
			index : param.container.children().length,
			type : param.type
		});
		param.container.append(cp);
	},
	createTree : function(param){
		var selMode = {
			"single" : 1,
			"multi" : 2,
			"multi-hier" : 3};
		jQuery("#" + param.treeId, param.doc).dynatree({
			checkbox: ConditionUtils.isTrue(param.checkbox),
			selectMode: selMode[param.selectMode],
			children: param.data,
			rootVisible: false,
			onSelect: function(select, dtnode) {
			},
			onClick: function(dtnode, event) {
				if( dtnode.getEventTargetType(event) == "title" )
				    dtnode.toggleSelect(); 
			},
			onKeydown: function(dtnode, event) {
				if( event.which == 32 ) {
					dtnode.toggleSelect();
					return false;
				}
			},
			cookieId: "ui-dynatree-Cb2",
			idPrefix: "ui-dynatree-Cb2-"
		});
	},
	getClipboardText : function (){
	    if (window.clipboardData) 
	    {
	        return (window.clipboardData.getData('text'));
	    } 
	    else 
	    {
	        if (window.netscape) 
	        {
	            try 
	            {
	                netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
	                var clip = Components.classes["@mozilla.org/widget/clipboard;1"].createInstance(Components.interfaces.nsIClipboard);
	                if (!clip) 
	                {
	                    return;
	                }
	                var trans = Components.classes["@mozilla.org/widget/transferable;1"].createInstance(Components.interfaces.nsITransferable);
	                if (!trans) 
	                {
	                    return;
	                }
	                trans.addDataFlavor("text/unicode");
	                clip.getData(trans, clip.kGlobalClipboard);
	                var str = new Object();
	                var len = new Object();
	                trans.getTransferData("text/unicode", str, len);
	            }
	            catch (e) 
	            {
	                alert("您的firefox安全限制限制您进行剪贴板操作，请打开'about:config'将 signed.applets.codebase_principal_support'设置为true'之后重试，相对路径为firefox根目录 /greprefs/all.js");
	                return null;
	            }
	            if (str) 
	            {
	                if (Components.interfaces.nsISupportsWString) 
	                {
	                    str = str.value.QueryInterface(Components.interfaces.nsISupportsWString);
	                } 
	                else 
	                {
	                    if (Components.interfaces.nsISupportsString) 
	                    {
	                        str = str.value.QueryInterface(Components.interfaces.nsISupportsString);
	                    } 
	                    else 
	                    {
	                        str = null;
	                    }
	                }
	            }
	            if (str) 
	            {
	                return (str.data.substring(0, len.value / 2));
	            }
	        }
	    }
    	return null;
	}
}

$C = $CUtils = ConditionUtils;

Array.prototype.remove = function(s) {
	for (var i = 0; i < this.length; i++) {
		if (s == this[i]) {
			this.splice(i, 1);
		}
	}
}

var DragHandler = {
	
	init : function(h, ds, doc) {
		doc = doc?doc:document;
		h = typeof h=='string'?jQuery("#" + h, doc):jQuery(h, doc);
		ds = typeof ds=='string'?jQuery("#" + ds, doc):jQuery(ds, doc)
		h.dragSource = ds;
		if (isNaN(ds.css("left"))) ds.css("left", "0px");
		if (isNaN(ds.css("top"))) ds.css("top", "0px");
		h.bind("mousedown", h,  this.start);
	},
	
	start : function(e) {
		var h = e.data;
		var ds = h.dragSource;
		
		var top = ds.position().top;
		var left = ds.position().left;

		h.lastMouseX = e.pageX;
		h.lastMouseY = e.pageY;
		
		jQuery(h.context).bind("mousemove", h, DragHandler.drag);
		jQuery(h.context).bind("mouseup", h, DragHandler.end);
		
		return false;
	},
	
	drag : function(e) {
		var h = e.data;
		var ds = h.dragSource;
		
		var mouseY = e.pageY;
		var mouseX = e.pageX;
		
		var top = ds.position().top;
		var left = ds.position().left;

		if (jQuery.browser.msie) {
			ds.get(0).setCapture();
		} else {
			e.preventDefault();
		};
		
		ds.css("left", left + mouseX - h.lastMouseX);
		ds.css("top", top + mouseY - h.lastMouseY);
		h.lastMouseX = mouseX;
		h.lastMouseY = mouseY;

		return false;
	},
	end : function(e) {
		var h = e.data;
		if (jQuery.browser.msie) {
			h.dragSource.get(0).releaseCapture();
		} else {
			e.preventDefault();
		};
		jQuery(h.context).unbind("mousemove");
		jQuery(h.context).unbind("mouseup");
	}
};