USE `lego`;

DROP PROCEDURE IF EXISTS add_np_filter_rule;
DELIMITER //
CREATE PROCEDURE add_np_filter_rule()
BEGIN

	IF (NOT EXISTS(SELECT * FROM t_vsm_np_filter WHERE filter_name = 'NTP_Amplification_Attack_1123')) and (NOT EXISTS(SELECT * FROM t_vsm_np_filter_rule WHERE source_port = '1123' and packet_start_len = 256 and packet_end_len = 1500))
	THEN
	INSERT INTO `t_vsm_np_filter` (`filter_index`, `filter_name`, `ip_type`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`) SELECT (MAX(filter_index)+1) ,'NTP_Amplification_Attack_1123','IPV4','UDP',NULL,1,10000 FROM `t_vsm_np_filter`;
	INSERT INTO `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) VALUES((SELECT pkid FROM t_vsm_np_filter WHERE filter_name = 'NTP_Amplification_Attack_1123'),(SELECT pkid FROM t_vsm_np_filter WHERE filter_name='NTP_Amplification_Attack_1123'),NULL,NULL,NULL,1123,256,1500,NULL);
END IF;

END;
//
DELIMITER ;
CALL add_np_filter_rule();

DROP PROCEDURE IF EXISTS add_np_filter_rule;


DROP PROCEDURE IF EXISTS add_http_policy;
DELIMITER //
CREATE PROCEDURE add_http_policy() BEGIN
    IF NOT EXISTS(SELECT * FROM information_schema.columns
		WHERE table_name = 't_vsm_zone_httpflood' AND column_name ='high_freq_detect_enable')
    THEN
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN high_freq_detect_enable BIT(1) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN high_freq_detect_threshold int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN high_freq_detect_interval int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN http_fix_uri_enable BIT(1) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN http_fix_uri_ratio_number int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN http_fix_uri_threshold int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN http_fix_uri_interval int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN large_res_detect_enable BIT(1) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN large_res_size int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN large_res_detect_ratio int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN large_res_detect_threshold int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN large_res_detect_interval int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN http_illegal_session_check_enable BIT(1) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN null_method_check BIT(1) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN range_header_check BIT(1) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN multi_get_check BIT(1) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN http_illegal_session_num int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN http_illegal_session_interval int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN dest_ip_conn_num_enable BIT(1) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpflood ADD COLUMN dest_ip_conn_num int(11) DEFAULT NULL;
	END IF;
END;
//
DELIMITER ;
CALL add_http_policy();

DROP PROCEDURE IF EXISTS add_http_policy;