USE `lego`;

DROP PROCEDURE IF EXISTS add_https_policy;
DELIMITER //
CREATE PROCEDURE add_https_policy() BEGIN
    IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE table_name = 't_vsm_zone_httpsflood' AND column_name ='https_high_freq_detect_enable')
    THEN
        ALTER TABLE t_vsm_zone_httpsflood ADD COLUMN https_high_freq_detect_enable BIT(1) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpsflood ADD COLUMN https_high_freq_detect_threshold int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpsflood ADD COLUMN https_high_freq_detect_interval int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpsflood ADD COLUMN https_fix_res_enable BIT(1) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpsflood ADD COLUMN https_fix_res_ratio_number int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpsflood ADD COLUMN https_fix_res_threshold int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpsflood ADD COLUMN https_fix_res_interval int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpsflood ADD COLUMN https_large_res_detect_enable BIT(1) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpsflood ADD COLUMN https_large_res_size int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpsflood ADD COLUMN https_large_res_detect_ratio int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpsflood ADD COLUMN https_large_res_detect_threshold int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpsflood ADD COLUMN https_large_res_detect_interval int(11) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpsflood ADD COLUMN https_dest_ip_conn_num_enable BIT(1) DEFAULT NULL;
		ALTER TABLE t_vsm_zone_httpsflood ADD COLUMN https_dest_ip_conn_num int(11) DEFAULT NULL;
        ALTER TABLE t_vsm_zone_httpsflood ADD COLUMN https_src_advance_enable BIT(1) DEFAULT NULL;

    END IF;
END;
//
DELIMITER ;
CALL add_https_policy();

DROP PROCEDURE IF EXISTS add_https_policy;