(
function ()
{
var tooltip = new Tooltip();
if(window.addEventListener)
{
window.addEventListener("load",init,false);
}
else if(window.attachEvent)
{
window.attachEvent("onload",init);
}
function init()
{
var links2 = document.getElementsByTagName('span');
for(var i = 0; i < links2.length; i++)
{
if(links2[i].id)
{
addTooltipToLink(links2[i]);
}
}
}
function addTooltipToLink(link)
{
if(link.addEventListener)
{
link.addEventListener("mouseover",mouseover,false);
link.addEventListener("mouseout",mouseout,false);
}
else if(link.attachEvent)
{
link.attachEvent("onmouseover",mouseover);
link.attachEvent("onmouseout",mouseout);
}
var timer;
function mouseover(event)
{
var e = event || window.event;
var x = e.clientX + Geometry.getHorizontalScroll()+17;
if(x > 580)
{
x = e.clientX + Geometry.getHorizontalScroll() - 190;
}
var y = e.clientY + Geometry.getVerticalScroll()-40;
if(timer)
{
window.clearTimeout(timer);
}
timer = window.setTimeout(showTooltip,500);
function showTooltip()
{
var id = link.id;
var name = link.name;
if(id && name != "")
{
tooltip.show(name,x,y);
}
}
}
function mouseout(e)
{
if(timer)
{
window.clearTimeout(timer);
}
timer = null;
tooltip.hide();
}
}
}
)();
