function SortableTable(tableBak,tableorl,oSortTypes,rowcount)
{
if(tableNumbers>1000)
return;
if(tableorl == null || tableorl == "null")
{
tableorl = tableBak;
}
var oTable = document.getElementById(tableorl);
var oTable2 = document.getElementById(tableBak);
this.element = oTable;
var scripts = document.getElementsByTagName("script");
for(var s = 0;s < scripts.length;s++)
{
var script = scripts[s];
if(script.src.indexOf("sortabletable") > -1)
{
var srcTemp = script.src;
this.imgPath = srcTemp.replace("script/tool/sortabletable.js","img/");
}
}
this.tHead = oTable2.tHead;
this.tBody = oTable.tBodies[0];
this.document = oTable.ownerDocument||oTable.document;
this.sortColumn = null;
this.descending = null;
var oThis = this;
this._headerOnclick = function(e)
{
oThis.headerOnclick(e);
};
var win = this.document.defaultView||this.document.parentWindow;
this._onunload = function()
{
};
if(win && win.attachEvent)
{
win.attachEvent("onunload",this._onunload);
}
this.initHeader(oSortTypes||[]);
}
SortableTable.gecko = navigator.product == "Gecko";
SortableTable.msie = /msie/i.test(navigator.userAgent);
SortableTable.removeBeforeSort = SortableTable.gecko;
SortableTable.prototype.onsort = function(){};
SortableTable.prototype.initHeader = function(oSortTypes)
{
var cells = this.tHead.rows[0].cells;
var l = cells.length;
var img,c;
for(var i = 0;i<l;i++)
{
c = cells[i];
img = this.document.createElement("IMG");
img.src = this.imgPath + "none.gif";
if(oSortTypes[i] != "none")
{
c.appendChild(img);
}
if(oSortTypes[i]!=null)
{
c._sortType = oSortTypes[i];
}
if(c.addEventListener)
{
c.addEventListener("click",this._headerOnclick,false);
}
else if(c.attachEvent)
{
c.attachEvent("onclick",this._headerOnclick);
}
}
flagInitSort = true;
this.updateHeaderArrows();
};
SortableTable.prototype.uninitHeader = function()
{
var cells = this.tHead.rows[0].cell;
var l = cells.length;
var c;
for(var i = 0;i<l;i++)
{
c = cells[i];
c.removeChild(c.lastChild);
if(typeof c.removeEventListener!="underfined")
{
c.removeEventListener("click",this._headerOnclick,false);
}
else if(typeof c.detachEvent!="underfined")
{
c.detachEvent("onclick",this._headerOnclick);
}
}
};
SortableTable.prototype.updateHeaderArrows = function()
{
var cells = this.tHead.rows[0].cells;
var l = cells.length;
var img;
for(var i = 0;i<l;i++)
{
img = cells[i].lastChild;
if(i == this.sortColumn)
{
img.src = this.descending ?  this.imgPath+"down.gif" :  this.imgPath+"up.gif";
}
else
{
if(img)
{
if(img.src)
{
img.src = this.imgPath+"none.gif" ;
}
}
}
}
if (flagInitSort)
{
flagInitSort = false;
this.initCurrSortColumn(cells);
}
};
SortableTable.currCellIndex = null;
SortableTable.prototype.headerOnclick = function(e)
{
var el = e.target || e.srcElement;
while(el.tagName != "TD")
{
el = el.parentNode;
}
SortableTable.currCellIndex = el.cellIndex;
this.sort(el.cellIndex);
};
SortableTable.getCellIndex = function(oTd)
{
var cells = oTd.parentNode.childNodes;
var l = cells.length;
var i;
for(i=0;cells[i]!=oTd&&i<l;i++)
{
return i;
}
};
SortableTable.prototype.getSortType = function(nColumn)
{
var cell = this.tHead.rows[0].cells[nColumn];
var val = cell._sortType;
if(val != "")
{
return val;
}
return "String";
};
SortableTable.prototype.sort = function(nColumn,bDescending,sSortType)
{
var sflag = nColumn!=this.sortColumn;
if(sSortType == null)
{
sSortType = this.getSortType(nColumn);
}
if(sSortType == "none")
{
return;
}
if(bDescending == null)
{
if(this.sortColumn != nColumn)
{
this.descending = false;
}
else
{
this.descending = !this.descending;
}
}
this.sortColumn = nColumn;
if(typeof this.onbeforesort == "function")
{
this.onbeforesort();
}
var a;
if(!this.tBody)
{
this.oTable=document.getElementsByTagName('table');
this.tBody = this.oTable[0].tBodies[0];
}
var tBody = this.tBody;
if(sSortType == "interface")
{
a = this.getCache(sSortType,nColumn);
var EArr = new Array();
var GEArr = new Array();
var XGEArr = new Array();
var TrunkArr = new Array();
var VlanArr = new Array();
var GlobArr = new Array();
for(var i = 0;i<a.length;i++)
{
if(a[i].value.indexOf("Ethernet") == 0)
{
EArr.push(a[i]);
}
if(a[i].value.indexOf("GigabitEthernet") == 0)
{
GEArr.push(a[i]);
}
if(a[i].value.indexOf("XGigabitEthernet") == 0)
{
XGEArr.push(a[i]);
}
if(a[i].value.indexOf("Eth-Trunk") == 0)
{
TrunkArr.push(a[i]);
}
if(a[i].value.indexOf("vlan") == 0)
{
VlanArr.push(a[i]);
}
if(a[i].value.indexOf("global") == 0)
{
GlobArr.push(a[i]);
}
}
var f2 = this.getSortFunction2(sSortType,nColumn);
if(sflag)
{
EArr.sort(f2);
GEArr.sort(f2);
TrunkArr.sort(f2);
XGEArr.sort(f2);
VlanArr.sort(f2);
GlobArr.sort(f2);
}
EArr.reverse();
GEArr.reverse();
TrunkArr.reverse();
XGEArr.reverse();
VlanArr.reverse();
GlobArr.reverse();
if(this.descending)
{
a.reverse();
}
else
{
a = VlanArr.concat(TrunkArr).concat(EArr).concat(GEArr).concat(GlobArr).concat(XGEArr);
}
}
else if(sSortType == "ip")
{
var f3 = this.getSortFunction3();
a = this.getCache(sSortType,nColumn);
if(sflag){
a.sort(f3);
}
a.reverse();
}
else if(sSortType == "time")
{
var f3 = this.getSortFunctionTime();
a = this.getCache(sSortType,nColumn);
if(sflag){
a.sort(f3);
}
a.reverse();
}
else
{
var f = this.getSortFunction(sSortType,nColumn);
a = this.getCache(sSortType,nColumn);
if(sflag){
a.sort(f);
}
a.reverse();
}
if(a[0]!=undefined)
{
if(SortableTable.removeBeforeSort)
{
var nextSibling = tBody.nextSibling;
var p = tBody.parentNode;
p.removeChild(tBody);
}
var l = a.length;
for(var i = 0;i<l;i++)
{
var className = (i % 2 == 0) ? "even_td" : "odd_td";
a[i].element.className  = className;
tBody.appendChild(a[i].element);
}
if(SortableTable.removeBeforeSort)
{
p.insertBefore(tBody,nextSibling);
}
this.updateHeaderArrows();
this.destroyCache(a);
if(typeof this.onsort == "function")
{
this.onsort();
}
}
};
SortableTable.prototype.asyncSort = function(nColumn,bDescending,sSortType)
{
var oThis = this;
this._asyncsort = function()
{
oThis.sort(nColumn,bDescending,sSortType);
};
window.setTimeout(this._asyncsort,1);
};
SortableTable.prototype.getCache = function(sType,nColumn)
{
if(!this.tBody)
{
this.oTable=document.getElementsByTagName('table');
this.tBody = this.oTable[0].tBodies[0];
}
var rows = this.tBody.rows;
var l = rows.length;
var a = new Array(l);
var r;
for(var i = 0;i<l;i++)
{
r = rows[i];
if(r.className != "")
{
a[i] = {value:this.getRowValue(r,sType,nColumn),element:r};
}
}
return a;
};
SortableTable.prototype.destroyCache = function(oArray)
{
var l = oArray.length;
for(var i = 0;i<l;i++)
{
oArray[i].value = null;
oArray[i].element = null;
oArray[i] = null;
}
};
SortableTable.prototype.getRowValue = function(oRow,sType,nColumn)
{
var s;
var c = oRow.cells[nColumn];
if(c.innerText)
{
s = c.innerText;
}
else if(c.textContent)
{
s = c.textContent;
}
else
{
s = SortableTable.getInnerText(c);
}
s = trim(s);
return this.getValueFromString(s,sType);
};
SortableTable.getInnerText = function(oNode)
{
var s = "";
var cs = oNode.childNodes;
var l = cs.length;
for(var i = 0;i<l;i++)
{
switch(cs[i].nodeType)
{
case 1:
s += SortableTable.getInnerText(cs[i]);
break;
case 3:
s += cs[i].nodeValue;
break;
}
}
return s;
};
SortableTable.prototype.getValueFromString = function(sText,sType)
{
switch(sType)
{
case "number": return Number("1"+sText);
case "caseInsensitiveString" : return sText.toUpperCase();
case "date":
var parts = sText.split("-");
var d = new Date(0);
d.setFullYear(parts[0]);
d.setDate(parts[2]);
d.setMonth(parts[1] -1);
return d.valueOf();
case "interface":
return sText;
case "Vlanif" : return Number(sText.replace("Vlanif",""));
case "LoopBack" : return Number(sText.replace("LoopBack",""));
case "Eth-Trunk" : return Number(sText.replace("Eth-Trunk",""));
case "speed" : return Number(sText.replace("Mbits/s",""));
case "IPv6" : return fullIPv6(sText);
}
return sText;
};
SortableTable.prototype.getSortFunction = function(sType,nColumn)
{
return function compare(n1,n2)
{
if(n1.value < n2.value)
{
return 1;
}
if(n2.value < n1.value)
{
return -1;
}
return 0;
};
};
SortableTable.prototype.changeTime = function changeTime(n1)
{
var tempTime = n1.split(' ');
var str="";
var month = trim(tempTime[0]);
switch(month)
{
case 'Jan':tempTime[0] = '01';break;
case 'Feb':tempTime[0] = '02';break;
case 'Mar':tempTime[0] = '03';break;
case 'Apr':tempTime[0] = '04';break;
case 'May':tempTime[0] = '05';break;
case 'Jun':tempTime[0] = '06';break;
case 'Jul':tempTime[0] = '07';break;
case 'Aug':tempTime[0] = '08';break;
case 'Sep':tempTime[0] = '09';break;
case 'Oct':tempTime[0] = '10';break;
case 'Nov':tempTime[0] = '11';break;
case 'Dec':tempTime[0] = '12';break;
default:break;
}
var x = 0;
for(var n = 0; n < tempTime.length; n++){
if(tempTime[n] != ""){
tempTime[x]=tempTime[n];
x++;
}
}
var day = trim(tempTime[1]);
switch(day)
{
case '1':tempTime[1] = '01';break;
case '2':tempTime[1] = '02';break;
case '3':tempTime[1] = '03';break;
case '4':tempTime[1] = '04';break;
case '5':tempTime[1] = '05';break;
case '6':tempTime[1] = '06';break;
case '7':tempTime[1] = '07';break;
case '8':tempTime[1] = '08';break;
case '9':tempTime[1] = '09';break;
default:break;
}
return tempTime[2]+" "+tempTime[0]+"/"+tempTime[1]+" "+tempTime[3];
};
SortableTable.prototype.getSortFunctionTime = function()
{
return function compare(n1,n2)
{
var v1 = this.changeTime(n1.value);
var v2 = this.changeTime(n2.value);
if(v1 < v2)
{
return 1;
}
if(v2 < v1)
{
return -1;
}
return 0;
};
};
SortableTable.prototype.getSortFunction2 = function(sType,nColumn)
{
return function compare(n1,n2)
{
var n1Int;
var n2Int;
var n1arr;
var n2arr;
var flag = false;
if(n1.value.indexOf("Eth-Trunk") == 0)
{
n1Int = Number(n1.value.substring(9,n1.value.length));
flag = false;
}
else if(n1.value.indexOf("vlan") == 0)
{
n1Int = Number(n1.value.substring(4,n1.value.length));
flag = false;
}
else
{
var temp = (((n1.value.replace("XGigabitEthernet","")).replace("GigabitEthernet","")).replace("Ethernet","")).replace("MEth","");
n1arr = temp.split("/");
flag = true;
}
if(n2.value.indexOf("Eth-Trunk") == 0)
{
n2Int = Number(n2.value.substring(9,n2.value.length));
}
else if(n2.value.indexOf("vlan") == 0)
{
n2Int = Number(n2.value.substring(4,n2.value.length));
}
else
{
var temp2 = (((n2.value.replace("XGigabitEthernet","")).replace("GigabitEthernet","")).replace("Ethernet","")).replace("MEth","");
n2arr = temp2.split("/");
}
if (!flag)
{
if(n1Int < n2Int)
{
return 1;
}
if(n2Int < n1Int)
{
return -1;
}
}
else
{
if (Number(n1arr[0]) > Number(n2arr[0]))
{
return -1;
}
else if(Number(n1arr[0]) < Number(n2arr[0]))
{
return 1;
}
else if (Number(n1arr[1]) > Number(n2arr[1]))
{
return -1;
}
else if(Number(n1arr[1]) < Number(n2arr[1]))
{
return 1;
}
else if (Number(n1arr[2]) > Number(n2arr[2]))
{
return -1;
}
else if(Number(n1arr[2]) < Number(n2arr[2]))
{
return 1;
}
}
return 0;
};
};
SortableTable.prototype.getSortFunction3 = function()
{
return function compare(n1,n2)
{
var n1arr;
var n2arr;
n1arr = n1.value.split(".");
n2arr = n2.value.split(".");
if(n1arr.length<4)
{
if(n1.value < n2.value)
{
return 1;
}
if(n2.value < n1.value)
{
return -1;
}
return 0;
}
if (Number(n1arr[0]) > Number(n2arr[0]))
{
return -1;
}
else if(Number(n1arr[0]) < Number(n2arr[0]))
{
return 1;
}
else if (Number(n1arr[1]) > Number(n2arr[1]))
{
return -1;
}
else if(Number(n1arr[1]) < Number(n2arr[1]))
{
return 1;
}
else if (Number(n1arr[2]) > Number(n2arr[2]))
{
return -1;
}
else if(Number(n1arr[2]) < Number(n2arr[2]))
{
return 1;
}
else if (Number(n1arr[3]) > Number(n2arr[3]))
{
return -1;
}
else if(Number(n1arr[3]) < Number(n2arr[3]))
{
return 1;
}
return 0;
};
};
SortableTable.prototype.destroy = function()
{
this.uninitHeader();
var win = this.document.parentWindow;
if(win && win.detachEvent)
{
win.detachEvent("onunload",this._onunload);
}
this._onunload = null;
this.element = null;
this.tHead = null;
this.tBody = null;
this.document = null;
this.imgPath = null;
this._headerOnclick = null;
this.sortTypes = null;
this._asyncsort = null;
this.onsort = null;
};
var sortInfo = "";
SortableTable.getCurrSortColumnInfo = function(tableBak)
{
sortInfo = "";
var headTable = document.getElementById(tableBak);
var cIndex = SortableTable.currCellIndex;
if (!headTable || !cIndex)
{
sortInfo = "";
return;
}
var tHead = headTable.tHead;
var sortCell = tHead.rows[0].cells[cIndex];
if (sortCell)
{
var htmlStr = sortCell.innerHTML;
if (-1 != htmlStr.indexOf("up.gif"))
{
sortInfo = cIndex + ":" +"up";
}
else if (-1 != htmlStr.indexOf("down.gif"))
{
sortInfo = cIndex + ":" +"down";
}
}
};
var flagInitSort = false;
SortableTable.prototype.initCurrSortColumn = function(cells)
{
var cIndex = SortableTable.currCellIndex;
if (!cIndex || "" == sortInfo)
{
return;
}
if (cIndex != sortInfo.split(":")[0])
{
return;
}
var sortCell = cells[cIndex];
if (sortCell)
{
if ("up" == sortInfo.split(":")[1])
{
this.sort(cIndex);
}
else if ("down" == sortInfo.split(":")[1])
{
this.sort(cIndex);
this.sort(cIndex);
}
}
};
function fullIPv6(str)
{
if(str!="")
{
var temp = str.split("::");
var temp2 = str.split(":");
var str2=":";
var j = 0;
str = "";
for(var i = 0;i < temp2.length; i++)
{
if(temp2[i]!="")
{
j = j + 1;
}
str=str+IPv6FullZero(temp2[i])+":";
}
str = str.substring(0,str.length-1);
for(var t=0;t<8 - j;t++)
{
str2=str2+"0000:";
}
str=str.replace("::",str2);
if(str.charAt(str.length-1)==":")
{
str = str.substring(0,str.length-1);
}
}
return IPv4FullZero(str);
}
function IPv6FullZero(str)
{
if(str.length==1)
{
str="000"+str;
}
else if(str.length==2)
{
str="00"+str;
}
else if(str.length==3)
{
str="0"+str;
}
return str;
}
function IPv4FullZero(str)
{
var temp = str.split(".");
if(temp.length==4)
{
str="";
for(var i=0;i<4;i++){
if(temp[i].length==1)
{
str=str+".00"+temp[i];
}
else if(temp[i].length==2)
{
str=str+".0"+temp[i];
}
else if(temp[i].length==3)
{
str=str+"."+temp[i];
}
}
}
return str;
}
