function tranParam(number,iName,index)
{
var str = " number=\""+number+"\"";
if(index)
{
if(typeof(iName) == "string")
{
str += " "+iName+"=\""+index+"\"";
}
else
{
for(var i = 0;i<iName.length;i++)
{
if("hwArpDynVrf"==iName[i]&&""==index[i])
{
index[i]=" ";
}
else if("hwArpCfgVrf"==iName[i]&&""==index[i])
{
index[i]=" ";
}
str += " "+iName[i]+"=\""+index[i]+"\"";
}
}
}
return str;
}
function M(id)
{
return document.getElementById(id);
}
function getLoginMsg(name,pass,type)
{
return "UserName=" + name + "&Password=" + pass + "&LanguageType=" + type;
}
function sysOID() {
var ret = '<system position="iso.org.dod.internet.mgmt.mib-2">'
+ '<sysObjectID/>'
+ '</system>';
return ret;
}
function getDispElabel(slotID)
{
return '<quit/><disp>elabel slot '+ slotID +'</disp>';
}
function getFanState()
{
return '<display>fan verbose</display>';
}
function getSoftwareRev()
{
var ret='<entPhysicalEntry position="iso.org.dod.internet.mgmt.mib-2.entityMIB.entityMIBObjects.entityPhysical.entPhysicalTable">'
+'<entPhysicalClass>9</entPhysicalClass>'
+'<entPhysicalName/>'
+' <entPhysicalSoftwareRev/>'
+'</entPhysicalEntry>';
return ret;
}
function getDevice()
{
var ret='<display> device </display>';
return ret;
}
function getFileList(param,number,iName,i)
{
var ret = '<huaweiFlhFileEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiUtility.hwFlash.huaweiFlashManMIBObjects.huaweiFlashDevice.hwFlashPartitions.hwFlhFiles.huaweiFlhFileTable" '+tranParam(number,iName,i)+'>'
+'	<hwFlhFileName/>'
+'	<hwFlhFileSize/>'
+'	<hwFlhFileStatus/>'
+'	</huaweiFlhFileEntry>';
return ret;
}
function uploadFile(ip,name,path,newName)
{
return '<quit/><cd>'+path+'</cd><tftp>'+ip+' get '+name+' '+newName+'</tftp>\n';
}
function downloadFile(ip,path,name)
{
return '<quit/><cd>'+path+'</cd><tftp>'+ip+' put '+name+'</tftp>\n';
}
function delFile(path,name)
{
return '<quit/><cd>'+path+'</cd><delete>'+name+'</delete>';
}
function delFileForever(path,name)
{
return '<quit/><cd>'+path+'</cd><delete>/unreserved '+name+'</delete>';
}
function recorveFile(path,name)
{
return '<quit/><cd>'+path+'</cd><undelete>'+name+'</undelete>';
}
function clearRecycle(path,name)
{
return '<quit/><cd>'+path+'</cd><reset>recycle-bin '+name+'</reset>';
}
function getDeviceSpace()
{
var ret = '<hwStorageEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiUtility.hwFlash.huaweiFlashManMIBObjects.huaweiStorageDevice.hwStorageTable">\n'
+'	</hwStorageEntry>\n';
return ret;
}
function getPortFlowDisplay(port)
{
return "<display>interface "+port+" | include Collisions</display>";
}
function getPortFlow(param,number,iName,i)
{
var ret = '<ifEntry position="iso.org.dod.internet.mgmt.mib-2.interfaces.ifTable" '+tranParam(number,iName,i)+'>'
+'	<ifDescr/>'
+'	<ifInOctets/>'
+'	<ifOutOctets/>'
+'	<ifInUcastPkts/>'
+'	<ifOutUcastPkts/>'
+'	</ifEntry>';
return ret;
}
function getPortFlowX(param,number,iName,i)
{
var ret ='<ifXEntry position="iso.org.dod.internet.mgmt.mib_2.ifMIB.ifMIBObjects.ifXTable" '+tranParam(number,iName,i)+'>'
+ '<ifName/>'
+ '<ifInMulticastPkts/>'
+ '<ifInBroadcastPkts/>'
+ '<ifOutMulticastPkts/>'
+ '<ifOutBroadcastPkts/>'
+ '</ifXEntry>';
return ret;
}
function getPortFlowDetailMib(port,index)
{
var ret = '';
ret +='<ifXEntry position="iso.org.dod.internet.mgmt.mib_2.ifMIB.ifMIBObjects.ifXTable">'
+'	<ifName>'+port+'</ifName>'
+'	<ifInMulticastPkts/>'
+'	<ifInBroadcastPkts/>'
+'	<ifOutMulticastPkts/>'
+'	<ifOutBroadcastPkts/>'
+'</ifXEntry>'
+'<ifEntry position="iso.org.dod.internet.mgmt.mib-2.interfaces.ifTable">'
+'	<ifDescr>'+port+'</ifDescr>'
+'	<ifInUcastPkts/>'
+'	<ifOutUcastPkts/>'
+'  <ifInDiscards/>'
+'  <ifOutDiscards/>'
+'</ifEntry>';
return ret;
}
function setPortFlowZero(port)
{
var ret = "<quit/><reset>counters if-mib interface";
if(port)
{
ret += " " + port;
}
ret += "</reset>";
ret += "<reset>counters interface";
if(port)
{
ret += " " + port;
}
ret += "</reset>";
return ret;
}
function getIpv4RoutTable(param,number,iName,i)
{
var ret = '<ipCidrRouteEntry position="iso.org.dod.internet.mgmt.mib-2.ip.ipForward.ipCidrRouteTable" '+tranParam(number,iName,i)+'>\n'
+'	<ipCidrRouteIfIndex/>\n'
+'	<ipCidrRouteDest/>\n'
+'	<ipCidrRouteMask/>\n'
+'	<ipCidrRouteType/>\n'
+'	<ipCidrRouteNextHop/>\n '
+'  <ipCidrRouteProto/>\n'
+'	</ipCidrRouteEntry>\n';
return ret;
}
function getIpv4StaticRouteTable(param,number,iName,i)
{
var ret = '<hwStaticRouteExtEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwRmExt.hwRmExtObjects.hwStaticRouteExtTable" '+tranParam(number,iName,i)+'>'
+ '</hwStaticRouteExtEntry>';
return ret;
}
function getRouteDefaultPri(type)
{
return '<display>current-configuration | include '+type+' route-static default-preferenc</display>';
}
function setRouteDefaultPri(type,pri)
{
return '<'+type+'>route-static default-preference '+pri+'</'+type+'>';
}
function ipv4StaticRoute(ip1,sub1,ip2,interFace,pri,content,type,oldPort,oldIP2,oldPri)
{
var ret = "";
if(type == "m")
{
var port = (oldPort == "Unknown") ? "" : oldPort;
var priStr = " preference " + oldPri;
if(oldIP2 == "0.0.0.0")
{
ret += '<undo>ip route-static '+ip1+' '+sub1+' '+port+' '+priStr+'</undo>\n';
}
else
{
ret += '<undo>ip route-static '+ip1+' '+sub1+' '+port+' '+oldIP2+' '+priStr+'</undo>\n';
}
}
ret += '<ip>route-static '+ip1+' '+sub1;
if (interFace == "")
{
ret = ret + ' NULL0 ' + ip2;
}
if (interFace == "Unknown")
{
ret = ret + ' ' + ip2;
}
else
{
if(interFace == "NULL0" || ip2 == "0.0.0.0")
{
ret =ret + ' ' + interFace + ' ';
}
else
{
ret =ret + ' ' + interFace + ' ' + ip2;
}
}
if (pri != "")
{
ret = ret + ' preference ' + pri;
}
if (content != "")
{
ret = ret + ' description ' + content;
}
ret = ret + '</ip>\n';
return ret;
}
function getCurrentConfig(arg)
{
var ret =' <display> current-configuration | include '+arg+' </display>';
return ret;
}
function delIpv4StaticRoute(ip,sub,port,next,pri)
{
var port2 = (port == "Unknown") ? "" : port;
var priStr = " preference " + pri;
if(next == "0.0.0.0")
{
return '<undo>ip route-static '+ip+' '+sub+' '+port2+' '+priStr+'</undo>\n';
}
else
{
return '<undo>ip route-static '+ip+' '+sub+' '+port2+' '+next+' '+priStr+'</undo>\n';
}
}
function delIpv4AllStaticRoute()
{
return '<undo>ip route-static all</undo>';
}
function getCISTRootPortId()
{
return '<display>stp | include CIST RootPortId</display>';
}
function getStpInstanceVlan()
{
var ret = '<stp isview="true"><instance>'
+'	<name>region-configuration</name>'
+' <check>region-configuration</check>'
+'	   </instance></stp>';
return ret;
}
function getStpInstanceVlan2()
{
return '<display>stp region-configuration</display>';
}
function getStpBrief()
{
return '<display>stp brief</display>\n';
}
function stphwL2IfEntry(parm,number,iName,i)
{
return  '<hwL2IfEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwL2IfMib.hwL2IfObjects.hwL2Interface.hwL2IfTable" '+tranParam(number,iName,i)+'>'
+'<hwL2IfPortName/>'
+'<hwL2IfPortIfIndex/>'
+'<hwL2IfBpdu/>'
+'</hwL2IfEntry>';
}
function getStpPortTable(param,number,iName,i)
{
var ret = '<hwMstpPortEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwMstp.hwMstpObjects.hwMstpPortTable" '+tranParam(number,iName,i)+'>';
if("" != param)
{
ret+=  '<hwMstpiPortIndex>'+param+'</hwMstpiPortIndex>';
}
ret+=  '</hwMstpPortEntry>';
return ret;
}
function getStpRootPort()
{
var ret = '';
ret	+= '<hwMstpInstanceEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwMstp.hwMstpObjects.hwMstpInstanceTable">';
ret	+= '<hwMstpInstanceID>0</hwMstpInstanceID>';
ret	+= '<hwMstpiRootPort/>';
ret += '<hwMstpiBridgeID/>';
ret	+= '</hwMstpInstanceEntry>';
return ret;
}
function getStpInstanceTable(ins,number,iName,i)
{
var ret = '';
ret +='<hwMstpInstanceEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwMstp.hwMstpObjects.hwMstpInstanceTable" '+tranParam(number,iName,i)+'>';
ret	+=' <hwMstpInstanceID/>';
ret	+=' <hwMstpiRootPathCost/>';
ret	+=' <hwMstpiBridgePriority/>';
ret	+=' <hwMstpiRootType/>';
ret	+='	</hwMstpInstanceEntry>';
return ret;
}
function getStpObjects()
{
var ret = '<hwMstpObjects position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwMstp">'
+' <hwMstpStatus/>'
+' <hwMstpForceVersion/>'
+' <hwMstpDiameter/>'
+' <hwMstpBridgeMaxHops/>'
+' <hwMstpMasterBridgeID/>'
+' <hwMstpMasterPathCost/>'
+' <hwMstpBpduGuard/>'
+' <hwMstpPathCostStandard/>'
+' <hwMstpSnooping/>'
+' </hwMstpObjects>';
return ret;
}
function getdot1dStp()
{
var ret = '<dot1dStp position="iso.org.dod.internet.mgmt.mib-2.dot1dBridge">'
+'   <dot1dStpTimeSinceTopologyChange/>'
+'   <dot1dStpTopChanges/>'
+'   <dot1dStpDesignatedRoot/>'
+'   <dot1dStpRootPort/>'
+'   <dot1dStpRootCost/>'
+'   <dot1dStpBridgeMaxAge/>'
+'   <dot1dStpBridgeHelloTime/>'
+'   <dot1dStpBridgeForwardDelay/>'
+'	</dot1dStp>';
return ret;
}
function getProStp()
{
var ret = '<hwMstpProEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwMstp.hwMstpObjects.hwMstpProTable">'
+'  <hwMstpProID>0</hwMstpProID>'
+'	</hwMstpProEntry>';
return ret;
}
function configStpStp(param)
{
return "<stp>"+param+"</stp>";
}
function configStpBpdu(param)
{
if(param)
{
return "<stp>bpdu-protection</stp>";
}
return "<undo>stp bpdu-protection</undo>";
}
function configStpTC(param)
{
if(param)
{
return "<stp>tc-protection</stp>";
}
return "<undo>stp tc-protection</undo>";
}
function configStpTimeFactor(param)
{
return "<stp>timer-factor "+param+"</stp>";
}
function configStpMode(param)
{
return "<stp>mode "+param+"</stp>";
}
function configStpMaxHop(param)
{
return "<stp>max-hops "+param+"</stp>";
}
function configStpCostStandard(param)
{
return "<stp>pathcost-standard "+param+"</stp>";
}
function configStpDiameter(param)
{
return "<stp>bridge-diameter "+param+"</stp>";
}
function configStpConverge(param)
{
return "<stp>converge "+param+"</stp>";
}
function configStpHello(param)
{
return "<stp>timer hello "+param+"</stp>";
}
function configStpDelay(param)
{
return "<stp>timer forward-delay "+param+"</stp>";
}
function configStpMaxAge(param)
{
return "<stp>timer max-age "+param+"</stp>";
}
function configStpInsPriType(ins,pri,type)
{
if(type == "primary")
{
return "<stp>instance "+ins+" root primary</stp>";
}
else if(type == "secondary")
{
return "<stp>instance "+ins+" root secondary</stp>";
}
else
{
return "<undo>stp instance "+ins+" root </undo><stp>instance "+ins+" priority "+pri+"</stp>";
}
}
function configStpPort(pname,param)
{
var ret = '<interface isview="true"><instance>'
+'<name>'+pname+'</name>'
+'<stp>'+param+'</stp>'
+'</instance></interface>';
return ret;
}
function configStpPortPri(pname,ins,param)
{
var ret = '<interface isview="true"><instance>'
+'<name>'+pname+'</name>'
+'<stp>instance '+ins+' port priority '+param+'</stp>'
+'</instance></interface>';
return ret;
}
function configStpPortCost(pname,ins,param)
{
var ret = '<interface isview="true"><instance>'
+'<name>'+pname+'</name>'
+'<stp>instance '+ins+' cost '+param+'</stp>'
+'</instance></interface>';
return ret;
}
function configStpPortProtect(pname,type)
{
var ret = "";
if(type == "none")
{
ret = '<interface isview="true"><instance>'
+'<name>'+pname+'</name>'
+'<undo>stp edged-port</undo>'
+'<undo>stp root-protection</undo>'
+'<undo>stp loop-protection</undo>'
+'</instance></interface>';
}
else if(type == "loop")
{
ret = '<interface isview="true"><instance>'
+'<name>'+pname+'</name>'
+'<undo>stp edged-port</undo>'
+'<undo>stp root-protection</undo>'
+'<stp>loop-protection</stp>'
+'</instance></interface>';
}
else if(type == "root")
{
ret = '<interface isview="true"><instance>'
+'<name>'+pname+'</name>'
+'<undo>stp edged-port</undo>'
+'<undo>stp loop-protection</undo>'
+'<stp>root-protection</stp>'
+'</instance></interface>';
}
else if(type == "edge")
{
ret = '<interface isview="true"><instance>'
+'<name>'+pname+'</name>'
+'<undo>stp root-protection</undo>'
+'<undo>stp loop-protection</undo>'
+'<stp>edged-port enable</stp>'
+'</instance></interface>';
}
return ret;
}
function configStpPortTransLimit(pname,param)
{
var ret = '<interface isview="true"><instance>'
+'<name>'+pname+'</name>'
+'<stp>transmit-limit '+param+'</stp>'
+'</instance></interface>';
return ret;
}
function configStpPortSnoop(pname,param)
{
if(param == "enable")
{
return  '<interface isview="true"><instance>'
+'<name>'+pname+'</name>'
+'<stp>config-digest-snoop</stp>'
+'</instance></interface>';
}
else
{
return  '<interface isview="true"><instance>'
+'<name>'+pname+'</name>'
+'<undo>stp config-digest-snoop</undo>'
+'</instance></interface>';
}
}
function configStpPortP2P(pname,param)
{
var ret = '<interface isview="true"><instance>'
+'<name>'+pname+'</name>'
+'<stp>point-to-point '+param+'</stp>'
+'</instance></interface>';
return ret;
}
function configStpPortCheck(pname,param)
{
if(param == "normal")
{
return  '<interface isview="true"><instance>'
+'<name>'+pname+'</name>'
+'<stp>no-agreement-check</stp>'
+'</instance></interface>';
}
else
{
return  '<interface isview="true"><instance>'
+'<name>'+pname+'</name>'
+'<undo>stp no-agreement-check</undo>'
+'</instance></interface>';
}
}
function getStpTCNRecv()
{
return '<display>stp | include TC or TCN received</display>';
}
function getDisplayIStp(port)
{
return '<display>current-configuration interface '+port+' | include stp</display>';
}
function setStpRegionN(param)
{
var ret = '<stp isview="true"><instance>'
+'	<name>region-configuration</name>'
+' <region-name>'+param+'</region-name>'
+'	   </instance></stp>';
return ret;
}
function setStpRegionL(param)
{
var ret = '<stp isview="true"><instance>'
+'	<name>region-configuration</name>'
+' <revision-level>'+param+'</revision-level>'
+'	   </instance></stp>';
return ret;
}
function delStpRegionVlans(ins)
{
var ret = '<stp isview="true"><instance>';
ret+='	<name>region-configuration</name>';
if(ins != "0" && ins != 0)
{
ret+=' <undo>instance '+ins+'</undo>';
}
ret+='	   </instance></stp>';
return ret;
}
function setStpRegionVlans(ins,vlans)
{
var ret = '<stp isview="true"><instance>';
ret+='	<name>region-configuration</name>';
ret+=' <instance>'+ins+' vlan '+vlans+'</instance>';
ret+='	   </instance></stp>';
return ret;
}
function setStpRegionActive()
{
var ret = '<stp isview="true"><instance>'
+'	<name>region-configuration</name>'
+' <active>region-configuration</active>'
+'	   </instance></stp>';
return ret;
}
function getSystemUsage(index)
{
var ret='<hwEntityStateEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwEntityExtentMIB.hwEntityExtObjects.hwEntityState.hwEntityStateTable">';
ret+='	<entPhysicalIndex>'+index+'</entPhysicalIndex>';
ret+='	<hwEntityCpuUsage/>';
ret+='	<hwEntityMemUsage/>';
ret+='	<hwEntityTemperature/>';
ret+='	<hwEntityTemperatureThreshold/>';
ret+='  <hwEntityOperStatus/>';
ret+='	</hwEntityStateEntry>';
return ret;
}
function getPortUtil(port)
{
return '<display>interface '+port+' | begin Input bandwidth utilization</display>';
}
function getSystemInfo(index,port)
{
var ret='';
ret = '<system position="iso.org.dod.internet.mgmt.mib-2">'
+'	<sysObjectID/>'
+'	<sysName/>'
+'	<sysLocation/>'
+'	<sysContact/>'
+'	<sysUpTime/>'
+'	</system>'
+'	<entPhysicalEntry position="iso.org.dod.internet.mgmt.mib-2.entityMIB.entityMIBObjects.entityPhysical.entPhysicalTable">'
+'	<entPhysicalIndex>'+index+'</entPhysicalIndex>'
+'	</entPhysicalEntry>'
+' <ifEntry position="iso.org.dod.internet.mgmt.mib-2.interfaces.ifTable">'
+'	<ifDescr>'+port+'</ifDescr>'
+'	<ifPhysAddress/>'
+' </ifEntry>';
return ret;
}
function getInterfaceClass(param,number,iName,i)
{
var ret='<entPhysicalEntry position="iso.org.dod.internet.mgmt.mib-2.entityMIB.entityMIBObjects.entityPhysical.entPhysicalTable" '+tranParam(number,iName,i)+'>'
+' <entPhysicalIndex/>'
+' <entPhysicalClass/>'
+' <entPhysicalVendorType/>'
+' <entPhysicalName/>'
+' </entPhysicalEntry>';
return ret;
}
function getBootRomV(slot)
{
return '<display>version slot '+slot+'</display>\n';
}
function getIGMPSnoopingState()
{
var ret = '<hwIGSPSystemInfo position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwMultiCastMIB.hwIGSPMibObject">'
+ '<hwIgmpSnoopingEnabled/>'
+ '</hwIGSPSystemInfo>';
return ret;
}
function getIGMPSnoopingStateByDis()
{
var ret = '<display>current-configuration configuration | include igmp-snooping</display>';
return ret;
}
function igmpSnoopingEnabled(flag)
{
var ret ='';
if ("enabled" == flag)
{
ret ='<igmp-snooping>enable</igmp-snooping>';
}
else
{
ret ='<undo>igmp-snooping enable</undo>';
}
return ret;
}
function getVlanIGMPSnoopingInfo(param,number,iName,i)
{
var strTag = '';
if (null != param && "" != param)
{
strTag = '<hwVlanIndex>'+param+'</hwVlanIndex>';
}
else
{
strTag = '<hwVlanIndex/>';
}
var ret = '<hwVlanCfgEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwMultiCastMIB.hwIGSPMibObject.hwVlanCfgInfo.hwVlanCfgTable" '+tranParam(number,iName,i)+'>'
+ strTag
+ '<hwVlanIgmpSnoopingEnabled/>'
+ '<hwVlanRouterAgingTime/>'
+ '<hwVlanMaxQueryRespTime/>'
+ '<hwVlanQueryInt/>'
+ '<hwVlanRobustCount/>'
+ '</hwVlanCfgEntry>';
return ret;
}
function configVlanIGMPS_state(vlanId)
{
var ret = '<vlan isview="true">'
+ '<instance>'
+ '<name>'+ vlanId +'</name>';
if (M("state_enabled").checked)
{
ret += '<igmp-snooping>enable</igmp-snooping>';
}
else
{
ret += '<undo>igmp-snooping enable</undo>';
}
ret += '</instance>'
+ '</vlan>';
return ret;
}
function configVlanIGMPS_maxqueryresptime(vlanId)
{
var ret = '<vlan isview="true">'
+ '<instance>'
+ '<name>'+ vlanId +'</name>';
if(M("maxqueryresptime").value == "")
{
ret +="<undo>igmp-snooping  max-response-time </undo>";
}
else
{
ret +='<igmp-snooping>max-response-time '+ M("maxqueryresptime").value +'</igmp-snooping>';
}
ret += '</instance>'
+ '</vlan>';
return ret;
}
function configVlanIGMPS_robustcount(vlanId)
{
var ret = '<vlan isview="true">'
+ '<instance>'
+ '<name>'+ vlanId +'</name>';
if(M("robustcount").value == "")
{
ret +="<undo>igmp-snooping robust-count</undo>";
}
else
{
ret +='<igmp-snooping>robust-count '+ M("robustcount").value +'</igmp-snooping>';
}
ret +='</instance>'
+ '</vlan>';
return ret;
}
function configVlanIGMPS_queryint(vlanId)
{
var ret = '<vlan isview="true">'
+ '<instance>'
+ '<name>'+ vlanId +'</name>';
if( M("queryint").value == "")
{
ret += '<undo>igmp-snooping query-interval</undo>';
}
else
{
ret += '<igmp-snooping>query-interval '+ M("queryint").value +'</igmp-snooping>';
}
ret += '</instance>'
+ '</vlan>';
return ret;
}
function configVlanIGMPS_routeragingtime(vlanId)
{
var ret = '<vlan isview="true">'
+ '<instance>'
+ '<name>'+ vlanId +'</name>';
if( M("routeragingtime").value == "")
{
ret += '<undo>igmp-snooping router-aging-time</undo>';
}
else
{
ret +=  '<igmp-snooping>router-aging-time '+ M("routeragingtime").value +'</igmp-snooping>';
}
ret +=  '</instance>'
+ '</vlan>';
return ret;
}
function getDnsDynamicHostList()
{
var ret = '<hwDnsHostsDynamicEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwDnsMIB.hwDnsObjects.hwDnsHostsDynamicTable">'
+ '<hwDnsDomainName/>'
+ '<hwDnsIpAddress/>'
+ '<hwDnsTtl/>'
+ '<hwDnsAlias/>'
+ '</hwDnsHostsDynamicEntry>';
return ret;
}
function clearAllDnsDynamicHost()
{
var ret = '<quit/>'
+ '<reset>dns dynamic-host</reset>';
return ret;
}
function getDnsServerList()
{
var ret = '<display>dns server</display>';
return ret;
}
function deleteDnsServer(ip_address)
{
var ret = '<undo>dns server '+ ip_address +'</undo>';
return ret;
}
function createDnsServer(ip_address)
{
var ret = '<dns>server '+ ip_address +'</dns>';
return ret;
}
function getDnsDomainList()
{
var ret = '<display>dns domain</display>';
return ret;
}
function deleteDnsDomain(domain_name)
{
var ret = '<undo>dns domain '+ domain_name +'</undo>';
return ret;
}
function createDnsDomain(domain_name)
{
var ret = '<dns>domain '+ domain_name +'</dns>';
return ret;
}
function getDnsResolveState()
{
var ret = '<display>current-configuration | include dns resolve</display>';
return ret;
}
function configDnsResolve(flag)
{
var ret ='';
if ("enabled" == flag)
{
ret = '<dns>resolve</dns>';
}
else
{
ret = '<undo>dns resolve</undo>';
}
return ret;
}
function restartComeBack()
{
var ret = '<quit/>'
+ '<reset>saved-configuration</reset>';
return ret;
}
function restartRebootFast()
{
var ret = '<quit/>'
+ '<reboot>fast</reboot>';
return ret;
}
function restartReboot()
{
var ret = '<quit/>'
+ '<reboot/>';
return ret;
}
function getCurStartupConfigFileIndex()
{
var ret = '<hwSysCurEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.huaweiSystemManMIB.huaweiSystemManMIBObjects.hwSysCurrent.hwSysCurTable">'
+ '<hwSysCurImageIndex/>'
+ '<hwSysCurCFGFileIndex/>'
+ '<hwSysCurPatchFileIndex/>'
+ '</hwSysCurEntry>';
return ret;
}
function getCurStartupConfigFile()
{
var ret =  '<display> startup </display>';
return ret;
}
function getIsolateMode()
{
return "<display>current-configuration | include port-isolate</display>";
}
function getPortDisplay()
{
return "<display>port-isolate group all</display>";
}
function getDanPort()
{
return "<display>current-configuration interface filter am isolate</display>";
}
function getPortByNum(num)
{
return "<display>port-isolate group " + num +"</display>";
}
function delPort(pname,group)
{
ret ='<interface isview="true"><instance>'
+'<name>'+pname+'</name>'
+'<undo>port-isolate enable group '+group+'</undo>'
+'</instance></interface>';
return ret;
}
function getIsolate(portName)
{
ret ='<interface isview="true"><instance>'
+'<name>'+portName+'</name>'
+'<display> this | include am isolate</display>'
+'</instance></interface>';
return ret;
}
function addPort(pname,group)
{
ret ='<interface isview="true"><instance>'
+'<name>'+pname+'</name>'
+'<port-isolate> enable group '+group+'</port-isolate>'
+'</instance></interface>';
return ret;
}
function configL2()
{
return '<port-isolate> mode l2</port-isolate>';
}
function configAll()
{
return '<port-isolate> mode all</port-isolate>';
}
function delDanPort(port,ports)
{
ret ='<interface isview="true"><instance>'
+'<name>'+port+'</name>'
+'<undo>am isolate '+ports+'</undo>'
+'</instance></interface>';
return ret;
}
function addDanPort(port,ports)
{
ret ='<interface isview="true"><instance>'
+'<name>'+port+'</name>'
+'<am>isolate '+ports+'</am>'
+'</instance></interface>';
return ret;
}
function getCurStartupConfigFileIndexs()
{
var ret = '<hwSysCurEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.huaweiSystemManMIB.huaweiSystemManMIBObjects.hwSysCurrent.hwSysCurTable">'
+ '<hwSysCurPatchFileIndex/>'
+ '</hwSysCurEntry>';
return ret;
}
function portModifyVlan(pvid,port,joinType,linktype) {
var ret = '<interface isview="true">'
+ '<instance>'
+ '<name>'+ port +'</name>';
if(linktype=="2")
{
ret +='<port>default vlan ' + pvid + '</port>';
}
else if(linktype=="1")
{
ret +='<port>trunk pvid vlan ' + pvid + '</port>';
}
else
{
ret +='<port>hybrid pvid vlan ' + pvid + '</port>\n';
}
ret +='</instance></interface>';
return ret;
}
function getAllSysImage()
{
var ret = '<hwSysImageEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.huaweiSystemManMIB.huaweiSystemManMIBObjects.hwSysImage.hwSysImageTable">'
+ '<hwSysImageIndex/>'
+ '<hwSysImageName/>'
+ '<hwSysImageLocation/>'
+ '</hwSysImageEntry>';
return ret;
}
function getAllSysCFGFile()
{
var ret = '<hwSysCFGFileEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.huaweiSystemManMIB.huaweiSystemManMIBObjects.hwSysCFGFile.hwSysCFGFileTable">'
+ '<hwSysCFGFileIndex/>'
+ '<hwSysCFGFileName/>'
+ '<hwSysCFGFileLocation/>'
+ '</hwSysCFGFileEntry>';
return ret;
}
function getAllPatchFile()
{
var ret = '<hwPatchFileEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.huaweiSystemManMIB.huaweiSystemManMIBObjects.hwPatch.hwPatchFileTable">'
+ '<hwPatchFileIndex/>'
+ '<hwPatchFileName/>'
+ '<hwPatchFileLocation/>'
+ '</hwPatchFileEntry>';
return ret;
}
function getLoadwebFile()
{
var ret =' <display> current-configuration | include http server load </display>';
return ret;
}
function configStartupSysImage(filename,slot)
{
var str = '';
if ("1"==slot)
{
str += ' all';
}
var ret = '<quit/>'
+ '<startup>system-software '+ filename + str + '</startup>';
return ret;
}
function configStartupSysCFGFile(filename,slot)
{
var str = '';
if ("1"==slot)
{
str += ' all';
}
var ret = '<quit/>'
+ '<startup>saved-configuration '+ filename + str + '</startup>';
return ret;
}
function configStartupPatchFile(filename,slot)
{
var str = '';
if ("1"==slot)
{
str += ' all';
}
var ret = '<quit/>'
+ '<startup>patch '+ filename + str + '</startup>';
return ret;
}
function saveCurrentConfig()
{
var ret = '<quit/>'
+ '<save/>';
return ret;
}
function getTftpFile(tftp_server,source_filename,destination_filename,device)
{
var floder="";
var ret = '<quit/><cd>flash:/</cd>'
+ floder
+ '<tftp>' + tftp_server + ' get ' + source_filename + ' ' + destination_filename + '</tftp>';
return ret;
}
function getSysImageByName(name)
{
var ret = '<hwSysImageEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.huaweiSystemManMIB.huaweiSystemManMIBObjects.hwSysImage.hwSysImageTable">'
+ '<hwSysImageIndex/>'
+ '<hwSysImageName>'+ name +'</hwSysImageName>'
+ '</hwSysImageEntry>';
return ret;
}
function checkNextStartupFileCmd()
{
var ret = '<quit/>'
+ '<check>startup next</check>';
return ret;
}
function checkNextStartupCRCFileCmd()
{
var ret = '<quit/>'
+ '<check>startup crc next</check>';
return ret;
}
function getDot1XCurGlobalConfig()
{
var ret = '<hwSrvcfgEapMibObjects position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwBRASMib.hwBRASSrvcfgEap">'
+ '</hwSrvcfgEapMibObjects>';
return ret;
}
function getDot1XCurQuietFailTimes()
{
var ret = '<display>dot1x | include Quiet-times</display>';
return ret;
}
function configDot1XState(flag)
{
var ret = '';
if (flag)
{
ret = '<dot1x>enable</dot1x>';
}
else
{
ret = '<undo>dot1x enable</undo>';
}
return ret;
}
function configDot1XQuietPeriod(flag)
{
var ret = '';
if (flag)
{
ret = '<dot1x>quiet-period</dot1x>';
}
else
{
ret = '<undo>dot1x quiet-period</undo>';
}
return ret;
}
function configDot1XDhcpTrigger(flag)
{
var ret = '';
if (flag)
{
ret = '<dot1x>dhcp-trigger</dot1x>';
}
else
{
ret = '<undo>dot1x dhcp-trigger</undo>';
}
return ret;
}
function configDot1XHandshake(flag)
{
var ret = '';
if (flag)
{
ret = '<dot1x>handshake</dot1x>';
}
else
{
ret = '<undo>dot1x handshake</undo>';
}
return ret;
}
function configDot1XQuietTimes(value)
{
var ret = '<dot1x>quiet-times '+ value +'</dot1x>';
return ret;
}
function configDot1XRetry(value)
{
var ret = '<dot1x>retry '+ value +'</dot1x>';
return ret;
}
function configDot1XTClientTimeout(value)
{
var ret = '<dot1x>timer client-timeout '+ value +'</dot1x>';
return ret;
}
function configDot1XTHandshakePeriod(value)
{
var ret = '<dot1x>timer handshake-period '+ value +'</dot1x>';
return ret;
}
function configDot1XTReauthenticatePeriod(value)
{
var ret = '<dot1x>timer reauthenticate-period '+ value +'</dot1x>';
return ret;
}
function configDot1XTTxPeriod(value)
{
var ret = '<dot1x>timer tx-period '+ value +'</dot1x>';
return ret;
}
function configDot1XTServerTimeout(value)
{
var ret = '<dot1x>timer server-timeout '+ value +'</dot1x>';
return ret;
}
function configDot1XTQuietPeriod(value)
{
var ret = '<dot1x>timer quiet-period '+ value +'</dot1x>';
return ret;
}
function getDot1xPortConfigList(param,number,iName,i)
{
var ret = '<hwDot1xPortConfigEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwBRASMib.hwBRASSrvcfgEap.hwSrvcfgEapMibObjects.hwDot1xPortConfigTable" '+tranParam(number,iName,i)+'>'
+ '</hwDot1xPortConfigEntry>';
return ret;
}
function getConfigInterfaceXML(name,cmdStr)
{
var ret = '<interface isview="true">'
+ '<instance>'
+ '<name>'+ name +'</name>'
+ cmdStr
+ '</instance>'
+ '</interface>';
return ret;
}
function undoDot1xIState(name)
{
var cmdStr = '<undo>dot1x enable</undo>';
return getConfigInterfaceXML(name,cmdStr);
}
function undoDot1xIMaxUser(name)
{
var cmdStr = '<undo>dot1x max-user</undo>';
return getConfigInterfaceXML(name,cmdStr);
}
function undoDot1xIPortControl(name)
{
var cmdStr = '<undo>dot1x port-control</undo>';
return getConfigInterfaceXML(name,cmdStr);
}
function undoDot1xIPortMethod(name)
{
var cmdStr = '<undo>dot1x port-method</undo>';
return getConfigInterfaceXML(name,cmdStr);
}
function undoDot1xIReauthenticate(name)
{
var cmdStr = '<undo>dot1x reauthenticate</undo>';
return getConfigInterfaceXML(name,cmdStr);
}
function undoDot1xIGuestVlanId(name)
{
var cmdStr = '<undo>dot1x guest-vlan</undo>';
return getConfigInterfaceXML(name,cmdStr);
}
function configDot1xIState(name,flag)
{
var cmdStr = '';
if (flag)
{
cmdStr = '<dot1x>enable</dot1x>';
}
else
{
cmdStr = '<undo>dot1x enable</undo>';
}
return getConfigInterfaceXML(name,cmdStr);
}
function configDot1xIMaxUser(name,value)
{
var cmdStr = '<dot1x>max-user '+ value +'</dot1x>';
return getConfigInterfaceXML(name,cmdStr);
}
function configDot1xIPortControl(name,value)
{
var cmdStr = '<dot1x>port-control '+ value +'</dot1x>';
return getConfigInterfaceXML(name,cmdStr);
}
function configDot1xIPortMethod(name,value)
{
var cmdStr = '<dot1x>port-method '+ value +'</dot1x>';
return getConfigInterfaceXML(name,cmdStr);
}
function configDot1xIReauthenticate(name,flag)
{
var cmdStr = '';
if (flag)
{
cmdStr = '<dot1x>reauthenticate</dot1x>';
}
else
{
cmdStr = '<undo>dot1x reauthenticate</undo>';
}
return getConfigInterfaceXML(name,cmdStr);
}
function configDot1xIGuestVlanId(name,value)
{
var cmdStr = '<undo>dot1x guest-vlan</undo>'
+ '<dot1x>guest-vlan '+ value +'</dot1x>';
return getConfigInterfaceXML(name,cmdStr);
}
function getAllPortList(param,number,iName,i)
{
var ret = '<ifEntry position="iso.org.dod.internet.mgmt.mib_2.interfaces.iftable" '+tranParam(number,iName,i)+'>'
+ '<ifIndex/>'
+ '<ifDescr/>'
+ '<ifType/>'
+ '</ifEntry>';
return ret;
}
function getVoiceVlanPortList(param,number,iName,i)
{
var ret = '<hwL2VlanMultiVoiceVlanPortEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwL2Vlan.hwL2VlanMngObjects.hwL2VlanApply.hwL2VlanMultiVoiceVlanPortTable" '+tranParam(number,iName,i)+'>'
+ '</hwL2VlanMultiVoiceVlanPortEntry>';
return ret;
}
function getVoiceVlanPortList2(param,number,iName,i)
{
var ret = '<hwL2VlanVoiceVlanPortEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwL2Vlan.hwL2VlanMngObjects.hwL2VlanApply.hwL2VlanVoiceVlanPortTable" '+tranParam(number,iName,i)+'>'
+ '</hwL2VlanVoiceVlanPortEntry>';
return ret;
}
function configVoiceVlanPort(name,vlanId,flag,type)
{
var cmdStr = '';
if ("state_old" == type)
{
if (flag)
{
cmdStr ='<undo>voice-vlan enable</undo>';
cmdStr +='<voice-vlan>'+ vlanId +' enable</voice-vlan>';
}
else
{
cmdStr ='<undo>voice-vlan enable</undo>';
}
}
else if ("state_new" == type)
{
if (flag)
{
cmdStr ='<undo>voice-vlan enable</undo>';
cmdStr += '<voice-vlan>'+ vlanId +' enable</voice-vlan>';
}
else
{
cmdStr ='<undo>voice-vlan enable</undo>';
}
}
else if ("security" == type)
{
if (flag)
{
cmdStr ='<voice-vlan>security enable</voice-vlan>';
}
else
{
cmdStr ='<undo>voice-vlan security enable</undo>';
}
}
else if ("mode" == type)
{
if (flag)
{
cmdStr ='<voice-vlan>mode auto</voice-vlan>';
}
else
{
cmdStr ='<voice-vlan>mode manual</voice-vlan>';
}
}
else if ("legacy" == type)
{
if (flag)
{
cmdStr ='<voice-vlan>legacy enable</voice-vlan>';
}
else
{
cmdStr ='<undo>voice-vlan legacy enable</undo>';
}
}
var ret = '<interface isview="true">'
+ '<instance>'
+ '<name>'+ name +'</name>'
+ cmdStr
+ '</instance>'
+ '</interface>';
return ret;
}
function getVoiceVlanOuiList()
{
var ret = '<hwL2VlanVoiceVlanOuiEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwL2Vlan.hwL2VlanMngObjects.hwL2VlanApply.hwL2VlanVoiceVlanOuiTable">'
+ '</hwL2VlanVoiceVlanOuiEntry>';
return ret;
}
function configVoiceVlanOUI(ouiAddr,ouiMask,description)
{
var desc = '';
if ("" != description)
{
desc = ' description '+ description;
}
var ret = '<voice-vlan>'
+ 'mac-address '+ ouiAddr +' mask '+ ouiMask + desc
+ '</voice-vlan>';
return ret;
}
function deleteVoiceVlanOUI(ouiAddr)
{
var ret = '<undo>'
+ 'voice-vlan mac-address ' + ouiAddr
+ '</undo>';
return ret;
}
function getCurVoiceVlanAgingTime()
{
var ret = '<hwL2VlanApply position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwL2Vlan.hwL2VlanMngObjects">'
+ '<hwL2VlanVoiceVlanAgingTime/>'
+ '</hwL2VlanApply>';
return ret;
}
function configVoiceVlanAgingTime(value)
{
var ret = '<voice-vlan>aging-time '+ value +'</voice-vlan>';
return ret;
}
function getCurSystemTime()
{
var ret = '<display>clock</display>';
return ret;
}
function configClockTimeZone(name,opt,offset)
{
var ret = '<quit/>'
+ '<clock>timezone '+ name +' '+ opt +' '+ offset +'</clock>';
return ret;
}
function configClockDateTime(timeStr,dateStr)
{
var ret = '<quit/>'
+ '<clock>datetime '+ timeStr +' '+ dateStr +'</clock>';
return ret;
}
function getCurSystemInfoConfig()
{
var ret = '<system position="iso.org.dod.internet.mgmt.mib-2">'
+'	<sysName/>'
+'	<sysLocation/>'
+'	<sysContact/>'
+'	</system>';
return ret;
}
function getHttpConfig()
{
var ret = '<display>http server</display>';
return ret;
}
function configSysName(value)
{
var ret = '<sysname>'+ value +'</sysname>';
return ret;
}
function configHttp(value)
{
var ret = '<http>timeout '+ value +'</http>';
return ret;
}
function configSysLocation(value)
{
var ret = '<snmp-agent>sys-info location '+ value +'</snmp-agent>';
return ret;
}
function configSysContact(value)
{
var ret = '<snmp-agent>sys-info contact '+ value +'</snmp-agent>';
return ret;
}
function getTimeRangeList(param,number,iName,i)
{
var name = '';
if ("" != param)
{
name = '<hwTrngName>'+ param +'</hwTrngName>';
}
var ret = '<hwTrngCreateTimerangeEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwTRNG.hwTRNGMibObjects.hwTrngCreateTimerangeTable">'
+ name
+ '</hwTrngCreateTimerangeEntry>';
return ret;
}
function getTimeRangeByIndex(index)
{
var ret = '<hwTrngPeriodicEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwTRNG.hwTRNGMibObjects.hwTrngPeriodicTable">'
+ '<hwTrngPeriodicNameIndex>'+ index +'</hwTrngPeriodicNameIndex>'
+ '</hwTrngPeriodicEntry>'
+ '<hwTrngAbsoluteEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwTRNG.hwTRNGMibObjects.hwTrngAbsoluteTable">'
+ '<hwTrngAbsoluteNameIndex>'+ index +'</hwTrngAbsoluteNameIndex>'
+ '</hwTrngAbsoluteEntry>';
return ret;
}
function configAclTimeRangePeriod(name,startTime,endTime,weeks)
{
var ret = '<time-range> '+ name +' '+ startTime +' to '+ endTime +' '+ weeks +'</time-range>';
return ret;
}
function configAclTimeRangeAbsolute(name,startDate,endDate)
{
var end = '';
if ("" != endDate)
{
end = ' to '+ endDate;
}
var ret = '<time-range> '+ name +' from '+ startDate + end +'</time-range>';
return ret;
}
function undoAclTimeRangePeriod(name,startTime,endTime,weeks)
{
var ret = '<undo>time-range '+ name +' '+ startTime +' to '+ endTime +' '+ weeks +'</undo>';
return ret;
}
function undoAclTimeRangeAbsolute(name,startDate,endDate)
{
var end = '';
if ("" != endDate)
{
end = ' to '+ endDate;
}
var ret = '<undo>time-range '+ name +' from '+ startDate + end +'</undo>';
return ret;
}
function undoAclTimeRange(name)
{
var ret = '<undo>time-range '+ name +'</undo>';
return ret;
}
function getAclList(param,number,iName,i)
{
var num = '';
var name = '';
if ("" != param.split("#_#")[0])
{
num = '<hwAclNumGroupAclNum>' + param.split("#_#")[0] + '</hwAclNumGroupAclNum>';
}
if ("" != param.split("#_#")[1])
{
name = '<hwAclNumGroupAclName>' + param.split("#_#")[1] + '</hwAclNumGroupAclName>';
}
var ret = '<hwAclNumGroupEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAcl.hwAclMibObjects.hwAclNumGroupTable" '+tranParam(number,iName,i)+'>'
+ num
+ name
+ '</hwAclNumGroupEntry>';
return ret;
}
function getAclIpv6List(param,number,iName,i)
{
var num = '';
var name = '';
if ("" != param.split("#_#")[0])
{
num = '<hwAclIpv6NumGroupAclNum>' + param.split("#_#")[0] + '</hwAclIpv6NumGroupAclNum>';
}
if ("" != param.split("#_#")[1])
{
name = '<hwAclIpv6NumGroupAclName>' + param.split("#_#")[1] + '</hwAclIpv6NumGroupAclName>';
}
var ret = '<hwAclIpv6NumGroupEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAcl.hwAclMibObjects.hwAclIpv6NumGroupTable" '+tranParam(number,iName,i)+'>'
+ num
+ name
+ '</hwAclIpv6NumGroupEntry>';
return ret;
}
function queryAclByName(aclName)
{
var ret = '<display>acl name '+ aclName +' </display>';
return ret;
}
function queryIpv6AclByName(aclName)
{
var ret = '<display>acl ipv6 name '+ aclName +' </display>';
return ret;
}
function queryIpv4AclById(aclId)
{
var ret = '<display>acl '+ aclId.toLowerCase() ;
ret += '</display>';
return ret;
}
function queryByPortName(portName_)
{
ret = '<interface isview="true">'
+ '<instance>'
+ '<name>'+ portName_ +'</name>'
+ '<display>this </display>'
+ '</instance>'
+ '</interface>';
return ret;
}
function queryByPortName_(portName_)
{
ret = '<interface isview="true">'
+ '<instance>'
+ '<name>Eth-Trunk '+ portName_ +'</name>'
+ '<display>this </display>'
+ '</instance>'
+ '</interface>';
return ret;
}
function queryIntInboundByAcl(aclNum)
{
var ret = '<display>traffic-applied interface inbound | include '+ aclNum +' </display>';
return ret;
}
function queryIntOutboundByAcl(aclNum)
{
var ret = '<display>traffic-applied interface outbound | include '+ aclNum +' </display>';
return ret;
}
function queryInboundByAclGlobal(aclNum)
{
var ret = '<display>traffic-applied  inbound | include '+ aclNum +' </display>';
return ret;
}
function queryOutboundByAclGlobal(aclNum)
{
var ret = '<display>traffic-applied  outbound | include '+ aclNum +' </display>';
return ret;
}
function queryVlanInboundByAcl(aclNum)
{
var ret = '<display>traffic-applied vlan inbound | include  '+ aclNum +' </display>';
return ret;
}
function queryVlanOutboundByAcl(aclNum)
{
var ret = '<display>traffic-applied vlan outbound | include  '+ aclNum +' </display>';
return ret;
}
function getApplyAclInbound(objName)
{
if(objName.indexOf("vlan") > -1)
{
var ret = '<display>traffic-applied '+ objName +' inbound</display>';
}
else if(objName.indexOf("global") > -1)
{
var ret = '<display>traffic-applied inbound</display>';
}
else
{
var ret = '<display>traffic-applied interface '+ objName +' inbound</display>';
}
return ret;
}
function getApplyAclOutbound(objName)
{
if(objName.indexOf("vlan") > -1)
{
var ret = '<display>traffic-applied '+ objName +' outbound</display>';
}
else
{
var ret = '<display>traffic-applied interface '+ objName +' outbound</display>';
}
return ret;
}
function deleteAClApply_GlobalOut(way,aclNum,vlan,ipType)
{
var ret = '<undo>traffic-filter ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret +='</undo>';
ret += '<undo>traffic-limit ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret +='</undo>';
ret += '<undo>traffic-remark ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' 8021p';
ret +='</undo>';
if(SysOID.indexOf("S53") < 0 && SysOID.indexOf("SI") < 0)
{
ret += '<undo>traffic-remark ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' cvlan-id';
ret +='</undo>';
}
ret += '<undo>traffic-remark ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' dscp';
ret +='</undo>';
ret += '<undo>traffic-remark ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' vlan-id';
ret +='</undo>';
ret += '<undo>traffic-statistic ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret +='</undo>';
return ret;
}
function deleteAClApply_GlobalIn(way,aclNum,vlan,ipType,SysOID)
{
var ret = '<undo>traffic-filter ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret +='</undo>';
ret += '<undo>traffic-limit ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret +='</undo>';
ret += '<undo>traffic-mirror ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret +='</undo>';
ret += '<undo>traffic-redirect ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret +='</undo>';
ret += '<undo>traffic-remark ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' 8021p';
ret +='</undo>';
if((SysOID.indexOf("S53") > 0 && SysOID.indexOf("EI") > 0 )  ||  (SysOID.indexOf("S33") > 0 && SysOID.indexOf("SI") > 0 ))
{
ret += '<undo>traffic-remark ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' destination-mac';
ret +='</undo>';
}
ret += '<undo>traffic-remark ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' dscp';
ret +='</undo>';
ret += '<undo>traffic-remark ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' local-precedence';
ret +='</undo>';
ret += '<undo>traffic-remark ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' ip-precedence';
ret +='</undo>';
ret += '<undo>traffic-remark ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' vlan-id';
ret +='</undo>';
ret += '<undo>traffic-statistic ';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret +='</undo>';
return ret;
}
function queryIntAcl(portName,bound,aclNum)
{
var ret = '<display>current-configuration interface '+portName+' | include '+bound+' '+ aclNum +'</display>';
return ret;
}
function getAClApplyByInt(portName,aclName)
{
var ret = '<interface isview="true">'
+ '<instance>'
+ '<name>'+ portName +'</name>'
+ '<display>current-configuration interface '+ portName +' | include '+ aclName +'</display>'
+ '</instance>'
+ '</interface>';
return ret;
}
function getAClApplyByVlan(aclNum)
{
return '<display>this | include acl '+ aclNum +'</display>';
}
function delAClApplyByPort(portName,cmd)
{
var ret = '<interface isview="true">'
+ '<instance>'
+ '<name>'+ portName +'</name>'
+ '<undo>'+ cmd +'</undo>'
+ '</instance>'
+ '</interface>';
return ret;
}
function delAClApplyByVlan(cmd)
{
var ret = '<undo>'+ cmd +'</undo>';
return ret;
}
function transActionCMD(portName,way,cmd)
{
var action=trim(cmd);
if(cmd.indexOf("traffic-filter")==0)
{
action="traffic-filter";
cmd=cmd.replace("traffic-filter","");
}
else if(cmd.indexOf("traffic-limit")==0)
{
action="traffic-limit";
cmd=cmd.replace("traffic-limit","");
}
else if(cmd.indexOf("traffic-redirect")==0)
{
action="traffic-redirect";
cmd=cmd.replace("traffic-redirect","");
}
else if(cmd.indexOf("traffic-remark")==0)
{
action="traffic-remark";
cmd=cmd.replace("traffic-remark","");
}
else if(cmd.indexOf("traffic-statistic")==0)
{
action="traffic-statistic";
cmd=cmd.replace("traffic-statistic","");
}
else if(cmd.indexOf("traffic-mirror")==0)
{
action="traffic-mirror";
cmd=cmd.replace("traffic-mirror","");
}
else if(cmd.indexOf("undo traffic-statistic")==0)
{
action="undo";
cmd=cmd.replace("undo","");
}
else if(cmd.indexOf("undo traffic-filter")==0)
{
action="undo";
cmd=cmd.replace("undo","");
}
var ret = '<interface isview="true"><instance>';
ret += '<name>'+portName+'</name>'
+'<'+action+'>' + cmd + '</'+action+'>'
+ '</instance></interface>';
return ret;
}
function transActionGlobeCMD(cmd)
{
var action=trim(cmd);
if(cmd.indexOf("traffic-filter")==0)
{
action="traffic-filter";
cmd=cmd.replace("traffic-filter","");
}
else if(cmd.indexOf("traffic-limit")==0)
{
action="traffic-limit";
cmd=cmd.replace("traffic-limit","");
}
else if(cmd.indexOf("traffic-redirect")==0)
{
action="traffic-redirect";
cmd=cmd.replace("traffic-redirect","");
}
else if(cmd.indexOf("traffic-remark")==0)
{
action="traffic-remark";
cmd=cmd.replace("traffic-remark","");
}
else if(cmd.indexOf("traffic-statistic")==0)
{
action="traffic-statistic";
cmd=cmd.replace("traffic-statistic","");
}
else if(cmd.indexOf("traffic-mirror")==0)
{
action="traffic-mirror";
cmd=cmd.replace("traffic-mirror","");
}
var ret ='<'+action+'>' + cmd + '</'+action+'>';
return ret;
}
function getGlobeApplyCMD(aclNum)
{
var ret ='<display> this | include '+aclNum+'</display>';
return ret;
}
function deleteAClApply(portName,way,aclNum,ipType,SysOID)
{
var ret = '<interface isview="true"><instance><name>'+ portName +'</name>'
+ '<undo>'
+ 'traffic-filter '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += '</undo>'
+ '<undo>'
ret += ' traffic-limit '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += '</undo>';
if(way == "inbound")
{
ret += '<undo>';
ret += ' traffic-mirror '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += '</undo>';
ret += '<undo>';
ret += ' traffic-redirect '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += '</undo>';
}
if(way == "outbound")
{
ret += '<undo>';
ret += ' traffic-remark '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' 8021p';
ret += '</undo>';
if(SysOID.indexOf("S53") < 0 && SysOID.indexOf("SI") < 0)
{
ret += '<undo>';
ret += ' traffic-remark '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' cvlan-id';
ret += '</undo>';
}
ret += '<undo>';
ret += ' traffic-remark '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' dscp';
ret += '</undo>'
+ '<undo>'
ret += ' traffic-remark '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' vlan-id';
ret += '</undo>';
}
else
{
ret += '<undo>';
ret += ' traffic-remark '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' 8021p';
ret += '</undo>'
if(SysOID.indexOf("S53") < 0 && SysOID.indexOf("SI") < 0)
{
ret += '<undo>';
ret += ' traffic-remark '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' destination-mac';
ret += '</undo>';
}
if(SysOID.indexOf("S5306") > -1)
{
ret += '<undo>';
ret += ' traffic-remark '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' destination-mac';
ret += '</undo>';
}
ret += '<undo>';
ret += ' traffic-remark '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' dscp';
ret += '</undo>'
+ '<undo>'
ret += ' traffic-remark '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' local-precedence';
ret += '</undo>'
+ '<undo>'
ret += ' traffic-remark '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' ip-precedence';
ret += '</undo>'
+ '<undo>'
ret += ' traffic-remark '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' vlan-id';
ret += '</undo>';
}
ret += '<undo>';
ret += ' traffic-statistic '+ way ;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += '</undo>'
+ '</instance></interface>';
return ret;
}
function configAcl(type,ipType,num,name,step,desc,sign)
{
var strName = '';
var strStep = '';
var strDesc = '';
if ("IPv6" == ipType)
{
strName += 'ipv6 ';
}
if ("" != name)
{
strName += 'name ' + name + " ";
}
if ("" != num)
{
strName += num;
}
else
{
strName += ("advanced"!=type) ? type : "advance";
}
if ("step" == sign)
{
if ("" != step && "IPv6" != ipType)
{
strStep = '<step>'+ step +'</step>';
}
else if("IPv6" != ipType)
{
strDesc = '<undo>step</undo>';
}
}
else if ("desc" == sign)
{
if ("" != desc && "IPv6" != ipType)
{
strDesc = '<description>'+ desc +'</description>';
}
else if("IPv6" != ipType)
{
strDesc = '<undo>description</undo>';
}
}
var ret = '<acl isview="true">'
+ '<instance>'
+ '<name>'+ strName +'</name>'
+ strStep
+ strDesc
+ '</instance>'
+ '</acl>';
return ret;
}
function deleteAcl(ipType,num)
{
var strNum = num;
if ("IPv6" == ipType)
{
strNum = 'ipv6 ' + num;
}
var ret = '<undo>acl ' + strNum + '</undo>';
return ret;
}
function getAclBasicRuleList(param,number,iName,i)
{
var ret = '<hwAclBasicRuleEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAcl.hwAclMibObjects.hwAclBasicRuleTable" '+tranParam(number,iName,i)+'>'
+ '<hwAclBasicAclNum>'+ param +'</hwAclBasicAclNum>'
+ '</hwAclBasicRuleEntry>';
return ret;
}
function getAclAdvancedRuleList(param,number,iName,i)
{
var ret = '<hwAclAdvancedRuleEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAcl.hwAclMibObjects.hwAclAdvancedRuleTable" '+tranParam(number,iName,i)+'>'
+ '<hwAclAdvancedAclNum>'+ param +'</hwAclAdvancedAclNum>'
+ '</hwAclAdvancedRuleEntry>';
return ret;
}
function getAclIpv6BasicRuleList(param,number,iName,i)
{
var ret = '<hwAclIpv6BasicRuleEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAcl.hwAclMibObjects.hwAclIpv6BasicRuleTable" '+tranParam(number,iName,i)+'>'
+ '<hwAclIpv6BasicAclNum>'+ param +'</hwAclIpv6BasicAclNum>'
+ '</hwAclIpv6BasicRuleEntry>';
return ret;
}
function getAclIpv6AdvancedRuleList(param,number,iName,i)
{
var ret = '<hwAclIpv6AdvancedRuleEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAcl.hwAclMibObjects.hwAclIpv6AdvancedRuleTable" '+tranParam(number,iName,i)+'>'
+ '<hwAclIpv6AdvancedAclNum>'+ param +'</hwAclIpv6AdvancedAclNum>'
+ '</hwAclIpv6AdvancedRuleEntry>';
return ret;
}
function getAclEthernetFrameRuleList(param,number,iName,i)
{
var ret = '<hwAclEthernetFrameRuleEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAcl.hwAclMibObjects.hwAclEthernetFrameRuleTable" '+tranParam(number,iName,i)+'>'
+ '<hwAclEthernetFrameAclNum>'+ param +'</hwAclEthernetFrameAclNum>'
+ '</hwAclEthernetFrameRuleEntry>';
return ret;
}
function configAclBasicRule(obj)
{
var strCmd = obj.ruleNum + ' ' + obj.ruleAct + ' ';
var undoCmd = '';
var strName = obj.aclNum;
if ("IPv6" == obj.ipType)
{
strName = 'ipv6 ' + obj.aclNum;
}
if ("" != obj.logging)
{
strCmd += "logging ";
}
else if ("modify" == obj.optType && "" == obj.logging && obj.flagLog)
{
undoCmd += '<undo>rule ' + obj.ruleNum + ' logging</undo>';
}
if ("" != obj.fragment)
{
strCmd += "fragment ";
}
else if ("modify" == obj.optType && "" == obj.fragment && obj.flagFrag)
{
undoCmd += '<undo>rule ' + obj.ruleNum + ' fragment</undo>';
}
if("any" == obj.source)
{
strCmd += "source any ";
}
else
{
strCmd += "source " + obj.source.split(";")[0] + " " + obj.source.split(";")[1] + " ";
}
if ("" != obj.ruleTRName)
{
strCmd += "time-range " + obj.ruleTRName;
}
else if ("modify" == obj.optType && "" == obj.ruleTRName && obj.flagTimeR)
{
undoCmd += '<undo>rule ' + obj.ruleNum + ' time-range</undo>';
}
return setConfigAclRuleCmd(strName,strCmd,undoCmd);
}
function configAclAdvancedRule(obj)
{
var strCmd = obj.ruleNum + ' ' + obj.ruleAct + ' ' + obj.protocol + ' ';
var undoCmd = '';
var strName = obj.aclNum;
if ("IPv6" == obj.ipType)
{
strName = 'ipv6 ' + obj.aclNum;
}
if ("" != obj.logging)
{
strCmd += "logging ";
}
else if ("modify" == obj.optType && "" == obj.logging && obj.flagLog)
{
undoCmd += '<undo>rule ' + obj.ruleNum + ' logging</undo>';
}
if ("" != obj.fragment)
{
strCmd += "fragment ";
}
else if ("modify" == obj.optType && "" == obj.fragment && obj.flagFrag)
{
undoCmd += '<undo>rule ' + obj.ruleNum + ' fragment</undo>';
}
if ("" != obj.icmpType && obj.ipType == "IPv4")
{
strCmd += "icmp-type " + obj.icmpType + " " + obj.icmpCode + " ";
}
else if ("" != obj.icmpType && obj.ipType == "IPv6")
{
strCmd += "icmp6-type " + obj.icmpType + " " + obj.icmpCode + " ";
}
if ("any" == obj.source)
{
strCmd += "source any ";
}
else
{
strCmd += "source " + obj.source.split(";")[0] + " " + obj.source.split(";")[1] + " ";
}
if ("any" == obj.destination)
{
strCmd += "destination any ";
}
else
{
strCmd += "destination " + obj.destination.split(";")[0] + " " + obj.destination.split(";")[1] + " ";
}
if ("" != obj.srcOp)
{
strCmd += "source-port " + obj.srcOp + " " + obj.srcPort1 + " " + obj.srcPort2 + " ";
}
else if ("modify" == obj.optType && "" == obj.srcOp && obj.flagSrcOp)
{
undoCmd += '<undo>rule ' + obj.ruleNum + ' source-port</undo>';
}
if ("" != obj.destOp)
{
strCmd += "destination-port " + obj.destOp + " " + obj.destPort1 + " " + obj.destPort2 + " ";
}
else if ("modify" == obj.optType && "" == obj.destOp && obj.flagDestOp)
{
undoCmd += '<undo>rule ' + obj.ruleNum + ' destination-port</undo>';
}
if ("" != obj.precedence)
{
strCmd += "precedence " + obj.precedence + " ";
}
else if ("modify" == obj.optType && "" == obj.precedence && obj.flagPrec)
{
undoCmd += '<undo>rule ' + obj.ruleNum + ' precedence</undo>';
}
if ("" != obj.tos)
{
strCmd += "tos " + obj.tos + " ";
}
else if ("modify" == obj.optType && "" == obj.tos && obj.flagTos)
{
undoCmd += '<undo>rule ' + obj.ruleNum + ' tos</undo>';
}
if ("" != obj.dscp)
{
strCmd += "dscp " + obj.dscp + " ";
}
else if ("modify" == obj.optType && "" == obj.dscp && obj.flagDscp)
{
undoCmd += '<undo>rule ' + obj.ruleNum + ' dscp</undo>';
}
if ("" != obj.ruleTRName)
{
strCmd += "time-range " + obj.ruleTRName;
}
else if ("modify" == obj.optType && "" == obj.ruleTRName && obj.flagTimeR)
{
undoCmd += '<undo>rule ' + obj.ruleNum + ' time-range</undo>';
}
return setConfigAclRuleCmd(strName,strCmd,undoCmd);
}
function configAclEthernetFrameRule(obj)
{
var strCmd = obj.ruleNum + ' ' + obj.ruleAct + ' ';
var undoCmd = '';
var strName = obj.aclNum;
if ("IPv6" == obj.ipType)
{
strName = 'ipv6 ' + obj.aclNum;
}
if ("" != obj.sMacAdrr && null != obj.sMacAdrr)
{
strCmd += "source-mac " + obj.sMacAdrr + " " + obj.sMacMask + " ";
}
if ("" != obj.dMacAdrr && null != obj.dMacAdrr)
{
strCmd += "destination-mac " + obj.dMacAdrr + " " + obj.dMacMask + " ";
}
if ("" != obj.encapType && null != obj.encapType)
{
strCmd += obj.encapType + " ";
}
if ("" != obj.l2Type && null != obj.l2Type)
{
strCmd += "l2-protocol " + obj.l2Type + " " + obj.l2TypeMask + " ";
}
if ("" != obj.vlanId && null != obj.vlanId)
{
strCmd += "vlan-id " + obj.vlanId + " " + obj.vlanIdMask + " ";
}
if ("" != obj.vlan8021p && null != obj.vlan8021p)
{
strCmd += "8021p " + obj.vlan8021p + " ";
}
if ("" != obj.cVlanId && null != obj.cVlanId)
{
strCmd += "cvlan-id " + obj.cVlanId + " " + obj.cVlanIdMask + " ";
}
if ("" != obj.cVlan8021p && null != obj.cVlan8021p)
{
strCmd += "cvlan-8021p " + obj.cVlan8021p + " ";
}
if ("" != obj.ruleTRName && null != obj.ruleTRName)
{
strCmd += "time-range " + obj.ruleTRName;
}
return setConfigAclRuleCmd(strName,strCmd,undoCmd);
}
function setConfigAclRuleCmd(strName,strCmd,undoCmd)
{
var ret = '<acl isview="true">'
+ '<instance>'
+ '<name>'+ strName +'</name>'
+ undoCmd
+ '<rule>' + strCmd +'</rule>'
+ '</instance>'
+ '</acl>';
return ret;
}
function deleteAClRules(ipType,aclNum,ruleNum)
{
var strName = '';
if ("IPv6" == ipType)
{
strName = 'ipv6 ' + aclNum;
}
else
{
strName = aclNum;
}
var ret = '<acl isview="true">'
+ '<instance>'
+ '<name>'+ strName +'</name>'
+ '<undo>rule ' + ruleNum +'</undo>'
+ '</instance>'
+ '</acl>';
return ret;
}
function getDHCPEnableState()
{
var ret = '<display>current-configuration | include dhcp enable</display>';
return ret;
}
function configDHCPEnable(flag)
{
var ret ='';
if ("enabled" == flag)
{
ret = '<dhcp>enable</dhcp>';
}
else
{
ret = '<undo>dhcp enable</undo>';
}
return ret;
}
function setDHCPPoolCmd(name,strCmd,type)
{
var ret = '';
if ("global" == type)
{
ret = '<ip isview="true">'
+ '<instance>'
+ '<name>pool '+ name +'</name>'
+ strCmd
+ '</instance>'
+ '</ip>';
}
else
{
ret = '<interface isview="true">'
+ '<instance>'
+ '<name>'+ name +'</name>'
+ strCmd
+ '</instance>'
+ '</interface>';
}
return ret;
}
function checkDHCPGlobalPoolNameExist(queryName)
{
var ret = '<display>ip pool name '+ queryName +'</display>';
return ret;
}
function getDHCPGlobalPoolByName(name)
{
var strCmd = '<display>this</display>';
return setDHCPPoolCmd(name,strCmd,"global");
}
function getAllDHCPGlobalPool(queryName)
{
var ret = '<display>current-configuration configuration ip-pool '+ queryName +'</display>';
return ret;
}
function checkDHCPInterfacePoolNameExist(queryName)
{
var ret = '<display>ip pool interface '+ queryName +'</display>';
return ret;
}
function getAllDHCPInterfacePool()
{
var ret = '<display>ip pool </display>';
return ret;
}
function getDHCPInterfacePoolByName(name)
{
var strCmd = '<display>this</display>';
return setDHCPPoolCmd(name,strCmd,"interface");
}
function configDHCPInterfacePool(name)
{
var strCmd = '<dhcp>select interface</dhcp>';
return setDHCPPoolCmd(name,strCmd,"interface");
}
function configDHCPGlobalPoolNetwork(name,network,mask)
{
var strCmd = '';
if ("" != network)
{
var maskstr = '';
if ("" != mask)
{
maskstr = 'mask ' + mask;
}
strCmd += '<network>' + network + ' ' + maskstr +'</network>';
}
return setDHCPPoolCmd(name,strCmd,"global");
}
function configDHCPPoolGateway(name,gateway_list,type)
{
var strCmd = '';
if ("" != gateway_list)
{
strCmd += '<gateway-list>' + gateway_list + '</gateway-list>';
}
return setDHCPPoolCmd(name,strCmd,type);
}
function undoDHCPPoolGateway(name,gateway_list,type)
{
var strCmd = '';
if ("" != gateway_list)
{
strCmd += '<undo>gateway-list ' + gateway_list + '</undo>';
}
return setDHCPPoolCmd(name,strCmd,type);
}
function configDHCPPoolExcludedIp(name,excluded_ip,type)
{
var strCmd = '';
if ("" != excluded_ip)
{
if ("global" == type)
{
strCmd += '<excluded-ip-address>' + excluded_ip + '</excluded-ip-address>';
}
else
{
strCmd += '<dhcp>server excluded-ip-address ' + excluded_ip + '</dhcp>';
}
}
return setDHCPPoolCmd(name,strCmd,type);
}
function undoDHCPPoolExcludedIp(name,excluded_ip,type)
{
var strCmd = '';
if ("" != excluded_ip)
{
if ("global" == type)
{
strCmd += '<undo>excluded-ip-address ' + excluded_ip + '</undo>';
}
else
{
strCmd += '<undo>dhcp server excluded-ip-address ' + excluded_ip + '</undo>';
}
}
return setDHCPPoolCmd(name,strCmd,type);
}
function configDHCPPoolLease(name,lease,type)
{
var strCmd = '';
if ("" != lease)
{
if ("global" == type)
{
strCmd += '<lease>day ' + lease.split(";")[0] + " hour " + lease.split(";")[1] + " minute " + lease.split(";")[2] + '</lease>';
}
else
{
strCmd += '<dhcp>server lease day ' + lease.split(";")[0] + " hour " + lease.split(";")[1] + " minute " + lease.split(";")[2] + '</dhcp>';
}
}
return setDHCPPoolCmd(name,strCmd,type);
}
function configDHCPPoolDns(name,domain_name,dns_list,opType,type)
{
var strCmd = '';
if ("" != domain_name)
{
if ("global" == type)
{
strCmd += '<domain-name>' + domain_name + '</domain-name>';
}
else
{
strCmd += '<dhcp>server domain-name ' + domain_name + '</dhcp>';
}
}
else if ("modify" == opType && "" == domain_name)
{
if ("global" == type)
{
strCmd += '<undo>domain-name</undo>';
}
else
{
strCmd += '<undo>dhcp server domain-name</undo>';
}
}
if ("" != dns_list)
{
if ("global" == type)
{
strCmd += '<undo>dns-list all</undo>';
strCmd += '<dns-list>' + dns_list + '</dns-list>';
}
else
{
strCmd += '<undo>dhcp server dns-list all</undo>';
strCmd += '<dhcp>server dns-list ' + dns_list + '</dhcp>';
}
}
else if ("" == dns_list)
{
if ("global" == type)
{
strCmd += '<undo>dns-list all</undo>';
}
else
{
strCmd += '<undo>dhcp server dns-list all</undo>';
}
}
return setDHCPPoolCmd(name,strCmd,type);
}
function configDHCPPoolNetBios(name,netbios_type,nbns_list,opType,type)
{
var strCmd = '';
if ("" != netbios_type)
{
if ("global" == type)
{
strCmd += '<netbios-type>' + netbios_type + '</netbios-type>';
}
else
{
strCmd += '<dhcp>server netbios-type ' + netbios_type + '</dhcp>';
}
}
else if ("modify" == opType && "" == netbios_type)
{
if ("global" == type)
{
strCmd += '<undo>netbios-type</undo>';
}
else
{
strCmd += '<undo>dhcp server netbios-type</undo>';
}
}
if ("" != nbns_list)
{
if ("global" == type)
{
strCmd += '<undo>nbns-list all</undo>';
strCmd += '<nbns-list>' + nbns_list + '</nbns-list>';
}
else
{
strCmd += '<undo>dhcp server nbns-list all</undo>';
strCmd += '<dhcp>server nbns-list ' + nbns_list + '</dhcp>';
}
}
else if ("" == nbns_list)
{
if ("global" == type)
{
strCmd += '<undo>nbns-list all</undo>';
}
else
{
strCmd += '<undo>dhcp server nbns-list all</undo>';
}
}
return setDHCPPoolCmd(name,strCmd,type);
}
function queryVlanifIp(param,number,iName,i)
{
var ret = '';
ret += '<hwIfIpEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwIFExtMib.hwIFExtObjects.hwInterfaceIp.hwIfIpTable" '+tranParam(number,iName,i)+'>'
+ '<hwIpAdEntAddr/>'
+ '<hwIpAdEntIfIndex/>'
+ '<hwIpAdEntNetMask/>'
+ '<hwIpAdEntAddressType/>'
+ '</hwIfIpEntry>';
return ret;
}
function deleteDHCPGlobalPool(name)
{
var ret = '<undo>ip pool '+ name +'</undo>';
return ret;
}
function deleteDHCPInterfacePool(name)
{
var strCmd = '<undo>dhcp select interface</undo>';
return setDHCPPoolCmd(name,strCmd,"interface");
}
function checkDHCPRelayVlanifExist(name)
{
var ret = '<display>interface '+ name +'</display>';
return ret;
}
function getDHCPRelayByVlanif(name)
{
var strCmd = '<display>this</display>';
return setDHCPPoolCmd(name,strCmd,"interface");
}
function deleteDHCPRelayByVlanif(name)
{
var strCmd = '<undo>dhcp relay server-select</undo>';
strCmd += '<undo>dhcp select relay</undo>';
return setDHCPPoolCmd(name,strCmd,"interface");
}
function configDHCPSelectRelay(name)
{
var strCmd = '<dhcp>select relay</dhcp>';
return setDHCPPoolCmd(name,strCmd,"interface");
}
function configDHCPRelay(name,group)
{
var strCmd = '<dhcp>relay server-select '+ group +'</dhcp>';
return setDHCPPoolCmd(name,strCmd,"interface");
}
function getDHCPGroupList()
{
var ret = '<display>dhcp server group</display>';
return ret;
}
function createDHCPGroup(name,ip)
{
var strCmd = '';
if ("" != ip)
{
strCmd = '<dhcp-server>'+ ip +'</dhcp-server>';
}
var ret = '<dhcp isview="true">'
+ '<instance>'
+ '<name>server group '+ name +'</name>'
+ strCmd
+ '</instance>'
+ '</dhcp>';
return ret;
}
function deleteDHCPGroup(name)
{
var ret = '<undo>dhcp server group '+ name +'</undo>';
return ret;
}
function getDHCPRelayList()
{
var ret = '<display>dhcp relay all</display>';
return ret;
}
function getGlobalPoeConifgInfo()
{
var ret = '<hwPoeSlotEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwPoeMIB.hwPoeSlotTable">'
+ '</hwPoeSlotEntry>';
return ret;
}
function configGlobalPoeManage(manage)
{
var ret = '<poe>power-management '+ manage +'</poe>';
return ret;
}
function configGlobalPoeMaxPower(maxPower)
{
var ret = '';
if ("" != maxPower)
{
ret += '<poe>max-power '+ maxPower +'</poe>';
}
else
{
ret += '<undo>poe max-power</undo>';
}
return ret;
}
function getPortPoeConfigInfo(param,number,iName,i)
{
var ret = '<hwPoePortEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwPoeMIB.hwPoePortTable"  '+tranParam(number,iName,i)+'>'
+ '</hwPoePortEntry>';
return ret;
}
function configPortPoeEnable(name,flag)
{
var cmdStr = '';
if (flag)
{
cmdStr = '<poe>enable</poe>';
}
else
{
cmdStr = '<undo>poe enable</undo>';
}
return getConfigInterfaceXML(name,cmdStr);
}
function configPortPoeForce(name,flag)
{
var cmdStr = '';
if (flag)
{
cmdStr = '<poe>force-power</poe>';
}
else
{
cmdStr = '<undo>poe force-power</undo>';
}
return getConfigInterfaceXML(name,cmdStr);
}
function configPortPoeMaxPower(name,maxPower)
{
var cmdStr = '';
if ("" != maxPower)
{
cmdStr = '<poe>power '+ maxPower +'</poe>';
}
else
{
cmdStr = '<undo>poe power</undo>';
}
return getConfigInterfaceXML(name,cmdStr);
}
function configPortPoePriority(name,priority)
{
var cmdStr = '';
if ("" != priority)
{
cmdStr = '<poe>priority '+ priority +'</poe>';
}
else
{
cmdStr = '<undo>poe priority</undo>';
}
return getConfigInterfaceXML(name,cmdStr);
}
function isPoePower()
{
var cmdStr = '<display>poe power</display>';
return cmdStr;
}
function configPortPoePowerOn(name,powerOn)
{
var ret = '<poe>'+ powerOn +' interface '+ name +'</poe>';
return ret;
}
function queryifEntry2(name,number,iName,i)
{
var ret = '<ifXEntry position="iso.org.dod.internet.mgmt.mib_2.ifMIB.ifMIBObjects.ifXTable" '+tranParam(number,iName,i)+'>';
ret += '<ifHighSpeed/>'
+'</ifXEntry>';
return ret;
}
function queryifEntry(name,number,iName,i)
{
var ret = '<ifEntry position="iso.org.dod.internet.mgmt.mib_2.interfaces.iftable" '+tranParam(number,iName,i)+'>';
if(name!="")
{
ret += '<ifDescr>'+name+'</ifDescr>';
}
else
{
ret +='<ifDescr/>';
}
ret += '<ifIndex/>'
+ '<ifOperStatus/>'
+ '<ifSpeed/>'
+ '<ifAdminStatus/>'
+ '<ifDescr/>'
+ '<ifType/>'
+ '<ifMtu/>'
+ '</ifEntry>';
return ret;
}
function queryifXEntry(name,number,iName,i)
{
var ret ='<ifXEntry position="iso.org.dod.internet.mgmt.mib_2.ifMIB.ifMIBObjects.ifXTable" '+tranParam(number,iName,i)+'>';
if(name!="")
{
ret += '<ifName>'+name+'</ifName>';
}
else
{
ret +='<ifName/>';
}
ret +='<ifIndex/>'
+'<ifAlias/>'
+'</ifXEntry>';
return ret;
}
function queryIpAddrEntry(name,number,iName,i)
{
var ret = '<IpAddrEntry position="iso.org.dod.internet.mgmt.mib_2.ip.ipAddrTable" '+tranParam(number,iName,i)+'>'
+ '<ipAdEntIfIndex/>'
+ '<ipAdEntAddr/>'
+ '<ipAdEntNetMask/>'
+ '</IpAddrEntry>';
return ret;
}
function configLoopBackName(name) {
var ret = '<interface isview="true"><instance>' + '<name>' + name + '</name>';
ret += '</instance>' + '</interface>';
return ret;
}
function configLoopBackIP(name, IP) {
var ret = '<interface isview="true"><instance>' + '<name>' + name + '</name>';
if (IP != "") {
ret += '<ip>address ' + IP + '</ip>';
} else {
ret += '<undo>ip address</undo>';
}
ret += '</instance>' + '</interface>';
return ret;
}
function configLoopBackDes(name, des) {
var ret = '<interface isview="true"><instance>' + '<name>' + name + '</name>';
if (des != "") {
ret += '<description>' + des + '</description>';
} else {
ret += '<undo>description</undo>';
}
ret += '</instance>' + '</interface>';
return ret;
}
function delloopbackbatch(ele) {
ret =  '<undo>interface ' + ele + '</undo>';
return ret;
}
function queryhwEthernetEntry(parm,number,iName,i)
{
var  ret = '<hwEthernetEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwPortMIB.hwPortMIBObjects.hwEthernet.hwEthernetTable" '+tranParam(number,iName,i)+'>'
+'<hwEthernetIfIndex/>'
+'<hwEthernetSpeedSet/>'
+'<hwEthernetDuplex/>'
+'<hwEthernetNegotiation/>'
+'<hwEthernetJumboframeMaxLength/>'
+'<hwEthernetPortMode/>'
+'</hwEthernetEntry>';
return ret;
}
function queryhwL2IfEntry(parm,number,iName,i)
{
var  ret = '<hwL2IfEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwL2IfMib.hwL2IfObjects.hwL2Interface.hwL2IfTable" '+tranParam(number,iName,i)+'>';
if(parm!="")
{
ret +='<hwL2IfPortType>'+parm+'</hwL2IfPortType>';
}
else
{
ret +='<hwL2IfPortType/>';
}
ret +='<hwL2IfPortIfIndex/>'
+'<hwL2IfPVID/>'
+'<hwL2IfBcastRatio/>'
+'<hwL2IfMacAddressLearn/>'
+'<hwL2IfBpdu/>'
+'</hwL2IfEntry>';
return ret;
}
function configDefaultVlan(name,vlanid,linktype)
{
var ret = '<interface isview="true"><instance>'
+'<name>'+name+'</name>';
if(linktype=="access")
{
ret+='<port>default vlan '+vlanid+'</port>';
}
else if(linktype=="trunk")
{
ret+='<port>trunk pvid vlan '+vlanid+'</port>';
}
else
{
ret+='<port>hybrid pvid vlan '+vlanid+'</port>';
}
ret+='</instance></interface>';
return ret;
}
function configEtState(name,State)
{
var ret = '<interface isview="true"><instance>'
+'<name>'+name+'</name>';
if(State=="up")
{
ret +='<undo>shutdown</undo>';
}
else
{
ret +='<shutdown></shutdown >';
}
ret +='</instance></interface>';
return ret;
}
function configNegotiation(name,negotiation,duplex,speed)
{
var ret = '<interface isview="true"><instance>'
+'<name>'+name+'</name>';
if(negotiation=="enabled")
{
ret +='<negotiation>auto</negotiation>';
}
else
{
ret +='<undo>negotiation auto</undo>';
}
ret +='</instance></interface>';
return ret;
}
function configDuplex(name,duplex)
{
var ret = '<interface isview="true"><instance>'
+'<name>'+name+'</name>'
+'<duplex>'+duplex+'</duplex>';
ret +='</instance></interface>';
return ret;
}
function configSpeed(name,speed)
{
var ret = '<interface isview="true"><instance>'
+'<name>'+name+'</name>'
+'<speed>'+speed+'</speed>';
ret +='</instance></interface>';
return ret;
}
function configLinkType(name,linktype,temp)
{
var ret = '<interface isview="true"><instance>'
+'<name>'+name+'</name>';
if(temp=="access")
{
ret+='<undo>port default vlan</undo>';
}
else if(temp=="trunk")
{
ret+='<undo>port trunk pvid vlan</undo>';
ret+='<port>trunk allow-pass vlan 1 </port>';
}
else
{
ret+='<undo>port hybrid pvid vlan</undo>';
ret+='<port>hybrid untag vlan 1 </port>';
}
ret+='<port>link-type ' + linktype + '</port>'
ret+='</instance></interface>';
return ret;
}
function configJumboframe(name,jumboframe)
{
var ret = '<interface isview="true"><instance>'
+'<name>'+name+'</name>';
if(jumboframe!="")
{
ret +='<jumbo>enable '+jumboframe+'</jumbo>';
}
else
{
ret +='<undo>jumbo enable</undo>';
}
ret +='</instance></interface>';
return ret;
}
function configJumboframe_(name,jumboframe)
{
var ret = '<interface isview="true"><instance>'
+'<name>Eth-Trunk '+name+'</name>';
if(jumboframe!="")
{
ret +='<jumbo>enable '+jumboframe+'</jumbo>';
}
else
{
ret +='<undo>jumbo enable</undo>';
}
ret +='</instance></interface>';
return ret;
}
function configBroadcast(name,Broadcast)
{
var ret = '<interface isview="true"><instance>'
+'<name>'+name+'</name>';
if(Broadcast=="")
{
ret+= '<undo>broadcast-suppression</undo>';
}
else
{
ret+= '<broadcast-suppression>'+Broadcast+'</broadcast-suppression>';
}
ret+= '</instance></interface>';
return ret;
}
function configDes(name,des)
{
var ret = '<interface isview="true"><instance>'
+'<name>'+name+'</name>';
if(des!="")
{
ret +='<description>'+des+'</description>';
}
else
{
ret +='<undo>description</undo>';
}
ret +='</instance></interface>';
return ret;
}
function queryhwArpDynEntry(parm,number,iName,i)
{
var ret = '<hwArpDynEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwEthernetARPMIB.hwEthernetARPObjects.hwArpDynTable" '+tranParam(number,iName,i)+'>'
+'<hwArpDynIpAdd/>'
+'<hwArpDynMacAdd/>'
+'<hwArpDynIfIndex/>'
+'<hwArpDynVlanId/>'
+'<hwArpDynOutIfIndex/>'
+'<hwArpDynType/>'
+'<hwArpDynExpireTime/>'
+'</hwArpDynEntry>';
return ret;
}
function queryhwArpCfgEntry(parm,number,iName,i)
{
var ret = '<hwArpCfgEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwEthernetARPMIB.hwEthernetARPObjects.hwArpCfgTable" '+tranParam(number,iName,i)+'>'
+'<hwArpCfgIpAdd/>'
+'<hwArpCfgMacAdd/>'
+'<hwArpCfgOutIfIndex/>'
+'<hwArpCfgVlanId/>'
+'</hwArpCfgEntry>';
return ret;
}
function cleanARPDynamic()
{
var ret = '<quit/>'
+'<reset>arp dynamic </reset>';
return ret;
}
function addARPStatic(ip,mac,vid,portName)
{
var ret = '<arp>static '+ip+' '+mac;
if(vid!="")
{
ret+= ' vid ' +vid;
if(portName!="")
{
ret+= ' interface ' +portName;
}
}
ret+='</arp>';
return ret;
}
function delStaticArp(ip,vid,portName) {
var ret = '<undo>arp static '+ ip +'</undo>';
return ret;
}
function delAllStaticArp() {
var ret = '<quit/><reset>arp static</reset>';
return ret;
}
function queryArpDeEe(name) {
var ret = '<display>current-configuration interface ' + name + '</display>';
return ret;
}
function configArpDetectTimes(vlanif,detectTimes) {
var ret = '<interface isview="true"><instance>' + '<name>' + vlanif + '</name>';
if(detectTimes!="")
{
ret +='<arp>detect-times '+ detectTimes+'</arp>';
}
else
{
ret +='<undo>arp detect-times</undo>';
}
ret += '</instance>' + '</interface>';
return ret;
}
function configArpAgingTime(vlanif,agingTime) {
var ret = '<interface isview="true"><instance>' + '<name>' + vlanif + '</name>';
if(agingTime!="")
{
ret += '<arp>expire-time '+ agingTime+'</arp>';
}
else
{
ret += '<undo>arp expire-time</undo>';
}
ret += '</instance>' + '</interface>';
return ret;
}
function queryVrrp(vrid,number,iName,i) {
var ret = '<vrrpOperEntry  position="iso.org.dod.internet.mgmt.mib-2.vrrpMIB.vrrpOperations.vrrpOperTable" '+tranParam(number,iName,i)+'>';
if (vrid!= "")
{
ret += '<vrrpOperVrId>'+vrid+'</vrrpOperVrId>';
}
ret += '</vrrpOperEntry>';
return ret;
}
function queryvrrpAssoIpAddrEntry(parm,number,iName,i) {
var ret = '<vrrpAssoIpAddrEntry  position="iso.org.dod.internet.mgmt.mib-2.vrrpMIB.vrrpOperations.vrrpAssoIpAddrTable" '+tranParam(number,iName,i)+'>';
if (parm!="")
{
ret += '<ifIndex>'+parm.split(",")[0]+'</ifIndex>';
ret += '<vrrpOperVrId>'+parm.split(",")[0]+'</vrrpOperVrId>';
}
ret += '</vrrpAssoIpAddrEntry>';
return ret;
}
function queryhwVrrpTrackInterEntry(parm,number,iName,i)
{
var ret= '<hwVrrpTrackInterEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwVrrpExt.vrrpExtOperations.hwVrrpTrackInterTable" '+tranParam(number,iName,i)+'>';
var tempParm = parm.split(",");
if (tempParm[0]!= "")
{
ret += '<hwVrrpTrackInterVRID>'+parm.split(",")[0]+'</hwVrrpTrackInterVRID>';
}
if (tempParm[1]!= "")
{
ret += '<hwVrrpTrackInterStandByIfnet>'+parm.split(",")[1]+'</hwVrrpTrackInterStandByIfnet>';
}
ret +='</hwVrrpTrackInterEntry>';
return ret;
}
function configVRRPVrid(vlanif,vrid,virtualip) {
var ret = '<interface isview="true"><instance>' + '<name>' + vlanif + '</name>'
+'<vrrp>vrid '+ vrid+' virtual-ip '+virtualip+'</vrrp>';
ret += '</instance>' + '</interface>';
return ret;
}
function configPreemptmode(vlanif,vrid,Preemptmode) {
var ret= '<interface isview="true"><instance>' + '<name>' + vlanif + '</name>';
if(Preemptmode=="false")
{
ret += '<vrrp>vrid '+ vrid+' preempt-mode disable</vrrp>';
}
else
{
ret += '<undo >vrrp vrid '+ vrid+' preempt-mode</undo >';
}
ret += '</instance>' + '</interface>';
return ret;
}
function configVrrpAdvertise(vlanif,vrid,advertise) {
var ret= '<interface isview="true"><instance>' + '<name>' + vlanif + '</name>'
+ '<vrrp>vrid '+ vrid+' timer advertise '+advertise	+'</vrrp>';
ret += '</instance>' + '</interface>';
return ret;
}
function configVrrpPriority (vlanif,vrid,priority) {
var ret= '<interface isview="true"><instance>' + '<name>' + vlanif + '</name>'
+'<vrrp>vrid '+ vrid+' priority  '+priority +'</vrrp>';
ret += '</instance>' + '</interface>';
return ret;
}
function configVrrptrackIf (vlanif,vrid,trackIf,type, priority)
{
var ret= '<interface isview="true"><instance>' + '<name>' + vlanif + '</name>'
+ '<vrrp>vrid '+ vrid+' track interface '+trackIf;
if(priority !="")
{
ret+=' '+type+' '+priority;
}
ret += '</vrrp></instance>' + '</interface>';
return ret;
}
function delVrrptrackIf (vlanif,vrid,trackIf)
{
var ret= '<interface isview="true"><instance>' + '<name>' + vlanif + '</name>'
+ '<undo>vrrp vrid '+ vrid+' track interface '+trackIf;
ret += '</undo></instance>' + '</interface>';
return ret;
}
function delVrrpVrid(vlanif,vrid,ip)
{
var ret = '<interface isview="true"><instance>' + '<name>' + vlanif + '</name>'
+'<undo>vrrp vrid '+ vrid;
if(ip!="")
{
ret += ' virtual-ip '+ ip;
}
ret += '</undo></instance>' + '</interface>';
return ret;
}
function queryVrrpconfig()
{
var ret = '<hwVrrpExtGlobal position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwVrrpExt">'
+'<hwVrrpExtFreeArpInterval/>'
+'<hwVrrpExtVIPPingCtr/>'
+'</hwVrrpExtGlobal>';
return ret;
}
function configVrrpingIP(flag)
{
var ret='';
if(flag)
{
ret = '<vrrp>virtual-ip ping enable</vrrp>';
}
else
{
ret = '<undo>vrrp virtual-ip ping enable</undo>';
}
return ret;
}
function configTakeTime(flag,time)
{
var ret='';
if(flag)
{
ret = '<vrrp>smooth-switching timer '+time+'</vrrp>';
}
else
{
ret = '<undo>vrrp smooth-switching timer</undo>';
}
return ret;
}
function configvrrpTal(flag)
{
var ret='';
if(flag)
{
ret = '<vrrp>timer-advertise learning enable</vrrp>';
}
else
{
ret = '<undo>vrrp timer-advertise learning enable</undo>';
}
return ret;
}
function configvrrparptimeout()
{
var ret = '<vrrp>gratuitous-arp timeout disable</vrrp>';
return ret;
}
function configvrrparptimeoutTime(time)
{
var ret = '<vrrp>gratuitous-arp timeout '+time+'</vrrp>';
return ret;
}
function queryhwdbDynFdbEntry(parm,number,iName,i)
{
var ret = '<hwdbDynFdbEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwL2MAM.hwL2MAMObjects.hwdbDynFdbTable" '+tranParam(number,iName,i)+'>'
+ '<hwDynFdbMac/>'
+ '<hwDynFdbVlanId/>'
+ '<hwDynFdbPort/>'
+ '</hwdbDynFdbEntry>';
return ret;
}
function queryhwdbhwdbCfgFdbEntry(parm,number,iName,i)
{
var ret = '<hwdbCfgFdbEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwL2MAM.hwL2MAMObjects.hwdbCfgFdbTable" '+tranParam(number,iName,i)+'>';
if(parm!="")
{
ret += '<hwCfgFdbType>'+parm+'</hwCfgFdbType>';
}
ret += '</hwdbCfgFdbEntry>';
return ret;
}
function queryMacAgingTime() {
var ret = '<hwL2MAMObjects position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwL2MAM">'
+ '<hwMacAgingTime/></hwL2MAMObjects>';
return ret;
}
function configMacAgingTime(agingTime)
{
var ret = '<mac-address>aging-time '+ agingTime +'</mac-address>';
return ret;
}
function delStaticMac(mac,vlanid)
{
var ret = '<undo> mac-address '+ mac + ' vlan '+vlanid +'</undo>';
return ret;
}
function configStaticMac(name,mac,vlanid)
{
var ret = '<mac-address> static '+mac +' '+name+ ' vlan '+ vlanid+'</mac-address>';
return ret;
}
function configBlackholeMac(mac,vlanid)
{
var ret = '<mac-address> blackhole '+mac ;
if(vlanid !="")
{
ret+=' vlan '+ vlanid;
}
ret+='</mac-address>';
return ret;
}
function delBlackholeMac(mac,vlanid)
{
var ret = '<undo>mac-address  blackhole '+mac ;
if(vlanid !="NONE")
{
ret='<undo>mac-address '+mac+ ' vlan '+ vlanid;
}
ret+='</undo>';
return ret;
}
function queryMaclimt(parm,number,iName,i)
{
var ret = '<hwMacLimitEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwL2MAM.hwL2MAMObjects.hwMacLimitTable" '+tranParam(number,iName,i)+'>'
+ '<hwMacLimitPort/>'
+ '<hwMacLimitVlanId/>'
+ '<hwMacLimitMaxMac/>'
+ '<hwMacLimitAction/>'
+ '<hwMacDynAddressLearnNum/>'
+ '</hwMacLimitEntry>';
return ret;
}
function configVlanMaclearn(vlan,falg)
{
var ret ='<vlan isview="true"><instance><name>' + vlan + '</name>';
if(falg)
{
ret +='<mac-address>learning disable</mac-address>';
}
else
{
ret +='<undo>mac-address learning disable</undo>';
}
ret +='</instance></vlan>';
return ret;
}
function configPortMaclearn(port,falg)
{
var ret ='<interface isview="true"><instance><name>' + port + '</name>';
if(falg)
{
ret +='<mac-address>learning disable</mac-address>';
}
else
{
ret +='<undo>mac-address learning disable</undo>';
}
ret +='</instance></interface>';
return ret;
}
function configVlanMaclimt(vlan,action,num)
{
var ret ='<vlan isview="true"><instance>'
+'<name>' + vlan + '</name>'
+'<mac-limit>alarm enable maximum '+num+'</mac-limit>'
+'</instance></vlan>';
return ret;
}
function configPortMaclimt(port,action,num)
{
var ret ='<interface isview="true"><instance>'
+'<name>' + port + '</name>'
+'<mac-limit>alarm enable maximum '+num+'</mac-limit>'
+'</instance></interface>';
return ret;
}
function undoMacLimit(port)
{
var str ='<interface isview="true"><instance>'
+'<name>' + port + '</name>'
+'<undo>mac-limit</undo>'
+'</instance></interface>';
return str;
}
function undoVlanMacLimit(vlan)
{
var str ='<vlan isview="true"><instance>'
+'<name>' + vlan + '</name>'
+'<undo>mac-limit</undo>'
+'</instance></vlan>';
return str;
}
function cancelPortMaclimt(port)
{
var ret ='<interface isview="true"><instance>'
+'<name>' + port + '</name>'
+'<undo>mac-limit</undo>'
+'</instance></interface>';
return ret;
}
function cancelVlanMaclimt(vlan)
{
var ret ='<vlan isview="true"><instance>'
+'<name>' + vlan + '</name>'
+'<undo>mac-limit</undo>'
+'</instance></vlan>';
return ret;
}
function configStickyMac(port,flag,type,num,securityFlag)
{
var ret ='<interface isview="true"><instance><name>' + port + '</name>';
if(!securityFlag)
{
ret +='<port-security>enable</port-security>';
}
if(flag)
{
ret +='<port-security>mac-address sticky</port-security>';
}
else
{
ret +='<undo>port-security mac-address sticky</undo>';
}
ret +='<port-security>protect-action '+ type+'</port-security>';
if(num!="")
{
ret +=  '<port-security>max-mac-num '+ num+'</port-security>';
}
ret +='</instance></interface>';
return ret;
}
function configStickyMac1(port)
{
var ret ='<interface isview="true"><instance><name>' + port + '</name>';
ret +='<undo>port-security mac-address sticky</undo>';
ret +='<undo>port-security enable</undo>';
ret +='</instance></interface>';
return ret;
}
function queryStickyMaclimt()
{
var ret ='<display>mac-address sticky</display>';
return ret;
}
function queryStickyPort(port)
{
var ret ='<display>current-configuration interface '+port+' | include port-security</display>';
return ret;
}
function queryhwTrunkIfEntry2()
{
var ret = '<hwTrunkIfEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwIFExtMib.hwIFExtObjects.hwTrunkAttr.hwTrunkIfTable">';
ret +='<hwTrunkIfID/></hwTrunkIfEntry>';
return ret;
}
function queryByPortNames(portName_)
{
ret = '<interface isview="true">'
+ '<instance>'
+ '<name>'+ portName_ +'</name>'
+ '<display>this | include am isolate </display>'
+ '</instance>'
+ '</interface>';
return ret;
}
function queryhwTrunkIfEntry(parm,number,iName,i)
{
var ret = '<hwTrunkIfEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwIFExtMib.hwIFExtObjects.hwTrunkAttr.hwTrunkIfTable" '+tranParam(number,iName,i)+'>';
ret +='<hwTrunkIfWorkingMode>2</hwTrunkIfWorkingMode>';
if(parm!="")
{
ret +='<hwTrunkIfID>'+parm+'</hwTrunkIfID>';
}
else
{
ret +='<hwTrunkIfID/>';
}
ret +='<hwTrunkIndex/>'
+'<hwTrunkIfIndex/>'
+'<hwTrunkIfWorkingMode/>'
+'<hwTrunkIfModel/>'
+'<hwTrunkIfMinLinkNum/>'
+'</hwTrunkIfEntry>';
return ret;
}
function queryhwTrunkLacpIfEntry(parm,number,iName,i)
{
var ret = '<hwTrunkIfEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwIFExtMib.hwIFExtObjects.hwTrunkAttr.hwTrunkIfTable" '+tranParam(number,iName,i)+'>';
ret +='<hwTrunkIfWorkingMode>3</hwTrunkIfWorkingMode>';
if(parm!="")
{
ret +='<hwTrunkIfID>'+parm+'</hwTrunkIfID>';
}
else
{
ret +='<hwTrunkIfID/>';
}
ret +='<hwTrunkIndex/>'
+'<hwTrunkIfIndex/>'
+'<hwTrunkIfWorkingMode/>'
+'<hwTrunkIfModel/>'
+'<hwTrunkIfTimeoutRev/>'
+'<hwTrunkIfMinLinkNum/>'
+'<hwTrunkIfLagMaxActiveLinkNum/>'
+'<hwTrunkIfPreemptEnable/>'
+'<hwTrunkIfPreemptDelay/>'
+'</hwTrunkIfEntry>';
return ret;
}
function queryhwTrunkMemEntry(parm,number,iName,i)
{
var ret ='<hwTrunkMemEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwIFExtMib.hwIFExtObjects.hwTrunkMemAttr.hwTrunkMemTable" '+tranParam(number,iName,i)+'>';
if(parm!="")
{
ret +='<hwTrunkIndex>'+parm+'</hwTrunkIndex>';
}
else
{
ret +='<hwTrunkIndex/>';
}
ret +='<hwTrunkMemifIndex/>'
+'<hwTrunkOperstatus />'
+'<hwTrunkPortPriority/>'
+'</hwTrunkMemEntry>';
return ret;
}
function queryLacpSysPriority()
{
var ret = '<hwTrunkAttr position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwIFExtMib.hwIFExtObjects">'
+'<hwTrunkSystemPriority/>'
+'</hwTrunkAttr>';
return ret;
}
function configLacpSysPriority(value)
{
var ret = '<lacp>priority '+ value +' </lacp>';
return ret;
}
function deleteTrunk(TrunkID)
{
var ret = ' <undo>interface Eth-Trunk '+TrunkID +'</undo>';
return ret;
}
function configTrunkID(TrunkID)
{
var ret = '<interface isview="true"><instance><name>Eth-Trunk '+TrunkID +'</name>'
+'</instance></interface>';
return ret;
}
function configBpdu(TrunkID,flag)
{
var ret = '<interface isview="true"><instance><name>Eth-Trunk '+TrunkID +'</name>';
if (flag)
{
ret += '<bpdu>enable</bpdu>';
}
else
{
ret += '<bpdu>disable</bpdu>';
}
ret += '</instance></interface>';
return ret;
}
function configWorkMode(TrunkID,workmode)
{
var ret = '<interface isview="true"><instance><name>Eth-Trunk '+TrunkID +'</name>';
if(workmode=="0")
{
ret +='<mode >manual load-balance</mode >';
}
else
{
ret +='<mode>lacp-static </mode>';
}
ret +='</instance></interface>';
return ret;
}
function configLeastactive(TrunkID,Least)
{
var ret = '<interface isview="true"><instance><name>Eth-Trunk '+TrunkID +'</name>'
+'<least>active-linknumber '+Least+'</least>'
+'</instance></interface>';
return ret;
}
function configmaxactive(TrunkID,max)
{
var ret = '<interface isview="true"><instance><name>Eth-Trunk '+TrunkID +'</name>'
+'<max>active-linknumber '+max+'</max>'
+'</instance></interface>';
return ret;
}
function configLacppreempt (TrunkID,preempt,time)
{
var ret = '<interface isview="true"><instance><name>Eth-Trunk '+TrunkID +'</name>';
if(preempt=="enable")
{
ret +='<lacp>preempt enable</lacp>'
+'<lacp>preempt delay '+ time+'</lacp>';
}
else
{
ret +='<undo>lacp preempt enable </undo>';
}
ret +='</instance></interface>';
return ret;
}
function configLacptimeout(TrunkID,timeout)
{
var ret = '<interface isview="true"><instance><name>Eth-Trunk '+TrunkID +'</name>'
+'<lacp>timeout '+ timeout+'</lacp>'
+'</instance></interface>';
return ret;
}
function configloadbalance(TrunkID,loadbalance)
{
var ret = '<interface isview="true"><instance><name>Eth-Trunk '+TrunkID +'</name>'
+'<load-balance>'+ loadbalance+'</load-balance>'
+'</instance></interface>';
return ret;
}
function configTrunkLinkType(TrunkID,LinkType)
{
var ret = '<interface isview="true"><instance><name>Eth-Trunk '+TrunkID +'</name>'
+'<port>link-type '+ LinkType+'</port>'
+'</instance></interface>';
return ret;
}
function configTrunkDes(TrunkID,des)
{
var ret = '<interface isview="true"><instance><name>Eth-Trunk '+TrunkID +'</name>'
+'<description>'+ des+'</description>'
+'</instance></interface>';
return ret;
}
function configTrunkDes2(TrunkID)
{
var ret = '<interface isview="true"><instance><name>Eth-Trunk '+TrunkID +'</name>'
+'<undo>description</undo>'
+'</instance></interface>';
return ret;
}
function configTrunkPort(TrunkID,port)
{
var ret = '<interface isview="true"><instance><name>'+port +'</name>'
+'<eth-trunk>'+TrunkID+'</eth-trunk>'
+'</instance></interface>';
return ret;
}
function delTrunkPort(port)
{
var ret = '<interface isview="true"><instance><name>'+port +'</name>'
+'<undo>eth-trunk</undo>'
+'</instance></interface>';
return ret;
}
function configTrunkPortPriority(port,priority)
{
var ret = '<interface isview="true"><instance><name>'+port +'</name>'
+'<lacp>priority  '+priority+'</lacp>'
+'</instance></interface>';
return ret;
}
function queryvlan(vlan,number,iName,i)
{
var ret = '<hwL2VlanMIBEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwL2Vlan.hwL2VlanMngObjects.hwL2VlanBase.hwL2VlanMIBTable" '+tranParam(number,iName,i)+'>\n';
if(vlan=="")
{
ret+='<hwL2VlanIndex/>\n';
}
else
{
ret+='<hwL2VlanIndex>'+vlan+'</hwL2VlanIndex>\n';
}
ret+='<hwL2VlanPortList/>\n'
+'<hwL2VlanType/>\n'
+'<hwL2VlanAdminStatus/>\n'
+'<hwL2VlanDescr/>\n'
+'<hwL2VlanMacLearn/>\n'
+'</hwL2VlanMIBEntry>';
return ret;
}
function queryhwL2IfHybridPortEntry(param,number,iName,i)
{
var ret = '<hwL2IfHybridPortEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwL2IfMib.hwL2IfObjects.hwL2Interface.hwL2IfHybridPortTable" '+tranParam(number,iName,i)+'>'
+'</hwL2IfHybridPortEntry>';
return ret;
}
function queryhwL2IfTrunkPortEntry(param,number,iName,i)
{
var ret = '<hwL2IfTrunkPortEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwL2IfMib.hwL2IfObjects.hwL2Interface.hwL2IfTrunkPortTable" '+tranParam(number,iName,i)+'>'
+'</hwL2IfTrunkPortEntry>';
return ret;
}
function deletevlan(vlan)
{
var ret = '<undo>vlan '+vlan+'</undo>';
return ret;
}
function batchAddVlan(vlan)
{
vlan = vlan.replace("-"," to ");
var ret = '<vlan>batch '+vlan+'</vlan>';
return ret;
}
function batchDelVlan(vlan)
{
vlan = vlan.replace(/-+/g," to ");
var ret = '<undo> vlan batch '+vlan+'</undo>';
return ret;
}
function configVlanId(vlanid) {
var ret = '<vlan isview="true">'
+ '<instance>'
+ '<name>'+ vlanid +'</name>'
+ '</instance></vlan>';
return ret;
}
function configVlanDes(vlanid,des) {
var ret = '<vlan isview="true">'
+ '<instance>'
+ '<name>'+ vlanid +'</name>';
if(des=="")
{
ret += '<undo>description '+des+'</undo>';
}
else
{
ret +='<description>'+des+'</description>';
}
ret +='</instance></vlan>';
return ret;
}
function portJoinVlan(vlanid,port,joinType,linktype) {
var ret = '<interface isview="true">'
+ '<instance>'
+ '<name>'+ port +'</name>';
if(linktype=="2")
{
ret +='<port>default vlan ' + vlanid + '</port>';
}
else if(linktype=="1")
{
ret +='<port>trunk allow-pass vlan ' + vlanid + '</port>';
}
else
{
ret +='<port>hybrid '+joinType +' vlan ' + vlanid + '</port>\n';
}
ret +='</instance></interface>';
return ret;
}
function  cleanConfigPortVlan(vlanid,port,joinType,linktype)
{
var ret = '<interface isview="true">'
+ '<instance>'
+ '<name>'+ port +'</name>';
if(linktype=="2")
{
ret +='<undo>port default vlan</undo>';
}
else if(linktype=="1")
{
ret +='<undo>port trunk allow-pass vlan ' + vlanid + '</undo>';
ret +='<undo>port trunk pvid vlan</undo>';
ret +='<port>trunk allow-pass vlan 1</port>';
}
else
{
ret +='<undo>port hybrid  vlan ' + vlanid + '</undo>';
ret +='<undo>port hybrid pvid vlan</undo>';
ret +='<port> hybrid untagged vlan 1</port>';
}
ret +='</instance></interface>';
return ret;
}
function  cleanConfigPortVlans(port,linktype)
{
var ret = '<interface isview="true">'
+ '<instance>'
+ '<name>'+ port +'</name>';
if(linktype=="2")
{
ret +='<undo>port default vlan</undo>';
}
else if(linktype=="1")
{
ret +='<undo>port trunk allow-pass vlan all</undo>';
ret +='<undo>port trunk pvid vlan</undo>';
ret +='<port>trunk allow-pass vlan 1</port>';
}
else
{
ret +='<undo>port hybrid  vlan all</undo>';
ret +='<undo>port hybrid pvid vlan</undo>';
ret +='<port> hybrid untagged vlan 1</port>';
}
ret +='</instance></interface>';
return ret;
}
function  delConfigPortVlan(vlan,port,joinType,linktype)
{
var ret = '<interface isview="true">'
+ '<instance>'
+ '<name>'+ port +'</name>';
if(linktype=="2")
{
ret +='<undo>port default vlan</undo>';
}
else if(linktype=="1")
{
ret +='<undo>port trunk allow-pass vlan '+vlan+'</undo>';
}
else
{
ret +='<undo>port hybrid  vlan '+vlan+'</undo>';
}
ret +='</instance></interface>';
return ret;
}
function queryhwIfIpEntry(parm,number,iName,i)
{
var ret = '<hwIfIpEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwIFExtMib.hwIFExtObjects.hwInterfaceIp.hwIfIpTable"  '+tranParam(number,iName,i)+'>'
+ '<hwIpAdEntAddr/>'
+ '<hwIpAdEntIfIndex/>'
+ '<hwIpAdEntNetMask/>'
+ '<hwIpAdEntAddressType/>'
+ '</hwIfIpEntry>';
return ret;
}
function configvlanif(name)
{
var ret = '<interface isview="true"><instance><name>Vlanif '+name +'</name>'
+'</instance></interface>';
return ret;
}
function configvlanifState(name,State)
{
var ret = '<interface isview="true"><instance><name>Vlanif '+name +'</name>';
if(State=="open")
{
ret += "<undo>shutdown</undo>";
}
else
{
ret += "<shutdown></shutdown>";
}
ret +='</instance></interface>';
return ret;
}
function configvlanifState1(name,State)
{
var ret = '<interface isview="true"><instance><name>Vlanif '+name +'</name>';
if(State=="open")
{
ret += "";
}
else
{
ret += "<shutdown></shutdown>";
}
ret +='</instance></interface>';
return ret;
}
function configvlanifMtu(name,mtu)
{
var ret = '<interface isview="true"><instance><name>Vlanif '+name +'</name>';
if(mtu!="")
{
ret += '<mtu>'+mtu+'</mtu>';
}
else
{
ret +='<undo>mtu</undo>';
}
ret +='</instance></interface>';
return ret;
}
function configvlanifDes(name,des)
{
var ret = '<interface isview="true"><instance><name>Vlanif '+name +'</name>';
if(des!="")
{
ret +='<description>'+des+'</description>';
}
else
{
ret +='<undo>description</undo>';
}
ret +='</instance></interface>';
return ret;
}
function configvlanifip(name,ip)
{
var ret = '<interface isview="true"><instance><name>Vlanif '+name +'</name>';
ret +='<ip>address  '+ip+'</ip>';
ret +='</instance></interface>';
return ret;
}
function configvlanifsubip(name,ip)
{
var ret = '<interface isview="true"><instance><name>Vlanif '+name +'</name>';
ret +='<ip>address  '+ip+' sub</ip>';
ret +='</instance></interface>';
return ret;
}
function delvlanifsubip(name,ip)
{
var ret = '<interface isview="true"><instance><name>Vlanif '+name +'</name>';
ret +='<undo>ip address  '+ip+' sub</undo>';
ret +='</instance></interface>';
return ret;
}
function delvlanifip(name)
{
var ret = '<interface isview="true"><instance><name>Vlanif '+name +'</name>';
ret +='<undo>ip address</undo>';
ret +='</instance></interface>';
return ret;
}
function ping(obj)
{
return "<ping>"+obj.ip+"</ping>";
}
function tracert(obj)
{
return  "<tracert>"+"-w 1000 "+obj.ip+"</tracert>";
}
function vct(interfaceName)
{
return '<interface isview="true"><instance><name> '+interfaceName+'</name>'
+'<virtual-cable-test/>'
+'</instance></interface>';
}
function getPlug(obj)
{
return "<quit/><cd>"+obj.location+"</cd><tftp>"+obj.ip+" get "+obj.fileName+" "+obj.localFileName+"</tftp>";
}
function loadPath(obj)
{
return "<quit/><patch>load "+obj.localFileName+" all</patch>";
}
function activePath(obj)
{
return "<quit/><patch>active all</patch>";
}
function runPath(obj)
{
return "<quit/><patch>run all</patch>";
}
function loadPatch(fileName)
{
return "<quit/><patch>load "+fileName+" all run</patch>";
}
function deletePlugOrder()
{
return "<quit/><patch>delete all</patch>";
}
function getStackSystemInfoOrder()
{
return "<display>stack</display>";
}
function getStackConfig()
{
return "<display>stack configuration</display>";
}
function getIsStack()
{
return '<hwStackObject position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.huaweiStackMIB">'
+'<hwStackRun/>'
+'</hwStackObject>';
}
function getStackMemberInfoOrder()
{
var ret='<hwStackMemberInfoEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.huaweiStackMIB.hwStackMemberInfoTable">'
+'<hwMemberCurrentStackId/>'
+'<hwMemberStackPriority/>'
+'<hwMemberStackRole/>'
+'<hwMemberStackMacAddress/>'
+'<hwMemberStackDeviceType/>'
+'</hwStackMemberInfoEntry>';
return ret;
}
function stackEnableConfig(flag)
{
if(flag)
{
return ret ="<stack>enable</stack>";
}
else
{
return ret ="<undo>stack enable</undo>";
}
}
function stackResVlanConfig(resVlan)
{
return ret ="<stack>reserved-vlan "+resVlan+"</stack>";
}
function CF_1360rConfig(flag,timer)
{
if(flag)
{
return ret ="<stack>timer mac-address switch-delay "+timer+"</stack>";
}
else
{
return ret ="<undo>stack timer mac-address switch-delay</undo>";
}
}
function stackUnitConfig(currUnit,newUnit)
{
return ret ="<stack>slot "+currUnit+" renumber "+newUnit+" </stack>";
}
function CF_1359Config(currUnit,pri)
{
return ret ="<stack>slot "+currUnit+" priority "+pri+" </stack>";
}
function getMacAuthSys()
{
return '<hwMacAuthenObjects position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwMacAuthenMIB">'
+'<hwMacAuthenGlobalEnable/>'
+'<hwMacAuthenDomain/>'
+'<hwMacAuthenModeUsername/>'
+'<hwMacAuthenPassword/>'
+'<hwMacAuthenUsername/>'
+'<hwMacAuthenTimerOfflineDetect/>'
+'<hwMacAuthenTimerQuiet/>'
+'<hwMacAuthenTimerServerTimeout/>'
+'<hwMacAuthenReauthInterval/>'
+'</hwMacAuthenObjects>';
}
function manAuthSysConfigEnableOrder(type)
{
if(0==type)
{
return "<mac-authen></mac-authen>";
}
else
{
return "<undo>mac-authen</undo>";
}
}
function macAuthSysDomainOrder(doman)
{
return "<mac-authen>domain "+doman+"</mac-authen>";
}
function undoMacAuthSysDomainOrder()
{
return "<undo>mac-authen domain</undo>";
}
function macAuthSysUserName(obj)
{
if(obj.type==0)
{
return "<mac-authen>username macaddress format "+obj.macAddType+"</mac-authen>";
}
else
{
if(obj.passWord != "")
{
return "<mac-authen>username fixed "+obj.userName+" password cipher "+obj.passWord+"</mac-authen>";
}
else
{
return "<mac-authen>username fixed "+obj.userName+"</mac-authen>";
}
}
}
function macAuthSysTimerOrder(obj)
{
return "<mac-authen>timer offline-detect "+obj.timeOffLine+"</mac-authen>"
+"<mac-authen>timer quiet-period "+obj.timeQuiet+"</mac-authen>"
+"<mac-authen>timer server-timeout "+obj.timeOut+"</mac-authen>"
+"<mac-authen>timer guest-vlan reauthenticate-period "+obj.reAuthInterval+"</mac-authen>";
}
function getMacAuthInterfaceOrder(parm,number,iName,i)
{
return ret='<hwMacAuthenCfgEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwMacAuthenMIB.hwMacAuthenObjects.hwMacAuthenCfgTable" '+tranParam(number,iName,i)+'>'
+'<hwMacAuthenPortIndex/>'
+'<hwMacAuthenPortEnable/>'
+'<hwMacAuthenGuestVlan/>'
+'<hwMacAuthenMaxUserNum/>'
+'</hwMacAuthenCfgEntry>';
}
function macAuthInterfaceEnableConfig(interfaceName)
{
return '<interface isview="true"><instance><name> '+interfaceName +'</name>'
+'<mac-authen></mac-authen>'
+'</instance></interface>';
}
function undoMacAuthInterfaceEnableConfig(interfaceName)
{
return '<interface isview="true"><instance><name> '+interfaceName +'</name>'
+'<undo>mac-authen</undo>'
+'</instance></interface>';
}
function macAuthInterfaceGuestVlanConfig(interfaceName,guestVlan)
{
return '<interface isview="true"><instance><name> '+interfaceName+'</name>'
+'<mac-authen>guest-vlan '+guestVlan+'</mac-authen>'
+'</instance></interface>';
}
function undoMacAuthInterfaceGuestVlanConfig(interfaceName)
{
return '<interface isview="true"><instance><name> '+interfaceName +'</name>'
+'<undo>mac-authen guest-vlan</undo>'
+'</instance></interface>';
}
function macAuthInterfaceMaxUserConfig(interfaceName,maxUser)
{
return '<interface isview="true"><instance><name> '+interfaceName+'</name>'
+'<mac-authen>max-user '+maxUser+'</mac-authen>'
+'</instance></interface>';
}
function undoMacAuthInterfaceMaxUserConfig(interfaceName,maxUser)
{
return '<interface isview="true"><instance><name> '+interfaceName+'</name>'
+'<undo>mac-authen max-user</undo>'
+'</instance></interface>';
}
function undomacAuthInterfaceConfig(interfaceName)
{
return '<interface isview="true"><instance><name> '+interfaceName +'</name>'
+'<undo>mac-authen</undo>'
+'<undo>mac-authen guest-vlan</undo>'
+'<undo>mac-authen max-user</undo>'
+'</instance></interface>';
}
function queryDomainName()
{
var ret = '<display>diffserv domain all | include domain </display>';
return ret;
}
function getDomainMapTable(name)
{
return '<diffserv> domain '+ name + '</diffserv>'+ '<display>this </display>';
}
function del8021pMap(domainName,id)
{
var ret = '<diffserv> domain '+ domainName + '</diffserv>'
+ '<undo> 8021p-inbound '+ id +  '</undo>';
return ret;
}
function deldscpMap(domainName,id)
{
var ret = '<diffserv> domain '+ domainName + '</diffserv>'
+ '<undo> ip-dscp-inbound '+ id +  '</undo>';
return ret;
}
function deldscpMapOutbound(domainName,id)
{
var ret = '<diffserv> domain '+ domainName + '</diffserv>'
+ '<undo> ip-dscp-outbound '+ id +  '</undo>';
return ret;
}
function del8021pMapOutbound(domainName,id)
{
var ret = '<diffserv> domain '+ domainName + '</diffserv>'
+ '<undo> 8021p-outbound '+ id +  '</undo>';
return ret;
}
function setQosMapTable_Inbound(domainName,confiType,input,cprotocol,cprotocol_)
{
if("8021p-inbound"==confiType)
{
confiType = "N___8021p-inbound" ;
}
return '<diffserv isview="true">'
+'<instance>'
+'<name>domain  ' + domainName +'  </name>'
+'<'+ confiType+ '>' + input + ' phb ' + cprotocol + ' ' +cprotocol_ +'</'+ confiType+ '>'
+'</instance>'
+'</diffserv>';
}
function setQosMapTable_Outbound(domainName,confiType,input,cprotocol,cprotocol_)
{
if("8021p-outbound"==confiType)
{
confiType = "N___8021p-outbound" ;
}
return '<diffserv isview="true">'
+'<instance>'
+'<name>domain ' + domainName +' </name>'
+'<'+ confiType+ '>' + cprotocol + ' ' + cprotocol_ + ' map ' +input +'</'+ confiType+ '>'
+'</instance>'
+'</diffserv>';
}
function delDomainNameFun(name)
{
var ret = '<undo> diffserv domain '+ name +  '</undo>';
return ret;
}
function getQosClassifierInfoOrder()
{
return "<display>current-configuration configuration classifier</display>";
}
function delQosClassRule(obj)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>classifier '+obj.className+'</name>'
+'<undo>if-match '+obj.ruleName+'</undo>'
+'</instance>'
+'</traffic>';
}
function delQosClass(className)
{
return "<undo>traffic classifier "+className+"</undo>";
}
function addQosClassOrder(obj)
{
return "<traffic>classifier "+obj.className+" operator "+obj.oper+"</traffic>";
}
function addQosClassRule(className,value)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>classifier '+className+'</name>'
+'<if-match>'+value+'</if-match>'
+'</instance>'
+'</traffic>';
}
function getQosBehaviorInfoOrder()
{
return "<display>current-configuration configuration behavior</display>";
}
function delQosBehavOrder(name)
{
return "<undo>traffic behavior "+name+"</undo>";
}
function addQosBehavOrder(obj)
{
return "<traffic>behavior "+obj.name+"</traffic>";
}
function addQosBehavOrderAction(obj)
{
return "<traffic>behavior "+obj.name+"</traffic>"
+"<"+obj.action+"></"+obj.action+">";
}
function addTraffic_filter_intface(portName,way,aclNum,ipType)
{
var ret = '<interface isview="true"><instance>';
ret += '<name>'+portName+'</name>'
+'<traffic-filter>'+way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum+'</traffic-filter>';
}
else
{
ret += ' acl '+aclNum+'</traffic-filter>';
}
ret += '</instance></interface>';
return ret;
}
function addTraffic_filter_global(vlan,way,aclNum,ipType)
{
var ret = '<traffic-filter>';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum+'</traffic-filter>';
}
else
{
ret += ' acl '+aclNum+'</traffic-filter>';
}
return ret;
}
function addTraffic_statistic_intface(portName,way,aclNum,ipType)
{
var ret = '<interface isview="true"><instance>';
ret += '<name>'+portName+'</name>'
+'<traffic-statistic>'+way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum+'</traffic-statistic>';
}
else
{
ret += ' acl '+aclNum+'</traffic-statistic>';
}
ret += '</instance></interface>';
return ret;
}
function addTraffic_statistic_global(vlan,way,aclNum,ipType)
{
var ret = '<traffic-statistic>';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum+'</traffic-statistic>';
}
else
{
ret += ' acl '+aclNum+'</traffic-statistic>';
}
return ret;
}
function addTraffic_limit_intface_inbound(portName,way,aclNum,
cir,pir,cbs,pbs,greenAction,greenDSCP,yellowAction,yellowDSCP,redAction,redDSCP,ipType)
{
var ret = '<interface isview="true"><instance>';
ret += '<name>'+portName+'</name>'
+'<traffic-limit>'+way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
if(cir != "")
{
ret += ' cir ' + cir + ' ';
}
if(pir != "")
{
ret += ' pir ' + pir + ' ';
}
if(cbs != "")
{
ret += ' cbs ' + cbs + ' ';
}
if(pbs != "")
{
ret += ' pbs ' + pbs + ' ';
}
if(greenAction == "pass")
{
ret += ' green ' + greenAction + ' ';
if(greenDSCP != "" && greenDSCP != "undefined")
{
ret += ' remark-dscp  ' + greenDSCP + ' ';
}
}
else
{
ret += ' green drop ';
}
if(yellowAction == "pass")
{
ret += ' yellow ' + yellowAction + ' ';
if(yellowDSCP != "" && yellowDSCP != "undefined")
{
ret += ' remark-dscp  ' + yellowDSCP + ' ';
}
}
else
{
ret += ' yellow drop ';
}
if(redAction == "pass")
{
ret += ' red ' + redAction + ' ';
if(redDSCP != "" && redDSCP != "undefined")
{
ret += ' remark-dscp  ' + redDSCP + ' ';
}
}
else
{
ret += ' red drop ';
}
ret	+='</traffic-limit>'
+ '</instance></interface>';
return ret;
}
function addTraffic_limit_intface_outbound(portName,way,aclNum,
cir,pir,cbs,pbs,greenAction,greenType,green8021p,greenDSCP,
yellowAction,yellowType,yellow8021p,yellowDSCP,
redAction,redType,red8021p,redDSCP,ipType)
{
var ret = '<interface isview="true"><instance>';
ret += '<name>'+portName+'</name>'
+'<traffic-limit>'+way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
if(cir != "")
{
ret += ' cir ' + cir + ' ';
}
if(pir != "")
{
ret += ' pir ' + pir + ' ';
}
if(cbs != "")
{
ret += ' cbs ' + cbs + ' ';
}
if(pbs != "")
{
ret += ' pbs ' + pbs + ' ';
}
if(greenAction == "pass")
{
ret += ' green ' + greenAction + ' ';
if(greenDSCP != "" && greenDSCP != "undefined" && greenType == "1")
{
ret += ' remark-dscp  ' + greenDSCP + ' ';
}
else if(green8021p != "" && green8021p != "undefined" && greenType == "0")
{
ret += ' remark-8021p  ' + green8021p + ' ';
}
}
else
{
ret += ' green drop ';
}
if(yellowAction == "pass")
{
ret += ' yellow ' + yellowAction + ' ';
if(yellowDSCP != "" && yellowDSCP != "undefined" && yellowType == "1")
{
ret += ' remark-dscp  ' + yellowDSCP + ' ';
}
else if(yellow8021p != "" && yellow8021p != "undefined"	&& yellowType == "0")
{
ret += ' remark-8021p  ' + yellow8021p + ' ';
}
}
else
{
ret += ' yellow drop ';
}
if(redAction == "pass")
{
ret += ' red ' + redAction + ' ';
if(redDSCP != "" && redDSCP != "undefined" && redType == "1")
{
ret += ' remark-dscp  ' + redDSCP + ' ';
}
else if(red8021p != "" && red8021p != "undefined" && redType == "0")
{
ret += ' remark-8021p  ' + red8021p + ' ';
}
}
else
{
ret += ' red drop ';
}
ret	+='</traffic-limit>'
+ '</instance></interface>';
return ret;
}
function addTraffic_limit_global_inbound(vlan,way,aclNum,
cir,pir,cbs,pbs,greenAction,greenDSCP,yellowAction,yellowDSCP,redAction,redDSCP,ipType)
{
var ret = '<traffic-limit>';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
if(cir != "")
{
ret += ' cir ' + cir + ' ';
}
if(pir != "")
{
ret += ' pir ' + pir + ' ';
}
if(cbs != "")
{
ret += ' cbs ' + cbs + ' ';
}
if(pbs != "")
{
ret += ' pbs ' + pbs + ' ';
}
if(greenAction == "pass")
{
ret += ' green ' + greenAction + ' ';
if(greenDSCP != "" && greenDSCP != "undefined")
{
ret += ' remark-dscp  ' + greenDSCP + ' ';
}
}
else
{
ret += ' green drop ';
}
if(yellowAction == "pass")
{
ret += ' yellow ' + yellowAction + ' ';
if(yellowDSCP != "" && yellowDSCP != "undefined")
{
ret += ' remark-dscp  ' + yellowDSCP + ' ';
}
}
else
{
ret += ' yellow drop ';
}
if(redAction == "pass")
{
ret += ' red ' + redAction + ' ';
if(redDSCP != "" && redDSCP != "undefined")
{
ret += ' remark-dscp  ' + redDSCP + ' ';
}
}
else
{
ret += ' red drop ';
}
ret	+='</traffic-limit>';
return ret;
}
function addTraffic_limit_global_outbound(vlan,way,aclNum,
cir,pir,cbs,pbs,greenAction,greenType,green8021p,greenDSCP,
yellowAction,yellowType,yellow8021p,yellowDSCP
,redAction,redType,red8021p,redDSCP,ipType)
{
var ret = '<traffic-limit>';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
if(cir != "")
{
ret += ' cir ' + cir + ' ';
}
if(pir != "")
{
ret += ' pir ' + pir + ' ';
}
if(cbs != "")
{
ret += ' cbs ' + cbs + ' ';
}
if(pbs != "")
{
ret += ' pbs ' + pbs + ' ';
}
if(greenAction == "pass")
{
ret += ' green ' + greenAction + ' ';
if(greenDSCP != "" && greenDSCP != "undefined" && greenType == "1")
{
ret += ' remark-dscp  ' + greenDSCP + ' ';
}
else if(green8021p != "" && green8021p != "undefined" && greenType == "0")
{
ret += ' remark-8021p  ' + green8021p + ' ';
}
}
else
{
ret += ' green drop ';
}
if(yellowAction == "pass")
{
ret += ' yellow ' + yellowAction + ' ';
if(yellowDSCP != "" && yellowDSCP != "undefined" && yellowType == "1")
{
ret += ' remark-dscp  ' + yellowDSCP + ' ';
}
else if(yellow8021p != "" && yellow8021p != "undefined" && yellowType == "0")
{
ret += ' remark-8021p  ' + yellow8021p + ' ';
}
}
else
{
ret += ' yellow drop ';
}
if(redAction == "pass")
{
ret += ' red ' + redAction + ' ';
if(redDSCP != "" && redDSCP != "undefined" && redType == "1")
{
ret += ' remark-dscp  ' + redDSCP + ' ';
}
else if(red8021p != "" && red8021p != "undefined" && redType == "0")
{
ret += ' remark-8021p  ' + red8021p + ' ';
}
}
else
{
ret += ' red drop ';
}
ret	+='</traffic-limit>';
return ret;
}
function addTraffic_limit_intface_inbound_53SI(portName,way,aclNum,
cir,pir,cbs,pbs,
greenAction,greenType,green8021p,greenDSCP,
yellowAction,yellowType,yellow8021p,yellowDSCP,
redAction,redType,red8021p,redDSCP,ipType)
{
var ret = '<interface isview="true"><instance>';
ret += '<name>'+portName+'</name>'
+'<traffic-limit>'+way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
if(cir != "")
{
ret += ' cir ' + cir + ' ';
}
if(pir != "")
{
ret += ' pir ' + pir + ' ';
}
if(cbs != "")
{
ret += ' cbs ' + cbs + ' ';
}
if(pbs != "")
{
ret += ' pbs ' + pbs + ' ';
}
if(greenAction == "pass")
{
ret += ' green ' + greenAction + ' ';
if(-1!=SysOID.indexOf("S37")&&-1!=SysOID.indexOf("SI"))
{
if(greenDSCP != "" && greenDSCP != "undefined" && greenType == "1")
{
ret += ' remark-dscp  ' + greenDSCP + ' ';
}
else if(green8021p != "" && green8021p != "undefined" && greenType == "0")
{
ret += ' remark-8021p  ' + green8021p + ' ';
}
}
}
if(yellowAction == "pass")
{
ret += ' yellow ' + yellowAction + ' ';
if(yellowDSCP != "" && yellowDSCP != "undefined" && yellowType == "1")
{
ret += ' remark-dscp  ' + yellowDSCP + ' ';
}
else if(yellow8021p != "" && yellow8021p != "undefined" && yellowType == "0")
{
ret += ' remark-8021p  ' + yellow8021p + ' ';
}
}
else
{
ret += ' yellow drop ';
}
if(redAction == "pass")
{
ret += ' red ' + redAction + ' ';
if(redDSCP != "" && redDSCP != "undefined" && redType == "1")
{
ret += ' remark-dscp  ' + redDSCP + ' ';
}
else if(red8021p != "" && red8021p != "undefined" && redType == "0")
{
ret += ' remark-8021p  ' + red8021p + ' ';
}
}
else
{
ret += ' red drop ';
}
ret	+='</traffic-limit>'
+ '</instance></interface>';
return ret;
}
function addTraffic_limit_intface_outbound_53SI(portName,way,aclNum,
cir,pir,cbs,pbs,greenAction,yellowAction,redAction,ipType)
{
var ret = '<interface isview="true"><instance>';
ret += '<name>'+portName+'</name>'
+'<traffic-limit>'+way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
if(cir != "")
{
ret += ' cir ' + cir + ' ';
}
if(pir != "")
{
ret += ' pir ' + pir + ' ';
}
if(cbs != "")
{
ret += ' cbs ' + cbs + ' ';
}
if(pbs != "")
{
ret += ' pbs ' + pbs + ' ';
}
if(greenAction == "pass")
{
ret += ' green ' + greenAction + ' ';
}
if(yellowAction == "pass")
{
ret += ' yellow ' + yellowAction + ' ';
}
if(redAction == "pass")
{
ret += ' red ' + redAction + ' ';
}
else
{
ret += ' red drop ';
}
ret	+='</traffic-limit>'
+ '</instance></interface>';
return ret;
}
function addTraffic_limit_global_inbound_53SI(vlan,way,aclNum,
cir,pir,cbs,pbs,greenAction,
yellowAction,yellowDSCP,yellow8021p,yellowDSCP,
redAction,redType,red8021p,redDSCP,ipType)
{
var ret = '<traffic-limit>';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
if(cir != "")
{
ret += ' cir ' + cir + ' ';
}
if(pir != "")
{
ret += ' pir ' + pir + ' ';
}
if(cbs != "")
{
ret += ' cbs ' + cbs + ' ';
}
if(pbs != "")
{
ret += ' pbs ' + pbs + ' ';
}
if(greenAction == "pass")
{
ret += ' green ' + greenAction + ' ';
}
if(yellowAction == "pass")
{
ret += ' yellow ' + yellowAction + ' ';
if(yellowDSCP != "" && yellowDSCP != "undefined")
{
ret += ' remark-dscp  ' + yellowDSCP + ' ';
}
else if(yellow8021p != "" && yellow8021p != "undefined")
{
ret += ' remark-8021p  ' + yellow8021p + ' ';
}
}
else
{
ret += ' yellow drop ';
}
if(redAction == "pass")
{
ret += ' red ' + redAction + ' ';
if(redDSCP != "" && redDSCP != "undefined")
{
ret += ' remark-dscp  ' + redDSCP + ' ';
}
else if(red8021p != "" && red8021p != "undefined")
{
ret += ' remark-8021p  ' + red8021p + ' ';
}
}
else
{
ret += ' red drop ';
}
ret	+='</traffic-limit>';
return ret;
}
function addTraffic_limit_global_outbound_53SI(vlan,way,aclNum,
cir,pir,cbs,pbs,greenAction,yellowAction,redAction,ipType)
{
var ret = '<traffic-limit>';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
if(cir != "")
{
ret += ' cir ' + cir + ' ';
}
if(pir != "")
{
ret += ' pir ' + pir + ' ';
}
if(cbs != "")
{
ret += ' cbs ' + cbs + ' ';
}
if(pbs != "")
{
ret += ' pbs ' + pbs + ' ';
}
if(greenAction == "pass")
{
ret += ' green ' + greenAction + ' ';
}
if(yellowAction == "pass")
{
ret += ' yellow ' + yellowAction + ' ';
}
if(redAction == "pass")
{
ret += ' red ' + redAction + ' ';
}
else
{
ret += ' red drop ';
}
ret	+='</traffic-limit>';
return ret;
}
function addTraffic_cliujingxiang_intface(portName,way,aclNum,observe,ipType)
{
var ret = '<interface isview="true"><instance>';
ret += '<name>'+portName+'</name>'
+'<traffic-mirror>'+way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' to observe-port ' + observe + '</traffic-mirror>'
+ '</instance></interface>';
return ret;
}
function addTraffic_cliujingxiang_global(vlan,portName,way,aclNum,observe,ipType)
{
var ret = '<traffic-mirror>';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' to observe-port ' + observe +'</traffic-mirror>';
return ret;
}
function addTraffic_cchongbiaoji_intface(portName,way,aclNum,name_,value_,ipType)
{
var ret = '<interface isview="true"><instance>';
ret += '<name>'+portName+'</name>'
+'<traffic-remark >'+way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret +=' ' + name_ + ' ' + value_ + '</traffic-remark >'
+ '</instance></interface>';
return ret;
}
function addTraffic_cchongbiaoji_global(vlan,way,aclNum,name_,value_,ipType)
{
var ret = '<traffic-remark>';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' ' + name_ + ' ' + value_ +'</traffic-remark>';
return ret;
}
function addTraffic_cchongdingxiang_intface(portName,way,aclNum,name_,value_,ipType)
{
var ret = '<interface isview="true"><instance>';
ret += '<name>'+portName+'</name>'
+'<traffic-redirect >'+way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret += ' ' + name_ + ' ' + value_ + '</traffic-redirect >'
+ '</instance></interface>';
return ret;
}
function addTraffic_cchongdingxiang_global(vlan,way,aclNum,name_,value_,ipType)
{
var ret = '<traffic-redirect>';
if(vlan != "")
{
ret += ' vlan ' + vlan + ' ';
}
ret += way;
if(ipType == "IPv6")
{
ret += ' acl ipv6 '+aclNum;
}
else
{
ret += ' acl '+aclNum;
}
ret +=' ' + name_ + ' ' + value_ + '</traffic-redirect>';
return ret;
}
function addQosBehavCarOrder(behavObj,deviceType)
{
var car = "cir " +behavObj.cir;
if(null!=behavObj.pir&&""!=behavObj.pir)
{
car = car+" pir "+behavObj.pir;
}
if(null!=behavObj.cbs&&""!=behavObj.cbs)
{
car = car + " cbs "+behavObj.cbs;
}
if(null!=behavObj.pbs&&""!=behavObj.pbs)
{
car = car + " pbs "+behavObj.pbs;
}
if("discard"==behavObj.greenAction)
{
car = car + " green discard ";
}
else if(null!=behavObj.greenAction)
{
car = car + " green pass ";
if(behavObj.green8021p&&""!=behavObj.green8021p)
{
car = car + " remark-8021p "+behavObj.green8021p;
}
else if(behavObj.greenDSCP&&""!=behavObj.greenDSCP)
{
car = car + " remark-dscp "+behavObj.greenDSCP;
}
}
if("discard"==behavObj.yellowAction)
{
car = car + " yellow discard ";
}
else if(null!=behavObj.yellowAction)
{
car = car + " yellow pass ";
if(behavObj.yellow8021p&&""!=behavObj.yellow8021p)
{
car = car + " remark-8021p "+behavObj.yellow8021p;
}
else if(behavObj.yellowDSCP&&""!=behavObj.yellowDSCP)
{
car = car + " remark-dscp "+behavObj.yellowDSCP;
}
}
if("discard"==behavObj.redAction)
{
car = car + " red discard ";
}
else if(null!=behavObj.redAction)
{
car = car + " red pass ";
if(behavObj.red8021p&&""!=behavObj.red8021p)
{
car = car + " remark-8021p "+behavObj.red8021p;
}
else if(behavObj.redDSCP&&""!=behavObj.redDSCP)
{
car = car + " remark-dscp "+behavObj.redDSCP;
}
}
return '<traffic isview="true">'
+'<instance>'
+'<name>behavior '+behavObj.name+'</name>'
+'<car>'+car+'</car>'
+'</instance>'
+'</traffic>';
}
function delQosBehavCarOrder(behavObj)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>behavior '+behavObj.name+'</name>'
+'<undo>car</undo>'
+'</instance>'
+'</traffic>';
}
function addQosBehavRemark802POrder(tempObj)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>behavior '+tempObj.name+'</name>'
+'<remark> 8021p '+tempObj._8021p +'</remark>'
+'</instance>'
+'</traffic>';
}
function addQosBehavRemarkDscpOrder(tempObj)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>behavior '+tempObj.name+'</name>'
+'<remark>dscp '+tempObj.dscp +'</remark>'
+'</instance>'
+'</traffic>';
}
function addQosBehavRemarLocalOrder(tempObj)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>behavior '+tempObj.name+'</name>'
+'<remark>local-precedence '+tempObj.local +'</remark>'
+'</instance>'
+'</traffic>';
}
function addQosBehavRemarkDestMacOrder(tempObj)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>behavior '+tempObj.name+'</name>'
+'<remark>destination-mac '+tempObj.destMac +'</remark>'
+'</instance>'
+'</traffic>';
}
function addQosBehavRemarkVlanOrder(tempObj)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>behavior '+tempObj.name+'</name>'
+'<remark>vlan-id '+tempObj.vlanID +'</remark>'
+'</instance>'
+'</traffic>';
}
function addQosBehavRemarkCVlanOrder(tempObj)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>behavior '+tempObj.name+'</name>'
+'<remark>cvlan-id '+tempObj.cvlanID +'</remark>'
+'</instance>'
+'</traffic>';
}
function delQosBehavRemarkOrder(behavObjName,remark)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>behavior '+behavObjName+'</name>'
+'<undo>remark '+remark+'</undo>'
+'</instance>'
+'</traffic>';
}
function addQosBehavCountOrder(name)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>behavior '+name+'</name>'
+'<statistic>enable</statistic>'
+'</instance>'
+'</traffic>';
}
function delQosBehavCountOrder(behavObj)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>behavior '+behavObj.name+'</name>'
+'<undo>statistic enable</undo>'
+'</instance>'
+'</traffic>';
}
function setObservePort(portIndex,interfaceNum)
{
return "<observe-port> "+portIndex+" interface "+interfaceNum+"</observe-port>";
}
function delObservePort(portIndex)
{
return "<undo>observe-port "+portIndex+"</undo>";
}
function getObservePortOrder()
{
return "<display>observe-port</display>";
}
function addQosBehavMirrorOrder(tempObj)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>behavior '+tempObj.name+'</name>'
+'<mirroring>to observe-port '+tempObj.index+'</mirroring>'
+'</instance>'
+'</traffic>';
}
function delQosBehavMirrorOrder(tempObj)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>behavior '+tempObj.name+'</name>'
+'<undo>mirroring</undo>'
+'</instance>'
+'</traffic>';
}
function addQosBehavRedirect(tempObj,device)
{
var redirect = "";
if(tempObj.redirectInter)
{
redirect = "<redirect>interface "+tempObj.redirectInter+"</redirect>";
}
if(tempObj.redirectNexIP)
{
redirect = redirect+"<redirect>ip-nexthop "+tempObj.redirectNexIP+"</redirect>";
}
if(tempObj.cpu)
{
redirect = "<redirect> "+tempObj.cpu+"</redirect>";
}
if(""!=redirect)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>behavior '+tempObj.name+'</name>'
+redirect
+'</instance>'
+'</traffic>';
}
else
{
return "";
}
}
function delQosBehavRedirect(behavObj)
{
return '<traffic isview="true">'
+'<instance>'
+'<name>behavior '+behavObj.name+'</name>'
+'<undo>redirect</undo>'
+'</instance>'
+'</traffic>';
}
function getQosPolicyOrder()
{
return "<display>current-configuration configuration trafficpolicy</display>";
}
function getQosClassName()
{
return "<display>current-configuration configuration | include traffic classifier</display>";
}
function getQosBehavName()
{
return "<display>current-configuration configuration | include traffic behavior</display>";
}
function getQosPolicyName()
{
return "<display>current-configuration configuration | include traffic policy</display>";
}
function addQosPolicy(qosPolicy)
{
var classBehav =qosPolicy.classBehav ;
var ret="<traffic>policy "+qosPolicy.name+"</traffic>";
for(var i=0;i<classBehav.length;i++)
{
var tempPolicy = classBehav[i].split("?");
ret = ret+"<classifier>"+tempPolicy[0]+" behavior "+tempPolicy[1]+"</classifier>";
}
return ret;
}
function delQosPolicy(policyName)
{
return "<undo>traffic policy "+policyName+"</undo>";
}
function modQosPolicy(qosPolicy)
{
var ret = '<traffic isview="true"><instance>'
+'<name>policy '+qosPolicy.name+'</name>';
var undoPolicy = qosPolicy.undoClassPolicy;
for(var i=0;i<undoPolicy.length;i++)
{
ret = ret+'<undo>classifier '+transitionChar(undoPolicy[i],0)+'</undo>';
}
modPolicy = qosPolicy.modClassPolicy;;
for(i=0;i<modPolicy.length;i++)
{
var tempPolicy = modPolicy[i].split("?");
ret = ret+'<classifier> '+tempPolicy[0]+' behavior '+tempPolicy[1]+'</classifier>';
}
return ret=ret+'</instance>'
+'</traffic>';
}
function getQosMapTable()
{
return "<display>qos map-table</display>";
}
function setQosMapTable(mapTaype,input,output)
{
return '<qos isview="true"><instance>'
+'<name>map-table '+mapTaype+'</name>'
+'<input>'+input+' output '+output+'</input>'
+'</instance></qos>';
}
function getTraffPolic(portName)
{
return "<display>current-configuration interface "+portName+" | include traffic-policy</display>";
}
function getTraffPolicSystem()
{
return "<display>current-configuration configuration | include traffic-policy</display>";
}
function usePolicyOrder(policyName,vlanOrInter,bound,type)
{
if("0"==type)
{
return '<interface isview="true"><instance>'
+'<name>'+vlanOrInter+'</name>'
+'<traffic-policy>'+policyName+' '+bound+'</traffic-policy>'
+'</instance></interface>';
}
else if("1"==type)
{
return '<vlan isview="true"><instance>'
+'<name>'+vlanOrInter+'</name>'
+'<traffic-policy>'+policyName+' '+bound+'</traffic-policy>'
+'</instance></vlan>';
}
else
{
return '<traffic-policy>'+policyName+' global '+bound+'</traffic-policy>';
}
}
function delQosPolicyOrder(interName)
{
var tempDelPolicy = interName.split("?");
if("global"==tempDelPolicy[0])
{
return '<undo>traffic-policy global '+tempDelPolicy[1]+'</undo>';
}
if(tempDelPolicy[2])
{
return '<vlan isview="true"><instance>'
+'<name>'+tempDelPolicy[0]+'</name>'
+'<undo>traffic-policy '+tempDelPolicy[2]+'</undo>'
+'</instance></vlan>';
}
else
{
return '<interface isview="true"><instance>'
+'<name>'+tempDelPolicy[0]+'</name>'
+'<undo>traffic-policy '+tempDelPolicy[1]+'</undo>'
+'</instance></interface>';
}
}
function getVlanApplyPolicyOrder(parame,number,iName,i)
{
return '<hwCBQoSVlanApplyPolicyEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwQoS.hwCBQoSMIB.hwCBQoSObjects.hwCBQoSApplyPolicyObjects.hwCBQoSVlanApplyPolicyTable" '+tranParam(number,iName,i)+'>'
+'<hwCBQoSVlanApplyPolicyVlanId>'+parame+'</hwCBQoSVlanApplyPolicyVlanId>'
+'<hwCBQoSVlanApplyPolicyName/>'
+'<hwCBQoSVlanApplyPolicyDirection/>'
+'</hwCBQoSVlanApplyPolicyEntry>';
}
function getInterfaceLimit(portName)
{
return "<display>current-configuration interface "+portName+" | include qos lr</display>";
}
function getInterfaceQosQueue(portName)
{
return "<display>current-configuration interface "+portName+" | include qos queue</display>";
}
function getInterfaceQosPq(portName)
{
return "<display>current-configuration interface "+portName+" | include qos</display>";
}
function setInterfaceQosPq(portName,attempType,drrOrWrr)
{
return '<interface isview="true"><instance>'
+'<name>'+portName+'</name>'
+'<qos> '+attempType+drrOrWrr+'</qos>'
+'</instance></interface>';
}
function setInterfaceQosWeight(portName,drrOrWrr,queueWeight)
{
var weight ="";
for(var i=0;i<queueWeight.length;i++)
{
weight+='<qos>queue '+queueWeight[i][0]+' '+drrOrWrr+' weight '+queueWeight[i][1]+'</qos>';
}
return '<interface isview="true"><instance>'
+'<name>'+portName+'</name>'
+weight
+'</instance></interface>';
}
function setInterfaceLimit(limitinterName,limitcir,limitcbs,limitbound)
{
var qoslrcmd="";
if(""!=limitcbs)
{
qoslrcmd=" cbs "+limitcbs;
}
return  '<interface isview="true"><instance>'
+'<name>'+limitinterName+'</name>'
+'<qos>lr '+limitbound+' cir '+limitcir+qoslrcmd+'</qos>'
+'</instance></interface>';
}
function delInterfaceLimit(interName,bound)
{
return '<interface isview="true"><instance>'
+'<name>'+interName+'</name>'
+'<undo>qos lr '+bound+'</undo>'
+'</instance></interface>';
}
function setInterfaceQosQueue(deviceType,interfaceName,queueIndex,cir,pir)
{
var _qosQueue="pir";
var SysOID = parent.parent.M("SysOID").value;
if(-1!=SysOID.indexOf("S23")&&!is2352EI(SysOID))
{
_qosQueue="cbs";
}
return '<interface isview="true"><instance>'
+'<name>'+interfaceName+'</name>'
+'<qos>queue '+queueIndex+' shaping cir '+cir+' '+_qosQueue+' '+pir+'</qos>'
+'</instance></interface>';
}
function delInterfaceQosQueue(deviceType,interName,queueIndex)
{
return '<interface isview="true"><instance>'
+'<name>'+interName+'</name>'
+'<undo>qos queue '+queueIndex+' shaping </undo>'
+'</instance></interface>';
}
function confiQosLocalPreQueue(localPre,queueIndex)
{
return "<qos>local-precedence-queue-map "+localPre+" "+queueIndex+"</qos>";
}
function getQosLocalPreQueue()
{
return "<display>qos local-precedence-queue-map</display>";
}
function getQosInterfaceTrust(portName)
{
return "<display>current-configuration interface "+portName+" </display>";
}
function addQosInterfaceTrust(portName,trustType)
{
return  '<interface isview="true"><instance>'
+'<name>'+portName+'</name>'
+'<trust>'+trustType+'</trust>'
+'</instance></interface>';
}
function delQosInterfaceTrust(portName,trustType)
{
return  '<interface isview="true"><instance>'
+'<name>'+portName+'</name>'
+'<undo>trust '+trustType+'</undo>'
+'</instance></interface>';
}
function addQosITrust(portName,trustType,domainName,enable)
{
var bvalue = '<interface isview="true"><instance>'
+'<name>'+portName+'</name>';
if("8021p-inner"==trustType)
{
bvalue+='<trust> 8021p inner</trust>';
}
else if("8021p-outer"==trustType)
{
bvalue+='<trust> 8021p outer</trust>';
}
else if("dscp"==trustType)
{
bvalue+='<trust> dscp </trust>';
}
bvalue+='<trust> upstream '+domainName+'</trust>';
if("yes"==enable)
{
bvalue+='<qos> phb marking enable </qos>';
}
else
{
bvalue+='<undo>qos phb marking enable </undo>';
}
bvalue+='</instance></interface>';
return bvalue;
}
function delQosITrust(portName)
{
var bvalue='<interface isview="true"><instance>'
+'<name>'+portName+'</name>'
+'<undo>trust</undo>'
+'<undo>trust upstream</undo>'
bvalue+='</instance></interface>';
return bvalue;
}
function delQosITrustenable(portName)
{
var bvalue='<interface isview="true"><instance>'
+'<name>'+portName+'</name>'
+'<qos>phb marking enable </qos>'
+'</instance></interface>';
return bvalue;
}
function undoDiffName(portName)
{
var bvalue='<interface isview="true"><instance>'
+'<name>'+portName+'</name>'
+'<undo>trust upstream </undo>'
+'</instance></interface>';
return bvalue;
}
function getAAASchemeOrder()
{
return ret='<hwAuthenSchemeEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAaa.hwAAAMibObjects.hwAuthenSchemeTable">'
+'<hwAuthenSchemeName/>'
+'<hwAuthenMethod/>'
+'</hwAuthenSchemeEntry>'
+'<hwAuthorSchemeEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAaa.hwAAAMibObjects.hwAuthorSchemeTable">'
+'<hwAuthorSchemeName/>'
+'<hwAuthorMethod/>'
+'</hwAuthorSchemeEntry>'
+'<hwAcctSchemeEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAaa.hwAAAMibObjects.hwAcctSchemeTable">'
+'<hwAcctSchemeName/>'
+'<hwAccMethod/>'
+'</hwAcctSchemeEntry>';
}
function addAuthenSchemeName(authenName)
{
return  '<aaa></aaa>'
+'<authentication-scheme>'+transitionChar(authenName,0)+'</authentication-scheme>';
}
function addAuthenScheme(authenName,authMode)
{
return  '<aaa></aaa>'
+'<authentication-scheme>'+transitionChar(authenName,0)+'</authentication-scheme>'
+'<authentication-mode>'+authMode+'</authentication-mode>';
}
function delAuthenScheme(authenName)
{
return  '<aaa></aaa><undo>authentication-scheme '+transitionChar(authenName,0)+'</undo>';
}
function addAuthorSchemeName(authorName)
{
return  '<aaa></aaa>'
+'<authorization-scheme>'+transitionChar(authorName,0)+'</authorization-scheme>';
}
function addAuthorScheme(authorName,authorMode)
{
return  '<aaa></aaa>'
+'<authorization-scheme>'+transitionChar(authorName,0)+'</authorization-scheme>'
+'<authorization-mode>'+authorMode+'</authorization-mode>';
}
function delAuthorScheme(authorName)
{
return  '<aaa></aaa><undo>authorization-scheme '+transitionChar(authorName,0)+'</undo>';
}
function addAccSchemeSchemeName(accName)
{
return  '<aaa></aaa>'
+'<accounting-scheme>'+transitionChar(accName,0)+'</accounting-scheme>';
}
function addAccSchemeScheme(accName,accMode)
{
return  '<aaa></aaa>'
+'<accounting-scheme>'+transitionChar(accName,0)+'</accounting-scheme>'
+'<accounting-mode>'+accMode+'</accounting-mode>';
}
function delAccSchemeScheme(accName)
{
return  '<aaa></aaa><undo>accounting-scheme '+transitionChar(accName,0)+'</undo>';
}
function getServiceScheme()
{
return ret='<hwServiceSchemeEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAaa.hwAAAMibObjects.hwServiceSchemeTable">'
+'<hwServiceSchemeName/>'
+'<hwSrvSchemeAdminUserPriority/>'
+'<hwServiceSchemeDnsFirst/>'
+'<hwServiceSchemeDnsSecond/>'
+'</hwServiceSchemeEntry>';
}
function addServiceScheme(serviceScheme)
{
var ret = "<aaa></aaa><service-scheme>"+transitionChar(serviceScheme.name,0)+"</service-scheme>";
if("16"!=serviceScheme.adminLev )
{
ret =ret+"<adminuser-priority>"+serviceScheme.adminLev+"</adminuser-priority>";
}
if(""!=serviceScheme.dnsFirst)
{
ret =ret+"<dns>"+serviceScheme.dnsFirst+"</dns>";
if(""!=serviceScheme.dnsSec)
{
ret =ret+"<dns>"+serviceScheme.dnsSec+" secondary</dns>";
}
}
return ret;
}
function addServiceScheme1(serviceScheme)
{
var ret = "<aaa></aaa><service-scheme>"+transitionChar(serviceScheme.name,0)+"</service-scheme>";
return ret;
}
function modServiceScheme(serviceScheme)
{
var ret = "<aaa></aaa><service-scheme>"+transitionChar(serviceScheme.name,0)+"</service-scheme>";
if("16"!=serviceScheme.adminLev && serviceScheme.adminLev != "")
{
ret =ret+"<adminuser-priority>"+serviceScheme.adminLev+"</adminuser-priority>";
}
else
{
ret =ret+"<undo>admin-user privilege level</undo>";
}
ret =ret+"<undo>dns</undo>";
if(""!=serviceScheme.newDnsFirst)
{
ret =ret+"<dns>"+serviceScheme.newDnsFirst+"</dns>";
if(""!=serviceScheme.newDnsSec)
{
ret =ret+"<dns>"+serviceScheme.newDnsSec+" secondary</dns>";
}
}
return ret;
}
function getIPPool()
{
return "<display>current-configuration configuration ip-pool | include ip pool </display>";
}
function delServiceScheme(serivceSchemeName)
{
return "<aaa></aaa><undo>service-scheme "+transitionChar(serivceSchemeName,0)+"</undo>";
}
function getRadiusTemple()
{
return ret='<hwRadiusGroupEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwBRASMib.hwBRASRadius.hwRadiusGroupObject.hwRadiusGroupTable">'
+'<hwRadiusGroupName/>'
+'<hwRadiusServerKey/>'
+'</hwRadiusGroupEntry>';
}
function RadiusConfigAll()
{
return ret='<hwRadiusGroupEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwBRASMib.hwBRASRadius.hwRadiusGroupObject.hwRadiusGroupTable">'
+'<hwRadiusGroupName/>'
+'<hwRadiusServerKey/>'
+'</hwRadiusGroupEntry>'
+'<hwRadiusServerEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwBRASMib.hwBRASRadius.hwRadiusGroupObject.hwRadiusServerTable">'
+'<hwRadiusServerType/>'
+'<hwRadiusServerIP/>'
+'<hwRadiusServerPort/>'
+'<hwRadiusServerRowStatus/>'
+'</hwRadiusServerEntry>';
}
function delObservePort_(observeIndex)
{
ret = '<undo>observe-port '+ observeIndex +'</undo>';
return ret;
}
function getMirrorPort()
{
return "<display>mirror-port</display>";
}
function getBehaviorName()
{
return "<display>traffic behavior user-defined</display>";
}
function queryAclIntMIrr()
{
return "<display>traffic-applied interface inbound | include mir</display>";
}
function displayACLIntMirr(portName)
{
var ret = '<interface isview="true"><instance>';
ret += '<name>'+portName+'</name>'
+ '<display> th | include mirr</display>'
+ '</instance></interface>';
return ret;
}
function delIntMirr(portName,condi)
{
var ret = '<interface isview="true"><instance>';
ret += '<name>'+portName+'</name>'
+ '<undo>' + condi + '</undo>'
+ '</instance></interface>';
return ret;
}
function delGloMirr(aclName)
{
return '<undo> traffic-mirror inbound acl ' + aclName + '</undo>';
}
function delVlanMirr(vlanId,aclId)
{
return '<undo> traffic-mirror ' + vlanId + ' inbound acl ' + aclId +'</undo>';
}
function queryAclGloMirr()
{
return "<display>traffic-applied inbound | include ACL </display>";
}
function queryAclVlanGloMirr()
{
return "<display>traffic-applied vlan inbound | include ACL </display>";
}
function getQosPolicyapplied(policyName)
{
return '<display> traffic-policy ' + policyName + ' applied-record </display>';
}
function delIntVlanSystem(intName,way)
{
if("system"==intName)
{
return '<undo>traffic-policy global '+ way +'</undo>';
}
else if(intName.indexOf("Ethernet") > -1 || intName.indexOf("Eth-Trunk") > -1)
{
return '<interface isview="true"><instance>'
+'<name>' + intName + '</name>'
+'<undo>traffic-policy ' + way + '</undo>'
+'</instance></interface>';
}
else
{
return '<vlan isview="true"><instance>'
+'<name>' + intName + '</name>'
+'<undo>traffic-policy ' + way + '</undo>'
+'</instance></vlan>';
}
}
function getUserStaticBind()
{
return "<display>user-bind all</display>"
}
function getUserStaticBindIpv4()
{
return "<display>dhcp static user-bind all </display>"
}
function getUserStaticBindIpv6()
{
return "<display>dhcpv6 static user-bind all </display>"
}
function enableUserStaticBind(portName)
{
var ret = '<interface isview="true"><instance>';
ret += '<name>'+portName+'</name>'
+ '<ip> source check user-bind enable</ip>'
+ '</instance></interface>';
return ret;
}
function undoUserStaticBind(portName)
{
var ret = '<interface isview="true"><instance>';
ret += '<name>'+portName+'</name>'
+ '<undo> ip source check user-bind enable</undo>'
+ '</instance></interface>';
return ret;
}
function delUserStateBind(portName,mac,ip,vlan)
{
var ret = '<undo>user-bind static ';
if(ip != "")
{
if(ip.indexOf(":") > -1)
{
ret += ' ipv6-address '+ ip;
}
else if(ip.indexOf(".") > -1)
{
ret += ' ip-address '+ ip;
}
}
if(mac != "")
{
ret += ' mac-address '+ mac;
if(vlan != "")
{
ret +=' vlan ' + vlan;
}
}
ret += '</undo>';
return ret;
}
function addUserStaticBindMAC_PORT(portName,vlan,mac1)
{
var ret = '<user-bind>static mac-address '+ mac1 + ' interface ' + portName;
if(vlan != "")
{
ret += ' vlan ' + vlan;
}
ret+='</user-bind>';
return ret;
}
function addUserStaticBindIPv4_PORT(portName,vlan,mac1,ipv4)
{
var ret = '<user-bind>static ip-address '+ ipv4 ;
if(mac1 != "")
{
ret += ' mac-address ' + mac1;
}
ret += ' interface ' + portName;
if(vlan != "")
{
ret += ' vlan ' + vlan;
}
ret+='</user-bind>';
return ret;
}
function addUserStaticBindIPv6_PORT(portName,vlan,mac1,ipv6)
{
var ret = '<user-bind>static ipv6-address  '+ ipv6 ;
if(mac1 != "")
{
ret += ' mac-address ' + mac1;
}
ret += ' interface ' + portName;
if(vlan != "")
{
ret += ' vlan ' + vlan;
}
ret+='</user-bind>';
return ret;
}
function addRadiusTemplName(radiusTempName)
{
return "<radius-server>template "+transitionChar(radiusTempName,0)+"</radius-server>";
}
function addRadiusTempl(radiusTempName,radiusTempKey)
{
var ret = "<radius-server>template "+transitionChar(radiusTempName,0)+"</radius-server>";
if(""!=radiusTempKey)
{
ret = ret+"<radius-server>shared-key  cipher "+transitionChar(radiusTempKey,0)+"</radius-server>";
}
return ret;
}
function delRadiusTempl(radiusTempName)
{
return "<undo>radius-server template "+transitionChar(radiusTempName,0)+"</undo>";
}
function getRadiusAuthenAccService()
{
return ret='<hwRadiusServerEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwBRASMib.hwBRASRadius.hwRadiusGroupObject.hwRadiusServerTable">'
+'<hwRadiusServerType/>'
+'<hwRadiusServerIP/>'
+'<hwRadiusServerPort/>'
+'<hwRadiusServerRowStatus/>'
+'</hwRadiusServerEntry>';
}
function addRadiusAuthenAccService(rediusServiceObj)
{
var ret = '<radius-server isview="true"><instance><name>template '+transitionChar(rediusServiceObj.templName,0)+'</name>';
var raidiusServerOpType ="";
if("1"==rediusServiceObj.type)
{
raidiusServerOpType = "authentication";
}
else
{
raidiusServerOpType = "accounting";
}
if(""!=rediusServiceObj.ip)
{
ret+="<radius-server>"+raidiusServerOpType+" "+rediusServiceObj.ip+" "+rediusServiceObj.port+"</radius-server>";
}
if(""!=rediusServiceObj.secip)
{
ret+="<radius-server>"+raidiusServerOpType+" "+rediusServiceObj.secip+" "+rediusServiceObj.secport+" secondary</radius-server>";
}
ret+="</instance></radius-server>";
return ret;
}
function modRadiusAuthenAccService(rediusServiceObj)
{
var ret = '<radius-server isview="true"><instance><name>template '+transitionChar(rediusServiceObj.templName,0)+'</name>';
var raidiusServerOpType ="";
if("1"==rediusServiceObj.type)
{
raidiusServerOpType = "authentication";
}
else
{
raidiusServerOpType = "accounting";
}
if(rediusServiceObj.havOldFirstServer)
{
ret+="<undo>radius-server "+raidiusServerOpType+"</undo>";
}
if(rediusServiceObj.havOldSecServer)
{
ret+="<undo>radius-server "+raidiusServerOpType+" secondary</undo>";
}
if(""!=rediusServiceObj.ip)
{
ret+="<radius-server>"+raidiusServerOpType+" "+rediusServiceObj.ip+" "+rediusServiceObj.port+"</radius-server>";
}
if(""!=rediusServiceObj.secip)
{
ret+="<radius-server>"+raidiusServerOpType+" "+rediusServiceObj.secip+" "+rediusServiceObj.secport+" secondary</radius-server>";
}
ret+="</instance></radius-server>";
return ret;
}
function delRadiusAuthenAccService(templName,type,isFirstFlag,isSecFlag)
{
var ret = '<radius-server isview="true"><instance><name>template '+transitionChar(templName,0)+'</name>';
if("1"==type)
{
if(""!=isFirstFlag)
{
ret+="<undo>radius-server authentication</undo>";
}
if(""!=isSecFlag)
{
ret+="<undo>radius-server authentication secondary</undo>";
}
}
else
{
if(""!=isFirstFlag)
{
ret+="<undo>radius-server accounting</undo>";
}
if(""!=isSecFlag)
{
ret+="<undo>radius-server accounting secondary</undo>";
}
}
ret+="</instance></radius-server>";
return ret;
}
function getRadiusAuthorService()
{
return "<display>current-configuration configuration | include radius-server authorization</display>";
}
function addRadiusAuthorService(ipAdd,serverName,shareKey,interval)
{
var ret= "<radius-server>authorization "+ipAdd;
if(""!=serverName)
{
ret+=" server-group "+transitionChar(serverName,0);
}
ret+=" shared-key cipher "+transitionChar(shareKey,0)
+" ack-reserved-interval "+interval
+"</radius-server>";
return ret;
}
function delRadiusAuthorService(ipAdd)
{
return "<undo> radius-server authorization "+ipAdd+" </undo>";
}
function getDomain()
{
return ret='<hwDomainEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAaa.hwAAAMibObjects.hwDomainTable">'
+'<hwDomainName/>'
+'<hwDomainAuthenSchemeName/>'
+'<hwDomainAcctSchemeName/>'
+'<hwDomainServiceSchemeName/>'
+'<hwDomainRadiusGroupName/>'
+'</hwDomainEntry>'
+'<hwDomainExtEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAaa.hwAAAMibObjects.hwDomainExtTable">'
+'<hwDomainAuthorSchemeName/>'
+'</hwDomainExtEntry>';
}
function aaaDomainConfig(aaaDomain)
{
return "<aaa></aaa><domain>"+aaaDomain.name+"</domain>";
}
function undoAAADomain(aaaDomainName)
{
return "<aaa></aaa><undo>domain "+aaaDomainName+"</undo>";
}
function aaaDomainAuthenConfig(aaaDomain)
{
return "<aaa></aaa><domain>"+aaaDomain.name+"</domain>" +
"<authentication-scheme>"+aaaDomain.authenName+"</authentication-scheme>";
}
function undoAAADomainAuthenConfig(aaaDomain)
{
return "<aaa></aaa><domain>"+aaaDomain.name+"</domain>" +
"<undo>authentication-scheme</undo>";
}
function aaaDomainAuthorConfig(aaaDomain)
{
return "<aaa></aaa><domain>"+aaaDomain.name+"</domain>" +
"<authorization-scheme>"+aaaDomain.authorName+"</authorization-scheme>";
}
function undoAAADomainAuthorConfig(aaaDomain)
{
return "<aaa></aaa><domain>"+aaaDomain.name+"</domain>" +
"<undo>authorization-scheme</undo>";
}
function aaaDomainAccConfig(aaaDomain)
{
return "<aaa></aaa><domain>"+aaaDomain.name+"</domain>" +
"<accounting-scheme>"+aaaDomain.accName+"</accounting-scheme>";
}
function undoAAADomainAccConfig(aaaDomain)
{
return "<aaa></aaa><domain>"+aaaDomain.name+"</domain>" +
"<undo>accounting-scheme</undo>";
}
function aaaDomainRadiusConfig(aaaDomain)
{
return "<aaa></aaa><domain>"+aaaDomain.name+"</domain>" +
"<radius-server>"+aaaDomain.templ+"</radius-server>";
}
function undoAAADomainRadiusConfig(aaaDomain)
{
return "<aaa></aaa><domain>"+aaaDomain.name+"</domain>" +
"<undo>radius-server</undo>";
}
function aaaDomainServiceConfig(aaaDomain)
{
return "<aaa></aaa><domain>"+aaaDomain.name+"</domain>" +
"<service-scheme>"+aaaDomain.service+"</service-scheme>";
}
function undoAAADomainServiceConfig(aaaDomain)
{
return "<aaa></aaa><domain>"+aaaDomain.name+"</domain>" +
"<undo>service-scheme</undo>";
}
function getSchemeName()
{
return ret='<hwServiceSchemeEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAaa.hwAAAMibObjects.hwServiceSchemeTable">'
+'<hwServiceSchemeName/>'
+'<hwSrvSchemeAdminUserPriority/>'
+'</hwServiceSchemeEntry>'
+'<hwRadiusGroupEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwBRASMib.hwBRASRadius.hwRadiusGroupObject.hwRadiusGroupTable">'
+'<hwRadiusGroupName/>'
+'<hwRadiusServerKey/>'
+'</hwRadiusGroupEntry>';
}
function getLocalUser(parm,number,iName,i)
{
return ret='<hwLocalUserEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAaa.hwAAAMibObjects.hwLocalUserTable" '+tranParam(number,iName,i)+'>'
+'<hwLocalUserName/>'
+'<hwLocalUserPriority/>'
+'<hwLocalUserAccessType/>'
+'<hwLocalUserRowStatus/>'
+'<hwftpdirction/>'
+'</hwLocalUserEntry>';
}
function getUserLeval(userName)
{
return ret='<hwLocalUserEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAaa.hwAAAMibObjects.hwLocalUserTable">'
+'<hwLocalUserName>'+userName+'</hwLocalUserName>'
+'<hwLocalUserPriority/>'
+'</hwLocalUserEntry>';
}
function getLocalUserStatus()
{
return ret='<hwLocalUserExtEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwAaa.hwAAAMibObjects.hwLocalUserExtTable">'
+'<hwLocalUserState/>'
+'</hwLocalUserExtEntry>';
}
function localUserConfig(localUser)
{
return "<aaa></aaa><local-user>"+localUser.name+" password "+localUser.passWord+"</local-user>";
}
function undoUser(userName)
{
return "<aaa></aaa><undo>local-user "+userName+"</undo>";
}
function localUserServiceTypeConfig(localUser)
{
return "<aaa></aaa><local-user>"+localUser.name+" service-type "+localUser.serviceType+"</local-user>";
}
function undoLocalUserServiceTypeConfig(localUser)
{
return "<aaa></aaa><undo>local-user "+localUser.name+" service-type</undo>";
}
function localUserFtpConfig(localUser)
{
return "<aaa></aaa><local-user>"+localUser.name+" ftp-directory "+localUser.ftp+"</local-user>";
}
function undoLocalUserFtpConfig(localUser)
{
return "<aaa></aaa><undo>local-user "+localUser.name+" ftp-directory</undo>";
}
function localUserLevelConfig(localUser)
{
return "<aaa></aaa><local-user>"+localUser.name+" level "+localUser.level+"</local-user>";
}
function undoLocalUserLevelConfig(localUser)
{
return "<aaa></aaa><undo>local-user "+localUser.name+" privilege level</undo>";
}
function localUserStatusConfig(localUser)
{
return "<aaa></aaa><local-user>"+localUser.name+" state "+localUser.status+"</local-user>";
}
function localUserLimitsConfig(localUser)
{
return "<aaa></aaa><local-user>"+localUser.name+" access-limit "+localUser.limit+"</local-user>";
}
function undoLocalUserLimitsConfig(localUser)
{
return "<aaa></aaa><undo>local-user "+localUser.name+" access-limit</undo>";
}
function getPatchInfo(){
return "<display>patch-information</display>"
}
function CancelInterfaceCFG(interfaceName,type)
{
return '<interface isview="true"><instance><name> '+interfaceName +'</name>'
+'<undo>'+type+'</undo>'
+'</instance></interface>';
}
function CancelInterfaceCFGMarking(interfaceName,cmd)
{
return '<interface isview="true"><instance><name> '+interfaceName +'</name>'
+cmd
+'</instance></interface>';
}
function getTotalNumber(mode,type,port,mac,vlan,vsi)
{
var ret = '<display>mac-address total-number ';
if(mode==1){
ret += '';
}else if(mode==2){
ret += '';
}else if(mode==3){
ret += '';
}else if(mode==4){
ret += ''+type;
}else if(mode==5){
ret += ''+type+' vlan '+vlan;
}else if(mode==6){
ret += ''+type+' '+port;
}else if(mode==7){
ret += ''+type+' '+port+' vlan '+vlan;
}else if(mode==8){
ret += 'vlan '+vlan;
}else if(mode==9){
ret += ''+port;
}else if(mode==10){
ret += ''+port+' vlan '+vlan;
}else if(mode==11){
ret += '';
}else if(mode==12){
ret += ''+type+' vsi '+vsi;
}else if(mode==13){
ret += '';
}else if(mode==14){
ret += 'vsi '+vsi;
}else if(mode==15){
ret += '';
}
ret += '</display>';
return ret;
}
function configBpdu53(TrunkID,flag)
{
var ret = '<interface isview="true"><instance><name>'+TrunkID +'</name>';
if (flag)
{
ret += '<bpdu>enable</bpdu>';
}
else
{
ret += '<bpdu>disable</bpdu>';
}
ret += '</instance></interface>';
return ret;
}
function getStaticMacInfo(param,number,iName,i)
{
var ret = '<hwCfgMacAddrQueryEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwL2MAM.hwL2MAMObjects.hwCfgMacAddrQueryTable" '+tranParam(number,iName,i)+'>'+
'<hwCfgMacAddrQueryMacAddr/>'+
'<hwCfgMacAddrQueryVlanId/>'+
'<hwCfgMacAddrQueryVsiName/>'+
'<hwCfgMacAddrQueryType/>'+
'<hwCfgMacAddrQueryIfIndex/>'+
'</hwCfgMacAddrQueryEntry>';
return ret;
}
function getDynMacInfo(param,number,iName,i)
{
var ret = '<hwDynMacAddrQueryEntry position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.hwL2Mgmt.hwL2MAM.hwL2MAMObjects.hwDynMacAddrQueryTable" '+tranParam(number,iName,i)+'>'+
'<hwDynMacAddrQueryMacAddr/>'+
'<hwDynMacAddrQueryVlanId/>'+
'<hwDynMacAddrQueryVsiName/>'+
'<hwDynMacAddrQueryType/>'+
'<hwDynMacAddrQueryIfIndex/>'+
'<hwDynMacAddrQueryAgingTime/>'+
'</hwDynMacAddrQueryEntry>';
return ret;
}
function getDispElabel(slotID)
{
return '<quit/><disp>elabel slot '+ slotID +'</disp>';
}
function getFanState()
{
return '<display>fan verbose</display>';
}
function displayBpdu()
{
var ret = ' <display>current-configuration | include bpdu</display>';
return ret;
}
function getDevice()
{
var ret='<display> device </display>';
return ret;
}
function getIsStack()
{
return '<hwStackObject position="iso.org.dod.internet.private.enterprises.huawei.huaweiMgmt.hwDatacomm.huaweiStackMIB">'
+'<hwStackRun/>'
+'</hwStackObject>';
}
var enableMap = {1:"enable",2:"disable"};
var enableMap2 = {1:"enabled",2:"disabled",3:"default"};
var enableMap3 = {1:"disabled",2:"enabled",3:"default"};
var stpModeMap = {0:"STP",2:"RSTP",3:"MSTP"};
var stpP2PMap = {1:"forceTrue",2:"forceFalse",3:"auto"};
var stpBPDUMap = {1:"disable",2:"enable",3:"undo"};
var convergeModeMap = {1:"fast",2:"normal"};
var portStateMap = {1:"disabled",2:"discarding",4:"learning",5:"forwarding"};
var costStandMap = {1:"dot1d-1998",2:"dot1t",3:"legacy"};
var upDownMap = {1:"up",2:"down"};
var portTypeMap = {1:"trunk",2:"access",3:"hybrid"};
var macTypeMap = {1:"dynamic",2:"static",3:"blackhole",4:"sticky"};
var vlanTypeMap = {1:"superVlan",2:"commonVlan",3:"subVlan"};
var macLimitActionMap = {1:"discard",2:"forward"};
var vrrpPreemptModeMap = {1:"true",2:"false"};
var rootTypeMap = {0:"normal",1:"secondary",2:"primary"};
var trunkIfModelMap={1:"packetAll",2: "sourceDesMac",3: "packetUdp",4: "packetTcp",5: "sourceDesIp",6: "sourceMacIpv6",7: "sourceIpIpv6",8: "sourceIp",9: "desIp",10:"sourceMac",11:"desMac" ,12: "sourcePort" ,13: "desPort",14: "sourceDesPort",15: "label" ,16:"ipOrLabel"};
var trunkIfWorkingModeMap={1:"masterBackup", 2: "normalMode", 3:"lacpStaticMode"};
var trunkIfTimeoutReceiveMap={1:"fast", 2: "slow"};
var routeProtoMap = {1:"Others",2:"Direct",3:"Static",8:"RIP",9:"IS-IS",13:"OSPF",14:"BGP"};
var duplexMap = {1:"full",2:"half"};
var SpeedMap = {1:"other",2:"10",3:"100",4:"1000",5:"10000"};
var vrrpOperStateMap = {1:"initialize",2: "backup",3: "master"};
var dot1xPortControlMap = {1:"auto",2: "authorizedForce",3: "unauthorizedForce"};
var dot1xPortMethodMap = {1:"mac",2: "port"};
var aclTypeMap = {1:"basic",2:"advanced",3:"link",4:"user"};
var aclRuleActMap = {1:"permit",2: "deny"};
var aclRuleFragmentsMap = {0:"fragmentSubseq",1:"fragment",2:"nonFragment",3:"nonSubseq",255:"none"};
var aclRuleLogMap = {1:"true",2: "false"};
var aclRuleAdvSrcOpMap = {1:"lt",2:"eq",3:"gt",4:"neq",5:"range",255:"invalid"};
var aclRuleL2EncapTypeMap = {1:"ether2",2:"ieee802dot3",3:"snap",255:"none"};
var voiceVlanMode = {1:"auto",2: "manual"};
var voiceVlanSecurity = {1:"security",2: "nomal"};
var poePortPriority ={1:"critical",2:"high",3:"low"};
var arpDynamicType ={1:"Dynamic",2: "Interface"};
