/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component;

import com.huawei.ism.tool.base.ui.action.ToolAction;
import com.huawei.ism.tool.base.ui.component.RolloverButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;

public abstract class AbstractBasePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final double DEFALUTRESIZEWEIGHT = 0.65;
    private static final Dimension DEFAULT_BTNPANESIZE = new Dimension(0, 32);
    private static final Dimension DEFAULT_TOPTABLESIZE = new Dimension(0, 100);
    private static final Border EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    protected JSplitPane splitPane;
    protected JPanel buttonPanel;
    private List<ToolAction> actionList = new ArrayList<ToolAction>();
    private List<RolloverButton> btnList = new ArrayList<RolloverButton>();
    private DefaultTableModel topTableModel = null;
    private JTable table = null;
    private JPanel bottomPanel;
    private boolean hasBottomPane;
    private Box buttonBox;

    public AbstractBasePanel(boolean hasBottomPane) {
        this.hasBottomPane = hasBottomPane;
        this.initComponents();
        this.initListeners();
    }

    public AbstractBasePanel() {
        this(true);
    }

    public Object getSelectObj() {
        return null;
    }

    public void updateButtons() {
        List<RolloverButton> buttonList = this.getBtnList();
        for (RolloverButton btn : buttonList) {
            Object rows = this.getSelectObj();
            ToolAction btnAction = (ToolAction)btn.getAction();
            btnAction.setSelectObject(rows);
            btn.setEnabled(btnAction.isAvailable());
        }
    }

    public Box getButtonBox() {
        this.buttonBox = Box.createHorizontalBox();
        return this.buttonBox;
    }

    protected JComponent getTopComponent() {
        if (null == this.table) {
            this.table = new JTable(this.topTableModel);
        }
        return this.table;
    }

    protected JComponent getBottomPane() {
        this.bottomPanel = new JPanel();
        return this.bottomPanel;
    }

    protected void seSplitPaneResizeWeight() {
        this.splitPane.setResizeWeight(0.65);
    }

    public JComponent initTopComponent() {
        JComponent topComp = this.getTopComponent();
        JScrollPane topPanel = new JScrollPane(topComp);
        topPanel.setBorder(new JScrollPaneBorder(Color.white));
        return topPanel;
    }

    public void initComponents() {
        this.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.add(Box.createHorizontalStrut(8));
        this.buttonPanel.add(this.getButtonBox());
        this.buttonPanel.add(Box.createGlue());
        this.buttonPanel.add(Box.createHorizontalStrut(8));
        this.buttonPanel.add(Box.createRigidArea(DEFAULT_BTNPANESIZE));
        this.add((Component)this.buttonPanel, "North");
        JComponent topComponent = this.initTopComponent();
        if (this.hasBottomPane) {
            this.splitPane = new JSplitPane(0);
            this.splitPane.setBorder(EMPTY_BORDER);
            this.splitPane.setDividerSize(7);
            this.splitPane.setContinuousLayout(true);
            JPanel bottomPane = new JPanel(new BorderLayout());
            bottomPane.setBorder(new EmptyBorder(8, 8, 8, 8));
            bottomPane.add((Component)this.getBottomPane(), "Center");
            this.splitPane.setBottomComponent(bottomPane);
            topComponent.setMinimumSize(new Dimension(100, 100));
            this.splitPane.setTopComponent(topComponent);
            topComponent.setPreferredSize(DEFAULT_TOPTABLESIZE);
            this.seSplitPaneResizeWeight();
            this.add((Component)this.splitPane, "Center");
        } else {
            this.add((Component)topComponent, "Center");
        }
    }

    protected void initListeners() {
    }

    public void addButton(ToolAction ... actions) {
        if (null == actions) {
            return;
        }
        for (ToolAction action : actions) {
            this.actionList.add(action);
            RolloverButton button = new RolloverButton(action);
            this.btnList.add(button);
            this.buttonBox.add(button);
            this.buttonBox.add(Box.createHorizontalStrut(4));
        }
    }

    public void addButton(ToolAction action, boolean isArrowVisiable) {
        if (null == action) {
            return;
        }
        this.actionList.add(action);
        RolloverButton button = new RolloverButton(action, isArrowVisiable);
        this.btnList.add(button);
        this.buttonBox.add(button);
        this.buttonBox.add(Box.createHorizontalStrut(4));
    }

    public void addGroupButton(String groupName, List<ToolAction> actions) {
        RolloverButton button = new RolloverButton(groupName, actions);
        this.buttonBox.add(button);
        this.buttonBox.add(Box.createHorizontalStrut(12));
        for (ToolAction action : actions) {
            this.actionList.add(action);
        }
    }

    public List<RolloverButton> getBtnList() {
        return this.btnList;
    }

    public JPanel getBtnPanel() {
        return this.buttonPanel;
    }

    public static class JScrollPaneBorder
    extends LineBorder {
        private static final long serialVersionUID = 1L;

        public JScrollPaneBorder(Color color) {
            super(color);
        }

        @Override
        public void paintBorder(Component com, Graphics gra, int x, int y, int width, int height) {
            Color oldColor = gra.getColor();
            JScrollPane sp = null;
            if (!(com instanceof JScrollPane)) {
                return;
            }
            sp = (JScrollPane)com;
            Component component = sp.getViewport().getView();
            if (null == component) {
                throw new NullPointerException();
            }
            String lineColorKey = component.isEnabled() ? "ScrollPane.borderColor" : "ScrollPane.borderColor_disable";
            gra.setColor(UIManager.getColor(lineColorKey));
            gra.fillRect(x, y, width - 1, 1);
            gra.setColor(Color.WHITE);
            gra.fillRect(x, y + 1, 1, height);
            gra.setColor(oldColor);
        }
    }
}

