/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.util.Objects;
import java.util.function.Supplier;

public final class Validation {
    private Validation() {
    }

    public static <T extends Comparable<T>> T between(T actual, T min, T max, String error, Object ... args) {
        if (ObjectUtils.between(actual, min, max)) {
            return actual;
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <T extends Comparable<T>, E extends RuntimeException> T between(T actual, T min, T max, Supplier<E> exceptionSupplier) {
        if (ObjectUtils.between(actual, min, max)) {
            return actual;
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    public static <T> T equals(T actual, T expected, String error, Object ... args) {
        if (Objects.equals(actual, expected)) {
            return actual;
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <T, E extends RuntimeException> T equals(T actual, T expected, Supplier<E> exceptionSupplier) {
        if (Objects.equals(actual, expected)) {
            return actual;
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    public static int greaterThan(int actual, int bound, String error, Object ... args) {
        if (actual > bound) {
            return actual;
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <E extends RuntimeException> int greaterThan(int actual, int bound, Supplier<E> exceptionSupplier) {
        if (actual > bound) {
            return actual;
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    public static long greaterThan(long actual, long bound, String error, Object ... args) {
        if (actual > bound) {
            return actual;
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <E extends RuntimeException> long greaterThan(long actual, long bound, Supplier<E> exceptionSupplier) {
        if (actual > bound) {
            return actual;
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    public static int greaterThanOrEquals(int actual, int bound, String error, Object ... args) {
        if (actual >= bound) {
            return actual;
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <E extends RuntimeException> int greaterThanOrEquals(int actual, int bound, Supplier<E> exceptionSupplier) {
        if (actual >= bound) {
            return actual;
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    public static long greaterThanOrEquals(long actual, long bound, String error, Object ... args) {
        if (actual >= bound) {
            return actual;
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <E extends RuntimeException> long greaterThanOrEquals(long actual, long bound, Supplier<E> exceptionSupplier) {
        if (actual >= bound) {
            return actual;
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    public static boolean isFalse(boolean actual, String error, Object ... args) {
        if (!actual) {
            return false;
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <E extends RuntimeException> boolean isFalse(boolean actual, Supplier<E> exceptionSupplier) {
        if (!actual) {
            return false;
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    public static <U, T extends U> T isInstanceOf(U actual, Class<T> clazz, String error, Object ... args) {
        if (clazz.isInstance(actual)) {
            return clazz.cast(actual);
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <U, T extends U, E extends RuntimeException> T isInstanceOf(U actual, Class<T> clazz, Supplier<E> exceptionSupplier) {
        if (clazz.isInstance(actual)) {
            return clazz.cast(actual);
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    public static boolean isTrue(boolean actual, String error, Object ... args) {
        if (actual) {
            return true;
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <E extends RuntimeException> boolean isTrue(boolean actual, Supplier<E> exceptionSupplier) {
        if (actual) {
            return true;
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    public static int lessThan(int actual, int bound, String error, Object ... args) {
        if (actual < bound) {
            return actual;
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <E extends RuntimeException> int lessThan(int actual, int bound, Supplier<E> exceptionSupplier) {
        if (actual < bound) {
            return actual;
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    public static long lessThan(long actual, long bound, String error, Object ... args) {
        if (actual < bound) {
            return actual;
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <E extends RuntimeException> long lessThan(long actual, long bound, Supplier<E> exceptionSupplier) {
        if (actual < bound) {
            return actual;
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    public static int lessThanOrEquals(int actual, int bound, String error, Object ... args) {
        if (actual <= bound) {
            return actual;
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <E extends RuntimeException> int lessThanOrEquals(int actual, int bound, Supplier<E> exceptionSupplier) {
        if (actual <= bound) {
            return actual;
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    public static long lessThanOrEquals(long actual, long bound, String error, Object ... args) {
        if (actual <= bound) {
            return actual;
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <E extends RuntimeException> long lessThanOrEquals(long actual, long bound, Supplier<E> exceptionSupplier) {
        if (actual <= bound) {
            return actual;
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    public static String notBlank(String actual, String error, Object ... args) {
        if (StringUtils.isNotBlank(actual)) {
            return actual;
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <E extends RuntimeException> String notBlank(String actual, Supplier<E> exceptionSupplier) {
        if (StringUtils.isNotBlank(actual)) {
            return actual;
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    public static <T> T notNull(T actual, String error, Object ... args) {
        if (actual != null) {
            return actual;
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <T, E extends RuntimeException> T notNull(T actual, Supplier<E> exceptionSupplier) {
        if (actual != null) {
            return actual;
        }
        throw (RuntimeException)exceptionSupplier.get();
    }

    public static <T> T same(T actual, T expected, String error, Object ... args) {
        if (actual == expected) {
            return actual;
        }
        throw new IllegalArgumentException(StringUtils.format(error, args));
    }

    public static <T, E extends RuntimeException> T same(T actual, T expected, Supplier<E> exceptionSupplier) {
        if (actual == expected) {
            return actual;
        }
        throw (RuntimeException)exceptionSupplier.get();
    }
}

