/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util.composite.support;

import com.huawei.fitframework.core.common.util.LockUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.core.common.util.composite.ConsumerComposite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;

public class ConsumerCompositeConcurrentDecorator<T>
implements ConsumerComposite<T> {
    private final ConsumerComposite<T> decorated;
    private final ReadWriteLock lock;

    public ConsumerCompositeConcurrentDecorator(ConsumerComposite<T> decorated) {
        this.decorated = Validation.notNull(decorated, "The decorated consumer composite cannot be null.", new Object[0]);
        this.lock = LockUtils.newReentrantReadWriteLock();
    }

    @Override
    public void add(Consumer<T> consumer) {
        LockUtils.synchronize(this.lock.writeLock(), () -> this.decorated.add(consumer));
    }

    @Override
    public void addAll(Collection<Consumer<T>> consumers) {
        LockUtils.synchronize(this.lock.writeLock(), () -> this.decorated.addAll(consumers));
    }

    @Override
    public void remove(Consumer<T> consumer) {
        LockUtils.synchronize(this.lock.writeLock(), () -> this.decorated.remove(consumer));
    }

    @Override
    public void removeAll(Collection<Consumer<T>> consumers) {
        LockUtils.synchronize(this.lock.writeLock(), () -> this.decorated.removeAll(consumers));
    }

    @Override
    public List<Consumer<T>> getConsumers() {
        return LockUtils.synchronize(this.lock.readLock(), this.decorated::getConsumers);
    }

    @Override
    public void accept(T object) {
        LockUtils.synchronize(this.lock.readLock(), () -> new ArrayList<Consumer<T>>(this.decorated.getConsumers())).forEach(consumer -> consumer.accept(object));
    }
}

