/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util.support;

import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.core.common.util.Version;
import java.util.Arrays;
import java.util.Comparator;

public class DefaultVersion
implements Version {
    public static final Comparator<Version> COMPARATOR = Comparator.comparingInt(Version::major).thenComparingInt(Version::minor).thenComparingInt(Version::revision).thenComparingInt(Version::build);
    private static final char SEPARATOR = '.';
    private final int major;
    private final int minor;
    private final int revision;
    private final int build;

    public DefaultVersion(int major, int minor, int revision, int build) {
        this.major = Validation.greaterThanOrEquals(major, 0, "The major version cannot be negative. [major={0}]", new Object[]{major});
        this.minor = Validation.greaterThanOrEquals(minor, 0, "The minor version cannot be negative. [minor={0}]", new Object[]{minor});
        this.revision = Validation.greaterThanOrEquals(revision, 0, "The revision version cannot be negative. [revision={0}]", new Object[]{revision});
        this.build = Validation.greaterThanOrEquals(build, 0, "The build version cannot be negative. [build={0}]", new Object[]{build});
    }

    @Override
    public int major() {
        return this.major;
    }

    @Override
    public int minor() {
        return this.minor;
    }

    @Override
    public int revision() {
        return this.revision;
    }

    @Override
    public int build() {
        return this.build;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.major()).append('.').append(this.minor);
        if (this.build() > 0) {
            builder.append('.').append(this.revision()).append('.').append(this.build());
        } else if (this.revision() > 0) {
            builder.append('.').append(this.revision());
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.equals((DefaultVersion)obj);
    }

    private boolean equals(DefaultVersion another) {
        return this.major() == another.major() && this.minor() == another.minor() && this.revision() == another.revision() && this.build() == another.build();
    }

    public int hashCode() {
        return Arrays.hashCode(new int[]{this.major(), this.minor(), this.revision(), this.build()});
    }

    public static Version parse(String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        String[] parts = StringUtils.split(value, '.');
        if (parts.length < 2) {
            throw new IllegalArgumentException(StringUtils.format("The value to parse does not contains a valid version. [value={0}]", value));
        }
        return new DefaultVersion(DefaultVersion.part(parts, 0, "major"), DefaultVersion.part(parts, 1, "minor"), DefaultVersion.part(parts, 2, "revision"), DefaultVersion.part(parts, 3, "build"));
    }

    private static int part(String[] parts, int index, String key) {
        if (index >= parts.length) {
            return 0;
        }
        try {
            return Integer.parseUnsignedInt(parts[index]);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(StringUtils.format("The {0} version is invalid. [actual={1}]", key, parts[index]), ex);
        }
    }
}

