/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicegraph.listener;

import com.huawei.ism.model.MOType;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tool.devicegraph.ui.DeviceGraphPanel;
import com.huawei.ism.tool.devicegraph.ui.components.EnclosureGraph;
import com.huawei.ism.tool.devicegraph.ui.components.RackPanel;
import com.huawei.ism.tool.devicegraph.util.DeviceGraphContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.IDeviceRetriever;
import com.huawei.ism.tool.framework.pubservice.exception.DeviceException;
import com.huawei.ism.tool.framework.pubservice.hardware.IEnclosureInfo;
import com.huawei.ism.tool.framework.pubservice.hardware.IHardwareInfo;
import com.huawei.ism.tool.framework.pubui.common.ui.EnclosureMenuItem;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import org.slf4j.Logger;

public class PopupMenuListener
extends MouseAdapter {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PopupMenuListener.class);
    private static final int ENCLOSURE_LEFT_X = 29;
    private static final int ENCLOSURE_RIGHT_X = 132;
    private static final int CONTROLLER_A_Y = 13;
    private static final int CONTROLLER_B_Y = 25;
    private JPopupMenu menu = null;
    private List<EnclosureMenuItem> menuItems = null;

    public PopupMenuListener(JPopupMenu menu, List<EnclosureMenuItem> menuItems) {
        this.menu = menu;
        this.menuItems = menuItems;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int xValue = (int)e.getPoint().getX();
        if (xValue < 29 || xValue > 132) {
            return;
        }
        EnclosureGraph graph = (EnclosureGraph)e.getComponent();
        this.bondMenuObjects(graph, (int)e.getPoint().getX());
        this.menu.show(graph, (int)e.getPoint().getX(), (int)e.getPoint().getY());
    }

    private void bondMenuObjects(EnclosureGraph graph, int y) {
        IHardwareInfo hardware = null;
        IEnclosureInfo info = graph.getEnclosureInfo();
        DeviceGraphPanel devciegraph = (DeviceGraphPanel)DeviceGraphContext.getInstance().getSingleObject("DEVICE_GRAPH");
        List<RackPanel> rackList = devciegraph.getRackList();
        RackPanel selectRack = rackList.get(graph.getRackIndex());
        ArrayList<IHardwareInfo> allHardware = new ArrayList<IHardwareInfo>();
        for (RackPanel r : rackList) {
            allHardware.addAll(r.getEnclosureList());
        }
        if (EnumDefine.ENCLOSURE_TYPE_E.CTRL.name().equals(info.getLogicTypeName())) {
            IDeviceManage devMng = PublicServiceManage.getInstance().getService(IDeviceManage.class);
            IDeviceRetriever retriver = devMng.getDeviceRetriever(devMng.getCurrentDevice());
            if (null == retriver) {
                return;
            }
            List<Object> controllersInRack = new ArrayList();
            try {
                controllersInRack = retriver.retrieveSubModules(info, MOType.CONTROLLER.name());
            }
            catch (DeviceException e) {
                LOGGER.error("mouseReleased: retrieve controller exception.", e);
                return;
            }
            if (y < 13 && y > 0) {
                hardware = (IHardwareInfo)controllersInRack.get(0);
            } else if (y < 25 && y >= 13) {
                hardware = (IHardwareInfo)controllersInRack.get(1);
            }
        } else {
            hardware = info;
        }
        for (EnclosureMenuItem item : this.menuItems) {
            item.setHardware(hardware);
            item.setHardwaresInRack(new ArrayList<IHardwareInfo>(selectRack.getEnclosureList()));
            item.setAllHardware(allHardware);
        }
    }
}

