/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicegraph.util;

import com.huawei.ism.model.MOType;
import com.huawei.ism.tool.devicegraph.Constants;
import com.huawei.ism.tool.devicegraph.ui.components.EnclosureGraph;
import com.huawei.ism.tool.framework.pubservice.hardware.IEnclosureInfo;
import com.huawei.ism.tool.framework.pubservice.hardware.IHardwareInfo;
import com.huawei.ism.util.Assert;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxICell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxCellOverlay;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public final class GraphUtils {
    private static final String IMAGE_STYLE_NAME = "imageStyle";

    private GraphUtils() {
    }

    public static List<IEnclosureInfo> sort(List<IEnclosureInfo> enclosureList) {
        Assert.notNullList(enclosureList);
        ArrayList<IEnclosureInfo> resultList = new ArrayList<IEnclosureInfo>();
        int size = enclosureList.size();
        for (int i = 0; i < size; ++i) {
            IEnclosureInfo info = GraphUtils.getMaxEnclosureInfo(enclosureList);
            resultList.add(info);
            enclosureList.remove(info);
        }
        return resultList;
    }

    public static Point getEnclosureCoordinate(EnclosureGraph graph) {
        int yValue = Constants.RACK_HEIGHT - 22 - graph.getHeight() - (graph.getStartU() - 1) * (Constants.ENCLOSURE_1U_HEIGHT + 1);
        return new Point(0, yValue);
    }

    public static Point getEnclosureCoordinateX(EnclosureGraph graph) {
        int yValue = Constants.RACK_HEIGHT - 22 - graph.getHeight() - (graph.getStartU() - 1) * (Constants.ENCLOSURE_1U_HEIGHT + 1);
        return new Point(Constants.PLACE_HOLDER_CELL_WIDTH, yValue);
    }

    private static IEnclosureInfo getMaxEnclosureInfo(List<IEnclosureInfo> enclosureList) {
        if (1 == enclosureList.size()) {
            return enclosureList.get(0);
        }
        IEnclosureInfo maxInfo = enclosureList.get(0);
        for (IEnclosureInfo info : enclosureList) {
            if (maxInfo.getStartU() >= info.getStartU()) continue;
            maxInfo = info;
        }
        return maxInfo;
    }

    public static void setChangelessSize(JComponent component, Dimension dimension) {
        component.setPreferredSize(dimension);
        component.setMaximumSize(dimension);
        component.setMinimumSize(dimension);
    }

    public static String getEnclosureName(IHardwareInfo module) {
        if (module == null) {
            return "";
        }
        if (MOType.ENCLOSURE.name().equals(module.getTypeName())) {
            return ((IEnclosureInfo)module).getName();
        }
        String moduleLocation = module.getLocation();
        String[] locArray = moduleLocation.split("\\.");
        String enclosureName = locArray[0];
        return enclosureName;
    }

    public static String getHardwareSilkScreen(String moduleLocation) {
        String[] locArray = moduleLocation.split("\\.");
        String silkScreen = locArray[locArray.length - 1];
        return silkScreen;
    }

    public static String getBoardSlotSilkScreen(String location) {
        String[] locArray = location.split("\\.");
        String silkScreen = locArray[1];
        return silkScreen;
    }

    public static void addImageOverlay(mxGraphComponent graphComponent, ImageIcon image, mxICell cell, Rectangle rectangle) {
        mxCellOverlay overlay = new mxCellOverlay(image, null);
        overlay.setBounds(0, 0, (int)rectangle.getWidth(), (int)rectangle.getHeight());
        overlay.setVerticalAlign("middle");
        overlay.setAlign("center");
        graphComponent.addCellOverlay(cell, overlay);
    }

    public static mxCell addImage(mxGraph graph, Object parent, String image, Rectangle rectangle) {
        String styleName = GraphUtils.setStyleSheet(graph, image);
        mxCell cell = (mxCell)graph.insertVertex(parent, null, null, rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), styleName);
        return cell;
    }

    private static String setStyleSheet(mxGraph graph, String image) {
        mxStylesheet stylesheet = graph.getStylesheet();
        int count = stylesheet.getStyles().size();
        String styleName = IMAGE_STYLE_NAME + count;
        Hashtable<String, Object> style = new Hashtable<String, Object>();
        style.put(mxConstants.STYLE_SHAPE, "image");
        style.put(mxConstants.STYLE_IMAGE, GraphUtils.getImageStylePath(image));
        style.put(mxConstants.STYLE_STROKECOLOR, "none");
        style.put(mxConstants.STYLE_FILLCOLOR, "none");
        stylesheet.putCellStyle(styleName, style);
        return styleName;
    }

    private static String getImageStylePath(String imagePath) {
        String imageStylePath = "";
        imageStylePath = imagePath.startsWith("/cbb") || !GraphUtils.isAbsolutePath(imagePath) ? imagePath : "file:/" + imagePath;
        return imageStylePath;
    }

    public static boolean isAbsolutePath(String path) {
        return path.startsWith("/") || path.indexOf(":") > 0;
    }

    public static void setDefaultStyle(mxGraph graph, mxGraphComponent component) {
        component.setOpaque(false);
        component.setConnectable(false);
        graph.setCellsMovable(false);
        graph.setCellsEditable(false);
        graph.setCellsSelectable(false);
        graph.setEdgeLabelsMovable(false);
    }
}

