/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cms.verify.bc;

import com.huawei.cms.verify.bc.CMSProcessableInputStreamImpl;
import com.huawei.cms.verify.bc.FileToX509;
import com.huawei.cms.verify.bc.HuaweiObjectIdentifiers;
import com.huawei.cms.verify.bc.SignatureType;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableFile;
import org.bouncycastle.jce.provider.AnnotatedException;

public class CertCtx {
    private String sigFile;
    private byte[] sigData;
    private String srcFile;
    private InputStream srcInputStream;
    private long startIndex;
    private long endIndex;
    private List<String> crtFiles = new ArrayList<String>();
    private List<byte[]> crtDatas = new ArrayList<byte[]>();
    private List<String> crlFiles = new ArrayList<String>();
    private List<byte[]> crlDatas = new ArrayList<byte[]>();
    private Set<String> signatureType = new HashSet<String>();

    public void setSigFile(String sigFile) {
        this.sigFile = sigFile;
    }

    public byte[] getSigData() throws AnnotatedException {
        if (this.sigFile == null && this.sigData == null) {
            throw new AnnotatedException("signature data is null, pls set signature data");
        }
        if (this.sigFile != null) {
            return FileToX509.readSigFile(this.sigFile);
        }
        return FileToX509.readSigData(this.sigData);
    }

    public void setSigData(byte[] sigData) {
        this.sigData = (byte[])sigData.clone();
    }

    public String getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(String srcFile) {
        this.srcFile = srcFile;
    }

    public CMSProcessable getSrcData() throws AnnotatedException {
        if (this.srcFile == null && this.srcInputStream == null) {
            throw new AnnotatedException("src data is null, pls set src data");
        }
        Object data = this.srcInputStream == null ? new CMSProcessableFile(new File(this.srcFile)) : new CMSProcessableInputStreamImpl(this.srcInputStream, this.startIndex, this.endIndex);
        return data;
    }

    public void setSrcInputStream(InputStream in, long startIndex, long endIndex) {
        this.srcInputStream = in;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public List<String> getCrtFiles() {
        return this.crtFiles;
    }

    public List<byte[]> getCrtDatas() {
        return this.crtDatas;
    }

    public List<String> getCrlFiles() {
        return this.crlFiles;
    }

    public List<byte[]> getCrlDatas() {
        return this.crlDatas;
    }

    SignatureType getSignatureType() {
        if (this.signatureType.contains(HuaweiObjectIdentifiers.ID_HW_KP_RELEASE_SIGNING.toString())) {
            return SignatureType.RELEASE_SIGNATURE;
        }
        return SignatureType.INTEGRITY_SIGNATURE;
    }

    public void setSignatureType(SignatureType signatureType) {
        if (signatureType == SignatureType.RELEASE_SIGNATURE) {
            this.signatureType.add(HuaweiObjectIdentifiers.ID_HW_KP_RELEASE_SIGNING.toString());
        }
    }

    public void addExpectedPurposeId(String oid) {
        this.signatureType.add(oid);
    }

    Set<String> getSignatureOId() {
        if (this.signatureType.isEmpty()) {
            return new HashSet<String>(Arrays.asList(KeyPurposeId.id_kp_codeSigning.toString()));
        }
        return this.signatureType;
    }

    public void reset() {
        this.sigFile = null;
        this.sigData = null;
        this.srcFile = null;
        this.srcInputStream = null;
        this.startIndex = 0L;
        this.endIndex = 0L;
        this.crtFiles.clear();
        this.crtDatas.clear();
        this.crlFiles.clear();
        this.crlDatas.clear();
        this.signatureType.clear();
    }
}

