/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.certbase.integrity;

import com.huawei.cms.verify.bc.CMSVerify;
import com.huawei.cms.verify.bc.SignatureType;
import com.huawei.ism.tool.certbase.integrity.pgp.PgpVerifyUtil;
import com.huawei.ism.tool.certbase.utils.FileUtils;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckFileIntegrityUtils {
    private static final Logger log = LoggerFactory.getLogger(CheckFileIntegrityUtils.class);

    public static boolean checkFileByPgp(String targetPath, String targetSignPath, String pgpKeysPath) {
        File targetFile = FileUtils.getCanonicalFile(targetPath);
        File signFile = FileUtils.getCanonicalFile(targetSignPath);
        if (targetFile == null || signFile == null || !targetFile.exists() || !signFile.exists()) {
            log.warn("sign file or original file is not exists.");
            return false;
        }
        File keyFile = FileUtils.getCanonicalFile(pgpKeysPath);
        if (keyFile == null || !keyFile.exists()) {
            log.warn("pgp default key file is not exits.");
            return false;
        }
        return PgpVerifyUtil.verifySignature(targetFile, signFile, keyFile);
    }

    public static boolean checkFileByCms(String certPath, String sourceFile, String crl, String cms) {
        return CheckFileIntegrityUtils.checkFileByCms(certPath, sourceFile, crl, cms, SignatureType.INTEGRITY_SIGNATURE);
    }

    public static boolean checkFileReleaseSignByCms(String signPath, String sourceFilePath, String certPath) {
        return CheckFileIntegrityUtils.checkReleaseSignByCms(new CMSVerify(signPath, sourceFilePath, new String[]{certPath}, null));
    }

    public static boolean checkFileReleaseSignByCms(String signPath, String sourceFilePath, byte[] certData) {
        CMSVerify cmsVerify = new CMSVerify(signPath, sourceFilePath, null, null);
        cmsVerify.addCrtData(certData);
        return CheckFileIntegrityUtils.checkReleaseSignByCms(cmsVerify);
    }

    private static boolean checkFileByCms(String certPath, String sourceFile, String crl, String cms, SignatureType signatureType) {
        CMSVerify cmsVerify = new CMSVerify();
        if (SignatureType.RELEASE_SIGNATURE == signatureType) {
            cmsVerify.setSignatureType(SignatureType.RELEASE_SIGNATURE);
        }
        cmsVerify.addCrtFile(certPath);
        cmsVerify.setSrcFile(sourceFile);
        cmsVerify.addCrlFile(crl);
        cmsVerify.setSigFile(cms);
        boolean verifyFlag = false;
        try {
            verifyFlag = cmsVerify.verify();
        }
        catch (Exception e) {
            log.error("checkFileByCms exception", (Throwable)e);
        }
        return verifyFlag;
    }

    private static boolean checkReleaseSignByCms(CMSVerify cmsVerify) {
        cmsVerify.setSignatureType(SignatureType.RELEASE_SIGNATURE);
        boolean verifyResult = false;
        try {
            verifyResult = cmsVerify.verify();
        }
        catch (Exception e) {
            log.error("checkFileReleaseSignByCms error", (Throwable)e);
        }
        return verifyResult;
    }
}

