/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.patch.dstorage.service;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.service.collect.dstorage.entity.CollectConf;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.tool.service.patch.dstorage.entity.ItemInfo;
import com.huawei.ism.tool.service.patch.dstorage.entity.PatchInfo;
import com.huawei.ism.tool.service.patch.service.IPatchConfigParse;
import com.huawei.ism.util.Utils;
import com.huawei.json.JSONUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class PatchConfigParseImp
implements IPatchConfigParse {
    private static final Logger log = LoggerFactory.getLogger(PatchConfigParseImp.class);
    private static final String CMS = "cms";
    private static final String WITH_CMS = "_cms";
    private static final String NFV = "nfv";
    private static final String NFV_CMS = "nfv_cms";
    private static final String NORMAL = "normal";
    private static final String STR_BLANK = "";
    private static final String UNDERLINE = "_";
    private static final String PATCH_PATH_REG = "inspect([\\s\\S]*?)yaml";
    private static final String NORMAL_PATCH_PATH_REG = "inspect_patch.yaml";
    private static final String NFV_PATCH_PATH_REG = "inspect([\\s\\S]*?)nfv\\.yaml";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<DstoragePatchInfo.Type, List<DstoragePatchInfo>> parse(String path) {
        File configXmlFile = new File(path);
        if (!configXmlFile.exists()) return Collections.emptyMap();
        if (!configXmlFile.isFile()) {
            return Collections.emptyMap();
        }
        try (FileInputStream in = new FileInputStream(configXmlFile);){
            Map<DstoragePatchInfo.Type, List<DstoragePatchInfo>> map = this.parseConfig(XmlUtils.searchNodeByExp((Document)XmlUtils.parseDocument((InputStream)in), (String)"//patch"));
            return map;
        }
        catch (Exception e) {
            log.error("Parse hotpatch.xml error.", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private Map<DstoragePatchInfo.Type, List<DstoragePatchInfo>> parseConfig(NodeList nodeList) {
        if (null == nodeList) {
            return Collections.emptyMap();
        }
        HashMap<DstoragePatchInfo.Type, List<DstoragePatchInfo>> patchs = new HashMap<DstoragePatchInfo.Type, List<DstoragePatchInfo>>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            DstoragePatchInfo patchInfo = this.parsePatchInfo((Element)node);
            List list = patchs.getOrDefault((Object)patchInfo.getPatchType(), new ArrayList());
            list.add(patchInfo);
            patchs.put(patchInfo.getType(), list);
        }
        return patchs;
    }

    private DstoragePatchInfo parsePatchInfo(Element patchRoot) {
        DstoragePatchInfo basicPatchInfo = new DstoragePatchInfo();
        Element cmsSign = (Element)XmlUtils.searchNodeByExp((Element)patchRoot, (String)"cmsSign").item(0);
        Element eleType = (Element)XmlUtils.searchNodeByExp((Element)patchRoot, (String)"patchPathByType").item(0);
        Map<String, String> patchPathMap = this.getPathMap(patchRoot, cmsSign, eleType, "patchPathNameRule");
        Element ele = (Element)XmlUtils.searchNodeByExp((Element)patchRoot, (String)"productVersion").item(0);
        List<String> supportVersions = Arrays.asList(ele.getTextContent().trim().split(","));
        basicPatchInfo.setSupportVersions(supportVersions);
        ele = (Element)XmlUtils.searchNodeByExp((Element)patchRoot, (String)"productModel").item(0);
        basicPatchInfo.setSupportProductModel(ele.getTextContent().trim());
        ele = (Element)XmlUtils.searchNodeByExp((Element)patchRoot, (String)"patchType").item(0);
        basicPatchInfo.setType(DstoragePatchInfo.Type.valueOf(ele.getTextContent().trim().toUpperCase(Locale.ENGLISH)));
        basicPatchInfo.setPatchPath(this.getPath(patchPathMap, NORMAL));
        basicPatchInfo.setPatchPathByCms(this.getPath(patchPathMap, CMS));
        basicPatchInfo.setPatchPathByNfv(this.getPath(patchPathMap, NFV));
        basicPatchInfo.setPatchPathByNfvAndCms(this.getPath(patchPathMap, NFV_CMS));
        ele = (Element)XmlUtils.searchNodeByExp((Element)patchRoot, (String)"parseType").item(0);
        basicPatchInfo.setParseType(DstoragePatchInfo.ParseType.value(ele.getTextContent().trim()));
        this.paresBackupPathList(patchRoot, cmsSign, eleType, basicPatchInfo);
        ele = (Element)XmlUtils.searchNodeByExp((Element)patchRoot, (String)"patchItemConfig").item(0);
        basicPatchInfo.setItemIdList(this.getPatchItem(ele, PATCH_PATH_REG));
        basicPatchInfo.initNfvItemIdList(this.getPatchItem(ele, NFV_PATCH_PATH_REG));
        basicPatchInfo.setItemInfos(this.getAllPatchItem(ele, NORMAL_PATCH_PATH_REG));
        basicPatchInfo.initNfvItemInfos(this.getAllPatchItem(ele, NFV_PATCH_PATH_REG));
        basicPatchInfo.setCollectItems(this.parseCollectItemConf(basicPatchInfo.getType(), ele.getTextContent().trim()));
        return basicPatchInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<CollectConf> parseCollectItemConf(DstoragePatchInfo.Type type, String path) {
        if (type != DstoragePatchInfo.Type.COLLECT) {
            return Collections.emptyList();
        }
        File pathFile = new File(Context.INS.getPackageRootPath(), path);
        String lan = Locale.getDefault().getLanguage();
        try (FileInputStream fis = new FileInputStream(pathFile);){
            Yaml yamlConfig = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
            Map configMap = (Map)yamlConfig.load((InputStream)fis);
            List patchInfoMap = (List)configMap.get("patch_info");
            List<CollectConf> list = patchInfoMap.stream().map(info -> CollectConf.builder().id(((String)info.get("item")).trim()).microservice(((String)info.get("micro")).trim()).clazz(((String)info.get("class")).trim()).name(info.getOrDefault("description_" + lan, "description_zh").trim()).build()).filter(item -> !item.getId().equals("collect_common")).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            log.error("Parse collect conf {} error.", (Object)pathFile);
            return Collections.emptyList();
        }
    }

    private List<String> getPatchItem(Element ele, String patchReg) {
        List<String> patchItem = new ArrayList<String>();
        try {
            String[] fileNameList;
            File pathFile = new File(Context.INS.getPackageRootPath() + File.separator + ele.getTextContent().trim());
            File parentFile = pathFile.getParentFile();
            for (String fileName2 : fileNameList = parentFile.list((file, fileName) -> fileName.matches(patchReg))) {
                patchItem.addAll(this.parsePatchItemConfig(parentFile.getCanonicalPath() + File.separator + fileName2));
            }
            patchItem = patchItem.stream().distinct().collect(Collectors.toList());
        }
        catch (IOException e) {
            log.error("Get file path error", (Throwable)e);
        }
        return patchItem;
    }

    private List<ItemInfo> getAllPatchItem(Element ele, String patchPathReg) {
        ArrayList<ItemInfo> patchItems = new ArrayList<ItemInfo>();
        File pathFile = new File(Context.INS.getPackageRootPath() + File.separator + ele.getTextContent().trim());
        File parentFile = pathFile.getParentFile();
        Object[] fileNameList = parentFile.list((file, fileName) -> fileName.matches(patchPathReg));
        if (Utils.isNullArray((Object[])fileNameList)) {
            log.info("The check item file does not exist.");
            return patchItems;
        }
        return Stream.of(fileNameList).flatMap(fileName -> this.getItemInfoStream(parentFile, (String)fileName)).distinct().collect(Collectors.toList());
    }

    @Nullable
    private Stream<ItemInfo> getItemInfoStream(File parentFile, String fileName) {
        try {
            return this.parseAllPatchItemConfig(parentFile.getCanonicalPath() + File.separator + fileName).stream();
        }
        catch (IOException e) {
            log.error("Failed to obtain the file path.");
            return null;
        }
    }

    private void paresBackupPathList(Element patchRoot, Element cmsSign, Element eleType, DstoragePatchInfo basicPatchInfo) {
        Element ele = (Element)XmlUtils.searchNodeByExp((Element)patchRoot, (String)"backupPatchs").item(0);
        NodeList nodeList = XmlUtils.searchNodeByExp((Element)ele, (String)"backupPatch");
        this.paresBackupPath(basicPatchInfo, nodeList, cmsSign, eleType);
    }

    private void paresBackupPath(DstoragePatchInfo basicPatchInfo, NodeList nodeList, Element cmsSign, Element eleType) {
        ArrayList<DstoragePatchInfo> backupPatchList = new ArrayList<DstoragePatchInfo>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Map<String, String> backupPatchPathMap = this.getPathMap((Element)node, cmsSign, eleType, "backupPatchPathNameRule");
            String backupPatchPath = this.getPath(backupPatchPathMap, NORMAL);
            if (StringUtils.isNULLStr((String)backupPatchPath)) continue;
            DstoragePatchInfo backupPatch = new DstoragePatchInfo();
            backupPatch.setType(basicPatchInfo.getType());
            backupPatch.setPatchPath(backupPatchPath);
            backupPatch.setPatchPathByCms(this.getPath(backupPatchPathMap, CMS));
            backupPatch.setPatchPathByNfv(this.getPath(backupPatchPathMap, NFV));
            backupPatch.setPatchPathByNfvAndCms(this.getPath(backupPatchPathMap, NFV_CMS));
            backupPatchList.add(backupPatch);
        }
        basicPatchInfo.setBackupPatchList(backupPatchList);
    }

    private String getPath(Map<String, String> pathMap, String key) {
        if (VerifyUtil.isEmpty(pathMap) || VerifyUtil.isEmpty((String)pathMap.get(key))) {
            return null;
        }
        String patchPathWithType = FilePathUtils.pathRegularize((String)pathMap.get(key));
        return Context.INS.getPackageRootPath() + File.separator + patchPathWithType;
    }

    private Map<String, String> getPathMap(Element patchRoot, Element cmsSign, Element eleType, String roleNameKey) {
        HashMap<String, String> pathMap = new HashMap<String, String>();
        Element elePathNameRule = (Element)XmlUtils.searchNodeByExp((Element)patchRoot, (String)roleNameKey).item(0);
        if (eleType == null || elePathNameRule == null || cmsSign == null) {
            return pathMap;
        }
        String pathNameRule = elePathNameRule.getTextContent().trim();
        String pathType = eleType.getTextContent().trim();
        boolean isCmsSign = Boolean.parseBoolean(cmsSign.getTextContent().trim());
        String[] types = pathType.split(";");
        this.getPathMapByPatchSign(pathNameRule, types, pathMap, isCmsSign);
        return pathMap;
    }

    private void getPathMapByPatchSign(String pathNameRule, String[] types, Map<String, String> pathMap, boolean isCmsSign) {
        String path = STR_BLANK;
        for (String type : types) {
            path = String.format(Locale.ROOT, pathNameRule, UNDERLINE + type, STR_BLANK);
            pathMap.put(type, path);
        }
        if (isCmsSign) {
            path = String.format(Locale.ROOT, pathNameRule, WITH_CMS, STR_BLANK);
            pathMap.put(CMS, path);
            for (String type : types) {
                path = String.format(Locale.ROOT, pathNameRule, UNDERLINE + type, WITH_CMS);
                pathMap.put(type + WITH_CMS, path);
            }
        }
        pathMap.put(NORMAL, String.format(Locale.ROOT, pathNameRule, STR_BLANK, STR_BLANK));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> parsePatchItemConfig(String file) {
        ArrayList<String> itemIds = new ArrayList<String>();
        if (StringUtils.isNULLStr((String)file)) {
            return itemIds;
        }
        File configFile = new File(file);
        if (!configFile.exists()) {
            return itemIds;
        }
        try (FileInputStream fis = new FileInputStream(configFile);){
            Yaml yamlConfig = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
            Map configMap = (Map)yamlConfig.load((InputStream)fis);
            List patchInfoMap = (List)configMap.get("patch_info");
            if (patchInfoMap == null) {
                log.warn("patchInfoMap is null, the configFile is {}", (Object)configFile);
                ArrayList<String> arrayList = itemIds;
                return arrayList;
            }
            patchInfoMap.forEach(itemMap -> itemIds.add((String)itemMap.get("item")));
            return itemIds;
        }
        catch (IOException e) {
            log.error("Parse config error.");
        }
        return itemIds;
    }

    private List<ItemInfo> parseAllPatchItemConfig(String file) {
        ArrayList<ItemInfo> itemInfos = new ArrayList<ItemInfo>();
        if (StringUtils.isNULLStr((String)file)) {
            log.info("The file path does not exist.");
            return itemInfos;
        }
        File configFile = new File(file);
        if (!configFile.exists()) {
            log.info("The file does not exist.");
            return itemInfos;
        }
        try (FileInputStream fis = new FileInputStream(configFile);){
            Yaml yamlConfig = new Yaml();
            String patchInfoJson = JSONUtils.toJson((Object)yamlConfig.load((InputStream)fis));
            PatchInfo patchInfo = (PatchInfo)JSONUtils.jsonToBean((String)patchInfoJson, PatchInfo.class);
            itemInfos.addAll(patchInfo.getPatchInfo());
        }
        catch (IOException e) {
            log.error("Parse config error.");
        }
        return itemInfos;
    }
}

