/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.task.state.based;

import com.huawei.ism.tool.service.annotations.Readonly;
import com.huawei.ism.tool.service.annotations.Stateful;
import com.huawei.ism.tool.service.task.state.based.Action;
import com.huawei.ism.tool.service.task.state.based.DefaultExecuteContext;
import com.huawei.ism.tool.service.task.state.based.ExecuteContext;
import com.huawei.ism.tool.service.task.state.based.ExtraData;
import com.huawei.ism.tool.service.task.state.based.TaskExecutor;
import com.huawei.ism.tool.service.task.state.based.exception.ErrorTransitionActionException;
import com.huawei.ism.tool.service.task.state.based.exception.ErrorTransitionMismatchException;
import com.huawei.ism.tool.service.task.state.based.exception.TaskExecutorException;
import com.huawei.ism.tool.service.task.state.based.transition.Transition;
import com.huawei.ism.tool.service.task.state.based.transition.TransitionPath;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateful
class DefaultTaskExecutor<S extends Enum<S>, E extends Enum<E>>
implements TaskExecutor<S, E> {
    private static final Logger log = LoggerFactory.getLogger(DefaultTaskExecutor.class);
    private final String id;
    private final Class<S> stateType;
    private final Class<E> eventType;
    private final S defaultInitialState;
    @Stateful
    private volatile S currentState;
    @Readonly
    private final Map<S, Action<S, E>> initialActions;
    @Readonly
    private final Map<S, Map<E, TransitionPath<S, E>>> transitions;
    @Stateful
    private final ExtraData extraData;

    @Override
    public Set<S> initialStates() {
        return EnumSet.copyOf(this.initialActions.keySet());
    }

    @Override
    public synchronized void start() {
        this.start(this.defaultInitialState);
    }

    @Override
    public void start(S initialState) {
        log.info("[{}] try to start with initial state: {}", (Object)this.id, initialState);
        if (!this.initialActions.containsKey(initialState)) {
            throw new TaskExecutorException("state [" + initialState + "] is not initial state");
        }
        if (this.currentState != null) {
            throw new TaskExecutorException("executor is already started, current state is [" + this.currentState + "]");
        }
        Optional<Enum> initialResult = Optional.empty();
        Action<Object, Object> initialAction = this.initialActions.get(initialState);
        if (initialAction != null) {
            log.info("[{}] executing initial action", (Object)this.id);
            initialResult = initialAction.execute(new DefaultExecuteContext<Object, Object>(null, initialState, null, this.extraData, this, null));
            log.info("[{}] initial action result event: {}", (Object)this.id, initialResult);
        } else {
            log.info("[{}] no initial action need to execute", (Object)this.id);
        }
        this.currentState = initialState;
        log.info("[{}] started with initial state: {}", (Object)this.id, this.currentState);
        initialResult.ifPresent(this::fireEventChain);
    }

    @Override
    public boolean isRunning() {
        return this.currentState != null;
    }

    private void checkRunning(S state) {
        if (state == null) {
            throw new TaskExecutorException("executor is not running yet");
        }
    }

    @Override
    public synchronized void fireEventChain(E event) {
        log.info("[{}] firing event chain from {} by {}", new Object[]{this.id, this.currentState, event});
        Object nextEvent = event;
        while (nextEvent != null) {
            nextEvent = this.fireEvent(nextEvent).orElse(null);
        }
        log.info("[{}] fired event chain to {}", (Object)this.id, this.currentState);
    }

    @Override
    public synchronized Optional<E> fireEvent(E event) {
        return this.fireEventWithErr(event, null);
    }

    private Optional<E> fireEventWithErr(E event, Exception transitError) {
        S source = this.currentState;
        log.info("[{}] firing event from {} by {}", new Object[]{this.id, source, event});
        this.checkRunning(source);
        TransitionPath<S, E> transitionPath = this.findTransition(event);
        if (transitionPath == null) {
            if (transitError != null) {
                throw new ErrorTransitionMismatchException(source, event, transitError);
            }
            throw new TaskExecutorException("event [" + event + "] is not accepted in state [" + source + "]");
        }
        DefaultExecuteContext<S, E> context = new DefaultExecuteContext<S, E>(source, transitionPath.target(), event, this.extraData, this, transitError);
        log.info("[{}] evaluating transition path with target state {}", (Object)this.id, transitionPath.target());
        Transition<S, E> transition = transitionPath.evaluate(context);
        log.info("[{}] evaluated transition path to target state {}", (Object)this.id, transition == null ? null : transition.target());
        if (transition == null) {
            if (transitError != null) {
                throw new ErrorTransitionMismatchException(source, event, transitError);
            }
            throw new TaskExecutorException("event <" + event + "> is not accepted in state <" + source + "> for transition <" + transitionPath + ">");
        }
        S target = transition.target();
        log.info("[{}] transiting from {} to {} by {}", new Object[]{this.id, source, target, event});
        try {
            Optional<E> nextEvent = transition.transit(this.getTransitContext(context, target));
            this.currentState = target;
            log.info("[{}] fired event to {}, result event is {}", new Object[]{this.id, target, nextEvent});
            return nextEvent;
        }
        catch (Exception exception) {
            if (transitError != null) {
                throw new ErrorTransitionActionException(source, event, transitError, exception);
            }
            E errEvent = transition.errEvent();
            if (errEvent == null) {
                throw exception;
            }
            log.error("[{}] transit error, re-transit to err state by err event {}", new Object[]{this.id, errEvent, exception});
            context.put("__ERR_TRANSITION_ID_KEY__", transition.id());
            return this.fireEventWithErr(errEvent, exception);
        }
    }

    private ExecuteContext<S, E> getTransitContext(DefaultExecuteContext<S, E> context, S target) {
        return context.targetState() != null ? context : new DefaultExecuteContext(context.sourceState(), target, context.event(), context.extraData(), context.executor(), context.error().orElse(null));
    }

    private TransitionPath<S, E> findTransition(E event) {
        Map<E, TransitionPath<S, E>> eventTransitions = this.transitions.get(this.currentState);
        return eventTransitions == null ? null : eventTransitions.get(event);
    }

    @Override
    public synchronized void reset() {
        this.currentState = null;
        this.clear();
    }

    @Override
    public <T> T get(Object key) {
        return this.extraData.get(key);
    }

    @Override
    public <T> Optional<T> get(Object key, @NotNull Class<T> type) {
        return this.extraData.get(key, type);
    }

    @Override
    public <T> T remove(Object key) {
        return this.extraData.remove(key);
    }

    @Override
    public <T> Optional<T> remove(Object key, @NotNull Class<T> type) {
        return this.extraData.remove(key, type);
    }

    @Override
    public void put(Object key, Object value) {
        this.extraData.put(key, value);
    }

    @Override
    public void clear() {
        this.extraData.clear();
    }

    @Override
    public String describe() {
        StringBuilder desc = new StringBuilder();
        this.appendBasicInfo(desc);
        this.appendTransitions(desc);
        return desc.toString();
    }

    private void appendBasicInfo(StringBuilder desc) {
        desc.append("Executor id: ").append(this.id).append(System.lineSeparator()).append("State type: ").append(this.stateType).append(System.lineSeparator()).append("Event type: ").append(this.eventType).append(System.lineSeparator()).append("Default initial state: ").append(this.defaultInitialState).append(System.lineSeparator()).append("All initial state: ").append(this.initialActions.keySet()).append(System.lineSeparator()).append("Current state: ").append(this.currentState).append(System.lineSeparator());
    }

    private void appendTransitions(StringBuilder desc) {
        desc.append("Transitions: ").append(System.lineSeparator());
        this.transitions.forEach((source, eventTransitions) -> eventTransitions.forEach((event, transition) -> desc.append("    ").append(transition).append(System.lineSeparator())));
    }

    public DefaultTaskExecutor(String id, Class<S> stateType, Class<E> eventType, S defaultInitialState, Map<S, Action<S, E>> initialActions, Map<S, Map<E, TransitionPath<S, E>>> transitions, ExtraData extraData) {
        this.id = id;
        this.stateType = stateType;
        this.eventType = eventType;
        this.defaultInitialState = defaultInitialState;
        this.initialActions = initialActions;
        this.transitions = transitions;
        this.extraData = extraData;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Class<S> stateType() {
        return this.stateType;
    }

    @Override
    public Class<E> eventType() {
        return this.eventType;
    }

    @Override
    public S defaultInitialState() {
        return this.defaultInitialState;
    }

    @Override
    public S currentState() {
        return this.currentState;
    }

    @Override
    public ExtraData extraData() {
        return this.extraData;
    }
}

