/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.task.state.based.transition;

import com.huawei.ism.tool.service.task.state.based.Action;
import com.huawei.ism.tool.service.task.state.based.Condition;
import com.huawei.ism.tool.service.task.state.based.ExecuteContext;
import com.huawei.ism.tool.service.task.state.based.transition.Transition;
import com.huawei.ism.tool.service.task.state.based.transition.TransitionPath;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class SingleTransitionPath<S extends Enum<S>, E extends Enum<E>>
implements TransitionPath<S, E>,
Transition<S, E> {
    private final int id;
    private final S source;
    private final S target;
    private final E event;
    @Nullable
    private final Condition<S, E> condition;
    @Nullable
    private final Action<S, E> action;
    @Nullable
    private final E errEvent;

    @Override
    public Transition<S, E> evaluate(ExecuteContext<S, E> context) {
        return this.condition == null || this.condition.matches(context) ? this : null;
    }

    @Override
    public Optional<E> transit(ExecuteContext<S, E> context) {
        return this.action == null ? Optional.empty() : this.action.execute(context);
    }

    public String toString() {
        return "SINGLE:" + this.source + "==<" + this.event + ">==>" + this.target + (this.condition == null ? (this.action == null ? "" : "(A)") : (this.action == null ? "(C)" : "(C|A)")) + (this.errEvent == null ? "" : "(E:" + this.errEvent + ")") + ":" + this.id;
    }

    @Override
    public int id() {
        return this.id;
    }

    public S source() {
        return this.source;
    }

    @Override
    public S target() {
        return this.target;
    }

    public E event() {
        return this.event;
    }

    @Nullable
    public Condition<S, E> condition() {
        return this.condition;
    }

    @Nullable
    public Action<S, E> action() {
        return this.action;
    }

    @Override
    @Nullable
    public E errEvent() {
        return this.errEvent;
    }

    public SingleTransitionPath(int id, S source, S target, E event, @Nullable Condition<S, E> condition, @Nullable Action<S, E> action, @Nullable E errEvent) {
        this.id = id;
        this.source = source;
        this.target = target;
        this.event = event;
        this.condition = condition;
        this.action = action;
        this.errEvent = errEvent;
    }
}

