/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service;

import com.huawei.ism.tool.devicemanager.service.AbstractDeviceService;
import com.huawei.ism.tool.devicemanager.service.DeviceAddService;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.util.NetUtil;
import java.util.List;
import org.slf4j.Logger;

public class DeviceImportService
extends AbstractDeviceService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DeviceImportService.class);
    private DeviceAddService deviceAddService = new DeviceAddService();

    public TaskResult importDevice(DevNode devNode) {
        if (!this.checkDeviceIsInvalid(devNode)) {
            LOGGER.error("parse error");
            return null;
        }
        TaskResult addDeviceResult = null;
        addDeviceResult = null != devNode.getItDeviceType() && (ItDeviceType.Storage.equals((Object)devNode.getItDeviceType()) || ItDeviceType.COMPUTE_STORAGE.equals((Object)devNode.getStorageDeviceType())) || ItDeviceType.FUSIONCUBE.equals((Object)devNode.getItDeviceType()) ? this.deviceAddService.addDeviceParallel(null, devNode, false) : this.deviceAddService.addDevice(devNode, DeviceOpr.IMPORT);
        if (null == addDeviceResult) {
            return null;
        }
        if (addDeviceResult.getResult() == TaskResult.Result.SUCCESS) {
            addDeviceResult.setErrorLocaleDescription("devicemanager.layout.device.import.success");
            addDeviceResult.setErrorId("devicemanager.layout.device.import.success");
        }
        if (this.handleMutiduplicate(devNode)) {
            return addDeviceResult;
        }
        if (addDeviceResult.getErrorLocaleDescription().equals("devicemanager.layout.device.add.deviceadddialog.deviceduplicate")) {
            addDeviceResult.setErrorLocaleDescription("devicemanager.layout.device.add.deviceadddialog.deviceduplicate");
            addDeviceResult.setErrorId("devicemanager.layout.device.add.deviceadddialog.deviceduplicate");
            addDeviceResult.setResult(TaskResult.Result.FAILED);
        }
        return addDeviceResult;
    }

    private boolean handleMutiduplicate(DevNode devNode) {
        List<DevNode> devNodes = DefaultNodeProviderImpl.getInstance().getNodeList();
        List devIpList = devNode.getIpList();
        for (String string : devIpList) {
            for (DevNode dev : devNodes) {
                if (!string.equals(dev.getIp())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkDeviceIsInvalid(DevNode devNode) {
        boolean ipIsOk = NetUtil.isValidIP((String)devNode.getIp());
        String pwd = devNode.getLoginUser().getPassword();
        boolean passwdOk = !StringUtils.isNULLStr((String)pwd);
        boolean usernameOK = !StringUtils.isNULLStr((String)devNode.getLoginUser().getUserName());
        return ipIsOk && passwdOk && usernameOK;
    }
}

