/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.dev.infoqry;

import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.FsClusterNode;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.service.builder.FusionComputeRestBuildService;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.ClusterNodeStatus;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.enums.FsmRole;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.FusionComputeRestUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionComputeNodeQuery
implements INodeTypeQuery {
    private static final Logger log = LoggerFactory.getLogger(FusionComputeNodeQuery.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\d+(?:\\.\\d)+\\.([Ss][Pp][Hh]|[Ss][Pp][Cc]|[Hh][Pp])?\\d+");
    private static final Pattern HOST_ID_PATTERN = Pattern.compile("\\d+");

    @Override
    public TaskResult queryNodeInfo(DevNode devNode, DeviceOpr opr) {
        return this.queryNodeInfo(devNode, opr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult queryNodeInfo(DevNode devNode, DeviceOpr opr, ProgressDialog progressDialog) {
        TaskResult taskResult = new TaskResult();
        try {
            this.queryBySsh(devNode);
            this.queryByRest(devNode);
            taskResult.setResult(TaskResult.Result.SUCCESS);
        }
        catch (ToolException e) {
            taskResult.setResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(e.getErrorLocaleDescription());
        }
        finally {
            RestConnectionManager.releaseFusionComputeConnection(devNode);
        }
        return taskResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryBySsh(DevNode devNode) throws ToolException {
        ICliConnection sshConnection = SshConnectionManager.getSshConnection((DevNode)devNode);
        try {
            String catVersionCmd = "cat /opt/galax/version/GalaxVersion.cfg";
            String result = sshConnection.execCmdWithTimout(catVersionCmd, 10);
            if ("TOOLKIT_SEND_CMD_TIME_OUT".equals(result)) {
                log.warn("query fusioncompute:{} version error with timeout", (Object)devNode.getIp());
                return;
            }
            Matcher matcher = VERSION_PATTERN.matcher(result);
            if (matcher.find()) {
                devNode.setProductVersion(matcher.group());
            }
        }
        finally {
            SshConnectionManager.releaseConnection((ICliConnection)sshConnection);
        }
    }

    private void queryByRest(DevNode devNode) throws ToolException {
        RestConnection connection = this.getRestConnection(devNode);
        this.querySiteName(connection, devNode);
        this.querySn(connection, devNode);
        this.queryCnaNodes(connection, devNode);
        this.queryVrmNodes(connection, devNode);
        this.queryVrmInPyhsicDeploy(connection, devNode);
        DefaultNodeProviderImpl.getInstance().addNode(devNode);
    }

    private void queryVrmInPyhsicDeploy(RestConnection connection, DevNode devNode) throws ToolException {
        if (devNode.getClusterNodes().stream().anyMatch(node -> "vrm".equals(node.getDeviceType()))) {
            log.info("not physic deploy scene");
            return;
        }
        String url = FusionComputeRestUtils.getQueryVrmPhysicUrl(devNode, connection.getBaseUrl());
        ResponseInfo responseInfo = connection.execGet(url);
        JSONObject jsonObject = new JSONObject(responseInfo.getContent());
        if (!jsonObject.has("vrms")) {
            log.warn("query physic vrms faield");
        }
        JSONArray jsonArray = jsonObject.getJSONArray("vrms");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject vrmNodeJson = jsonArray.getJSONObject(i);
            FsClusterNode vrmNode = this.buildPhysicVrmNode(vrmNodeJson);
            devNode.getClusterNodes().add(vrmNode);
        }
    }

    private FsClusterNode buildPhysicVrmNode(JSONObject vrmNodeJson) {
        FsClusterNode fsClusterNode = new FsClusterNode();
        fsClusterNode.setSerialNumber(vrmNodeJson.getStringOrDefault("urn", ""));
        fsClusterNode.setManagementIp(vrmNodeJson.getStringOrDefault("ip", ""));
        fsClusterNode.setDeviceType("vrm");
        if ("true".equalsIgnoreCase(vrmNodeJson.getStringOrDefault("isMaster", "false"))) {
            fsClusterNode.getRoles().add(FsmRole.ACTIVE.name());
            return fsClusterNode;
        }
        fsClusterNode.getRoles().add(FsmRole.STANDBY.name());
        return fsClusterNode;
    }

    private void querySn(RestConnection connection, DevNode devNode) throws ToolException {
        devNode.setDeviceSerialNumber(devNode.getIp());
    }

    private void querySiteName(RestConnection connection, DevNode devNode) throws ToolException {
        String baseUrl = FusionComputeRestUtils.getBaseUrl(devNode);
        ResponseInfo responseInfo = connection.execGet(baseUrl);
        JSONObject jsonObject = new JSONObject(responseInfo.getContent());
        if (jsonObject.has("sites")) {
            JSONArray sites = jsonObject.getJSONArray("sites");
            if (sites.length() < 1) {
                return;
            }
            JSONObject siteObj = sites.getJSONObject(0);
            if (siteObj.has("name")) {
                devNode.setDeviceName(siteObj.getStringOrDefault("name", ""));
            }
        }
    }

    private void queryVrmNodes(RestConnection connection, DevNode devNode) throws ToolException {
        String queryHostUrl = FusionComputeRestUtils.getQueryVrmNodeUrl(devNode, connection.getBaseUrl());
        ResponseInfo responseInfo = connection.execGet(queryHostUrl);
        FusionComputeRestUtils.checkResponse(responseInfo);
        JSONObject jsonObject = new JSONObject(responseInfo.getContent());
        if (!jsonObject.has("vms")) {
            devNode.setClusterNodes(new ArrayList());
            return;
        }
        String result = this.queryVrmIpsBySsh(devNode);
        JSONArray hosts = jsonObject.getJSONArray("vms");
        List clusterNodes = IntStream.range(0, hosts.length()).mapToObj(arg_0 -> ((JSONArray)hosts).getJSONObject(arg_0)).map(vmNode -> this.buildVrmNode((JSONObject)vmNode, devNode)).filter(vmNode -> !StringUtils.isNULLStr((String)vmNode.getManagementIp())).collect(Collectors.toList());
        List vrmNodes = clusterNodes.stream().filter(node -> result.contains(node.getManagementIp())).collect(Collectors.toList());
        if (!vrmNodes.isEmpty()) {
            clusterNodes.stream().filter(node -> node.getRoles().contains(FsmRole.ACTIVE.name())).findFirst().ifPresent(node -> {
                if (vrmNodes.stream().noneMatch(vrm -> vrm.getManagementIp().equals(node.getManagementIp()))) {
                    vrmNodes.add(node);
                }
            });
            devNode.getClusterNodes().addAll(vrmNodes);
            return;
        }
        devNode.getClusterNodes().addAll(clusterNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryVrmIpsBySsh(DevNode devNode) throws ToolException {
        ICliConnection sshConnection = SshConnectionManager.getSshConnection((DevNode)devNode);
        try {
            String catVersionCmd = "cat /opt/galax/data/ha/hainfo";
            String result = sshConnection.execCmdWithTimout(catVersionCmd, 10);
            if ("TOOLKIT_SEND_CMD_TIME_OUT".equals(result)) {
                log.warn("query fusioncompute:{} vrm info error with timeout", (Object)devNode.getIp());
            }
            String string = result;
            return string;
        }
        finally {
            SshConnectionManager.releaseConnection((ICliConnection)sshConnection);
        }
    }

    private FsClusterNode buildVrmNode(JSONObject jsonObject, DevNode devNode) {
        FsClusterNode fsClusterNode = new FsClusterNode();
        fsClusterNode.setName(jsonObject.getStringOrDefault("name", ""));
        JSONObject nicNode = FusionComputeNodeQuery.getNicNodes(jsonObject);
        String ip = nicNode.getStringOrDefault("ip", "");
        if (StringUtils.isNULLStr((String)ip)) {
            return fsClusterNode;
        }
        fsClusterNode.setManagementIp(FusionComputeNodeQuery.parseIp(devNode, ip));
        fsClusterNode.setSerialNumber(jsonObject.getStringOrDefault("urn", fsClusterNode.getManagementIp()));
        fsClusterNode.setDeviceType("vrm");
        fsClusterNode.setDeviceId(FusionComputeNodeQuery.getHostId(jsonObject.getStringOrDefault("hostUrn", "")));
        if (fsClusterNode.getManagementIp().equals(devNode.getIp())) {
            fsClusterNode.getRoles().add(FsmRole.ACTIVE.name());
            return fsClusterNode;
        }
        fsClusterNode.getRoles().add(ip.contains("-") ? FsmRole.ACTIVE.name() : FsmRole.STANDBY.name());
        return fsClusterNode;
    }

    private static String getHostId(String urn) {
        String id = urn;
        Matcher matcher = HOST_ID_PATTERN.matcher(urn);
        while (matcher.find()) {
            id = matcher.group();
        }
        return id;
    }

    private static String parseIp(DevNode devNode, String ip) {
        if (!ip.contains("-")) {
            return ip;
        }
        return Arrays.stream(ip.split("-")).filter(vrmIp -> !devNode.getIp().equals(vrmIp)).findFirst().orElseGet(() -> ip.split("-")[0]);
    }

    private static JSONObject getNicNodes(JSONObject jsonObject) {
        JSONObject configObj = jsonObject.getJSONObject("vmConfig");
        if (Objects.isNull(configObj)) {
            return new JSONObject();
        }
        JSONArray jsonArray = configObj.getJSONArray("nics");
        if (Objects.isNull(jsonArray)) {
            return new JSONObject();
        }
        return jsonArray.getJSONObject(0);
    }

    private void queryCnaNodes(RestConnection connection, DevNode devNode) throws ToolException {
        String queryHostUrl = FusionComputeRestUtils.getQueryHostUrl(devNode, connection.getBaseUrl());
        ResponseInfo responseInfo = connection.execGet(queryHostUrl);
        FusionComputeRestUtils.checkResponse(responseInfo);
        JSONObject jsonObject = new JSONObject(responseInfo.getContent());
        if (!jsonObject.has("hosts")) {
            devNode.setClusterNodes(new ArrayList());
            return;
        }
        JSONArray hosts = jsonObject.getJSONArray("hosts");
        devNode.setClusterNodes(IntStream.range(0, hosts.length()).mapToObj(arg_0 -> ((JSONArray)hosts).getJSONObject(arg_0)).map(this::buildClusterNode).collect(Collectors.toList()));
    }

    private FsClusterNode buildClusterNode(JSONObject jsonObject) {
        FsClusterNode clusterNode = new FsClusterNode();
        clusterNode.setManagementIp(jsonObject.getStringOrDefault("ip", ""));
        clusterNode.setStatus(ClusterNodeStatus.ofWithState((String)jsonObject.getStringOrDefault("status", "")));
        clusterNode.setName(jsonObject.getStringOrDefault("name", ""));
        clusterNode.setDeviceType("cna");
        clusterNode.setSerialNumber(jsonObject.getStringOrDefault("urn", clusterNode.getManagementIp()));
        clusterNode.setDeviceId(FusionComputeNodeQuery.getHostId(jsonObject.getStringOrDefault("urn", "")));
        return clusterNode;
    }

    private RestConnection getRestConnection(DevNode devNode) throws ToolException {
        RestConnection connection = RestConnectionManager.getRestConnectionWithBuildService(devNode, new FusionComputeRestBuildService());
        if (Objects.isNull(connection) || !connection.isLogin()) {
            throw new ToolException("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror", new Object[]{devNode.getIp()});
        }
        return connection;
    }
}

