/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.DeveloperModeCheck;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import org.slf4j.LoggerFactory;

public class DebugPwdStepDialog
extends PublicDialog {
    private static final long serialVersionUID = 9080689851744812485L;
    private static final Dimension SIZE = new Dimension(390, 275);
    private static final Dimension SIZE_ZH = new Dimension(360, 235);
    private JPasswordField developerPwd;
    private JCheckBox useDebug;
    private boolean checkOK = false;
    private String toolName = "";

    public DebugPwdStepDialog(JFrame parent, String toolName) {
        super(parent);
        this.toolName = toolName;
        this.init();
        this.addListeners();
    }

    private boolean checkDebugPwd(String dpwd) {
        List result = AsyncExcutor.execute((Window)((Object)this), (Callable[])new Callable[]{new CheckDebugPwdThread(dpwd)});
        boolean succ = (Boolean)result.get(0);
        return succ;
    }

    private void addListeners() {
        JButton okBtn = this.getOkBtn();
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugPwdStepDialog.this.checkDebug();
            }
        });
        this.useDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugPwdStepDialog.this.developerPwd.setEnabled(!DebugPwdStepDialog.this.useDebug.isSelected());
            }
        });
    }

    private void checkDebug() {
        if (this.useDebug.isSelected()) {
            this.checkOK = true;
            this.setVisible(false);
            return;
        }
        String dpwd = String.valueOf(this.developerPwd.getPassword());
        if (StringUtils.isNULLStr((String)dpwd)) {
            dpwd = null;
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"toolbox.showinfo.debugisnull"));
            return;
        }
        if (!this.checkDebugPwd(dpwd)) {
            dpwd = null;
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"toolbox.showinfo.debugiswrong"));
            return;
        }
        this.checkOK = true;
        dpwd = null;
        this.setVisible(false);
    }

    private void init() {
        this.setTitle(ResourceUtil.getString((String)"toolbox.showinfo.title"));
        this.add(UiMethod.buildFrameSpace((JComponent)this.buildJComponent(), (int)12));
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            this.setPreferredSize(SIZE);
        } else {
            this.setPreferredSize(SIZE_ZH);
        }
        this.setModal(true);
        this.setResizable(false);
        this.validate();
        this.pack();
        SwingUtil.putScreenCenter((Window)((Object)this));
    }

    private JComponent buildJComponent() {
        this.developerPwd = UiMethod.getPasswordFiled();
        this.useDebug = new JCheckBox(ResourceUtil.getStringWithParams((String)"toolbox.showinfo.usedebug", (Object[])new Object[]{this.toolName}));
        JLabel pwdLabel = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"toolbox.login.developer"));
        JTextArea descLabel = UiMethod.createJTextArea((String)ResourceUtil.getStringWithParams((String)"toolbox.showinfo.needdebug", (Object[])new Object[]{this.toolName}));
        JComponent rightCom = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{descLabel}), UCD.buildHBoxLeft((Component[])new Component[]{pwdLabel, this.developerPwd}), UCD.buildHBoxLeft((Component[])new Component[]{this.useDebug}), Box.createVerticalGlue()});
        JLabel iconLabel = new JLabel(ResourceUtil.getImage((String)"Information.png"));
        return UCD.buildHorizotalBox(null, (Component[])new Component[]{iconLabel, rightCom});
    }

    public boolean isCheckOK() {
        return this.checkOK;
    }

    private static class CheckDebugPwdThread
    implements Callable<Boolean> {
        private String dpwd = "";

        public CheckDebugPwdThread(String dpwd) {
            this.dpwd = dpwd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            ICliConnection sshConn;
            DevNode node;
            block4: {
                Boolean bl;
                node = DefaultNodeProviderImpl.getInstance().getNodeList().get(0);
                node.setDeveloperPwd(this.dpwd);
                sshConn = null;
                try {
                    sshConn = SshConnectionManager.getSshConnection((DevNode)node, null, (boolean)true, (boolean)false);
                    TaskResult result = DeveloperModeCheck.checkDeveloperPwd(sshConn, node);
                    if (!TaskResult.Result.SUCCESS.equals((Object)result.getResult())) break block4;
                    bl = true;
                }
                catch (Exception e) {
                    try {
                        LoggerFactory.getLogger(this.getClass()).error("check debug pwd error. ", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SshConnectionManager.releaseConnection(sshConn);
                        throw throwable;
                    }
                    SshConnectionManager.releaseConnection((ICliConnection)sshConn);
                }
                SshConnectionManager.releaseConnection((ICliConnection)sshConn);
                return bl;
            }
            SshConnectionManager.releaseConnection((ICliConnection)sshConn);
            node.setDeveloperPwd("");
            return false;
        }
    }
}

