/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.devicemanager.ui.context.DeviceSceneContext;
import com.huawei.ism.tool.devicemanager.ui.dialog.FcvSelectControllerEnclosureJDialogLayout;
import com.huawei.ism.tool.devicemanager.ui.listener.ScenePreparedMainJDialogListener;
import com.huawei.ism.tool.devicemanager.utils.DeviceForbidLoginUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.obase.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.obase.ui.tablecompositer.IpAddressStrategy;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.UIManager;
import javax.swing.plaf.RootPaneUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FcvSelectControllerEnclosureJDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(FcvSelectControllerEnclosureJDialog.class);
    private static final long serialVersionUID = 1L;
    private static final int SN_NUMBER_ONE_LINE = 3;
    private boolean isSingleDev;
    private FcvSelectControllerEnclosureJDialogLayout mainLayout;
    private WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
    private DeviceSceneContext context = DeviceSceneContext.getInstance();
    private Window parent;
    private Map<String, TableRow> snRow = new HashMap<String, TableRow>();
    private List<DevNode> storageDevNodeList = new ArrayList<DevNode>();

    public FcvSelectControllerEnclosureJDialog(Window parent, List<DevNode> storageNodeList) {
        super(parent);
        this.parent = parent;
        this.isSingleDev = DeviceSceneContext.getInstance().isSingleDev();
        this.initUI();
        this.initData(storageNodeList);
        this.addListener();
    }

    public FcvSelectControllerEnclosureJDialog(Window parent, List<DevNode> storageNodeList, boolean isSingleDev) {
        super(parent);
        this.parent = parent;
        this.isSingleDev = isSingleDev;
        this.initUI();
        this.initData(storageNodeList);
        this.addListener();
    }

    private void initUI() {
        this.getRootPane().setUI((RootPaneUI)this.rootPaneUI);
        this.mainLayout = new FcvSelectControllerEnclosureJDialogLayout(this.isSingleDev);
        this.add(this.mainLayout);
        this.setTitle(ResourceUtil.getString((String)"scene.adddevice.computeStorageSelect.title"));
        this.setModal(true);
        this.setResizable(false);
        this.validate();
        this.pack();
        this.setDefaultCloseOperation(0);
        SwingUtil.putParentCenter((Window)this, (Window)this.parent);
    }

    private void initData(List<DevNode> storageDevList) {
        this.mainLayout.getDeviceTable().removeAll();
        List<DevNode> devsXML = DeviceForbidLoginUtil.filterForbidDevContainsShowErrMsg(SceneXmlData.getInstance().loadSceneFromFile());
        for (DevNode dev : storageDevList) {
            this.mainLayout.getDeviceTableModel().addRow(new TableRow[]{this.createTableRow(dev)});
            int row = this.mainLayout.getDeviceTable().getRowCount() - 1;
            this.isSelecteDev(dev, devsXML, row);
        }
        if (DeviceSceneContext.getInstance().isSingleDev() && !storageDevList.isEmpty()) {
            List markRows = this.mainLayout.getDeviceTable().getMarkedRows();
            if (Utils.isNullList((List)markRows)) {
                return;
            }
            this.settingHyperRemoteDev(storageDevList, markRows);
        }
    }

    private void settingHyperRemoteDev(List<DevNode> storageDevList, List<TableRow> markRows) {
        DevNode dev = (DevNode)markRows.get(0).getUserObject();
        if (!dev.isHyperMetro()) {
            return;
        }
        storageDevList.forEach(remoteDev -> {
            String remoteSn = remoteDev.getDeviceSerialNumber();
            if (dev.getRemoteSNs().contains(remoteSn)) {
                this.setColor(this.snRow.get(remoteSn), UIManager.getColor("Table.rolloverColor"));
                this.addRelatedDevNode((DevNode)remoteDev);
            }
        });
    }

    private void isSelecteDev(DevNode dev, List<DevNode> devsXML, int row) {
        if (CollectionUtil.isEmpty(devsXML)) {
            return;
        }
        devsXML.stream().filter(devNode -> devNode.getDeviceSerialNumber().equalsIgnoreCase(dev.getDeviceSerialNumber())).forEach(devNode -> this.mainLayout.getDeviceTable().addRowSelectionInterval(row, row));
    }

    private void addListener() {
        this.addWindowListener(new ScenePreparedMainJDialogListener(this){

            @Override
            public void okCallback() {
            }

            @Override
            public void cancelCallback() {
                FcvSelectControllerEnclosureJDialog.this.setDefaultCloseOperation(0);
            }
        });
        this.mainLayout.getOkBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FcvSelectControllerEnclosureJDialog.this.setSelectedDevNode();
                if (FcvSelectControllerEnclosureJDialog.this.judgeDevsIsEmpty(FcvSelectControllerEnclosureJDialog.this.storageDevNodeList)) {
                    log.info("not select controller enclosure.");
                    return;
                }
                FcvSelectControllerEnclosureJDialog.this.dispose();
            }
        });
        this.mainLayout.getCancleBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.info("click cacel btn, not select controller enclosure.");
                FcvSelectControllerEnclosureJDialog.this.dispose();
            }
        });
    }

    private boolean judgeDevsIsEmpty(List<DevNode> devs) {
        if (devs.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"scene.remind.selectnodevice"));
            return true;
        }
        return false;
    }

    private TableRow<DevNode, String> createTableRow(DevNode dev) {
        DefaultTableRow row = new DefaultTableRow(this.mainLayout.getTableColumn(), (Object)dev, (Object)dev.getDeviceSerialNumber());
        int rowIndex = 0;
        if (dev.isHyperMetro()) {
            IsmTableCell.TextIconCell cell = new IsmTableCell.TextIconCell(dev.getDeviceType().toString(), (Icon)ResourceUtil.getImage((String)"hyperMetroIcon.png"));
            String sns = dev.getRemoteSNs().toString();
            sns = sns.substring(sns.indexOf(91) + 1, sns.indexOf(93));
            sns = this.cutTooLongSns2Lines(sns);
            cell.setTips(ResourceUtil.getStringWithParams((String)"devicemanager.layout.hypermetro.device.tips", (Object[])new Object[]{sns}));
            row.setValueAt(rowIndex++, (Object)cell);
        } else {
            row.setValueAt(rowIndex++, (Object)new IsmTableCell.TextCell(dev.getDeviceType().toString()));
        }
        String deviceName = dev.getDeviceName();
        row.setValueAt(rowIndex++, (Object)new IsmTableCell.TextCell(deviceName));
        row.setValueAt(rowIndex++, (Object)new IsmTableCell.TextCell(dev.getProductVersion()));
        row.setValueAt(rowIndex++, (Object)new IsmTableCell.TextCell(new IpAddressStrategy(dev.getIp()).toString()));
        String userName = dev.getLoginUser().getUserName();
        row.setValueAt(rowIndex++, (Object)new IsmTableCell.TextCell(userName));
        String fcvIp = dev.getComputeStorageDevNode().getFcvIp();
        row.setValueAt(rowIndex++, (Object)new IsmTableCell.TextCell(fcvIp));
        this.snRow.put(dev.getDeviceSerialNumber(), (TableRow)row);
        return row;
    }

    private String cutTooLongSns2Lines(String sns) {
        String[] snsList = sns.split(",");
        StringBuilder snsParsed = new StringBuilder();
        for (int poi = 0; poi < snsList.length; ++poi) {
            if (poi != 0 && poi % 3 == 0) {
                snsParsed.append(snsList[poi] + ",<br/>");
                continue;
            }
            if (poi + 1 == snsList.length) {
                snsParsed.append(snsList[poi]);
                continue;
            }
            snsParsed.append(snsList[poi] + ",");
        }
        return snsParsed.toString();
    }

    private boolean needDoCascadeOp(DevNode dev, TableRow<DevNode, String> row) {
        if (dev.isHyperMetro()) {
            return this.mainLayout.getDeviceTable().getMarkedRows().stream().map(tableRow -> (DevNode)tableRow.getUserObject()).map(DevNode::getDeviceSerialNumber).anyMatch(sn -> dev.getRemoteSNs().contains(sn));
        }
        return false;
    }

    public void setHelpActionCallBack(IHelpActionCallBack helpActionCallBack) {
        this.rootPaneUI.setHelpActionCallBack(helpActionCallBack);
        this.rootPaneUI.setHelpIconNotShown();
    }

    public void addRelatedDevNode(DevNode dev) {
        if (!this.storageDevNodeList.contains(dev)) {
            this.storageDevNodeList.add(dev);
        }
    }

    private void setColor(TableRow tableRow, Color col) {
        for (int i = 0; i < tableRow.getColumnCount(); ++i) {
            if (!(tableRow.getValueAt(i) instanceof IsmTableCell)) continue;
            IsmTableCell cell = (IsmTableCell)tableRow.getValueAt(i);
            cell.setColor(col);
        }
    }

    private void setSelectedDevNode() {
        int[] rowIndexs = this.getMainLayout().getDeviceTable().getSelectedRows();
        if (rowIndexs == null || rowIndexs.length == 0) {
            return;
        }
        for (int index : rowIndexs) {
            index = this.getMainLayout().getDeviceTable().convertRowIndexToModel(index);
            TableRow row = this.getMainLayout().getDeviceTableModel().getRow(index);
            this.addRelatedDevNode((DevNode)row.getUserObject());
        }
    }

    public boolean isSingleDev() {
        return this.isSingleDev;
    }

    public FcvSelectControllerEnclosureJDialogLayout getMainLayout() {
        return this.mainLayout;
    }

    public WizardRootPaneUI getRootPaneUI() {
        return this.rootPaneUI;
    }

    public DeviceSceneContext getContext() {
        return this.context;
    }

    @Override
    public Window getParent() {
        return this.parent;
    }

    public Map<String, TableRow> getSnRow() {
        return this.snRow;
    }

    public List<DevNode> getStorageDevNodeList() {
        return this.storageDevNodeList;
    }

    public void setSingleDev(boolean isSingleDev) {
        this.isSingleDev = isSingleDev;
    }

    public void setMainLayout(FcvSelectControllerEnclosureJDialogLayout mainLayout) {
        this.mainLayout = mainLayout;
    }

    public void setRootPaneUI(WizardRootPaneUI rootPaneUI) {
        this.rootPaneUI = rootPaneUI;
    }

    public void setContext(DeviceSceneContext context) {
        this.context = context;
    }

    public void setParent(Window parent) {
        this.parent = parent;
    }

    public void setSnRow(Map<String, TableRow> snRow) {
        this.snRow = snRow;
    }

    public void setStorageDevNodeList(List<DevNode> storageDevNodeList) {
        this.storageDevNodeList = storageDevNodeList;
    }

    public static class OpenHelpCallBack
    implements IHelpActionCallBack {
        private JDialog parentDlg = null;

        public OpenHelpCallBack(JDialog dlg) {
            this.parentDlg = dlg;
        }

        public void doHelpActionWork() {
            FileUtils.openHelpFile((String)"SencePrepare\\Prepare", (Window)this.parentDlg, (String)".chm");
        }

        public String getListenerName() {
            return "Open SencePrepare help file";
        }
    }
}

