/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceTypePaneLayout;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.AbstractAddDeviceLayout;
import com.huawei.ism.tool.devicemanager.ui.dialog.listener.DeviceTypeChangeListener;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubui.entity.DeviceDialogType;
import com.huawei.ism.tool.framework.pubui.entity.DeviceManageSetting;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.SettingType;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SceneDeviceAddDialog
extends DeviceAddDialog {
    private static final Map<ItDeviceType, List<String>> DEVICE_TYPE_MAP = Collections.singletonMap(ItDeviceType.Host, Collections.singletonList("Linux"));
    private final JPanel showLayout;
    private final DeviceTypePaneLayout deviceTypePaneLayout;
    private AbstractAddDeviceLayout currentLayout;
    private JComponent concatComponent;

    public SceneDeviceAddDialog(Window parent, DeviceManageSetting setting, INodeTypeQuery nodeTypeQuery, DeviceAddDialog.InfoTips tips) {
        super(parent, nodeTypeQuery, tips, DeviceDialogType.All, SettingType.Socks5Proxy, SettingType.SshForward);
        this.remove(this.layout);
        this.showLayout = new JPanel();
        this.deviceTypePaneLayout = new DeviceTypePaneLayout(this.layout, setting.getItDeviceList());
        this.initUi();
        this.bindListener();
        this.deviceTypePaneLayout.setItDeviceTypel2(setting.getItDeviceList(), DEVICE_TYPE_MAP);
    }

    private void bindListener() {
        this.deviceTypePaneLayout.addDeviceTypeItemChangeListener(new DeviceTypeChangeListener(this));
        this.deviceTypePaneLayout.getl2Type().addItemListener(event -> {
            Object devType = this.layout.getDevTypePane().getl2Type().getSelectedItem();
            boolean isWindows = devType != null && devType.toString().equals("Windows");
            this.layout.showPort(!isWindows);
            this.layout.enableCustAuth(!isWindows);
            this.layout.getProxySelectPan().setVisible(!isWindows);
            this.layout.setIsDebugPwVisible(this.deviceTypePaneLayout);
        });
    }

    private void initUi() {
        this.initFirstLayout();
        this.concatComponent = UCD.buildVerticalBox(null, (Component[])new Component[]{this.deviceTypePaneLayout, this.layout});
        this.showLayout.add(this.concatComponent);
        this.add(this.showLayout);
        this.pack();
    }

    private void initFirstLayout() {
        this.currentLayout = this.layout;
        this.getRootPane().setDefaultButton(this.currentLayout.getDefaultButton());
        this.getRootPane().setDefaultButton(this.layout.getNextBtn());
        if (LanguageManager.getInstance().getCurrentLanguage().equals(Locale.ENGLISH)) {
            this.currentLayout.setPreferredSize(new Dimension(500, 500));
        } else {
            this.currentLayout.setPreferredSize(new Dimension(415, 500));
        }
        this.layout.getDevTypePane().setVisible(false);
    }

    public void replaceCurrentLayout(AbstractAddDeviceLayout jPanel) {
        this.hiddenCurrentLayout();
        this.updateCurrentLayout(jPanel);
    }

    private void updateCurrentLayout(AbstractAddDeviceLayout jPanel) {
        this.concatComponent.remove(this.currentLayout);
        this.currentLayout = jPanel;
        this.concatComponent.add(this.currentLayout);
        this.getRootPane().setDefaultButton(this.currentLayout.getDefaultButton());
        this.pack();
        this.repaint();
    }

    @Override
    protected void resetRootVisible() {
        boolean rootFlag = !this.layout.getUsername().getText().isEmpty() && !"root".equalsIgnoreCase(this.layout.getUsername().getText());
        boolean needCheckSwitchRoot = this.needCheckSwitchRoot();
        if (needCheckSwitchRoot && rootFlag) {
            this.layout.setRootPwEnableForLastbtn(needCheckSwitchRoot && rootFlag, true);
        } else {
            super.resetRootVisible();
        }
    }

    private void hiddenCurrentLayout() {
        if (!this.currentLayout.equals(this.layout)) {
            this.currentLayout.setEnabled(false);
        }
    }

    public AbstractAddDeviceLayout getDefaultPaneLayout() {
        return this.layout;
    }

    public void setTabState() {
        this.layout.setTabState(1);
        this.transState();
    }

    @Override
    protected boolean needCheckSwitchRoot() {
        if (Objects.isNull(this.deviceTypePaneLayout)) {
            return true;
        }
        if (ItDeviceType.Host.equals(this.deviceTypePaneLayout.getItDevType().getSelectedItem())) {
            this.layout.rootPwCheck.setEnabled(false);
            return true;
        }
        this.layout.rootPwCheck.setEnabled(true);
        return false;
    }

    @Override
    protected boolean needSocks5() {
        if (Objects.isNull(this.deviceTypePaneLayout)) {
            return true;
        }
        return !ItDeviceType.Host.equals(this.deviceTypePaneLayout.getItDevType().getSelectedItem());
    }

    @Override
    protected boolean needSshForward() {
        if (Objects.isNull(this.deviceTypePaneLayout)) {
            return true;
        }
        return !ItDeviceType.Host.equals(this.deviceTypePaneLayout.getItDevType().getSelectedItem());
    }

    @Override
    protected boolean isNeedProxy() {
        if (Objects.isNull(this.deviceTypePaneLayout)) {
            return true;
        }
        return !ItDeviceType.Host.equals(this.deviceTypePaneLayout.getItDevType().getSelectedItem());
    }

    @Override
    protected DeviceTypePaneLayout getTypeSelectPanel() {
        if (Objects.isNull(this.deviceTypePaneLayout)) {
            return this.layout.getDevTypePane();
        }
        return this.deviceTypePaneLayout;
    }

    @Override
    protected boolean isDeviceSupported(List<Callable<DevNode>> calls, DevNode device, Map<ItDeviceType, List<String>> supportedTyeMap) {
        if (DeviceAddUtil.isReplaceCertScene()) {
            calls.add(new DeviceAddDialog.FetchDevNodeCall(this, device));
            return true;
        }
        return super.isDeviceSupported(calls, device, supportedTyeMap);
    }
}

