/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.layout.aistorage;

import com.huawei.ism.tool.devicemanager.ui.dialog.component.ScrollTablePanel;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.AbstractLoginPanel;
import com.huawei.ism.tool.devicemanager.ui.dialog.listener.BatchAuthZoneListener;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneLoginPanel
extends AbstractLoginPanel {
    private static final Logger log = LoggerFactory.getLogger(ZoneLoginPanel.class);
    private final ScrollTablePanel scrollTablePanel = new ScrollTablePanel();

    public ZoneLoginPanel() {
        this.initUi();
    }

    private void initUi() {
        this.setLayout(new BorderLayout());
        this.add((Component)UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), this.scrollTablePanel}), "North");
    }

    public void bindListener(Window parent) {
        this.scrollTablePanel.bindListener(new BatchAuthZoneListener(parent, this.scrollTablePanel.getDataTable(), this.scrollTablePanel));
    }

    @Override
    public boolean process(Window parent) {
        log.info("click zone login next step");
        if (this.scrollTablePanel.hasNoAuthRow()) {
            WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)parent, (String)ResourceUtil.getString((String)"has.not.auth.node"));
            log.info("has no already login rows, user chose warning option :{}", (Object)warningDialog.getValue());
            return 0 == warningDialog.getValue();
        }
        log.info("all zone rows login finish");
        return true;
    }

    public void setShowData(List<? extends DevNode> datas) {
        List zoneNodes = datas.stream().filter(A800Node.class::isInstance).map(A800Node.class::cast).map(A800Node::getZones).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toList());
        this.scrollTablePanel.setTableData(zoneNodes);
    }
}

