/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.listener;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.SceneDeviceAddDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.service.ServerDeviceAddService;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.server.ServiceAddDeviceLayout;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAddConfirmAction
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(ServerAddConfirmAction.class);
    private final SceneDeviceAddDialog deviceAddDialog;
    private final ServiceAddDeviceLayout sourceLayout;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.sourceLayout.validInput()) {
            return;
        }
        CustMsgProgressDialog custMsgProgressDialog = new CustMsgProgressDialog((Window)this.deviceAddDialog);
        DevNode devNode = this.sourceLayout.creatDevNode();
        ServerDeviceAddService fusionStorageDeviceAddService = new ServerDeviceAddService(devNode, custMsgProgressDialog);
        Future submit = AsyncExcutor.submit((Callable)fusionStorageDeviceAddService);
        if (custMsgProgressDialog.isDisplayable()) {
            custMsgProgressDialog.setVisible(true);
        }
        this.waitResult(submit, devNode);
    }

    private void waitResult(Future<TaskResult> submit, DevNode devNode) {
        try {
            TaskResult taskResult = submit.get();
            if (TaskResult.Result.FAILED.equals((Object)taskResult.getResult())) {
                DialogUtils.showInfoDialog((JDialog)this.deviceAddDialog, (String)taskResult.getErrorLocaleDescription());
                return;
            }
            if (TaskResult.Result.SUCCESS.equals((Object)taskResult.getResult())) {
                this.notifyNodeAdded(devNode);
                this.deviceAddDialog.dispose();
                return;
            }
            this.showErrorMsg(taskResult);
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("login device :{} failed", (Object)devNode.getIp(), (Object)e);
        }
        catch (ToolException e) {
            log.error("add fusionStorage node error", (Throwable)e);
        }
    }

    private void notifyNodeAdded(DevNode devNode) throws ToolException {
        DefaultNodeProviderImpl.getInstance().addNode(devNode);
    }

    private void showErrorMsg(TaskResult taskResult) {
        DialogUtils.showErrorDialog((JDialog)this.deviceAddDialog, (String)taskResult.getErrorLocaleDescription());
    }

    public ServerAddConfirmAction(SceneDeviceAddDialog deviceAddDialog, ServiceAddDeviceLayout sourceLayout) {
        this.deviceAddDialog = deviceAddDialog;
        this.sourceLayout = sourceLayout;
    }
}

