/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.inputconfirm;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.listener.FieldDocumentListener;
import com.huawei.ism.util.UCD;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class DangerConfirmLayout
extends JPanel {
    private final Window parent;
    private final String compareString;
    private Icon dangerIcon;
    private JEditorPane textPanel;
    private JTextField confirmInput;
    private JButton confirmButton;
    private JButton cancelButton;
    private boolean clickConfirm;

    public DangerConfirmLayout(Window parent, String confirmMes, String compareString) {
        this.parent = parent;
        this.compareString = compareString;
        this.initUi();
        this.initData(confirmMes);
        this.bindListener();
        this.confirmButton.setEnabled(false);
    }

    private void bindListener() {
        this.confirmInput.getDocument().addDocumentListener((DocumentListener)new FieldDocumentListener(this::enableComponentIfInput));
        this.confirmButton.addActionListener(e -> {
            this.clickConfirm = true;
            this.parent.dispose();
        });
        this.cancelButton.addActionListener(e -> this.parent.dispose());
    }

    private void enableComponentIfInput(String input) {
        if (StringUtils.isNULLStr((String)input)) {
            this.confirmButton.setEnabled(false);
            return;
        }
        this.confirmButton.setEnabled(input.trim().equalsIgnoreCase(this.compareString));
    }

    private void initData(String dangerInfos) {
        this.textPanel.setText(dangerInfos);
    }

    private void initUi() {
        this.initComponent();
        this.initLayout();
    }

    private void initLayout() {
        Box leftBox = this.buildLeftIcon();
        Box rightBox = this.buildRightPanel();
        this.add(Box.createHorizontalStrut(30));
        this.add(leftBox);
        this.add(Box.createHorizontalStrut(10));
        this.add(rightBox);
        this.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        this.add(Box.createHorizontalGlue());
        this.add(Box.createHorizontalStrut(30));
    }

    @NotNull
    private Box buildRightPanel() {
        Box rightBox = Box.createVerticalBox();
        rightBox.add(Box.createVerticalStrut(10));
        Box levelDesc = Box.createHorizontalBox();
        JScrollPane scrollPane = new JScrollPane(this.textPanel);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setPreferredSize(new Dimension(330, 140));
        levelDesc.add(scrollPane);
        levelDesc.add(Box.createGlue());
        rightBox.add(levelDesc);
        Box verticalBox = UiMethod.createVerticalBox((JComponent[])new JComponent[]{this.confirmInput});
        rightBox.add(verticalBox);
        rightBox.add(Box.createVerticalStrut(15));
        Box box = UCD.buildButtonBoxRight((JButton[][])new JButton[][]{{this.confirmButton, this.cancelButton}});
        rightBox.add(box);
        return rightBox;
    }

    @NotNull
    private Box buildLeftIcon() {
        Box leftBox = Box.createVerticalBox();
        leftBox.add(Box.createVerticalStrut(10));
        leftBox.add(new JLabel(this.dangerIcon));
        leftBox.add(Box.createVerticalGlue());
        return leftBox;
    }

    private void initComponent() {
        this.dangerIcon = ResourceManager.getImage((String)"comfirmdialog_danger.png");
        this.textPanel = new JEditorPane();
        this.textPanel.setContentType("text/html");
        this.textPanel.setEditable(false);
        this.textPanel.setBackground(this.parent.getBackground());
        this.confirmInput = new JTextField();
        this.confirmButton = UCD.createButton((String)ResourceManager.getString((String)"COMMON.TXT.CONFIRM"), (char)'O');
        this.cancelButton = UCD.createButton((String)ResourceManager.getString((String)"COMMON.TXT.CANCEL"), (char)'C');
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public boolean isClickConfirm() {
        return this.clickConfirm;
    }
}

