/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.listener.verify;

import com.huawei.ism.tool.devicemanager.ui.listener.verify.A800SceneJudge;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.VerifyResult;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JDialog;

public class A800SelectVerifier
extends A800SceneJudge {
    public static final List<String> NEED_LIMIT_A800_COUNT_SCENES = Collections.unmodifiableList(Arrays.asList("IntelligentCompute_A800_Storage_Collect", "IntelligentCompute_A800_History", "IntelligentCompute_A800_inspection", "IntelligentCompute_A800_Quality_Checks"));

    @Override
    public VerifyResult verify(JDialog parent, String scene, List<DevNode> selectDevs) {
        VerifyResult verifyResult = new VerifyResult();
        if (NEED_LIMIT_A800_COUNT_SCENES.stream().noneMatch(subScene -> subScene.equals(scene)) || !this.isA800NodesOverLimit(selectDevs)) {
            return verifyResult;
        }
        verifyResult.setVerifySuccess(false);
        verifyResult.setMsg(ResourceUtil.getStringWithParams((String)"a800.collect.select.a800.node.count.over.msg", (Object[])new Object[]{DeviceAddUtil.getMaxA800CollectSelectConfig()}));
        return verifyResult;
    }

    private boolean isA800NodesOverLimit(List<DevNode> devs) {
        long a800NodeCount = devs.stream().filter(devNode -> ItDeviceType.A800_NODE.getName().equals(devNode.getDeviceType().toString())).count();
        return a800NodeCount > (long)DeviceAddUtil.getMaxA800CollectSelectConfig();
    }
}

