/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.listener.verify;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.FsClusterNode;
import com.huawei.ism.tool.devicemanager.ui.dialog.nodeauth.enums.NodeAuthState;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.Verifier;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.VerifyResult;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JDialog;

public class NodeNotConfiguredVerifier
implements Verifier {
    @Override
    public VerifyResult verify(JDialog parent, String scene, List<DevNode> selectedNodes) {
        VerifyResult verifyResult = new VerifyResult();
        if (StringUtils.isNULLStr((String)scene) || !scene.contains("ReplacingCertificates")) {
            return verifyResult;
        }
        if (selectedNodes.size() > 1) {
            return verifyResult;
        }
        DevNode devNode = selectedNodes.get(0);
        com.huawei.ism.tool.obase.entity.DevNode cacheNode = DefaultNodeProviderImpl.getInstance().findDevNode(devNode.getDeviceSerialNumber());
        if (Objects.isNull(cacheNode)) {
            return verifyResult;
        }
        if (cacheNode.isNeedAuthClusterNodes() && !this.allNodeAuthed(cacheNode)) {
            verifyResult.setVerifySuccess(false);
            verifyResult.setMsg(ResourceUtil.getString((String)"node.not.auth.tip"));
        }
        return verifyResult;
    }

    private boolean allNodeAuthed(com.huawei.ism.tool.obase.entity.DevNode cacheNode) {
        if (CollectionUtil.isEmpty((Collection)cacheNode.getClusterNodes())) {
            return true;
        }
        return cacheNode.getClusterNodes().stream().filter(FsClusterNode.class::isInstance).map(FsClusterNode.class::cast).allMatch(node -> node.getNodeAuthState().getAuthState() == NodeAuthState.SUCCESS);
    }
}

