/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.listener.verify;

import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.A800SceneJudge;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.VerifyResult;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneAuthVerifier
extends A800SceneJudge {
    private static final Logger log = LoggerFactory.getLogger(ZoneAuthVerifier.class);

    @Override
    public VerifyResult verify(JDialog parent, String scene, List<DevNode> selectedNodes) {
        log.info("start verify nodes:{} at scene: {}", (Object)selectedNodes.stream().map(DevNode::getIp).collect(Collectors.joining(",")), (Object)scene);
        VerifyResult verifyResult = new VerifyResult();
        if (DeviceAddUtil.isSceneSupportOmOnly()) {
            return verifyResult;
        }
        String allZoneNotAuthNode = this.findAllZoneNotAuthNode(selectedNodes);
        if (!StringUtils.isNULLStr((String)allZoneNotAuthNode)) {
            verifyResult.setVerifySuccess(false);
            verifyResult.setMsg(ResourceUtil.getStringWithParams((String)"all.zone.not.auth", (Object[])new Object[]{allZoneNotAuthNode}));
            return verifyResult;
        }
        if (this.selectA800HasZoneNotAuth(selectedNodes)) {
            if (DeviceAddUtil.isAllowZoneNoAuth(scene)) {
                ZoneAuthVerifier.showUserChooseDialog(parent, verifyResult);
                return verifyResult;
            }
            verifyResult.setVerifySuccess(false);
            verifyResult.setMsg(ResourceUtil.getString((String)"has.no.auth.zones"));
        }
        return verifyResult;
    }

    private String findAllZoneNotAuthNode(List<DevNode> selectedNodes) {
        return selectedNodes.stream().filter(node -> ItDeviceType.A800_NODE.equals((Object)node.getItDeviceType())).map(this::castToA800DevNode).filter(this::isAllZoneNotAuth).map(com.huawei.ism.tool.obase.entity.DevNode::getIp).collect(Collectors.joining(", "));
    }

    private boolean isAllZoneNotAuth(A800Node a800) {
        return a800.getZones().stream().allMatch(zone -> Objects.isNull(zone.getLoginUser()));
    }

    private static void showUserChooseDialog(JDialog parent, VerifyResult verifyResult) {
        WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)parent, (String)ResourceUtil.getString((String)"has.no.auth.zones.confirm.info"));
        if (warningDialog.getValue() != 0) {
            verifyResult.setVerifySuccess(false);
        }
    }

    private boolean selectA800HasZoneNotAuth(List<DevNode> selectedNodes) {
        return selectedNodes.stream().filter(node -> ItDeviceType.A800_NODE.equals((Object)node.getItDeviceType())).map(this::castToA800DevNode).anyMatch(this::hasNoAuthZone);
    }

    private boolean hasNoAuthZone(A800Node a800Node) {
        return !CollectionUtil.isEmpty((Collection)a800Node.getZones()) && a800Node.getZones().stream().anyMatch(zone -> Objects.isNull(zone.getLoginUser()));
    }

    private A800Node castToA800DevNode(DevNode selectedNode) {
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(node -> node instanceof AiDevNode).map(node -> (AiDevNode)node).map(AiDevNode::getA800Nodes).flatMap(Collection::stream).filter(node -> node.getDeviceSerialNumber().equals(selectedNode.getDeviceSerialNumber())).findFirst().orElse(new A800Node());
    }
}

