/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.utils;

import com.huawei.ism.tool.devicemanager.utils.ProductParser;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevCfgUtil {
    private static Map<String, String> needDebugInfos = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(DevCfgUtil.class);

    public static Map<String, String> getNeedDebugInfos() {
        return needDebugInfos;
    }

    public static boolean isNeedDebusPsw(DevNode dev) {
        if (null == dev || null == needDebugInfos) {
            LOGGER.info("dev or needDebugInfos is null.");
            return false;
        }
        String devType = dev.getDeviceType().toString();
        String devVersion = dev.getProductVersion();
        if (needDebugInfos.containsKey(devType)) {
            String[] visions;
            for (String vison : visions = needDebugInfos.get(devType).split(",")) {
                if (!devVersion.contains(vison.trim())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ProductParser parser = new ProductParser();
        needDebugInfos = parser.parse();
    }
}

