/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.utils;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.license.LicenseFeature;
import com.huawei.ism.tool.obase.license.LicenseStatus;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.RegexConfigUtils;
import com.huawei.ism.tool.protocol.rest.RestConnFactory;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import com.huawei.json.JSONUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseFeatureQueryUtil {
    private static final Logger log = LoggerFactory.getLogger(LicenseFeatureQueryUtil.class);
    private static Map<String, String> featureMap;
    private static final String FEATURES_URL = "https://%s:%s/deviceManager/rest/xxxxx/license/feature";
    private static final String ACTIVE_HARDWARE_FEATURE_URL = "https://%s:%s/deviceManager/rest/%s/hardware_feature/active_hardware_feature";
    private static final String FEATUERE_ID = "id";
    private static final String APPLICATION_STATUS_KEY = "Status";
    private static final String APPLICATION_STATUS_QUERY_CMD = "show container_application general name=dataprotect";
    private static final String APPLICATION_STATUS_QUERY_CMD_NEW_CONTAINER = "show container_application general name=dataprotect namespace=dpa";

    public static boolean hasSupportedContainerFeature(DevNode devNode) {
        JSONArray features = LicenseFeatureQueryUtil.queryDeviceFeatures(devNode);
        return LicenseFeatureQueryUtil.hasCloudBackupFeature(features) || LicenseFeatureQueryUtil.hasDataBackupFeature(features) || LicenseFeatureQueryUtil.supportHyperDetectFeature(features);
    }

    public static boolean hasCloudBackupFeature(DevNode devNode) {
        JSONArray features = LicenseFeatureQueryUtil.queryDeviceFeatures(devNode);
        return LicenseFeatureQueryUtil.hasCloudBackupFeature(features);
    }

    private static boolean hasCloudBackupFeature(JSONArray features) {
        try {
            return IntStream.range(0, features.length()).mapToObj(arg_0 -> ((JSONArray)features).getJSONObject(arg_0)).anyMatch(LicenseFeatureQueryUtil::isCloudBackupFeature);
        }
        catch (JSONException e) {
            log.error("parse features error.", (Throwable)e);
            return false;
        }
    }

    private static boolean isCloudBackupFeature(JSONObject feature) {
        return feature.has(LicenseFeature.CLOUD_BACKUP.getFeatureKey()) && LicenseFeatureQueryUtil.isValidStatus(feature, LicenseFeature.CLOUD_BACKUP.getFeatureKey()) && featureMap.get(LicenseFeature.CLOUD_BACKUP.getFeatureKey()).contains(feature.getStringOrDefault(FEATUERE_ID, "-1"));
    }

    private static boolean isValidStatus(JSONObject feature, String featureKey) {
        return feature.getInt(featureKey) == LicenseStatus.VALID.getStatus() || feature.getInt(featureKey) == LicenseStatus.EXPIRE.getStatus();
    }

    public static boolean hasHyperDetectFeature(DevNode devNode) {
        JSONArray features = LicenseFeatureQueryUtil.queryDeviceFeatures(devNode);
        return LicenseFeatureQueryUtil.supportHyperDetectFeature(features);
    }

    public static boolean supportHyperDetectFeature(JSONArray features) {
        return LicenseFeatureQueryUtil.hasHyperDetectFeature(features);
    }

    private static boolean hasHyperDetectFeature(JSONArray features) {
        try {
            return IntStream.range(0, features.length()).mapToObj(arg_0 -> ((JSONArray)features).getJSONObject(arg_0)).anyMatch(LicenseFeatureQueryUtil::isHyperDetectFeature);
        }
        catch (JSONException e) {
            log.error("parse features error.", (Throwable)e);
            return false;
        }
    }

    private static boolean isHyperDetectFeature(JSONObject feature) {
        return feature.has(LicenseFeature.HYPER_DETECT.getFeatureKey()) && LicenseFeatureQueryUtil.isValidStatus(feature, LicenseFeature.HYPER_DETECT.getFeatureKey()) && featureMap.get(LicenseFeature.HYPER_DETECT.getFeatureKey()).contains(feature.getStringOrDefault(FEATUERE_ID, "-1"));
    }

    public static boolean hasDataBackupFeature(DevNode devNode) {
        JSONArray features = LicenseFeatureQueryUtil.queryDeviceFeatures(devNode);
        return LicenseFeatureQueryUtil.hasDataBackupFeature(features);
    }

    private static boolean hasDataBackupFeature(JSONArray features) {
        try {
            return IntStream.range(0, features.length()).mapToObj(arg_0 -> ((JSONArray)features).getJSONObject(arg_0)).anyMatch(LicenseFeatureQueryUtil::isDataBackupFeature);
        }
        catch (JSONException e) {
            log.error("parse features error.", (Throwable)e);
            return false;
        }
    }

    private static boolean isDataBackupFeature(JSONObject feature) {
        return feature.has(LicenseFeature.DATA_BACKUP_CAPACITY.getFeatureKey()) && LicenseFeatureQueryUtil.isValidStatus(feature, LicenseFeature.DATA_BACKUP_CAPACITY.getFeatureKey()) && featureMap.get(LicenseFeature.DATA_BACKUP_CAPACITY.getFeatureKey()).contains(feature.getStringOrDefault(FEATUERE_ID, "-1"));
    }

    public static boolean hasHyperEncryptionFeature(DevNode devNode) {
        JSONArray features = LicenseFeatureQueryUtil.queryDeviceFeatures(devNode);
        return LicenseFeatureQueryUtil.hasHyperEncryptionFeature(features);
    }

    private static boolean hasHyperEncryptionFeature(JSONArray features) {
        try {
            return IntStream.range(0, features.length()).mapToObj(arg_0 -> ((JSONArray)features).getJSONObject(arg_0)).anyMatch(LicenseFeatureQueryUtil::isHyperEncryptionFeature);
        }
        catch (JSONException e) {
            log.error("parse features error.", (Throwable)e);
            return false;
        }
    }

    private static boolean isHyperEncryptionFeature(JSONObject feature) {
        return feature.has(LicenseFeature.HYPER_ENCRYPTION.getFeatureKey()) && LicenseFeatureQueryUtil.isValidStatus(feature, LicenseFeature.HYPER_ENCRYPTION.getFeatureKey()) && featureMap.get(LicenseFeature.HYPER_ENCRYPTION.getFeatureKey()).contains(feature.getStringOrDefault(FEATUERE_ID, "-1"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JSONArray queryDeviceFeatures(DevNode devNode) {
        try (RestConnection conn = LicenseFeatureQueryUtil.loginDev(devNode);){
            ResponseInfo req = conn.execGet(LicenseFeatureQueryUtil.buildFeatureQueryUrl(FEATURES_URL, devNode));
            JSONArray jSONArray = LicenseFeatureQueryUtil.getFeatures(req);
            return jSONArray;
        }
        catch (Exception e) {
            log.error("get features error.", (Throwable)e);
            return new JSONArray();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasSecurityModuleFeature(DevNode devNode) {
        try (RestConnection conn = LicenseFeatureQueryUtil.loginDev(devNode);){
            ResponseInfo req = conn.execGet(LicenseFeatureQueryUtil.buildActiveHardwareFeatureUrl(devNode));
            boolean bl = LicenseFeatureQueryUtil.getSecurityModuleFeature(req);
            return bl;
        }
        catch (Exception e) {
            log.error("get features error.", (Throwable)e);
            return false;
        }
    }

    public static String buildActiveHardwareFeatureUrl(DevNode devNode) {
        return String.format(Locale.ROOT, ACTIVE_HARDWARE_FEATURE_URL, LicenseFeatureQueryUtil.formatHttpIp(devNode.getIp()), "8088", devNode.getDeviceSerialNumber());
    }

    public static boolean getSecurityModuleFeature(ResponseInfo req) {
        if (Objects.isNull(req) || StringUtils.isNULLStr((String)req.getContent())) {
            log.warn("get features fail.");
            return false;
        }
        JSONObject data = new JSONObject(req.getContent()).getJSONObject("data");
        if (Objects.nonNull(data) && data.length() == 0) {
            return false;
        }
        return data.getBoolean("securityModuleFeature");
    }

    private static RestConnection loginDev(DevNode devNode) throws ToolException {
        RestConnection conn = RestConnFactory.getRestConn(devNode);
        conn.login();
        return conn;
    }

    private static JSONArray getFeatures(ResponseInfo req) {
        if (req == null || StringUtils.isNULLStr((String)req.getContent())) {
            log.warn("get features fail.");
            return new JSONArray();
        }
        JSONArray data = new JSONObject(req.getContent()).getJSONArray("data");
        if (data != null && data.length() == 0) {
            data.put((Object)new JSONObject());
        }
        return data;
    }

    private static String buildFeatureQueryUrl(String originalUrl, DevNode devNode) {
        return String.format(Locale.ROOT, originalUrl, LicenseFeatureQueryUtil.formatHttpIp(devNode.getIp()), "8088");
    }

    private static String formatHttpIp(String ip) {
        return NetUtil.isValidIPV6((String)ip) ? NetUtil.getIPV6AddrForCmd((String)ip) : ip;
    }

    public static boolean isContainerAppDeployed(ICliConnection connection) {
        List<Map<String, String>> cliResult = LicenseFeatureQueryUtil.queryContainerAppStatus(connection);
        return LicenseFeatureQueryUtil.isContainerAppDeployed(cliResult);
    }

    private static List<Map<String, String>> queryContainerAppStatus(ICliConnection connection) {
        try {
            String result = connection.execCmd(APPLICATION_STATUS_QUERY_CMD);
            if (result.contains("namespace=?")) {
                result = connection.execCmd(APPLICATION_STATUS_QUERY_CMD_NEW_CONTAINER);
            }
            return CliResolverUtils.resloveVerticalCliRetToList((String)result);
        }
        catch (ToolException e) {
            log.error("query container application status error.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static boolean isContainerAppDeployed(List<Map<String, String>> cliResult) {
        if (CollectionUtil.isEmpty(cliResult)) {
            return false;
        }
        return cliResult.stream().anyMatch(result -> !StringUtils.isNULLStr((String)((String)result.get(APPLICATION_STATUS_KEY))));
    }

    public static int queryCloudBackupState(DevNode devNode) {
        JSONArray features = LicenseFeatureQueryUtil.queryDeviceFeatures(devNode);
        if (features.length() == 0) {
            return CloudBackupState.EXCEPTION.getCode();
        }
        return LicenseFeatureQueryUtil.hasCloudBackupFeature(features) ? CloudBackupState.ENABLED.getCode() : CloudBackupState.DISABLED.getCode();
    }

    static {
        try (InputStream inputStream = RegexConfigUtils.class.getResourceAsStream("/config/licenseFeature.json");){
            String json = String.join((CharSequence)"", IOUtils.readLines((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            featureMap = JSONUtils.jsonToMaps((String)json);
        }
        catch (IOException e) {
            log.error("query regex json info IO error");
        }
    }

    public static enum CloudBackupState {
        ENABLED(1),
        DISABLED(0),
        EXCEPTION(2);

        private int code;

        public int getCode() {
            return this.code;
        }

        private CloudBackupState(int code) {
            this.code = code;
        }
    }
}

